/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.record.impl;

import java.io.Serializable;
import java.text.ParseException;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import tv.amwa.maj.constant.CommonConstants;
import tv.amwa.maj.enumeration.EdgeType;
import tv.amwa.maj.enumeration.FilmType;
import tv.amwa.maj.exception.PropertyNotPresentException;
import tv.amwa.maj.io.xml.XMLBuilder;
import tv.amwa.maj.io.xml.XMLSerializable;
import tv.amwa.maj.misctype.EdgecodeHeader;
import tv.amwa.maj.misctype.FrameOffset;
import tv.amwa.maj.misctype.PositionType;
import tv.amwa.maj.record.EdgeCodeValue;
import tv.amwa.maj.util.Utilities;

public final class EdgeCodeValueImpl
implements EdgeCodeValue,
Serializable,
XMLSerializable,
Cloneable,
CommonConstants {
    private static final long serialVersionUID = 4175102659219151076L;
    @FrameOffset
    private long edgeCodeStart;
    private FilmType edgeCodeFilmFormat;
    private EdgeType edgeCodeFormat;
    @EdgecodeHeader
    private byte[] edgeCodeHeader = null;
    private static final char[] headerTemplate = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'};
    private static final char[] hexCharMap = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final Pattern edgeCodeStartPattern = Pattern.compile("<\\w*\\:?EdgeCodeStart\\>\\-?([\\d]{1,20})\\<\\/\\w*\\:?EdgeCodeStart\\>");
    private static final Pattern filmKindPattern = Pattern.compile("<\\w*\\:?FilmKind\\>(\\w*)\\<\\/\\w*\\:?FilmKind\\>");
    private static final Pattern codeFormatPattern = Pattern.compile("<\\w*\\:?CodeFormat\\>(\\w*)\\<\\/\\w*\\:?CodeFormat\\>");
    private static final Pattern headerPattern = Pattern.compile("<\\w*\\:?EdgeCodeHeader\\>([0-9a-fA-F]*)\\<\\/\\w*\\:?EdgeCodeHeader\\>");
    public static final String START_TAG = "EdgeCodeStart";
    public static final String FILMKIND_TAG = "FilmKind";
    public static final String CODEFORMAT_TAG = "CodeFormat";
    public static final String HEADER_TAG = "EdgeCodeHeader";

    public EdgeCodeValueImpl(@PositionType long startFrame, FilmType filmKind, EdgeType codeFormat) throws NullPointerException {
        if (filmKind == null) {
            throw new NullPointerException("Cannot create a new edgecode value with a null film kind.");
        }
        if (codeFormat == null) {
            throw new NullPointerException("Cannot create a new edgecode value with a null code format.");
        }
        this.edgeCodeStart = startFrame;
        this.edgeCodeFilmFormat = filmKind;
        this.edgeCodeFormat = codeFormat;
    }

    public EdgeCodeValueImpl() {
        this.edgeCodeStart = 0L;
        this.edgeCodeFilmFormat = FilmType.FtNull;
        this.edgeCodeFormat = EdgeType.Null;
        this.edgeCodeHeader = null;
    }

    @Override
    public EdgeType getEdgeCodeFormat() {
        return this.edgeCodeFormat;
    }

    @Override
    public void setEdgeCodeFormat(EdgeType edgeCodeFormat) throws NullPointerException {
        if (edgeCodeFormat == null) {
            throw new NullPointerException("Cannot set the code format of an edgecode value with a null value.");
        }
        this.edgeCodeFormat = edgeCodeFormat;
    }

    @Override
    public FilmType getEdgeCodeFilmFormat() {
        return this.edgeCodeFilmFormat;
    }

    @Override
    public void setEdgeCodeFilmFormat(FilmType edgeCodeFilmFormat) throws NullPointerException {
        if (edgeCodeFilmFormat == null) {
            throw new NullPointerException("Cannot set the film kind of an edgecode value with a null value.");
        }
        this.edgeCodeFilmFormat = edgeCodeFilmFormat;
    }

    @Override
    @EdgecodeHeader
    public byte[] getEdgeCodeHeader() throws PropertyNotPresentException {
        if (this.edgeCodeHeader == null) {
            throw new PropertyNotPresentException("The optional header property is not present in this edgecode value.");
        }
        return (byte[])this.edgeCodeHeader.clone();
    }

    @Override
    public void setEdgeCodeHeader(@EdgecodeHeader byte[] edgeCodeHeader) {
        if (edgeCodeHeader == null) {
            this.edgeCodeHeader = null;
            return;
        }
        this.edgeCodeHeader = (byte[])edgeCodeHeader.clone();
    }

    @Override
    public String getEdgeCodeHeaderAsString() throws PropertyNotPresentException {
        if (this.edgeCodeHeader == null) {
            throw new PropertyNotPresentException("The optional header property is not present for this edge code value.");
        }
        String headerAsString = new String(this.edgeCodeHeader);
        if (headerAsString.endsWith("\u0000")) {
            return headerAsString.substring(0, headerAsString.length() - 1);
        }
        return headerAsString;
    }

    @Override
    public void setEdgeCodeHeader(String header) {
        if (header == null) {
            this.edgeCodeHeader = null;
            return;
        }
        this.edgeCodeHeader = header.getBytes();
    }

    @Override
    public long getEdgeCodeStart() {
        return this.edgeCodeStart;
    }

    @Override
    public void setEdgeCodeStart(long edgeCodeStart) {
        this.edgeCodeStart = edgeCodeStart;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof EdgeCodeValue)) {
            return false;
        }
        EdgeCodeValue testEdgecode = (EdgeCodeValue)o;
        if (testEdgecode.getEdgeCodeFormat() != this.edgeCodeFormat) {
            return false;
        }
        if (testEdgecode.getEdgeCodeFilmFormat() != this.edgeCodeFilmFormat) {
            return false;
        }
        if (testEdgecode.getEdgeCodeStart() != this.edgeCodeStart) {
            return false;
        }
        return Arrays.equals(testEdgecode.getEdgeCodeHeader(), this.edgeCodeHeader);
    }

    @Override
    public String toString() {
        return XMLBuilder.toXMLNonMetadata(this);
    }

    public static final EdgeCodeValue parseFactory(String edgeCodeAsString) throws NullPointerException, ParseException {
        if (edgeCodeAsString == null) {
            throw new NullPointerException("Cannot create a new edge code value from a null string.");
        }
        Matcher matcher = edgeCodeStartPattern.matcher(edgeCodeAsString);
        long start = 0L;
        if (matcher.find()) {
            start = Long.parseLong(matcher.group(1));
        }
        matcher = filmKindPattern.matcher(edgeCodeAsString);
        FilmType kind = FilmType.FtNull;
        try {
            if (matcher.find()) {
                String enumValue = matcher.group(1);
                kind = FilmType.valueOf(enumValue);
            }
        }
        catch (IllegalArgumentException iae) {
            throw new ParseException("Unrecognised film kind when parsing an edge code value.", 0);
        }
        matcher = codeFormatPattern.matcher(edgeCodeAsString);
        EdgeType format = EdgeType.Null;
        try {
            if (matcher.find()) {
                String enumValue = matcher.group(1);
                if (enumValue.startsWith("Et")) {
                    enumValue = enumValue.substring(2);
                }
                format = EdgeType.valueOf(enumValue);
            }
        }
        catch (IllegalArgumentException iae) {
            throw new ParseException("Unrecognised code format value when parsing an edge code value.", 0);
        }
        EdgeCodeValueImpl value = new EdgeCodeValueImpl(start, kind, format);
        matcher = headerPattern.matcher(edgeCodeAsString);
        try {
            if (matcher.find()) {
                value.setEdgeCodeHeader(EdgeCodeValueImpl.convertHexCodingToHeader(matcher.group(1)));
            }
        }
        catch (NumberFormatException nfe) {
            throw new ParseException("Unable to convert edge code header to a valid value.", 0);
        }
        return value;
    }

    @Override
    public EdgeCodeValue clone() {
        try {
            EdgeCodeValueImpl cloned = (EdgeCodeValueImpl)super.clone();
            cloned.setEdgeCodeHeader(this.edgeCodeHeader);
            return cloned;
        }
        catch (CloneNotSupportedException cnse) {
            cnse.printStackTrace();
            return null;
        }
    }

    public int hashCode() {
        return new Long(this.edgeCodeStart).hashCode() ^ this.edgeCodeFilmFormat.ordinal() << 16 + this.edgeCodeFormat.ordinal() ^ this.edgeCodeHeader.hashCode();
    }

    @Override
    public void appendXMLChildren(Node parent) {
        XMLBuilder.appendComment(parent, "EdgecodeValue represents a structure and is not a defined AAF XML element.");
        Element edgecodeElement = XMLBuilder.createChild(parent, "http://www.smpte-ra.org/schemas/2001-2/2007/aaf", "aaf", "EdgecodeValue");
        this.appendXMLGrandchildren(edgecodeElement);
    }

    public void appendXMLGrandchildren(Node edgecodeElement) {
        XMLBuilder.appendElement(edgecodeElement, "http://www.smpte-ra.org/schemas/2001-2/2007/aaf", "aaf", START_TAG, this.edgeCodeStart);
        XMLBuilder.appendElement(edgecodeElement, "http://www.smpte-ra.org/schemas/2001-2/2007/aaf", "aaf", FILMKIND_TAG, this.edgeCodeFilmFormat.name());
        XMLBuilder.appendElement(edgecodeElement, "http://www.smpte-ra.org/schemas/2001-2/2007/aaf", "aaf", CODEFORMAT_TAG, "Et" + this.edgeCodeFormat.name());
        if (this.edgeCodeHeader == null) {
            return;
        }
        XMLBuilder.appendComment(edgecodeElement, "Header as text: '" + this.getEdgeCodeHeaderAsString() + "'");
        XMLBuilder.appendElement(edgecodeElement, "http://www.smpte-ra.org/schemas/2001-2/2007/aaf", "aaf", HEADER_TAG, new String(EdgeCodeValueImpl.convertHeaderToHexCoding(this.edgeCodeHeader)));
    }

    public static final String convertHeaderToHexCoding(byte[] edgeCodeHeader) {
        if (edgeCodeHeader == null) {
            return new String();
        }
        char[] headerChars = (char[])headerTemplate.clone();
        int headerIndex = 0;
        for (int x = 0; x < edgeCodeHeader.length; ++x) {
            headerChars[headerIndex++] = hexCharMap[edgeCodeHeader[x] >>> 4 & 0xF];
            headerChars[headerIndex++] = hexCharMap[edgeCodeHeader[x] & 0xF];
            if (headerIndex > headerChars.length) break;
        }
        return new String(headerChars);
    }

    public static final byte[] convertHexCodingToHeader(String hexCode) throws NumberFormatException {
        if (hexCode == null) {
            return null;
        }
        if (hexCode.length() != 16) {
            return null;
        }
        char[] hexCodeChars = hexCode.toCharArray();
        byte[] header = new byte[]{Utilities.twoCharsToByte(hexCodeChars[0], hexCodeChars[1]), Utilities.twoCharsToByte(hexCodeChars[2], hexCodeChars[3]), Utilities.twoCharsToByte(hexCodeChars[4], hexCodeChars[5]), Utilities.twoCharsToByte(hexCodeChars[6], hexCodeChars[7]), Utilities.twoCharsToByte(hexCodeChars[8], hexCodeChars[9]), Utilities.twoCharsToByte(hexCodeChars[10], hexCodeChars[11]), Utilities.twoCharsToByte(hexCodeChars[12], hexCodeChars[13]), Utilities.twoCharsToByte(hexCodeChars[14], hexCodeChars[15])};
        return header;
    }

    @Override
    public String getComment() {
        return null;
    }
}

