/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.model.impl;

import java.io.Serializable;
import tv.amwa.maj.exception.PropertyNotPresentException;
import tv.amwa.maj.industry.MediaClass;
import tv.amwa.maj.industry.MediaProperty;
import tv.amwa.maj.industry.MediaPropertySetter;
import tv.amwa.maj.io.xml.XMLSerializable;
import tv.amwa.maj.misctype.AAFString;
import tv.amwa.maj.model.AuxiliaryDescriptor;
import tv.amwa.maj.model.impl.PhysicalDescriptorImpl;

@MediaClass(uuid1=0xD010101, uuid2=257, uuid3=19968, uuid4={6, 14, 43, 52, 2, 6, 1, 1}, definedName="AuxiliaryDescriptor", description="The AuxiliaryDescriptor class specifies describes an auxiliary file essence source.", symbol="AuxiliaryDescriptor")
public class AuxiliaryDescriptorImpl
extends PhysicalDescriptorImpl
implements AuxiliaryDescriptor,
Serializable,
XMLSerializable,
Cloneable {
    private static final long serialVersionUID = 6166632371007055060L;
    private String charSet = null;
    private String mimeType;

    public AuxiliaryDescriptorImpl() {
    }

    public AuxiliaryDescriptorImpl(@AAFString String mimeType) throws NullPointerException {
        if (mimeType == null) {
            throw new NullPointerException("Cannot create an auxiliary descriptor using a null mime type value.");
        }
        this.setMIMEType(mimeType);
    }

    @Override
    @MediaProperty(uuid1=67699456, uuid2=0, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 8}, definedName="CharSet", typeName="UTF16String", optional=true, uniqueIdentifier=false, pid=19986, symbol="CharSet")
    public String getCharSet() throws PropertyNotPresentException {
        if (this.charSet == null) {
            throw new PropertyNotPresentException("The optional character set property is not present in this auxiliary descriptor.");
        }
        return this.charSet;
    }

    @Override
    @MediaPropertySetter(value="CharSet")
    public void setCharSet(String charSet) {
        this.charSet = charSet;
    }

    @Override
    @MediaProperty(uuid1=67699201, uuid2=0, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 7}, definedName="MIMEType", aliases={"MimeType"}, typeName="UTF16String", optional=false, uniqueIdentifier=false, pid=19985, symbol="MIMEType")
    public String getMIMEType() {
        return this.mimeType;
    }

    @Override
    @MediaPropertySetter(value="MIMEType")
    public void setMIMEType(String mimeType) throws NullPointerException {
        if (mimeType == null) {
            throw new NullPointerException("Cannot set the value of the mime type of this auxiliary descriptor using a null value.");
        }
        this.mimeType = mimeType;
    }

    public static final String initializeMIMEType() {
        return "application/octet-stream";
    }

    @Override
    public AuxiliaryDescriptor clone() {
        return (AuxiliaryDescriptor)super.clone();
    }
}

