/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.io.mxf.impl;

import tv.amwa.maj.industry.MediaClass;
import tv.amwa.maj.industry.MediaProperty;
import tv.amwa.maj.industry.MediaPropertySetter;
import tv.amwa.maj.industry.MetadataObject;
import tv.amwa.maj.integer.UInt16;
import tv.amwa.maj.io.mxf.FixedLengthPack;
import tv.amwa.maj.io.mxf.LocalTagEntry;
import tv.amwa.maj.io.mxf.MXFConstants;
import tv.amwa.maj.io.xml.XMLBuilder;
import tv.amwa.maj.record.AUID;

@MediaClass(uuid1=259133698, uuid2=256, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 1}, definedName="LocalTagEntry", description="MAJ API implementation of a local tag lookup value.", symbol="LocalTagEntry", namespace="http://www.smpte-ra.org/rp210", prefix="mxf")
public class LocalTagEntryImpl
implements LocalTagEntry,
FixedLengthPack,
MetadataObject,
Cloneable,
MXFConstants {
    private static final String[] packOrder = new String[]{"LocalTag", "UID"};
    private short localTag;
    private AUID uid;

    public LocalTagEntryImpl() {
    }

    public LocalTagEntryImpl(@UInt16 short localTag, AUID uid) throws NullPointerException {
        if (uid == null) {
            throw new NullPointerException("Cannot create a primer pack entry with a null uid.");
        }
        this.setUID(uid);
        this.setLocalTag(localTag);
    }

    @Override
    @MediaProperty(uuid1=16975362, uuid2=0, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 5}, definedName="Local Tag", aliases={"Local Tag Value"}, typeName="UInt16", optional=false, uniqueIdentifier=false, pid=0, symbol="LocalTag")
    @UInt16
    public short getLocalTag() {
        return this.localTag;
    }

    @Override
    @MediaPropertySetter(value="Local Tag")
    public void setLocalTag(@UInt16 short localTag) {
        this.localTag = localTag;
    }

    @Override
    @MediaProperty(uuid1=16975363, uuid2=0, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 5}, definedName="UID", aliases={"Local Tag Unique ID"}, typeName="AUID", optional=false, uniqueIdentifier=true, pid=0, symbol="UID")
    public AUID getUID() {
        return this.uid.clone();
    }

    @Override
    @MediaPropertySetter(value="UID")
    public void setUID(AUID uid) throws NullPointerException {
        if (uid == null) {
            throw new NullPointerException("Cannot set the UID of this primer pack entry with a null value.");
        }
        this.uid = uid.clone();
    }

    public String toString() {
        return XMLBuilder.toXML(this);
    }

    @Override
    public String[] getPackOrder() {
        return packOrder;
    }

    @Override
    public LocalTagEntry clone() {
        try {
            return (LocalTagEntry)super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new InternalError("The cloning of local tag entries is supported.");
        }
    }
}

