/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.model.impl;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import tv.amwa.maj.constant.ContainerConstant;
import tv.amwa.maj.constant.ContainerDescription;
import tv.amwa.maj.exception.PropertyNotPresentException;
import tv.amwa.maj.industry.MediaClass;
import tv.amwa.maj.industry.MediaProperty;
import tv.amwa.maj.industry.MediaPropertySetter;
import tv.amwa.maj.model.ContainerDefinition;
import tv.amwa.maj.model.impl.DefinitionObjectImpl;
import tv.amwa.maj.record.AUID;

@MediaClass(uuid1=0xD010101, uuid2=257, uuid3=8192, uuid4={6, 14, 43, 52, 2, 6, 1, 1}, definedName="ContainerDefinition", description="The ContainerDefinition class specifies the mechanism used to store essence data.", symbol="ContainerDefinition")
public class ContainerDefinitionImpl
extends DefinitionObjectImpl
implements ContainerDefinition,
Serializable,
ContainerConstant,
Cloneable {
    private static final long serialVersionUID = 1398838773463122930L;
    private Boolean essenceIsIndentified = null;
    private static final Map<String, ContainerDefinition> definitionsByName = new HashMap<String, ContainerDefinition>(200);
    private static final Map<AUID, ContainerDefinition> definitionsById = new HashMap<AUID, ContainerDefinition>(100);

    public static final int registerContainersFromClass(Class<?> classWithContainers) throws NullPointerException {
        Field[] fields;
        if (classWithContainers == null) {
            throw new NullPointerException("Cannot register parameter definitions using a null class.");
        }
        int registered = 0;
        for (Field field : fields = classWithContainers.getFields()) {
            int modifiers = field.getModifiers();
            if (!Modifier.isPublic(modifiers) && !Modifier.isStatic(modifiers)) continue;
            try {
                Object value = field.get(null);
                if (!(value instanceof AUID) || !field.isAnnotationPresent(ContainerDescription.class)) continue;
                ContainerDescription containerMetadata = field.getAnnotation(ContainerDescription.class);
                ContainerDefinitionImpl definedContainer = new ContainerDefinitionImpl((AUID)value, field.getName());
                if (containerMetadata.description().length() > 0) {
                    definedContainer.setDescription(containerMetadata.description());
                }
                ContainerDefinitionImpl.registerContainerDefinition(definedContainer);
                for (String alias : containerMetadata.aliases()) {
                    definitionsByName.put(alias, definedContainer);
                }
                ++registered;
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return registered;
    }

    public static final boolean registerContainerDefinition(ContainerDefinition definedContainer) throws NullPointerException {
        if (definedContainer == null) {
            throw new NullPointerException("Cannot register a new container definition using a null value.");
        }
        boolean alreadyContained = definitionsById.containsKey(definedContainer.getAUID());
        definitionsByName.put(definedContainer.getName(), definedContainer);
        definitionsByName.put("ContainerDef_" + definedContainer.getName(), definedContainer);
        definitionsById.put(definedContainer.getAUID(), definedContainer);
        return alreadyContained;
    }

    public static final ContainerDefinition forName(String containerName) throws NullPointerException {
        if (containerName == null) {
            throw new NullPointerException("Cannot retrieve a container definition with a null name.");
        }
        return definitionsByName.get(containerName);
    }

    public static final ContainerDefinition forIdentification(AUID identification) throws NullPointerException {
        if (identification == null) {
            throw new NullPointerException("Cannot retrieve a container definition with a null identification.");
        }
        return definitionsById.get(identification);
    }

    public static final ContainerDefinition forAUID(AUID identification) throws NullPointerException {
        return ContainerDefinitionImpl.forIdentification(identification);
    }

    public static final Collection<String> inventory() {
        TreeSet<String> inventory = new TreeSet<String>();
        for (AUID definitionID : definitionsById.keySet()) {
            inventory.add(definitionsById.get(definitionID).getName());
        }
        return inventory;
    }

    public static final int count() {
        return definitionsById.size();
    }

    public ContainerDefinitionImpl() {
    }

    public ContainerDefinitionImpl(AUID identification, String name) throws NullPointerException {
        if (identification == null) {
            throw new NullPointerException("Cannot create a container definition with a null identifier.");
        }
        this.setAUID(identification);
        this.setName(name);
    }

    @Override
    public boolean essenceIsIdentified() throws PropertyNotPresentException {
        return this.getEssenceIsIdentified();
    }

    @Override
    @MediaProperty(uuid1=50397697, uuid2=768, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 1}, definedName="EssenceIsIdentified", typeName="Boolean", optional=true, uniqueIdentifier=false, pid=9217, symbol="EssenceIsIdentified")
    public boolean getEssenceIsIdentified() throws PropertyNotPresentException {
        if (this.essenceIsIndentified == null) {
            throw new PropertyNotPresentException("The optional essence is identified property is not present in this container definition.");
        }
        return this.essenceIsIndentified;
    }

    @Override
    @MediaPropertySetter(value="EssenceIsIdentified")
    public void setEssenceIsIdentified(Boolean essenceIsIdentified) {
        this.essenceIsIndentified = essenceIsIdentified;
    }

    @Override
    public ContainerDefinition clone() {
        return (ContainerDefinition)super.clone();
    }

    @Override
    public String getWeakTargetReference() {
        if (this.getName().startsWith("ContainerDef_")) {
            return this.getName();
        }
        return "ContainerDef_" + this.getName();
    }

    static {
        ContainerDefinitionImpl.registerContainersFromClass(ContainerConstant.class);
    }
}

