/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.meta.impl;

import java.io.NotSerializableException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.List;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import tv.amwa.maj.enumeration.TypeCategory;
import tv.amwa.maj.exception.EndOfDataException;
import tv.amwa.maj.exception.IllegalPropertyValueException;
import tv.amwa.maj.exception.InsufficientSpaceException;
import tv.amwa.maj.exception.TypeNotFoundException;
import tv.amwa.maj.industry.MediaClass;
import tv.amwa.maj.industry.MediaEnumerationValue;
import tv.amwa.maj.industry.PropertyValue;
import tv.amwa.maj.industry.TypeDefinitions;
import tv.amwa.maj.industry.Warehouse;
import tv.amwa.maj.io.mxf.UL;
import tv.amwa.maj.io.xml.XMLBuilder;
import tv.amwa.maj.meta.TypeDefinition;
import tv.amwa.maj.meta.TypeDefinitionIndirect;
import tv.amwa.maj.meta.impl.SingletonTypeDefinitionImpl;
import tv.amwa.maj.meta.impl.TypeDefinitionImpl;
import tv.amwa.maj.meta.impl.TypeDefinitionOpaqueImpl;
import tv.amwa.maj.misctype.AAFString;
import tv.amwa.maj.record.AUID;
import tv.amwa.maj.record.Rational;
import tv.amwa.maj.record.impl.AUIDImpl;

@MediaClass(uuid1=0xD010101, uuid2=545, uuid3=0, uuid4={6, 14, 43, 52, 2, 6, 1, 1}, definedName="TypeDefinitionIndirect", description="The TypeDefinitionIndirect class defines a property type that has a value whose type is specified in each instance.", symbol="TypeDefinitionIndirect")
public class TypeDefinitionIndirectImpl
extends SingletonTypeDefinitionImpl
implements TypeDefinitionIndirect,
Serializable {
    private static final long serialVersionUID = -3618444671349385648L;

    protected TypeDefinitionIndirectImpl() {
    }

    public TypeDefinitionIndirectImpl(AUID identification, @AAFString String typeName) throws NullPointerException {
        if (identification == null) {
            throw new NullPointerException("Cannot create a new indirect type definition with a null identification.");
        }
        this.setIdentification(identification);
        this.setName(typeName);
    }

    @Override
    public PropertyValue createValueFromActualData(TypeDefinition actualType, byte[] initData) throws NullPointerException, EndOfDataException, ClassCastException {
        if (actualType == null) {
            throw new NullPointerException("Cannot create a new indirect property value with a null actual type value.");
        }
        if (initData == null) {
            throw new NullPointerException("Cannot create a new indirect property value with null initialization data.");
        }
        PropertyValue indirectValue = actualType.createFromBytes(ByteBuffer.wrap(initData));
        return new IndirectValue(this, indirectValue);
    }

    @Override
    public PropertyValue createValueFromActualValue(PropertyValue indirectProperty) throws NullPointerException, NotSerializableException {
        if (indirectProperty == null) {
            throw new NullPointerException("Cannot create a new indirect property definition from a null value.");
        }
        return new IndirectValue(this, indirectProperty);
    }

    @Override
    public byte[] getActualData(PropertyValue indirectProperty) throws NullPointerException, IllegalPropertyValueException {
        if (indirectProperty == null) {
            throw new NullPointerException("Cannot retrieve the actual data for a null indirect property value.");
        }
        if (!this.equals(indirectProperty.getType())) {
            throw new IllegalPropertyValueException("The type of the given property value does not match this type definition.");
        }
        PropertyValue internalValue = (PropertyValue)indirectProperty.getValue();
        ByteBuffer buffer = ByteBuffer.allocate((int)internalValue.getType().lengthAsBytes(internalValue));
        try {
            internalValue.getType().writeAsBytes(internalValue, buffer);
        }
        catch (InsufficientSpaceException e) {
            e.printStackTrace();
            throw new InternalError("Should never get here.");
        }
        return buffer.array();
    }

    @Override
    public int getActualSize(PropertyValue indirectProperty) throws NullPointerException, IllegalPropertyValueException {
        if (indirectProperty == null) {
            throw new NullPointerException("Cannot retrieve the actual data size for a null indirect property value.");
        }
        if (!this.equals(indirectProperty.getType())) {
            throw new IllegalPropertyValueException("The type of the given property value does not match this type definition.");
        }
        PropertyValue internalValue = (PropertyValue)indirectProperty.getValue();
        return (int)internalValue.getType().lengthAsBytes(internalValue);
    }

    @Override
    public TypeDefinition getActualType(PropertyValue indirectProperty) throws NullPointerException, IllegalPropertyValueException {
        if (indirectProperty == null) {
            throw new NullPointerException("Cannot find the actual type of a null indirect property value.");
        }
        if (!this.equals(indirectProperty.getType())) {
            throw new IllegalPropertyValueException("The type of the given property does not match this type definition.");
        }
        PropertyValue actualValue = ((IndirectValue)indirectProperty).getValue();
        if (actualValue == null) {
            throw new TypeNotFoundException("The actual type of the indirect property value could not be found.");
        }
        return actualValue.getType();
    }

    @Override
    public PropertyValue getActualValue(PropertyValue indirectProperty) throws NullPointerException, IllegalPropertyValueException {
        if (indirectProperty == null) {
            throw new NullPointerException("Cannot find the actual type of a null indirect property value.");
        }
        if (!this.equals(indirectProperty.getType())) {
            throw new IllegalPropertyValueException("The type of the given property does not match this type definition.");
        }
        PropertyValue actualValue = ((IndirectValue)indirectProperty).getValue();
        return actualValue;
    }

    @Override
    public PropertyValue createValue(Object javaValue) throws ClassCastException {
        TypeDefinition guessedEnumType;
        if (javaValue instanceof PropertyValue) {
            return new IndirectValue(this, (PropertyValue)javaValue);
        }
        if (javaValue instanceof String) {
            return new IndirectValue(this, TypeDefinitions.UTF16String.createValue(javaValue));
        }
        if (javaValue instanceof Integer) {
            return new IndirectValue(this, TypeDefinitions.Int32.createValue(javaValue));
        }
        if (javaValue instanceof Byte) {
            return new IndirectValue(this, TypeDefinitions.Int8.createValue(javaValue));
        }
        if (javaValue instanceof Short) {
            return new IndirectValue(this, TypeDefinitions.Int16.createValue(javaValue));
        }
        if (javaValue instanceof Long) {
            return new IndirectValue(this, TypeDefinitions.Int64.createValue(javaValue));
        }
        if (javaValue instanceof MediaEnumerationValue && (guessedEnumType = Warehouse.lookForType(javaValue.getClass().getSimpleName())) != null) {
            return new IndirectValue(this, guessedEnumType.createValue(javaValue));
        }
        if (javaValue instanceof Rational) {
            return new IndirectValue(this, TypeDefinitions.Rational.createValue((Rational)javaValue));
        }
        throw new ClassCastException("Cannot create a new indirect property value from the given object.");
    }

    @Override
    public TypeCategory getTypeCategory() {
        return TypeCategory.Indirect;
    }

    @Override
    public PropertyValue createFromBytes(ByteBuffer buffer) throws NullPointerException, EndOfDataException {
        super.createFromBytes(buffer);
        if (buffer.remaining() < 16) {
            throw new EndOfDataException("Not enough bytes to read a 16-byte key for an indirect value.");
        }
        AUID typeID = AUIDImpl.createFromBuffer(buffer);
        TypeDefinition type = Warehouse.lookForType(typeID);
        PropertyValue indirectValue = type.createFromBytes(buffer);
        return this.createValue(indirectValue);
    }

    @Override
    public List<PropertyValue> writeAsBytes(PropertyValue value, ByteBuffer buffer) throws NullPointerException, IllegalPropertyValueException, InsufficientSpaceException {
        super.writeAsBytes(value, buffer);
        if ((long)buffer.remaining() < this.lengthAsBytes(value)) {
            throw new InsufficientSpaceException("Insufficient space in the given buffer to write a key and an indirect value.");
        }
        PropertyValue indirectValue = ((IndirectValue)value).getValue();
        AUID typeKey = indirectValue.getType().getAUID();
        if (typeKey.isUniversalLabel()) {
            buffer.put(((UL)typeKey).getUniversalLabel());
        } else {
            buffer.put(typeKey.getAUIDValue());
        }
        indirectValue.getType().writeAsBytes(indirectValue, buffer);
        return null;
    }

    @Override
    public List<PropertyValue> writeAsStructuredStorageBytes(PropertyValue value, ByteBuffer buffer) throws NullPointerException, IllegalPropertyValueException, InsufficientSpaceException {
        super.writeAsBytes(value, buffer);
        if ((long)buffer.remaining() < this.lengthAsBytes(value)) {
            throw new InsufficientSpaceException("Insufficient space in the given buffer to write a key and an indirect value.");
        }
        PropertyValue indirectValue = ((IndirectValue)value).getValue();
        AUID typeKey = indirectValue.getType().getAUID();
        buffer.put(typeKey.getAUIDValue());
        indirectValue.getType().writeAsBytes(indirectValue, buffer);
        return null;
    }

    @Override
    public long lengthAsBytes(PropertyValue value) throws NullPointerException, IllegalPropertyValueException {
        super.lengthAsBytes(value);
        if (value instanceof TypeDefinitionOpaqueImpl.OpaqueValue) {
            return 0L;
        }
        PropertyValue indirectValue = (PropertyValue)value.getValue();
        return indirectValue.getType().lengthAsBytes(indirectValue) + 16L;
    }

    @Override
    public void appendMetadictXML(Node metadict, String namespace, String prefix) {
        Element typeElement = null;
        if (metadict instanceof Element) {
            Element passedElement = (Element)metadict;
            typeElement = passedElement.getNodeName().startsWith("TypeDefinition") ? passedElement : XMLBuilder.createChild(metadict, namespace, prefix, "TypeDefinitionIndirect");
        }
        if (metadict instanceof DocumentFragment) {
            typeElement = XMLBuilder.createChild(metadict, namespace, prefix, "TypeDefinitionIndirect");
        }
        super.appendMetadictXML(typeElement, namespace, prefix);
    }

    @Override
    public TypeDefinitionIndirect clone() {
        return (TypeDefinitionIndirect)super.clone();
    }

    public static class IndirectValue
    extends TypeDefinitionImpl.PropertyValueImpl
    implements PropertyValue {
        private TypeDefinitionIndirectImpl type;
        private PropertyValue value;

        private IndirectValue(TypeDefinitionIndirectImpl type, PropertyValue value) {
            this.type = type;
            this.setValue(value);
        }

        @Override
        public TypeDefinition getType() {
            return this.type;
        }

        @Override
        public PropertyValue getValue() {
            return this.value;
        }

        public boolean isDefinedType() {
            return true;
        }

        void setValue(PropertyValue value) {
            this.value = value;
        }
    }
}

