/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.io.mxf.impl;

import java.io.Serializable;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import tv.amwa.maj.exception.InsufficientSpaceException;
import tv.amwa.maj.industry.MediaClass;
import tv.amwa.maj.industry.MediaEngine;
import tv.amwa.maj.industry.MediaProperty;
import tv.amwa.maj.industry.MediaPropertyClear;
import tv.amwa.maj.industry.MediaPropertyCount;
import tv.amwa.maj.industry.MediaPropertySetter;
import tv.amwa.maj.industry.MetadataObject;
import tv.amwa.maj.integer.UInt32;
import tv.amwa.maj.integer.UInt64;
import tv.amwa.maj.integer.UInt64Array;
import tv.amwa.maj.io.mxf.MXFBuilder;
import tv.amwa.maj.io.mxf.RandomIndexItem;
import tv.amwa.maj.io.mxf.RandomIndexPack;
import tv.amwa.maj.io.mxf.UL;
import tv.amwa.maj.io.mxf.UnitType;
import tv.amwa.maj.io.mxf.impl.RandomIndexItemImpl;

@MediaClass(uuid1=218169857, uuid2=273, uuid3=256, uuid4={6, 14, 43, 52, 2, 5, 1, 1}, definedName="RandomIndexPack", description="A device to help find partitions scattered throughout an MXF file.", namespace="http://www.smpte-ra.org/rp210", prefix="mxf", symbol="RandomIndexPack")
public class RandomIndexPackImpl
implements MetadataObject,
Serializable,
Cloneable,
RandomIndexPack {
    private static final long serialVersionUID = -4119168629997789616L;
    private SortedSet<RandomIndexItem> partitionOrder = new TreeSet<RandomIndexItem>();
    private Map<Integer, SortedSet<RandomIndexItem>> partitionTable = new HashMap<Integer, SortedSet<RandomIndexItem>>();

    @Override
    @MediaProperty(uuid1=0xF000000, uuid2=0, uuid3=115, uuid4={6, 14, 43, 52, 0, 0, 0, 0}, definedName="PartitionIndex", typeName="RandomIndexItemArray", optional=false, uniqueIdentifier=false, symbol="PartitionIndex")
    public RandomIndexItem[] getPartitionIndex() {
        RandomIndexItem[] currentTable = new RandomIndexItem[this.partitionOrder.size()];
        int x = 0;
        for (RandomIndexItem item : this.partitionOrder) {
            currentTable[x++] = item.clone();
        }
        return currentTable;
    }

    @Override
    @MediaPropertySetter(value="PartitionIndex")
    public void setPartitionIndex(RandomIndexItem[] partitionIndex) throws NullPointerException {
        if (partitionIndex == null) {
            throw new NullPointerException("Cannot set the partition index witn a null value.");
        }
        this.clear();
        for (RandomIndexItem item : partitionIndex) {
            this.addRandomIndexItem(item);
        }
    }

    @Override
    @UInt64Array
    public long[] lookupPartitionOffsets(@UInt32 int bodySID) {
        if (!this.partitionTable.containsKey(bodySID)) {
            return null;
        }
        SortedSet<RandomIndexItem> streamSet = this.partitionTable.get(bodySID);
        long[] streamPartitions = new long[streamSet.size()];
        int index = 0;
        for (RandomIndexItem item : streamSet) {
            streamPartitions[index++] = item.getByteOffset();
        }
        return streamPartitions;
    }

    @Override
    @MediaPropertyCount(value="PartitionIndex")
    public int count() {
        return this.partitionOrder.size();
    }

    @Override
    @MediaPropertyClear(value="PartitionIndex")
    public void clear() {
        this.partitionOrder.clear();
        this.partitionTable.clear();
    }

    @Override
    public void addRandomIndexItem(@UInt32 int bodySID, @UInt64 long byteOffset) throws IllegalArgumentException {
        this.addRandomIndexItem(new RandomIndexItemImpl(bodySID, byteOffset));
    }

    @Override
    public void addRandomIndexItem(RandomIndexItem randomPartitionItem) throws NullPointerException {
        if (randomPartitionItem == null) {
            throw new NullPointerException("Cannot put a null entry into the random index pack table.");
        }
        RandomIndexItem clonedItem = randomPartitionItem.clone();
        this.partitionOrder.add(clonedItem);
        SortedSet<RandomIndexItem> streamSet = null;
        streamSet = this.partitionTable.containsKey(clonedItem.getBodySID()) ? this.partitionTable.get(clonedItem.getBodySID()) : new TreeSet<RandomIndexItem>();
        streamSet.add(clonedItem);
        this.partitionTable.put(clonedItem.getBodySID(), streamSet);
    }

    @Override
    @MediaProperty(uuid1=67506177, uuid2=0, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 4}, definedName="Length", typeName="UInt32", uniqueIdentifier=false, optional=false, symbol="Length")
    @UInt32
    public int getLength() {
        return this.partitionOrder.size() * 12 + 24;
    }

    @MediaPropertySetter(value="Length")
    public void setLength(@UInt32 int length) throws IllegalArgumentException {
        if (this.partitionOrder.size() > 0) {
            throw new IllegalArgumentException("The length of a random index pack is automnatically maintained.");
        }
    }

    public String toString() {
        return MediaEngine.toString(this);
    }

    public boolean equals(Object o) {
        return MediaEngine.equals(this, o);
    }

    public int hashCode() {
        return MediaEngine.hashCode(this);
    }

    @Override
    public RandomIndexPack clone() {
        try {
            return (RandomIndexPack)super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new InternalError(cnse.getMessage());
        }
    }

    @Override
    public int writeAsBytes(ByteBuffer buffer) throws NullPointerException, InsufficientSpaceException {
        if (buffer == null) {
            throw new NullPointerException("Cannot write a random index pack into a null buffer.");
        }
        if (this.getLength() > buffer.remaining()) {
            throw new InsufficientSpaceException("Insufficient space to write this random index pack into the given buffer.");
        }
        MXFBuilder.writeKey(ripKeyValue, buffer);
        MXFBuilder.writeBERLength(this.partitionOrder.size() * 12 + 4, 4, buffer);
        for (RandomIndexItem item : this.partitionOrder) {
            buffer.putInt(item.getBodySID());
            buffer.putLong(item.getByteOffset());
        }
        buffer.putInt(this.getLength());
        return this.getLength();
    }

    @Override
    public UnitType getUnitType() {
        return UnitType.RandomIndexPack;
    }

    public static RandomIndexPack createFromBytes(ByteBuffer ripBytes) throws BufferUnderflowException {
        UL ripKey = MXFBuilder.readKey(ripBytes);
        if (ripKey == null) {
            return null;
        }
        if (!ripKeyValue.equals(ripKey)) {
            return null;
        }
        long ripLength = MXFBuilder.readBERLength(ripBytes);
        int ripItemCount = (int)(ripLength - 4L) / 12;
        if ((ripLength - 4L) % 12L != 0L) {
            return null;
        }
        RandomIndexItem[] itemArray = new RandomIndexItem[ripItemCount];
        for (int x = 0; x < ripItemCount; ++x) {
            itemArray[x] = new RandomIndexItemImpl(ripBytes.getInt(), ripBytes.getLong());
        }
        RandomIndexPackImpl rip = new RandomIndexPackImpl();
        rip.setPartitionIndex(itemArray);
        ripBytes.getInt();
        return rip;
    }

    public static final int initializeLength() {
        return 24;
    }

    public static final RandomIndexItem[] initializePartitionIndex() {
        return new RandomIndexItem[0];
    }
}

