/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.io.mxf.impl;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import tv.amwa.maj.exception.EndOfDataException;
import tv.amwa.maj.exception.InsufficientSpaceException;
import tv.amwa.maj.exception.PropertyNotPresentException;
import tv.amwa.maj.industry.Forge;
import tv.amwa.maj.industry.MediaClass;
import tv.amwa.maj.industry.MediaEngine;
import tv.amwa.maj.industry.MediaProperty;
import tv.amwa.maj.industry.MediaPropertyClear;
import tv.amwa.maj.industry.MediaPropertyContains;
import tv.amwa.maj.industry.MediaPropertyCount;
import tv.amwa.maj.industry.MediaSetAdd;
import tv.amwa.maj.industry.MetadataObject;
import tv.amwa.maj.industry.PropertyValue;
import tv.amwa.maj.industry.Warehouse;
import tv.amwa.maj.integer.UInt16;
import tv.amwa.maj.io.mxf.FixedLengthPack;
import tv.amwa.maj.io.mxf.HeaderMetadata;
import tv.amwa.maj.io.mxf.LocalTagEntry;
import tv.amwa.maj.io.mxf.MXFBuilder;
import tv.amwa.maj.io.mxf.MXFConstants;
import tv.amwa.maj.io.mxf.MXFFactory;
import tv.amwa.maj.io.mxf.MXFFile;
import tv.amwa.maj.io.mxf.PrimerPack;
import tv.amwa.maj.io.mxf.TypeDefinitions;
import tv.amwa.maj.io.mxf.UL;
import tv.amwa.maj.io.mxf.impl.IndexPrimerPackImpl;
import tv.amwa.maj.io.mxf.impl.LocalTagEntryImpl;
import tv.amwa.maj.io.xml.XMLBuilder;
import tv.amwa.maj.meta.ClassDefinition;
import tv.amwa.maj.meta.PropertyDefinition;
import tv.amwa.maj.meta.TypeDefinition;
import tv.amwa.maj.meta.TypeDefinitionSet;
import tv.amwa.maj.meta.TypeDefinitionStrongObjectReference;
import tv.amwa.maj.meta.TypeDefinitionVariableArray;
import tv.amwa.maj.model.Preface;
import tv.amwa.maj.record.AUID;
import tv.amwa.maj.record.impl.AUIDImpl;

@MediaClass(uuid1=218169857, uuid2=261, uuid3=256, uuid4={6, 14, 43, 52, 2, 5, 1, 1}, definedName="PrimerPack", description="Table of local 2-byte tags mapped to defined identifiers.", symbol="PrimerPack", namespace="http://www.smpte-ra.org/rp210", prefix="mxf")
public class PrimerPackImpl
implements MetadataObject,
FixedLengthPack,
PrimerPack {
    public static final String[] packOrder = new String[]{"LocalTagEntry Batch"};
    private Map<Short, LocalTagEntry> localTagBatch = Collections.synchronizedMap(new HashMap(100));
    private Map<AUID, Short> reverseMap = Collections.synchronizedMap(new HashMap());
    private short localCounter = 0;
    private long primerPackPadding = 0L;

    void setPrimerPackPadding(long primerPackPadding) {
        this.primerPackPadding = primerPackPadding;
    }

    @Override
    @MediaProperty(uuid1=100729095, uuid2=5376, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 5}, definedName="LocalTagEntry Batch", aliases={"Local Tag Entries"}, typeName="LocalTagEntryBatch", optional=false, uniqueIdentifier=false, pid=0, symbol="LocalTagEntryBatch")
    public Set<LocalTagEntry> getLocalTagEntryBatch() {
        return new HashSet<LocalTagEntry>(this.localTagBatch.values());
    }

    @Override
    @MediaSetAdd(value="LocalTagEntry Batch")
    public void addLocalTagEntry(LocalTagEntry localTagEntry) throws NullPointerException {
        if (localTagEntry == null) {
            throw new NullPointerException("Cannot add a new local tag entry to this batch with a null value.");
        }
        this.localTagBatch.put(localTagEntry.getLocalTag(), localTagEntry);
        this.reverseMap.put(localTagEntry.getUID(), localTagEntry.getLocalTag());
    }

    @Override
    public void addLocalTagEntry(@UInt16 short localTag, AUID uid) {
        this.addLocalTagEntry(new LocalTagEntryImpl(localTag, uid));
        this.reverseMap.put(uid, localTag);
    }

    @Override
    @MediaPropertyCount(value="LocalTagEntry Batch")
    public int countLocalTagEntries() {
        return this.localTagBatch.size();
    }

    @Override
    @MediaPropertyClear(value="LocalTagEntry Batch")
    public void clearLocalTagEntries() {
        this.localTagBatch.clear();
    }

    @Override
    public AUID lookupUID(@UInt16 short localTag) {
        if (!this.localTagBatch.containsKey(localTag)) {
            System.err.println("Could not find tag 0x" + Integer.toHexString(localTag) + " in this primer pack.");
            return null;
        }
        return this.localTagBatch.get(localTag).getUID();
    }

    @Override
    @MediaPropertyContains(value="LocalTagEntry Batch")
    public boolean isLocalTagEntryPresent(LocalTagEntry localTagEntry) {
        return this.localTagBatch.containsKey(localTagEntry.getLocalTag());
    }

    @Override
    public String[] getPackOrder() {
        return packOrder;
    }

    public String toString() {
        return XMLBuilder.toXML(this);
    }

    public synchronized short getNextLocalCounter() {
        this.localCounter = (short)(this.localCounter - 1);
        return this.localCounter;
    }

    @Override
    public void addLocalTagEntry(PropertyDefinition propertyDefinition) throws NullPointerException {
        if (propertyDefinition == null) {
            throw new NullPointerException("Cannot add a null property definition to a primer pack.");
        }
        AUID uid = propertyDefinition.getAUID();
        if (!this.reverseMap.containsKey(uid)) {
            short localTag = propertyDefinition.getLocalIdentification();
            if (localTag <= 0) {
                localTag = this.getNextLocalCounter();
            }
            this.addLocalTagEntry(localTag, propertyDefinition.getAUID());
        }
    }

    @Override
    public Short lookupLocalTag(AUID uid) throws NullPointerException {
        if (uid == null) {
            throw new NullPointerException("Cannot look up a property reference to find a local tag from a null value.");
        }
        Short localTag = this.reverseMap.get(uid);
        if (localTag == null) {
            System.err.println("Cannot map the given identifier for a property " + uid.toString() + " to a tag.");
            return null;
        }
        return localTag;
    }

    @Override
    public Short lookupLocalTag(PropertyDefinition propertyDefinition) throws NullPointerException {
        if (propertyDefinition == null) {
            throw new NullPointerException("Cannot look up a property to find its local tag using a null value.");
        }
        AUID propertyID = propertyDefinition.getAUID();
        Short localTag = this.reverseMap.get(propertyID);
        if (localTag == null) {
            System.err.println("Cannot map the given property " + propertyDefinition.getMemberOf().getName() + "." + propertyDefinition.getName() + " to a tag.");
            return null;
        }
        return localTag;
    }

    @Override
    public PrimerPack clone() {
        try {
            return (PrimerPack)super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new InternalError(cnse.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final PrimerPack createFromBytes(ByteBuffer buffer) throws EndOfDataException {
        UL key = MXFBuilder.readKey(buffer);
        long length = MXFBuilder.readBERLength(buffer);
        int preserveLimit = buffer.limit();
        PrimerPack primerPack = null;
        try {
            buffer.limit((int)((long)buffer.position() + length));
            primerPack = (PrimerPack)MXFBuilder.readFixedLengthPack((AUIDImpl)key, buffer);
        }
        finally {
            buffer.limit(preserveLimit);
        }
        return primerPack;
    }

    public static final int lengthAsBytes(PrimerPack primerPack) throws NullPointerException {
        if (primerPack == null) {
            throw new NullPointerException("Cannot calculate the byte length of a null primer pack.");
        }
        return 28 + 18 * primerPack.countLocalTagEntries();
    }

    public static final void writeAsBytes(PrimerPack primerPack, ByteBuffer buffer) throws NullPointerException, InsufficientSpaceException {
        if (primerPack == null) {
            throw new NullPointerException("Cannot write a null primer pack to a buffer.");
        }
        if (buffer == null) {
            throw new NullPointerException("Cannot write a primer pack into a null buffer.");
        }
        if (buffer.remaining() < PrimerPackImpl.lengthAsBytes(primerPack)) {
            throw new InsufficientSpaceException("Insufficient space remaining to write primer pack into given buffer.");
        }
        UL key = (UL)Forge.makeAUID(218169857, (short)261, (short)256, new byte[]{6, 14, 43, 52, 2, 5, 1, 1});
        MXFBuilder.writeKey(key, buffer);
        MXFBuilder.writeBERLength(18 * primerPack.countLocalTagEntries() + 8, 4, buffer);
        buffer.putInt(primerPack.countLocalTagEntries());
        buffer.putInt(18);
        for (LocalTagEntry entry : primerPack.getLocalTagEntryBatch()) {
            buffer.putShort(entry.getLocalTag());
            MXFBuilder.writeKey((UL)entry.getUID(), buffer);
        }
    }

    public static final PrimerPack createFromPreface(Preface preface) throws NullPointerException {
        if (preface == null) {
            throw new NullPointerException("Cannot create a primer pack from a null preface.");
        }
        PrimerPackImpl pack = new PrimerPackImpl();
        pack.addLocalTagEntry((short)15370, MXFConstants.InstanceUID);
        PrimerPackImpl.addPropertiesForObject(pack, preface);
        return pack;
    }

    public static final long addPropertiesForObject(PrimerPack primerPack, MetadataObject mdObject) throws NullPointerException {
        if (primerPack == null) {
            throw new NullPointerException("Cannot add local tag entries to a null primer pack.");
        }
        if (mdObject == null) {
            throw new NullPointerException("Cannot add local tag entries to a primer pack using a null metadata object.");
        }
        ClassDefinition objectsClass = MediaEngine.getClassDefinition(mdObject);
        long setLength = MXFBuilder.lengthOfLocalSet(mdObject) + 20L;
        block8: for (PropertyDefinition propertyDefinition : objectsClass.getAllPropertyDefinitions()) {
            PropertyValue propertyValue;
            block17: {
                propertyValue = null;
                try {
                    if (!propertyDefinition.getIsOptional()) break block17;
                    propertyDefinition.getPropertyValue(mdObject);
                }
                catch (IllegalArgumentException iae) {
                    continue;
                }
                catch (PropertyNotPresentException pnpe) {
                    continue;
                }
            }
            primerPack.addLocalTagEntry(propertyDefinition);
            TypeDefinition propertyType = propertyDefinition.getTypeDefinition();
            switch (propertyType.getTypeCategory()) {
                case StrongObjRef: {
                    if (propertyValue == null) {
                        propertyValue = propertyDefinition.getPropertyValue(mdObject);
                    }
                    MetadataObject stronglyReferencedObject = (MetadataObject)propertyValue.getValue();
                    setLength += PrimerPackImpl.addPropertiesForObject(primerPack, stronglyReferencedObject);
                    break;
                }
                case Set: {
                    TypeDefinition setElementType;
                    if (propertyValue == null) {
                        propertyValue = propertyDefinition.getPropertyValue(mdObject);
                    }
                    if (!((setElementType = ((TypeDefinitionSet)propertyType).getElementType()) instanceof TypeDefinitionStrongObjectReference)) break;
                    Set setValues = (Set)propertyValue.getValue();
                    for (Object value : setValues) {
                        setLength += PrimerPackImpl.addPropertiesForObject(primerPack, (MetadataObject)value);
                    }
                    continue block8;
                }
                case VariableArray: {
                    TypeDefinition arrayElementType;
                    if (propertyValue == null) {
                        propertyValue = propertyDefinition.getPropertyValue(mdObject);
                    }
                    if (!((arrayElementType = ((TypeDefinitionVariableArray)propertyType).getType()) instanceof TypeDefinitionStrongObjectReference)) break;
                    List arrayValues = (List)propertyValue.getValue();
                    for (Object value : arrayValues) {
                        setLength += PrimerPackImpl.addPropertiesForObject(primerPack, (MetadataObject)value);
                    }
                    continue block8;
                }
            }
        }
        IndexPrimerPackImpl indexPrimerPack = new IndexPrimerPackImpl();
        for (LocalTagEntry tagEntry : indexPrimerPack.getLocalTagEntryBatch()) {
            primerPack.addLocalTagEntry(tagEntry);
        }
        return setLength;
    }

    public static final void main(String[] args) {
        if (args.length < 1) {
            System.err.println("Please provide the name of an MXF file to reflect.");
            System.exit(1);
        }
        String fileName = args[0];
        MXFFile mxfFile = MXFFactory.readPartitions(fileName);
        HeaderMetadata fromTheFooter = null;
        long startTime = System.currentTimeMillis();
        fromTheFooter = mxfFile.getFooterPartition().readHeaderMetadata();
        long endTime = System.currentTimeMillis();
        System.out.println("INFO: Reading MXF File header data took " + (endTime - startTime) + "ms.");
        System.out.println(fromTheFooter.getPrimerPack().toString());
        mxfFile.close();
        PrimerPack generatedPrimer = PrimerPackImpl.createFromPreface(fromTheFooter.getPreface());
        System.out.println(generatedPrimer.toString());
    }

    static {
        Warehouse.registerTypes(TypeDefinitions.class, "http://www.smpte-ra.org/rp210", "mxf");
        Warehouse.lookForClass(LocalTagEntryImpl.class);
        Warehouse.lookForClass(PrimerPackImpl.class);
    }
}

