/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.industry;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import tv.amwa.maj.industry.FileStream;
import tv.amwa.maj.industry.MemoryResidentStream;
import tv.amwa.maj.industry.Stream;
import tv.amwa.maj.industry.StreamResolver;
import tv.amwa.maj.io.aaf.AAFStream;
import tv.amwa.maj.io.mxf.impl.MXFStream;
import tv.amwa.maj.io.xml.XMLStream;

public class LocalFileResolver
implements StreamResolver {
    private Map<URI, List<URI>> mappings = Collections.synchronizedMap(new HashMap());
    private Map<URI, Stream> streamCache = Collections.synchronizedMap(new HashMap());

    @Override
    public URI makeSpecific(URI streamReference, String accept) throws NullPointerException, IllegalArgumentException {
        if (streamReference == null) {
            throw new NullPointerException("Cannot make a null stream reference specific.");
        }
        if (this.mappings.containsKey(streamReference)) {
            return this.mappings.get(streamReference).get(0);
        }
        return null;
    }

    @Override
    public void registerMapping(URI canonicalForm, URI location) throws NullPointerException, IllegalArgumentException {
        if (canonicalForm == null) {
            throw new NullPointerException("Cannot register a null canonical URI reference.");
        }
        if (location == null) {
            throw new NullPointerException("Cannot register a null location URI reference.");
        }
        List<Object> locationList = null;
        if (this.mappings.containsKey(canonicalForm)) {
            locationList = this.mappings.get(canonicalForm);
        } else {
            locationList = Collections.synchronizedList(new ArrayList());
            this.mappings.put(canonicalForm, locationList);
        }
        locationList.add(location);
    }

    @Override
    public boolean removeLocation(URI identifier) throws NullPointerException {
        if (identifier == null) {
            throw new NullPointerException("Cannot remove a null location.");
        }
        if (this.mappings.containsKey(identifier)) {
            this.streamCache.remove(identifier);
            this.mappings.remove(identifier);
            return true;
        }
        boolean removedFromValues = false;
        for (List<URI> uriList : this.mappings.values()) {
            if (!uriList.contains(identifier)) continue;
            uriList.remove(identifier);
            removedFromValues = true;
        }
        return removedFromValues;
    }

    @Override
    public Stream resolveStream(URI streamReference) throws NullPointerException {
        if (streamReference == null) {
            throw new NullPointerException("Cannot resolve a stream with a null reference.");
        }
        if (this.streamCache.containsKey(streamReference)) {
            return this.streamCache.get(streamReference).clone();
        }
        if (streamReference.getQuery().contains("type=ss")) {
            AAFStream stream = new AAFStream(streamReference);
            this.streamCache.put(streamReference, stream);
            return stream;
        }
        if (streamReference.getQuery().contains("type=klv")) {
            MXFStream stream = new MXFStream(streamReference);
            this.streamCache.put(streamReference, stream);
            return stream;
        }
        if (streamReference.getQuery().contains("type=xml")) {
            XMLStream stream = new XMLStream(streamReference);
            this.streamCache.put(streamReference, stream);
            return stream;
        }
        return new FileStream(streamReference);
    }

    @Override
    public Stream resolveStream(URI streamReference, String accept) throws NullPointerException, IllegalArgumentException {
        if (streamReference == null) {
            throw new NullPointerException("Cannot resolve a stream from a null reference.");
        }
        if (accept == null) {
            throw new NullPointerException("Cannot process null accept criteria.");
        }
        if (!accept.equals("*/*")) {
            throw new IllegalArgumentException("The local file resolver only accepts */* as accept criteria.");
        }
        return this.resolveStream(streamReference);
    }

    public void clearStreamCacheFiles() {
        for (URI uri : this.streamCache.keySet()) {
            if (this.streamCache.get(uri) instanceof MemoryResidentStream) continue;
            this.streamCache.remove(uri);
        }
    }

    @Override
    public void cacheStream(Stream stream) throws NullPointerException, IllegalArgumentException {
        if (stream == null) {
            throw new NullPointerException("Cannot cache a stream location from a null stream value.");
        }
        this.streamCache.put(stream.getStreamURI(), stream);
    }
}

