/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.example;

import tv.amwa.maj.constant.OperationConstant;
import tv.amwa.maj.constant.ParameterConstant;
import tv.amwa.maj.constant.TransferCharacteristicType;
import tv.amwa.maj.constant.UsageType;
import tv.amwa.maj.enumeration.AlphaTransparencyType;
import tv.amwa.maj.enumeration.ColorSitingType;
import tv.amwa.maj.enumeration.FieldNumber;
import tv.amwa.maj.enumeration.LayoutType;
import tv.amwa.maj.enumeration.SignalStandardType;
import tv.amwa.maj.enumeration.TapeFormatType;
import tv.amwa.maj.enumeration.VideoSignalType;
import tv.amwa.maj.extensions.avid.AvidFactory;
import tv.amwa.maj.extensions.avid.CDCIDescriptor;
import tv.amwa.maj.extensions.avid.TapeDescriptor;
import tv.amwa.maj.extensions.avid.WAVEPCMDescriptor;
import tv.amwa.maj.industry.Forge;
import tv.amwa.maj.industry.MediaEngine;
import tv.amwa.maj.industry.Warehouse;
import tv.amwa.maj.io.aaf.AAFFactory;
import tv.amwa.maj.io.xml.XMLFactory;
import tv.amwa.maj.model.AAFFileDescriptor;
import tv.amwa.maj.model.CompositionPackage;
import tv.amwa.maj.model.ConstantValue;
import tv.amwa.maj.model.ContentStorage;
import tv.amwa.maj.model.DataDefinition;
import tv.amwa.maj.model.Locator;
import tv.amwa.maj.model.MaterialPackage;
import tv.amwa.maj.model.MultipleDescriptor;
import tv.amwa.maj.model.NetworkLocator;
import tv.amwa.maj.model.OperationDefinition;
import tv.amwa.maj.model.OperationGroup;
import tv.amwa.maj.model.Package;
import tv.amwa.maj.model.Parameter;
import tv.amwa.maj.model.Preface;
import tv.amwa.maj.model.Sequence;
import tv.amwa.maj.model.SourceClip;
import tv.amwa.maj.model.SourcePackage;
import tv.amwa.maj.model.TimelineTrack;
import tv.amwa.maj.model.Track;
import tv.amwa.maj.model.Transition;

public class CompositionExample {
    public static final void main(String[] args) {
        if (args.length == 0) {
            System.err.println("Example composition generator: java tv.amwa.maj.example.CompositionExample <filename(.aaf/.isr/.xml)>");
            System.exit(1);
        }
        MediaEngine.initializeAAF();
        try {
            Preface preface = CompositionExample.makeExamplePreface();
            if (args[0].endsWith(".aaf") || args[0].endsWith(".isr")) {
                AvidFactory.registerAvidExtensions();
                AAFFactory.writePreface(preface, args[0]);
            } else {
                AvidFactory.registerAvidExtensions();
                XMLFactory.writePreface(preface, args[0]);
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static final Preface makeExamplePreface() throws Exception {
        CompositionPackage rootComposition = Forge.make(CompositionPackage.class, "PackageName", "RootPackage", "PackageID", Forge.dCinemaUMID(), "PackageUsage", UsageType.TopLevel);
        int sourceVideoTrackID = 2;
        int sourceAudioTrackID = 3;
        int sourceEssenceLength = 125;
        TapeDescriptor tapeDescription = Forge.make(TapeDescriptor.class, new Object[0]);
        tapeDescription.setSignalType(VideoSignalType.PALSignal);
        tapeDescription.setTapeBatchNumber("PL/1234/12");
        tapeDescription.setTapeManufacturer("Sony");
        tapeDescription.setTapeFormulation("Digibeta");
        tapeDescription.setTapeFormat(TapeFormatType.BetacamFormat);
        tapeDescription.setTapeCapacity(30);
        SourcePackage sourceTape = Forge.make(SourcePackage.class, "PackageName", "SourceTape", "PackageID", Forge.randomUMID(), "PackageTracks", new Track[]{CompositionExample.makeTimelineTrack("Picture", null, 0, 0L, 1, 2700000L), CompositionExample.makeTimelineTrack("Sound", null, 0, 0L, 2, 2700000L)}, "EssenceDescription", tapeDescription);
        SourcePackage sourceFile = (SourcePackage)Forge.makeAAF("SourceMob", "PackageName", "SourceFile", "PackageID", Forge.randomUMID(), "PackageTracks", new Track[]{CompositionExample.makeTimelineTrack("Picture", sourceTape, 1, 900000L, sourceVideoTrackID, 125L), CompositionExample.makeTimelineTrack("Sound", sourceTape, 2, 900000L, sourceAudioTrackID, 125L)}, "EssenceDescription", Forge.make(MultipleDescriptor.class, "FileDescriptors", new AAFFileDescriptor[]{CompositionExample.makeIMX50VideoDescriptor(sourceEssenceLength, sourceVideoTrackID), CompositionExample.makeWAVEPCMDescriptor(sourceEssenceLength, sourceAudioTrackID)}, "Locators", new Locator[]{Forge.make(NetworkLocator.class, "URL", "file://library/media/imx50-example.mxf")}));
        MaterialPackage masterPackage = Forge.make(MaterialPackage.class, "PackageName", "MasterMaterial", "PackageID", Forge.randomUMID(), "PackageTracks", new Track[]{CompositionExample.makeTimelineTrack("Picture", sourceFile, sourceVideoTrackID, 0L, sourceVideoTrackID, 125L), CompositionExample.makeTimelineTrack("Sound", sourceFile, sourceAudioTrackID, 0L, sourceAudioTrackID, 125L)});
        Sequence videoSequence = Forge.make(Sequence.class, "ComponentDataDefinition", "Picture");
        Sequence audioSequence = Forge.make(Sequence.class, "ComponentDataDefinition", "Sound");
        OperationGroup videoDissolve = Forge.make(OperationGroup.class, "ComponentDataDefinition", "Picture", "ComponentLength", 12);
        videoDissolve.setOperationDefinition(Warehouse.lookup(OperationDefinition.class, OperationConstant.VideoDissolve));
        Parameter parameter = Forge.make(ConstantValue.class, "ParameterDefinitionReference", ParameterConstant.Level, "Value", Forge.makeRational(1, 2));
        videoDissolve.addParameter(parameter);
        Transition videoTranstion = Forge.make(Transition.class, "ComponentDataDefinition", "Picture", "ComponentLength", 12, "TransitionOperation", videoDissolve);
        OperationGroup audioDissolve = Forge.make(OperationGroup.class, "ComponentDataDefinition", "Sound", "ComponentLength", 12, "Operation", "MonoAudioDissolve", "Parameters", new Parameter[]{Forge.make(ConstantValue.class, "ParameterDefinitionReference", ParameterConstant.Level, "Value", Forge.makeRational(1, 2))});
        Transition audioTransition = Forge.make(Transition.class, "ComponentDataDefinition", "Sound", "ComponentLength", 12, "TransitionOperation", audioDissolve);
        videoSequence.appendComponentObject(CompositionExample.makeSourceClip("Picture", masterPackage, sourceVideoTrackID, 0L, 50L));
        videoSequence.appendComponentObject(videoTranstion);
        videoSequence.appendComponentObject(CompositionExample.makeSourceClip("Picture", masterPackage, sourceVideoTrackID, 75L, 50L));
        audioSequence.appendComponentObject(CompositionExample.makeSourceClip("Sound", masterPackage, sourceAudioTrackID, 0L, 50L));
        audioSequence.appendComponentObject(audioTransition);
        audioSequence.appendComponentObject(CompositionExample.makeSourceClip("Sound", masterPackage, sourceAudioTrackID, 75L, 50L));
        rootComposition.appendNewTimelineTrack(Forge.makeRational(25, 1), videoSequence, sourceVideoTrackID, "VideoTrack", 0L);
        rootComposition.appendNewTimelineTrack(Forge.makeRational(25, 1), audioSequence, sourceAudioTrackID, "AudioTrack", 0L);
        return Forge.make(Preface.class, "ContentStorageObject", Forge.make(ContentStorage.class, "Packages", new Package[]{sourceTape, sourceFile, rootComposition, masterPackage}));
    }

    public static final CDCIDescriptor makeIMX50VideoDescriptor(long essenceLength, int linkedTrackID) {
        return Forge.make(CDCIDescriptor.class, "SampleRate", "25/1", "ContainerFormat", "MXFGC_Framewrapped_SMPTE_D10_625x50I_50Mbps_DefinedTemplate", "EssenceLength", essenceLength, "PictureCompression", "urn:smpte:ul:060e2b34.04010101.04010202.01020101", "FrameLayout", LayoutType.SeparateFields, "VideoLineMap", new int[]{7, 320}, "ImageAspectRatio", Forge.makeRational(16, 9), "AlphaTransparency", AlphaTransparencyType.MinValueTransparent, "ImageAlignmentFactor", 0, "TransferCharacteristic", TransferCharacteristicType.ITU470_PAL, "ImageStartOffset", 0, "ImageEndOffset", 0, "FieldDominance", FieldNumber.One, "DisplayF2Offset", 0, "StoredF2Offset", 0, "SignalStandard", SignalStandardType.ITU601, "DisplayHeight", 288, "DisplayWidth", 720, "DisplayXOffset", 0, "DisplayYOffset", 16, "SampledHeight", 304, "SampledWidth", 720, "SampledXOffset", 0, "SampledYOffset", 0, "StoredHeight", 304, "StoredWidth", 720, "AlphaSampleDepth", 0, "BlackRefLevel", 16, "ColorRange", 225, "ColorSiting", ColorSitingType.Rec601, "ComponentDepth", 8, "HorizontalSubsampling", 2, "PaddingBits", 0, "ReversedByteOrder", false, "VerticalSubsampling", 1, "WhiteRefLevel", 235, "LinkedTrackID", linkedTrackID);
    }

    public static final WAVEPCMDescriptor makeWAVEPCMDescriptor(long essenceLength, int linledTrackID) {
        return Forge.make(WAVEPCMDescriptor.class, "SampleRate", "25/1", "ContainerFormat", "MXFGC_Clipwrapped_Broadcast_Wave_audio_data", "EssenceLength", essenceLength, "AudioSampleRate", Forge.makeRational(48000, 1), "QuantizationBits", 16, "ChannelCount", 1, "Locked", true, "AverageBytesPerSecond", 96000, "BlockAlign", 2, "ChannelAssignment", "urn:uuid:4b7093c0-c8d2-4f9a-aadc-c1a8d556d3e3", "LinkedTrackID", 3);
    }

    public static final TimelineTrack makeTimelineTrack(String trackType, Package sourceChainReference, int sourceTrackID, long startPosition, int localTrackID, long componentLength) {
        SourceClip clipReference = CompositionExample.makeSourceClip(trackType, sourceChainReference, sourceTrackID, startPosition, componentLength);
        return (TimelineTrack)Forge.makeAAF("TimelineMobSlot", "SlotID", localTrackID, "SlotName", "Slot" + localTrackID, "TimelineMobSlotEditRate", "25/1", "MobSlotSegment", clipReference);
    }

    public static final SourceClip makeSourceClip(String trackType, Package sourcePackage, int sourceTrackID, long startPosition, long componentLength) {
        if (sourcePackage != null) {
            return Forge.make(SourceClip.class, "ComponentDataDefinition", Warehouse.lookup(DataDefinition.class, trackType), "ComponentLength", componentLength, "StartPosition", 0L, "SourceTrackID", sourceTrackID, "SourcePackageID", sourcePackage.getPackageID(), "StartPosition", startPosition);
        }
        SourceClip clipReference = Forge.make(SourceClip.class, new Object[0]);
        clipReference.setComponentDataDefinition(Warehouse.lookup(DataDefinition.class, trackType));
        clipReference.setComponentLength(componentLength);
        clipReference.setSourceReference(Forge.originalSource());
        return clipReference;
    }
}

