/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.enumeration;

import tv.amwa.maj.industry.MediaEnumerationValue;

public enum MaterialType implements MediaEnumerationValue
{
    Picture(1),
    Audio(2),
    Data(3),
    Other(4),
    SinglePicture(5),
    TwoPicturesOrMore(6),
    SingleAudio(8),
    TwoAudiosOrMore(9),
    SingleAuxilary(11),
    TwoAuxilarysOrMore(12),
    MixedGroup(13),
    NotIdentified(15);

    private byte type = 0;

    private MaterialType(byte type) {
        this.type = type;
    }

    public byte getMaterialTypeCode() {
        return this.type;
    }

    public static final MaterialType materialTypeFromCode(byte code) {
        for (MaterialType materialType : MaterialType.values()) {
            if (materialType.getMaterialTypeCode() != code) continue;
            return materialType;
        }
        return null;
    }

    @Override
    public long value() {
        return this.type;
    }

    @Override
    public String symbol() {
        return this.name();
    }
}

