/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.meta.impl;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedMap;
import tv.amwa.maj.exception.BadParameterException;
import tv.amwa.maj.exception.InvalidParameterException;
import tv.amwa.maj.industry.AAFSpecifiedClasses;
import tv.amwa.maj.industry.MediaClass;
import tv.amwa.maj.industry.MediaEngine;
import tv.amwa.maj.industry.MediaProperty;
import tv.amwa.maj.industry.MetadataObject;
import tv.amwa.maj.industry.PropertyValue;
import tv.amwa.maj.industry.TypeDefinitions;
import tv.amwa.maj.industry.Warehouse;
import tv.amwa.maj.io.aaf.AAFConstants;
import tv.amwa.maj.meta.ClassDefinition;
import tv.amwa.maj.meta.MetaDefinition;
import tv.amwa.maj.meta.MetaDictionary;
import tv.amwa.maj.meta.PropertyDefinition;
import tv.amwa.maj.meta.TypeDefinition;
import tv.amwa.maj.meta.TypeDefinitionEnumeration;
import tv.amwa.maj.meta.TypeDefinitionFixedArray;
import tv.amwa.maj.meta.TypeDefinitionObjectReference;
import tv.amwa.maj.meta.TypeDefinitionRecord;
import tv.amwa.maj.meta.TypeDefinitionRename;
import tv.amwa.maj.meta.TypeDefinitionSet;
import tv.amwa.maj.meta.TypeDefinitionString;
import tv.amwa.maj.meta.TypeDefinitionVariableArray;
import tv.amwa.maj.meta.impl.ClassDefinitionImpl;
import tv.amwa.maj.meta.impl.TypeDefinitionIndirectImpl;
import tv.amwa.maj.meta.impl.TypeDefinitionSetImpl;
import tv.amwa.maj.meta.impl.TypeDefinitionVariableArrayImpl;
import tv.amwa.maj.model.ApplicationObject;
import tv.amwa.maj.model.ApplicationPluginObject;
import tv.amwa.maj.model.ApplicationReferencedObject;
import tv.amwa.maj.model.InterchangeObject;
import tv.amwa.maj.model.Preface;
import tv.amwa.maj.record.AUID;

@MediaClass(definedName="MetaDictionary", uuid1=0xD010101, uuid2=549, uuid3=0, uuid4={6, 14, 43, 52, 2, 6, 1, 1}, description="The meta dictionary class is deprecated and replaced by extension schemes and the baseline dictionary.", symbol="MetaDictionary", namespace="http://www.smpte-ra.org/schemas/2001-2/2007/aaf", prefix="aaf")
public class MetaDictionaryImpl
implements MetaDictionary,
MetadataObject,
Cloneable,
Serializable {
    private boolean dynamic = false;
    private Set<ClassDefinition> classDefinitions = null;
    private Set<TypeDefinition> typeDefinitions = null;
    private static final long serialVersionUID = 1L;

    @Override
    public int countClassDefinitions() {
        return ClassDefinitionImpl.countClassDefinitions();
    }

    @Override
    public int countOpaqueTypeDefinitions() {
        return 0;
    }

    @Override
    public int countTypeDefinitions() {
        return this.dynamic ? this.typeDefinitions.size() : Warehouse.countTypeDefinitions();
    }

    @Override
    public void createForwardClassReference(AUID classId) throws InvalidParameterException {
    }

    @Override
    @Deprecated
    public InterchangeObject createInstance(AUID identification) throws NullPointerException, IllegalArgumentException {
        ClassDefinition classToCreate = Warehouse.lookForClass(identification);
        if (classToCreate == null) {
            throw new IllegalArgumentException("The given class identifier does not match a class known to this meta dictionary.");
        }
        if (this.dynamic && !this.classDefinitions.contains(classToCreate)) {
            throw new IllegalArgumentException("The given class identifier exists but is not in this dynamic meta dictionary.");
        }
        MetadataObject created = classToCreate.createInstance();
        if (!(created instanceof InterchangeObject)) {
            throw new IllegalArgumentException("The created class is not an interchange object.");
        }
        return (InterchangeObject)created;
    }

    @Override
    @Deprecated
    public MetaDefinition createMetaInstance(AUID identification) throws NullPointerException, IllegalArgumentException {
        ClassDefinition classToCreate = Warehouse.lookForClass(identification);
        if (classToCreate == null) {
            throw new IllegalArgumentException("The given class identifier does not match a class known to this meta dictionary.");
        }
        if (this.dynamic && !this.classDefinitions.contains(classToCreate)) {
            throw new IllegalArgumentException("The given class identifier exists but is not in this dynamic meta dictionary.");
        }
        MetadataObject created = classToCreate.createInstance();
        if (!(created instanceof MetaDefinition)) {
            throw new IllegalArgumentException("The created class is not a meta definition.");
        }
        return (MetaDefinition)created;
    }

    @Override
    @MediaProperty(definedName="ClassDefinitions", uuid1=100729095, uuid2=1792, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, symbol="ClassDefinitions", typeName="ClassDefinitionStrongReferenceSet", optional=true, uniqueIdentifier=false, pid=3)
    public Set<? extends ClassDefinition> getClassDefinitions() {
        if (!this.dynamic) {
            return new HashSet<ClassDefinition>(ClassDefinitionImpl.getClassDefinitions());
        }
        return this.classDefinitions;
    }

    @Override
    public Set<? extends TypeDefinition> getOpaqueTypeDefinitions() {
        return null;
    }

    @Override
    @MediaProperty(definedName="TypeDefinitions", uuid1=100729095, uuid2=2048, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, symbol="TypeDefinitions", typeName="TypeDefinitionStrongReferenceSet", optional=true, uniqueIdentifier=false, pid=4)
    public Set<? extends TypeDefinition> getTypeDefinitions() {
        if (!this.dynamic) {
            return new HashSet<TypeDefinition>(Warehouse.getTypeDefinitions());
        }
        return this.typeDefinitions;
    }

    @Override
    public boolean hasForwardClassReference(AUID classId) throws InvalidParameterException {
        return false;
    }

    @Override
    public ClassDefinition lookupClassDefinition(AUID identification) throws NullPointerException, InvalidParameterException {
        if (identification == null) {
            throw new NullPointerException("Cannot lookup a class definition with a null value.");
        }
        ClassDefinition classDefinition = ClassDefinitionImpl.forAUID(identification);
        if (classDefinition != null) {
            return classDefinition;
        }
        throw new InvalidParameterException("The given identifier does not match that of a known class definition.");
    }

    @Override
    public TypeDefinition lookupOpaqueTypeDefinition(AUID typeId) throws NullPointerException, InvalidParameterException {
        return null;
    }

    @Override
    public TypeDefinition lookupTypeDefinition(AUID identification) throws NullPointerException, InvalidParameterException {
        if (identification == null) {
            throw new NullPointerException("Cannot lookup a type definition with a null value.");
        }
        TypeDefinition typeDefinition = Warehouse.lookForType(identification);
        if (typeDefinition != null) {
            return typeDefinition;
        }
        throw new InvalidParameterException("The given identifier does not match that of a known type definition.");
    }

    @Override
    public void registerClassDefinition(ClassDefinition classDefinition) throws NullPointerException, InvalidParameterException {
        if (classDefinition == null) {
            throw new NullPointerException("Cannot register a class definition using a null value.");
        }
        if (ClassDefinitionImpl.forAUID(classDefinition.getAUID()) != null) {
            throw new InvalidParameterException("The given class definition is already registered in the meta dictionary.");
        }
        Warehouse.lookForClass(classDefinition.getJavaImplementation());
    }

    @Override
    public void registerOpaqueTypeDefinition(TypeDefinition typeDef) throws NullPointerException, InvalidParameterException {
    }

    @Override
    public void registerTypeDefinition(TypeDefinition typeDefinition) throws NullPointerException, InvalidParameterException {
        if (typeDefinition == null) {
            throw new NullPointerException("Cannot register a class definition using a null value.");
        }
        if (Warehouse.lookForType(typeDefinition.getAUID()) != null) {
            throw new InvalidParameterException("The given type definition is already registered in the meta dictionary.");
        }
        Warehouse.register(typeDefinition, typeDefinition.getNamespace(), typeDefinition.getPrefix());
    }

    @Override
    public void makeDynamic(Preface preface) throws NullPointerException {
        if (preface == null) {
            throw new NullPointerException("Cannot use a null preface value to make this meta dictionary dynamic.");
        }
        this.classDefinitions = Collections.synchronizedSet(new HashSet());
        this.typeDefinitions = Collections.synchronizedSet(new HashSet());
        for (Class<?> metaClass : AAFSpecifiedClasses.abstractMeta) {
            this.classDefinitions.add(Warehouse.lookForClass(metaClass));
        }
        for (Class<?> metaClass : AAFSpecifiedClasses.existingMeta) {
            this.classDefinitions.add(Warehouse.lookForClass(metaClass));
        }
        this.addMetaDefinitions(preface);
        this.typeDefinitions.remove(TypeDefinitions.ApplicationPluginObjectStrongReference);
        this.typeDefinitions.remove(TypeDefinitions.ApplicationPluginObjectStrongReferenceSet);
        this.dynamic = true;
    }

    private void addMetaDefinitions(MetadataObject mdObject) {
        if (mdObject == null) {
            return;
        }
        SortedMap<? extends PropertyDefinition, ? extends PropertyValue> values = null;
        if (mdObject instanceof ApplicationObject) {
            ApplicationObject appObject = (ApplicationObject)mdObject;
            this.addClassHierarchy(appObject.getObjectClass());
            values = ((ApplicationObject)mdObject).getProperties();
            for (PropertyDefinition propertyDefinition : values.keySet()) {
                this.typeDefinitions.add(propertyDefinition.getTypeDefinition());
                ClassDefinition memberOf = propertyDefinition.getMemberOf();
                if (memberOf == null) continue;
                if (!this.classDefinitions.contains(memberOf)) {
                    this.classDefinitions.add(memberOf.clone());
                }
                for (ClassDefinition toBeWrittenMemberOf : this.classDefinitions) {
                    if (!toBeWrittenMemberOf.getAUID().equals(memberOf.getAUID())) continue;
                    try {
                        toBeWrittenMemberOf.lookupPropertyDefinition(propertyDefinition.getAUID());
                    }
                    catch (BadParameterException bpe) {
                        ((ClassDefinitionImpl)toBeWrittenMemberOf).addPropertyDefinition(propertyDefinition);
                    }
                }
            }
        } else {
            ClassDefinition targetClass = MediaEngine.getClassDefinition(mdObject);
            this.addClassHierarchy(targetClass);
            for (PropertyDefinition propertyDefinition : targetClass.getAllPropertyDefinitions()) {
                TypeDefinition propertyType = propertyDefinition.getTypeDefinition();
                if (propertyType == null) {
                    System.err.println("When making a dynamic preface, adding null type for property '" + targetClass.getName() + ":" + propertyDefinition.getName() + "'.");
                }
                this.typeDefinitions.add(propertyType);
            }
            values = targetClass.getProperties(mdObject);
        }
        block12: for (PropertyDefinition propertyDefinition : values.keySet()) {
            if (propertyDefinition.getAUID().equals(AAFConstants.ObjectClassID)) continue;
            TypeDefinition typeDefinition = propertyDefinition.getTypeDefinition();
            if (typeDefinition == null) {
                System.err.println("When making a dynamic preface, adding null type for property '" + propertyDefinition.getName() + "'.");
            }
            this.typeDefinitions.add(typeDefinition);
            PropertyValue value = null;
            switch (typeDefinition.getTypeCategory()) {
                case WeakObjRef: 
                case StrongObjRef: {
                    value = (PropertyValue)values.get(propertyDefinition);
                    if (value.getValue() instanceof ClassDefinition) break;
                    this.addMetaDefinitions((MetadataObject)value.getValue());
                    break;
                }
                case VariableArray: {
                    TypeDefinitionVariableArray arrayType = (TypeDefinitionVariableArray)typeDefinition;
                    TypeDefinition arrayRefType = arrayType.getType();
                    if (arrayRefType == null) {
                        System.err.println("When making a dynamic preface, adding null sub type for array ref property '" + propertyDefinition.getName() + "'.");
                    }
                    this.typeDefinitions.add(arrayRefType);
                    value = (PropertyValue)values.get(propertyDefinition);
                    Object list = ((TypeDefinitionVariableArrayImpl.VariableArrayValue)value).getValue();
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        Object listItem = iterator.next();
                        if (!(listItem instanceof MetadataObject)) continue;
                        this.addMetaDefinitions((MetadataObject)listItem);
                    }
                    continue block12;
                }
                case Set: {
                    TypeDefinitionSet setType = (TypeDefinitionSet)typeDefinition;
                    TypeDefinition setRefType = setType.getElementType();
                    this.typeDefinitions.add(setRefType);
                    if (setRefType == null) {
                        System.err.println("When making a dynamic preface, adding null sub type for set ref property '" + propertyDefinition.getName() + "'.");
                    }
                    value = (PropertyValue)values.get(propertyDefinition);
                    Object elements = ((TypeDefinitionSetImpl.SetValue)value).getValue();
                    Iterator iterator = elements.iterator();
                    while (iterator.hasNext()) {
                        Object element = iterator.next();
                        if (!(element instanceof MetadataObject)) continue;
                        this.addMetaDefinitions((MetadataObject)element);
                    }
                    continue block12;
                }
                case FixedArray: {
                    TypeDefinition fixedRefType = ((TypeDefinitionFixedArray)typeDefinition).getType();
                    if (fixedRefType == null) {
                        System.err.println("When making a dynamic preface, adding null sub type for fixed ref property '" + propertyDefinition.getName() + "'.");
                    }
                    this.typeDefinitions.add(fixedRefType);
                    break;
                }
                case Indirect: {
                    value = (PropertyValue)values.get(propertyDefinition);
                    PropertyValue indirectValue = ((TypeDefinitionIndirectImpl.IndirectValue)value).getValue();
                    TypeDefinition indirectType = indirectValue.getType();
                    if (indirectType == null) {
                        System.err.println("When making a dynamic preface, adding null sub type for indirect property '" + propertyDefinition.getName() + "'.");
                    }
                    this.typeDefinitions.add(indirectType);
                    if (!(indirectValue.getValue() instanceof MetadataObject)) break;
                    this.addMetaDefinitions((MetadataObject)indirectValue.getValue());
                    break;
                }
            }
        }
    }

    private void addClassHierarchy(ClassDefinition baseClass) {
        if (baseClass.equals(Warehouse.lookForClass(ApplicationPluginObject.class)) || baseClass.equals(Warehouse.lookForClass(ApplicationReferencedObject.class))) {
            return;
        }
        if (this.classDefinitions.contains(baseClass)) {
            return;
        }
        this.classDefinitions.add(baseClass.clone());
        if (!baseClass.isRoot()) {
            this.addClassHierarchy(baseClass.getParent());
        }
        for (PropertyDefinition propertyDefinition : baseClass.getPropertyDefinitions()) {
            TypeDefinition type = propertyDefinition.getTypeDefinition();
            if (type == null) continue;
            this.addType(type);
        }
    }

    private void addType(TypeDefinition type) {
        if (this.typeDefinitions.contains(type)) {
            return;
        }
        this.typeDefinitions.add(type);
        switch (type.getTypeCategory()) {
            case WeakObjRef: 
            case StrongObjRef: {
                this.addClassHierarchy(((TypeDefinitionObjectReference)type).getObjectType());
                break;
            }
            case Rename: {
                this.addType(((TypeDefinitionRename)type).getBaseType());
                break;
            }
            case Enum: {
                this.addType(((TypeDefinitionEnumeration)type).getElementType());
                break;
            }
            case FixedArray: {
                this.addType(((TypeDefinitionFixedArray)type).getType());
                break;
            }
            case Record: {
                TypeDefinitionRecord recordType = (TypeDefinitionRecord)type;
                for (int x = 0; x < recordType.getCount(); ++x) {
                    this.addType(recordType.getMemberType(x));
                }
                break;
            }
            case Set: {
                this.addType(((TypeDefinitionSet)type).getElementType());
                break;
            }
            case VariableArray: {
                this.addType(((TypeDefinitionVariableArray)type).getType());
                break;
            }
            case String: {
                this.addType(((TypeDefinitionString)type).getElementType());
                break;
            }
        }
    }

    @Override
    public void makeStatic() {
        this.dynamic = false;
        this.classDefinitions = null;
        this.typeDefinitions = null;
    }

    @Override
    public boolean getIsDynamic() {
        return this.dynamic;
    }

    public String toString() {
        return MediaEngine.toString(this);
    }

    public int hashCode() {
        return MediaEngine.hashCode(this);
    }

    public boolean equals(Object o) {
        return MediaEngine.equals(this, o);
    }

    @Override
    public MetaDictionary clone() {
        try {
            return (MetaDictionary)super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new InternalError(cnse.getMessage());
        }
    }
}

