/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.io.mxf;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import tv.amwa.maj.exception.EndOfDataException;
import tv.amwa.maj.exception.InsufficientSpaceException;
import tv.amwa.maj.industry.MediaEngine;
import tv.amwa.maj.industry.MetadataObject;
import tv.amwa.maj.industry.PropertyValue;
import tv.amwa.maj.io.mxf.CPSystemItem;
import tv.amwa.maj.io.mxf.EssenceElement;
import tv.amwa.maj.io.mxf.FixedLengthPack;
import tv.amwa.maj.io.mxf.HeaderMetadata;
import tv.amwa.maj.io.mxf.IndexTable;
import tv.amwa.maj.io.mxf.IndexTableSegment;
import tv.amwa.maj.io.mxf.MAJMXFStreamException;
import tv.amwa.maj.io.mxf.MXFBuilder;
import tv.amwa.maj.io.mxf.MXFConstants;
import tv.amwa.maj.io.mxf.MXFUnit;
import tv.amwa.maj.io.mxf.PartitionPack;
import tv.amwa.maj.io.mxf.PrimerPack;
import tv.amwa.maj.io.mxf.RandomIndexItem;
import tv.amwa.maj.io.mxf.RandomIndexPack;
import tv.amwa.maj.io.mxf.UL;
import tv.amwa.maj.io.mxf.UnitType;
import tv.amwa.maj.io.mxf.impl.CPSystemItemImpl;
import tv.amwa.maj.io.mxf.impl.EssenceElementImpl;
import tv.amwa.maj.io.mxf.impl.HeaderMetadataImpl;
import tv.amwa.maj.io.mxf.impl.PrimerPackImpl;
import tv.amwa.maj.io.mxf.impl.RandomIndexPackImpl;
import tv.amwa.maj.io.mxf.impl.ResolutionEntry;
import tv.amwa.maj.meta.ClassDefinition;
import tv.amwa.maj.model.Preface;
import tv.amwa.maj.model.impl.PrefaceImpl;
import tv.amwa.maj.record.impl.AUIDImpl;

public class MXFStream {
    static final int RIP_BYTES_MAX = 262144;
    static final byte[] zeroBytes = new byte[4096];

    public static final MXFUnit readNextUnit(InputStream stream, long sizeLimit) throws IOException {
        KeyAndConsumed kandc = MXFStream.readKey(stream);
        if (kandc.getConsumed() > sizeLimit) {
            throw new MAJMXFStreamException("Size limit exceeded when reading key for next MXF unit.");
        }
        UnitType unitType = UnitType.typeFromKey(kandc.getKey());
        switch (unitType) {
            case HeaderClosedCompletePartitionPack: 
            case HeaderClosedIncompletePartitionPack: 
            case HeaderOpenCompletePartitionPack: 
            case HeaderOpenIncompletePartitionPack: 
            case FooterClosedCompletePartitionPack: 
            case FooterClosedIncompletePartitionPack: 
            case BodyClosedCompletePartitionPack: 
            case BodyClosedIncompletePartitionPack: 
            case BodyOpenCompletePartitionPack: 
            case BodyOpenIncompletePartitionPack: {
                return MXFStream.readPartitionPack(stream, kandc.getKey());
            }
            case HeaderMetadata: {
                return MXFStream.readHeaderMetadata(stream, kandc.getKey(), sizeLimit - kandc.getConsumed());
            }
            case ContentPackageEssenceElement: 
            case ContentPackagePicture: 
            case ContentPackageSound: 
            case ContentPackageData: 
            case GenericContainerEssenceElement: 
            case GenericContainerPicture: 
            case GenericContainerSound: 
            case GenericContainerData: 
            case GenericContainerCompound: {
                return MXFStream.readEssenceElement(stream, kandc.getKey());
            }
            case ContentPackageSystemItem: {
                return MXFStream.readCPSystemItem(stream, kandc.getKey());
            }
            case IndexTableSegment: {
                return MXFStream.readIndexTableSegment(stream, kandc.getKey());
            }
            case RandomIndexPack: {
                return MXFStream.readRandomIndexPack(stream, kandc.getKey());
            }
        }
        throw new MAJMXFStreamException("Unexpected element encountered when reading input stream, starting with key '" + kandc.getKey().toString() + "'.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final RandomIndexPack readRandomIndexPack(InputStream stream, long size) throws IOException {
        int bytesRead;
        long skipBytes = size > 262144L ? size - 262144L : 0L;
        byte[] lastBytesOfFile = new byte[262144];
        try {
            MXFStream.skipForward(stream, skipBytes);
            bytesRead = stream.read(lastBytesOfFile);
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
        if (bytesRead < 36) {
            throw new MAJMXFStreamException("Input stream does not contain RIP as total bytes read from file is too low.");
        }
        ByteBuffer buffer = ByteBuffer.wrap(lastBytesOfFile, 0, bytesRead);
        buffer.position(buffer.limit() - 4);
        int ripOffset = buffer.getInt();
        if (ripOffset > buffer.limit()) {
            throw new MAJMXFStreamException("Input stream does not contain a valid RIP offset value. File does not contain a readable RIP.");
        }
        buffer.position(buffer.limit() - ripOffset);
        RandomIndexPack rip = RandomIndexPackImpl.createFromBytes(buffer);
        if (rip == null) {
            throw new MAJMXFStreamException("Input stream does not contain a valid RIP.");
        }
        return rip;
    }

    public static final HeaderMetadata readHeaderMetadata(InputStream stream, long headerSize) throws IOException {
        KeyAndConsumed kandc = MXFStream.readKey(stream);
        return MXFStream.readHeaderMetadata(stream, kandc.getKey(), headerSize - 16L);
    }

    static final HeaderMetadata readHeaderMetadata(InputStream stream, UL primerKey, long headerSize) throws IOException {
        Object candidatePack = null;
        PrimerPack primerPack = null;
        long primerSize = 0L;
        try {
            LengthAndConsumed landc = MXFStream.readBERLength(stream);
            primerSize = landc.getLength();
            ByteBuffer primerBytes = MXFStream.readValue(stream, primerSize);
            headerSize -= landc.getTotal();
            candidatePack = MXFBuilder.readFixedLengthPack((AUIDImpl)primerKey, primerBytes);
            primerPack = (PrimerPack)candidatePack;
        }
        catch (EndOfDataException eode) {
            throw new MAJMXFStreamException("Insufficient bytes in header bytes read from stream to create a primer pack.");
        }
        catch (IllegalArgumentException ioe) {
            throw new MAJMXFStreamException("Insufficient bytes in header bytes read from stream to create a primer pack, detected on setting primer pack buffer limit for primer pack size '" + primerSize + "'.");
        }
        catch (BufferUnderflowException bue) {
            throw new MAJMXFStreamException("Insufficient bytes in header bytes read from stream to create a primer length.");
        }
        catch (ClassCastException cce) {
            throw new MAJMXFStreamException("Expected a primer pack in header metadata bytes but found an instance of '" + candidatePack.getClass().getCanonicalName() + "'.");
        }
        HashMap<AUIDImpl, MetadataObject> referenceTable = new HashMap<AUIDImpl, MetadataObject>();
        Vector<ResolutionEntry> resolutions = new Vector<ResolutionEntry>();
        PrefaceImpl preface = null;
        try {
            while (headerSize > 0L) {
                UL metadataKey = MXFStream.readSingleKey(stream);
                headerSize -= 16L;
                if (MXFBuilder.isKLVFill(metadataKey)) {
                    headerSize -= MXFStream.readPastFill(stream);
                    continue;
                }
                LengthAndConsumed landc = MXFStream.readBERLength(stream);
                ByteBuffer headerBytes = MXFStream.readValue(stream, landc.getLength());
                headerSize -= landc.getTotal();
                MetadataObject metadataFromFile = MXFBuilder.readLocalSet((AUIDImpl)metadataKey, headerBytes, primerPack, referenceTable, resolutions);
                if (!(metadataFromFile instanceof Preface)) continue;
                preface = (PrefaceImpl)metadataFromFile;
            }
        }
        catch (Exception e) {
            throw new MAJMXFStreamException("Problem reading header metadata from file, caused by a " + e.getClass().getName() + ": " + e.getMessage() + ".", e);
        }
        if (preface == null) {
            throw new MAJMXFStreamException("No preface local set found in MXF header metadata.");
        }
        for (ResolutionEntry resolutionEntry : resolutions) {
            resolutionEntry.resolve(referenceTable);
        }
        return new HeaderMetadataImpl(primerPack, preface);
    }

    public static final PartitionPack readPartitionPack(InputStream stream) throws IOException {
        KeyAndConsumed kandc = MXFStream.readKey(stream);
        return MXFStream.readPartitionPack(stream, kandc.getKey());
    }

    static final PartitionPack readPartitionPack(InputStream stream, UL key) throws IOException {
        long size = MXFStream.readBERLength(stream).getLength();
        if (size > 4096L) {
            throw new MAJMXFStreamException("Extremely unlikely size for a partition pack '" + size + "' when reading a stream.");
        }
        ByteBuffer packValue = MXFStream.readValue(stream, size);
        FixedLengthPack candidatePack = null;
        try {
            candidatePack = MXFBuilder.readFixedLengthPack(key, packValue);
        }
        catch (EndOfDataException eode) {
            throw new MAJMXFStreamException("Insufficient bytes read from stream to create a valid partition pack.");
        }
        try {
            return (PartitionPack)((Object)candidatePack);
        }
        catch (ClassCastException cce) {
            throw new MAJMXFStreamException("Value read from stream was not a partition pack as expected, but rather an instance of '" + candidatePack.getClass().getCanonicalName() + "'.");
        }
    }

    public static final EssenceElement readEssenceElement(InputStream stream) throws IOException {
        KeyAndConsumed kandc = MXFStream.readKey(stream);
        return MXFStream.readEssenceElement(stream, kandc.getKey());
    }

    static final EssenceElement readEssenceElement(InputStream stream, UL essenceKey) throws IOException {
        long size = MXFStream.readBERLength(stream).getLength();
        byte[] elementData = new byte[(int)size];
        if ((long)stream.read(elementData, 0, (int)size) < size) {
            throw new MAJMXFStreamException("Failed to read complete essence element into memory.");
        }
        if (!EssenceElementImpl.isEssenceElement(essenceKey)) {
            throw new MAJMXFStreamException("Expected essence element key but found '" + essenceKey.toString() + "'.");
        }
        return EssenceElementImpl.make(essenceKey, ByteBuffer.wrap(elementData));
    }

    public static final int readEssenceElementWithTrackID(InputStream stream, byte[] elementData) throws IOException {
        KeyAndConsumed kandc = MXFStream.readKey(stream);
        return MXFStream.readEssenceElementWithTrackID(stream, kandc.getKey(), elementData);
    }

    static final int readEssenceElementWithTrackID(InputStream stream, UL essenceElementKey, byte[] elementData) throws IOException {
        long size = MXFStream.readBERLength(stream).getLength();
        if ((long)elementData.length < size) {
            throw new MAJMXFStreamException("Insufficient space in element data array to read in an essence element.");
        }
        if ((long)stream.read(elementData, 0, (int)size) < size) {
            throw new MAJMXFStreamException("Failed to read complete essence element into memory.");
        }
        if (!EssenceElementImpl.isEssenceElement(essenceElementKey)) {
            throw new MAJMXFStreamException("Expected essence element key but found '" + essenceElementKey.toString() + "'.");
        }
        byte[] keyBytes = essenceElementKey.getUniversalLabel();
        int essenceTrackID = (keyBytes[12] & 0xFF) << 24 | (keyBytes[13] & 0xFF) << 16 | (keyBytes[14] & 0xFF) << 8 | keyBytes[15] & 0xFF;
        return essenceTrackID;
    }

    public static final int readEssenceElementWithBytesRead(InputStream stream, byte[] elementData) throws IOException {
        KeyAndConsumed kandc = MXFStream.readKey(stream);
        return MXFStream.readEssenceElementWithBytesRead(stream, kandc.getKey(), elementData);
    }

    static final int readEssenceElementWithBytesRead(InputStream stream, UL essenceElementKey, byte[] elementData) throws IOException {
        int bytesRead;
        long size = MXFStream.readBERLength(stream).getLength();
        if ((long)elementData.length < size) {
            throw new MAJMXFStreamException("Insufficient space in element data array to read in an essence element.");
        }
        int totalBytesRead = 0;
        while ((long)totalBytesRead < size && (bytesRead = stream.read(elementData, totalBytesRead, (int)(size - (long)totalBytesRead))) > 0) {
            totalBytesRead += bytesRead;
        }
        if ((long)totalBytesRead < size) {
            throw new MAJMXFStreamException("Failed to read complete essence element into memory.");
        }
        if (!EssenceElementImpl.isEssenceElement(essenceElementKey)) {
            throw new MAJMXFStreamException("Expected essence element key but found '" + essenceElementKey.toString() + "'.");
        }
        return totalBytesRead;
    }

    public static final void writeEssenceElement(OutputStream stream, int essenceTrackID, byte[] elementData) throws IOException {
        byte[] essenceElementBase = ((UL)EssenceElement.essenceElementBase).getUniversalLabel();
        stream.write(essenceElementBase, 0, 12);
        byte[] essenceTrackIDBytes = ByteBuffer.allocate(4).putInt(essenceTrackID).array();
        stream.write(essenceTrackIDBytes);
        MXFStream.writeBERLength(stream, elementData.length, 8);
        stream.write(elementData);
    }

    public static final void writeEssenceElement(OutputStream stream, int essenceTrackID, byte[] elementData, int offset, int length) throws IOException {
        byte[] essenceElementBase = ((UL)EssenceElement.essenceElementBase).getUniversalLabel();
        stream.write(essenceElementBase, 0, 12);
        byte[] essenceTrackIDBytes = ByteBuffer.allocate(4).putInt(essenceTrackID).array();
        stream.write(essenceTrackIDBytes);
        MXFStream.writeBERLength(stream, length, 8);
        stream.write(elementData, offset, length);
    }

    public static final CPSystemItem readCPSystemItem(InputStream stream) throws IOException {
        KeyAndConsumed kandc = MXFStream.readKey(stream);
        return MXFStream.readCPSystemItem(stream, kandc.getKey());
    }

    static final CPSystemItem readCPSystemItem(InputStream stream, UL cpSystemItemKey) throws IOException {
        long size = MXFStream.readBERLength(stream).getLength();
        byte[] cpSystemItemBytes = new byte[(int)size];
        if ((long)stream.read(cpSystemItemBytes, 0, (int)size) < size) {
            throw new MAJMXFStreamException("Failed to read complete CP system item into memory.");
        }
        if (!cpSystemItemKey.equals(CPSystemItemImpl.key)) {
            throw new MAJMXFStreamException("Expected a CP system item key but found '" + cpSystemItemKey.toString() + "'.");
        }
        CPSystemItem cpSystemItem = CPSystemItemImpl.make(ByteBuffer.wrap(cpSystemItemBytes));
        return cpSystemItem;
    }

    public static final IndexTableSegment readIndexTableSegment(InputStream stream) throws IOException {
        KeyAndConsumed kandc = MXFStream.readKey(stream);
        return MXFStream.readIndexTableSegment(stream, kandc.getKey());
    }

    static final IndexTableSegment readIndexTableSegment(InputStream stream, UL key) throws IOException {
        long size = MXFStream.readBERLength(stream).getLength();
        ByteBuffer indexValue = MXFStream.readValue(stream, size);
        HashMap<AUIDImpl, MetadataObject> referenceTable = new HashMap<AUIDImpl, MetadataObject>();
        Vector<ResolutionEntry> resolutions = new Vector<ResolutionEntry>();
        try {
            MetadataObject candidateSegment = MXFBuilder.readLocalSet(key, indexValue, IndexTable.indexPrimer, referenceTable, resolutions);
            return (IndexTableSegment)candidateSegment;
        }
        catch (Exception e) {
            throw new MAJMXFStreamException(e.getClass().getName() + " throw when trying to read an index table segment.", e);
        }
    }

    public static final RandomIndexPack readRandomIndexPack(InputStream stream) throws IOException {
        KeyAndConsumed kandc = MXFStream.readKey(stream);
        return MXFStream.readRandomIndexPack(stream, kandc.getKey());
    }

    static final RandomIndexPack readRandomIndexPack(InputStream stream, UL key) throws IOException {
        long size = MXFStream.readBERLength(stream).getLength();
        ByteBuffer ripBytes = MXFStream.readValue(stream, size);
        try {
            RandomIndexPack rip = RandomIndexPackImpl.createFromBytes(ripBytes);
            return rip;
        }
        catch (BufferUnderflowException bue) {
            throw new MAJMXFStreamException("Insufficient bytes in buffer to read a complete random index pack.");
        }
    }

    public static final HeaderMetadata readFooterHeaderMetadata(InputStream inputStream, int pag) throws IOException {
        return null;
    }

    public static final HeaderMetadata readFooterHeaderMetadata(InputStream inputStream, long footerPartitionOffset) throws IOException {
        return null;
    }

    public static final void writePartitionPack(OutputStream stream, PartitionPack pack) throws IOException {
        long partitionPackSize = pack.getEncodedSize();
        ByteBuffer partitionBytes = ByteBuffer.allocate((int)partitionPackSize);
        try {
            MXFBuilder.writeFixedLengthPack((FixedLengthPack)((Object)pack), partitionBytes);
        }
        catch (InsufficientSpaceException ise) {
            throw new MAJMXFStreamException("Unexpetedly, insufficient space for partition pack in buffer.", ise);
        }
        ClassDefinition theClass = MediaEngine.getClassDefinition(pack);
        MXFStream.writeKey(stream, (UL)theClass.getAUID());
        MXFStream.writeBERLength(stream, partitionPackSize, 4);
        MXFStream.writeValue(stream, partitionBytes);
    }

    public static final void writeHeaderMetadata(OutputStream stream, Preface preface) throws IOException {
        PrimerPackImpl primerPack = new PrimerPackImpl();
        primerPack.addLocalTagEntry((short)15370, MXFConstants.InstanceUID);
        long lengthOfAllSets = PrimerPackImpl.addPropertiesForObject(primerPack, preface);
        ByteBuffer primerAndPreface = ByteBuffer.allocate((int)(lengthOfAllSets + (long)PrimerPackImpl.lengthAsBytes(primerPack)));
        try {
            primerAndPreface.rewind();
            PrimerPackImpl.writeAsBytes(primerPack, primerAndPreface);
            ArrayList<PropertyValue> stillToWrite = new ArrayList<PropertyValue>();
            MXFBuilder.writeLocalSet(preface, primerAndPreface, (PrimerPack)primerPack, stillToWrite);
            while (stillToWrite.size() > 0) {
                PropertyValue headItem = (PropertyValue)stillToWrite.remove(0);
                MXFBuilder.writeLocalSet(headItem, primerAndPreface, (PrimerPack)primerPack, stillToWrite);
            }
        }
        catch (InsufficientSpaceException ise) {
            throw new MAJMXFStreamException("Unxepectedly, insufficient space to write primer pack and local sets.", ise);
        }
        catch (BufferOverflowException boe) {
            throw new MAJMXFStreamException("Unxepectedly, insufficient space to write primer pack and local sets.", boe);
        }
        MXFStream.writeValue(stream, primerAndPreface);
    }

    public static final void writeIndexTableSegment(OutputStream stream, IndexTableSegment indexTableSegment) throws IOException {
        long indexSegmentSize = MXFBuilder.lengthOfLocalSet(indexTableSegment);
        ByteBuffer indexBuffer = ByteBuffer.allocate((int)(indexSegmentSize + 20L));
        try {
            indexBuffer.rewind();
            MXFBuilder.writeLocalSet(indexTableSegment, indexBuffer, IndexTable.indexPrimer, new ArrayList<PropertyValue>());
            indexBuffer.rewind();
        }
        catch (InsufficientSpaceException ise) {
            throw new MAJMXFStreamException("Unxepectedly, insufficient space to write index table segment local set.", ise);
        }
        catch (BufferOverflowException boe) {
            throw new MAJMXFStreamException("Unxepectedly, insufficient space to write index table segment local set.", boe);
        }
        MXFStream.writeValue(stream, indexBuffer);
    }

    public static final void writeRandomIndexPack(OutputStream stream, RandomIndexPack rip) throws IOException {
        MXFStream.writeKey(stream, RandomIndexPack.ripKeyValue);
        MXFStream.writeBERLength(stream, 12 * rip.count() + 4, 4);
        for (RandomIndexItem item : rip.getPartitionIndex()) {
            int bodySID = item.getBodySID();
            stream.write(ByteBuffer.allocate(4).putInt(bodySID).array());
            long byteOffset = item.getByteOffset();
            stream.write(ByteBuffer.allocate(8).putLong(byteOffset).array());
        }
        stream.write(ByteBuffer.allocate(4).putInt(rip.getLength()).array());
    }

    public static final KeyAndConsumed readKey(InputStream stream) throws IOException {
        byte[] keyBytes = new byte[16];
        int bytesRead = stream.read(keyBytes);
        if (bytesRead < 0) {
            throw new MAJMXFStreamException("Unexpectedly reached the end of the stream in the middle of reading a key.");
        }
        if (bytesRead < 16) {
            throw new MAJMXFStreamException("Insufficient bytes remaing in stream to read a complete key.");
        }
        long consumed = 16L;
        while (bytesRead == 16) {
            byte[] keySwap = new byte[16];
            for (int x = 0; x < 8; ++x) {
                keySwap[x] = keyBytes[x + 8];
                keySwap[x + 8] = keyBytes[x];
            }
            AUIDImpl readKey = new AUIDImpl(keySwap);
            if (!MXFBuilder.isKLVFill(readKey)) {
                return new KeyAndConsumed(readKey, consumed);
            }
            consumed += MXFStream.readPastFill(stream);
            bytesRead = stream.read(keyBytes);
            consumed += (long)bytesRead;
        }
        throw new MAJMXFStreamException("Insufficient bytes remaing in stream to read a complete key.");
    }

    public static final UL readSingleKey(InputStream stream) throws IOException {
        byte[] keyBytes = new byte[16];
        int bytesRead = stream.read(keyBytes);
        if (bytesRead < 0) {
            throw new MAJMXFStreamException("Unexpectedly reached the end of the stream in the middle of reading a key.");
        }
        if (bytesRead < 16) {
            throw new MAJMXFStreamException("Insufficient bytes remaing in stream to read a complete key.");
        }
        byte[] keySwap = new byte[16];
        for (int x = 0; x < 8; ++x) {
            keySwap[x] = keyBytes[x + 8];
            keySwap[x + 8] = keyBytes[x];
        }
        AUIDImpl readKey = new AUIDImpl(keySwap);
        return readKey;
    }

    public static final LengthAndConsumed readBERLength(InputStream stream) throws IOException {
        int first = stream.read();
        if (first == -1) {
            throw new MAJMXFStreamException("Unexpectedly readed the end of the stream when reading a length.");
        }
        if (first < 128) {
            return new LengthAndConsumed(first, 1L);
        }
        int berTailLength = first & 0x7F;
        byte[] lengthData = new byte[berTailLength];
        for (int bytesRead = stream.read(lengthData); bytesRead < berTailLength; bytesRead += stream.read(lengthData, bytesRead, berTailLength - bytesRead)) {
            System.out.println("Bytes read less than BER tail length when reading length, with bytesRead = " + bytesRead + " and berTailLength = " + berTailLength + " and input stream " + stream.getClass().getCanonicalName());
            if (bytesRead >= 0) continue;
            throw new MAJMXFStreamException("Unexpectedly reached the end of the stream after the first byte when reading a length.");
        }
        long lengthValue = 0L;
        for (int u = 0; u < lengthData.length; ++u) {
            lengthValue = lengthValue << 8 | (long)(lengthData[u] >= 0 ? lengthData[u] : 256 + lengthData[u]);
        }
        return new LengthAndConsumed(lengthValue, 1L + (long)berTailLength);
    }

    public static final ByteBuffer readValue(InputStream stream, long size) throws IOException {
        if (size > Runtime.getRuntime().freeMemory()) {
            Runtime.getRuntime().gc();
            if (size > Runtime.getRuntime().freeMemory()) {
                throw new MAJMXFStreamException("Insufficient memory to read stream content value of size '" + size + "' into a byte buffer.");
            }
        }
        if (size > Integer.MAX_VALUE) {
            throw new MAJMXFStreamException("MAJ can only work with values up to '2147483647' in length.");
        }
        byte[] valueBytes = new byte[(int)size];
        int bytesRead = stream.read(valueBytes);
        while ((long)bytesRead < size) {
            System.out.println("Bytes read less than size on value read, with bytesRead = " + bytesRead + " and size = " + size + ".");
            if (bytesRead == -1) {
                throw new MAJMXFStreamException("Unexpectedly reached the end of the stream when reading a value.");
            }
            bytesRead += stream.read(valueBytes, bytesRead, (int)(size - (long)bytesRead));
        }
        return ByteBuffer.wrap(valueBytes);
    }

    public static final void writeKey(OutputStream stream, UL key) throws IOException {
        if (stream == null) {
            throw new NullPointerException("Cannot write a key to a null stream.");
        }
        if (key == null) {
            throw new NullPointerException("Cannot write a null key to a stream.");
        }
        byte[] keyBytes = key.getUniversalLabel();
        if (keyBytes[4] == 2 && keyBytes[5] == 6 && keyBytes[6] == 1) {
            keyBytes[5] = 83;
        }
        stream.write(keyBytes);
    }

    public static final void writeBERLength(OutputStream stream, long length, int encodedBytes) throws IOException {
        long maxValue;
        if (stream == null) {
            throw new NullPointerException("Cannot write a BER length to a null stream.");
        }
        if (length < 0L) {
            throw new IllegalArgumentException("Cannot write a negative length value.");
        }
        if (encodedBytes < 1 || encodedBytes > 9) {
            throw new IllegalArgumentException("The number of encoded bytes must be between 1 and 9.");
        }
        if (encodedBytes == 1) {
            if (length > 127L) {
                throw new IllegalArgumentException("The number of encoded bytes is 1 but the length is greater than 127.");
            }
            stream.write((byte)length);
            return;
        }
        if (length >= (maxValue = 2L << --encodedBytes * 8)) {
            throw new IllegalArgumentException("The given length of " + length + " is greater than the maximum value for the given number of bytes to encode at " + maxValue + ".");
        }
        stream.write(128 + encodedBytes);
        for (int x = encodedBytes - 1; x >= 0; --x) {
            long mask = 255 << x * 8;
            stream.write((int)((length & mask) >> x * 8));
        }
    }

    public static final void writeValue(OutputStream stream, ByteBuffer buffer) throws IOException {
        buffer.rewind();
        if (buffer.hasArray()) {
            stream.write(buffer.array());
        } else {
            while (buffer.hasRemaining()) {
                stream.write(buffer.get());
            }
            buffer.rewind();
        }
    }

    public static final void writeFill(OutputStream stream, long totalLength) throws IOException {
        if (stream == null) {
            throw new NullPointerException("Cannot write a KLV fill item into a null stream.");
        }
        if (totalLength < 20L) {
            throw new IllegalArgumentException("Cannot write a fill value less than 20 bytes and '" + totalLength + "' is requested.");
        }
        MXFStream.writeKey(stream, (UL)MXFConstants.KLVFill);
        int encodedLength = totalLength < 0x2000000L ? 4 : 8;
        MXFStream.writeBERLength(stream, totalLength -= (long)(16 + encodedLength), encodedLength);
        long bytesWritten = 0L;
        for (long x = (long)zeroBytes.length; x < totalLength; x += (long)zeroBytes.length) {
            stream.write(zeroBytes);
            bytesWritten += (long)zeroBytes.length;
        }
        stream.write(zeroBytes, 0, (int)(totalLength - bytesWritten));
    }

    public static final long readPastFill(InputStream stream) throws IOException {
        LengthAndConsumed landc = MXFStream.readBERLength(stream);
        MXFStream.skipForward(stream, landc.getLength());
        return landc.getTotal();
    }

    public static final long skipForward(InputStream sourceStream, long bytesToSkip) throws IOException {
        long bytesSkipped;
        long bytesSkippedThisTime = 0L;
        for (bytesSkipped = 0L; bytesSkipped < bytesToSkip && (bytesSkippedThisTime = sourceStream.skip(bytesToSkip - bytesSkipped)) > 0L; bytesSkipped += bytesSkippedThisTime) {
        }
        return bytesSkipped;
    }

    static {
        for (int x = 0; x < zeroBytes.length; ++x) {
            MXFStream.zeroBytes[x] = 0;
        }
    }

    public static final class LengthAndConsumed {
        private long length;
        private long consumed;

        public LengthAndConsumed(long length, long consumed) {
            this.length = length;
            this.consumed = consumed;
        }

        public long getLength() {
            return this.length;
        }

        public long getConsumed() {
            return this.consumed;
        }

        public long getTotal() {
            return this.length + this.consumed;
        }
    }

    public static class KeyAndConsumed {
        private UL key;
        private long consumed;

        public KeyAndConsumed(UL key, long consumed) {
            this.key = key;
            this.consumed = consumed;
        }

        public UL getKey() {
            return this.key;
        }

        public long getConsumed() {
            return this.consumed;
        }
    }
}

