/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.model.impl;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import tv.amwa.maj.exception.BadLengthException;
import tv.amwa.maj.exception.BadPropertyException;
import tv.amwa.maj.exception.InvalidDataDefinitionException;
import tv.amwa.maj.exception.PropertyNotPresentException;
import tv.amwa.maj.exception.SegmentNotFoundException;
import tv.amwa.maj.industry.MediaClass;
import tv.amwa.maj.industry.MediaListAppend;
import tv.amwa.maj.industry.MediaProperty;
import tv.amwa.maj.industry.MediaPropertyClear;
import tv.amwa.maj.industry.MediaPropertyCount;
import tv.amwa.maj.industry.MediaPropertyRemove;
import tv.amwa.maj.industry.MediaPropertySetter;
import tv.amwa.maj.industry.StrongReferenceVector;
import tv.amwa.maj.model.Segment;
import tv.amwa.maj.model.Selector;
import tv.amwa.maj.model.impl.DataDefinitionImpl;
import tv.amwa.maj.model.impl.FillerImpl;
import tv.amwa.maj.model.impl.SegmentImpl;

@MediaClass(uuid1=0xD010101, uuid2=257, uuid3=3584, uuid4={6, 14, 43, 52, 2, 6, 1, 1}, definedName="Selector", description="The Selector class provides the value of a single Segment while preserving references to unused alternatives.", symbol="Selector")
public class SelectorImpl
extends SegmentImpl
implements Selector,
Serializable,
Cloneable {
    private static final long serialVersionUID = -4427002615493374453L;
    private Segment selectedSegment;
    private List<Segment> alternateSegments = Collections.synchronizedList(new Vector());

    public SelectorImpl() {
    }

    public SelectorImpl(Segment selected) throws NullPointerException, BadLengthException {
        if (selected == null) {
            throw new NullPointerException("Cannot create a new selector with a null segment.");
        }
        this.setComponentDataDefinition(selected.getComponentDataDefinition());
        this.setLengthPresent(true);
        try {
            this.setComponentLength(selected.getComponentLength());
        }
        catch (BadPropertyException bpe) {
            this.setLengthPresent(false);
        }
        this.selectedSegment = selected.clone();
    }

    @MediaProperty(uuid1=100729092, uuid2=1544, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="AlternateSegments", aliases={"Alternates"}, typeName="SegmentStrongReferenceVector", optional=true, uniqueIdentifier=false, pid=3842, symbol="AlternateSegments")
    public List<Segment> getAlternateSegments() throws PropertyNotPresentException {
        if (this.alternateSegments.size() == 0) {
            throw new PropertyNotPresentException("No alternates are present for this selector.");
        }
        return StrongReferenceVector.getOptionalList(this.alternateSegments);
    }

    @Override
    @MediaListAppend(value="AlternateSegments")
    public void appendAlternateSegment(Segment segment) throws NullPointerException, BadLengthException, InvalidDataDefinitionException {
        if (segment == null) {
            throw new NullPointerException("Cannot append a null-valued segment to the lost of alternatives of this selector.");
        }
        this.checkCompatible(segment);
        StrongReferenceVector.append(this.alternateSegments, segment);
    }

    @Override
    @MediaPropertyCount(value="AlternateSegments")
    public int countAlternateSegments() {
        return this.alternateSegments.size();
    }

    @Override
    @MediaPropertyRemove(value="AlternateSegments")
    public void removeAlternateSegment(Segment segment) throws NullPointerException, SegmentNotFoundException {
        if (segment == null) {
            throw new NullPointerException("Cannot remove a segment from the list of alternates of this selector using a null-valued segment.");
        }
        if (!this.alternateSegments.contains(segment)) {
            throw new SegmentNotFoundException("The given segment could not be found in the list of alternatives of this selector.");
        }
        StrongReferenceVector.remove(this.alternateSegments, segment);
    }

    @MediaPropertyClear(value="AlternateSegments")
    public void clearAlternates() {
        this.alternateSegments = Collections.synchronizedList(new Vector());
    }

    @Override
    @MediaProperty(uuid1=100729092, uuid2=521, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="SelectedSegment", aliases={"Selected"}, typeName="SegmentStrongReference", optional=false, uniqueIdentifier=false, pid=3841, symbol="SelectedSegment")
    public Segment getSelectedSegment() {
        return this.selectedSegment;
    }

    @Override
    @MediaPropertySetter(value="SelectedSegment")
    public void setSelectedSegment(Segment selectedSegment) throws NullPointerException, BadLengthException, InvalidDataDefinitionException {
        if (selectedSegment == null) {
            throw new NullPointerException("Cannot set the selected segment of this selector from a null-valued segment.");
        }
        this.checkCompatible(selectedSegment);
        Segment replacement = selectedSegment;
        if (!this.alternateSegments.contains(this.selectedSegment)) {
            StrongReferenceVector.append(this.alternateSegments, selectedSegment);
        }
        if (this.alternateSegments.contains(replacement)) {
            this.alternateSegments.remove(replacement);
        }
        this.selectedSegment = replacement;
    }

    public static final Segment initializeSelectedSegment() {
        return new FillerImpl(DataDefinitionImpl.forName("Unknown"));
    }

    private void checkCompatible(Segment segment) throws BadLengthException, InvalidDataDefinitionException {
        block13: {
            if (this.alternateSegments.size() == 0) {
                try {
                    segment.getComponentLength();
                    this.setLengthPresent(true);
                    this.setComponentLength(segment.getComponentLength());
                }
                catch (BadPropertyException bpe) {
                    this.setLengthPresent(false);
                }
                try {
                    this.getComponentDataDefinition();
                }
                catch (NullPointerException npe) {
                    this.setComponentDataDefinition(segment.getComponentDataDefinition());
                }
            }
            if (this.getComponentDataDefinition().getName().contains("test-string")) {
                return;
            }
            if (this.getLengthPresent()) {
                try {
                    if (this.getComponentLength() != segment.getComponentLength()) {
                        throw new BadLengthException("The given segment does not have the same length as this selector.");
                    }
                    break block13;
                }
                catch (BadPropertyException bpe) {
                    throw new BadLengthException("The given segment has a present length property and this selector does not.");
                }
            }
            try {
                segment.getComponentLength();
                throw new BadLengthException("The given segment has a length property set and this selector does not.");
            }
            catch (BadPropertyException badPropertyException) {
                // empty catch block
            }
        }
        if (!this.getComponentDataDefinition().equals(segment.getComponentDataDefinition())) {
            throw new InvalidDataDefinitionException("The given segment does not have the same data definition as this selector.");
        }
    }

    @Override
    public Selector clone() {
        return (Selector)super.clone();
    }
}

