/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.union.impl;

import java.io.Serializable;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import tv.amwa.maj.enumeration.FadeType;
import tv.amwa.maj.exception.BadLengthException;
import tv.amwa.maj.io.xml.XMLBuilder;
import tv.amwa.maj.io.xml.XMLSerializable;
import tv.amwa.maj.misctype.LengthType;
import tv.amwa.maj.record.Rational;
import tv.amwa.maj.record.impl.RationalImpl;
import tv.amwa.maj.union.DefaultFade;

public class DefaultFadeImpl
implements DefaultFade,
XMLSerializable,
Serializable,
Cloneable {
    private static final long serialVersionUID = -3254222018572655370L;
    @LengthType
    private long fadeLength;
    private FadeType fadeType;
    private Rational fadeEditUnit;
    static final String DEFAULTFADE_TAG = "DefaultFade";
    static final String DEFAULTFADELENGTH_TAG = "DefaultFadeLength";
    static final String DEFAULTFADEEDITUNIT_TAG = "DefaultFadeEditUnit";
    static final String DEFAULTFADETYPE_TAG = "DefaultFadeType";

    public DefaultFadeImpl(@LengthType long fadeLength, FadeType fadeType, Rational fadeEditUnit) throws NullPointerException, BadLengthException {
        if (fadeEditUnit == null) {
            throw new NullPointerException("Cannot create a default fade with a null value for fade edit unit.");
        }
        if (fadeType == null) {
            throw new NullPointerException("Cannot create a default fade with a null value for fade type.");
        }
        this.setFadeLength(fadeLength);
        this.setFadeType(fadeType);
        this.setFadeEditUnit(fadeEditUnit);
    }

    public DefaultFadeImpl() {
        this.fadeLength = 0L;
        this.fadeType = FadeType.None;
        this.setFadeEditUnit(new RationalImpl(0, 1));
    }

    @Override
    public Rational getFadeEditUnit() {
        return this.fadeEditUnit.clone();
    }

    @Override
    public void setFadeEditUnit(Rational fadeEditUnit) throws NullPointerException {
        if (fadeEditUnit == null) {
            throw new NullPointerException("Cannot set the fade edit unit of a default fade using a null value.");
        }
        this.fadeEditUnit = new RationalImpl(fadeEditUnit.getNumerator(), fadeEditUnit.getDenominator());
    }

    @Override
    @LengthType
    public long getFadeLength() {
        return this.fadeLength;
    }

    @Override
    public void setFadeLength(@LengthType long fadeLength) throws BadLengthException {
        if (fadeLength < 0L) {
            throw new BadLengthException("Cannot set the length of a default fade to a negative value.");
        }
        this.fadeLength = fadeLength;
    }

    @Override
    public FadeType getFadeType() {
        return this.fadeType;
    }

    @Override
    public void setFadeType(FadeType fadeType) throws NullPointerException {
        if (fadeType == null) {
            throw new NullPointerException("Cannot set the fade type of a default fade with a null value.");
        }
        this.fadeType = fadeType;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof DefaultFade)) {
            return false;
        }
        DefaultFade testFade = (DefaultFade)o;
        if (testFade.getFadeLength() != this.fadeLength) {
            return false;
        }
        if (testFade.getFadeType() != this.fadeType) {
            return false;
        }
        return this.fadeEditUnit.equals(testFade.getFadeEditUnit());
    }

    public int hashCode() {
        return new Long(this.fadeLength).hashCode() ^ ~this.fadeEditUnit.hashCode() ^ this.fadeType.hashCode();
    }

    @Override
    public void appendXMLChildren(Node parent) {
        XMLBuilder.appendComment(parent, "The DefaultFade tag is not valid AAF XML.");
        Element referenceElement = XMLBuilder.createChild(parent, "http://www.amwa.tv/projects/maj", "maj", DEFAULTFADE_TAG);
        XMLBuilder.appendElement((Node)referenceElement, "http://www.smpte-ra.org/schemas/2001-2/2007/aaf", "aaf", DEFAULTFADELENGTH_TAG, this.fadeLength);
        XMLBuilder.appendElement((Node)referenceElement, "http://www.smpte-ra.org/schemas/2001-2/2007/aaf", "aaf", DEFAULTFADEEDITUNIT_TAG, this.fadeEditUnit.toString());
        XMLBuilder.appendElement((Node)referenceElement, "http://www.smpte-ra.org/schemas/2001-2/2007/aaf", "aaf", DEFAULTFADETYPE_TAG, this.fadeType.symbol());
    }

    @Override
    public String getComment() {
        return null;
    }

    public String toString() {
        return XMLBuilder.toXMLNonMetadata(this);
    }

    @Override
    public DefaultFade clone() {
        try {
            return (DefaultFade)super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new InternalError("Clone is supported. Should never get here.");
        }
    }
}

