package com.portalmedia.embarc.gui;

import java.util.HashMap;
import java.util.TreeMap;

public class RFC5646LanguageTags {

	private HashMap<String, String> values = new HashMap<String, String>();

	public RFC5646LanguageTags() {
		values.put("", "");
		values.put("af", "af | Afrikaans");
		values.put("af-ZA", "af-ZA | Afrikaans (South Africa)");
		values.put("ar", "ar | Arabic");
		values.put("ar-AE", "ar-AE | Arabic (U.A.E.)");
		values.put("ar-BH", "ar-BH | Arabic (Bahrain)");
		values.put("ar-DZ", "ar-DZ | Arabic (Algeria)");
		values.put("ar-EG", "ar-EG | Arabic (Egypt)");
		values.put("ar-IQ", "ar-IQ | Arabic (Iraq)");
		values.put("ar-JO", "ar-JO | Arabic (Jordan)");
		values.put("ar-KW", "ar-KW | Arabic (Kuwait)");
		values.put("ar-LB", "ar-LB | Arabic (Lebanon)");
		values.put("ar-LY", "ar-LY | Arabic (Libya)");
		values.put("ar-MA", "ar-MA | Arabic (Morocco)");
		values.put("ar-OM", "ar-OM | Arabic (Oman)");
		values.put("ar-QA", "ar-QA | Arabic (Qatar)");
		values.put("ar-SA", "ar-SA | Arabic (Saudi Arabia)");
		values.put("ar-SY", "ar-SY | Arabic (Syria)");
		values.put("ar-TN", "ar-TN | Arabic (Tunisia)");
		values.put("ar-YE", "ar-YE | Arabic (Yemen)");
		values.put("az", "az | Azeri (Latin)");
		values.put("az-AZ", "az-AZ | Azeri (Latin) (Azerbaijan)");
		values.put("az-Cyrl-AZ", "az-Cyrl-AZ | Azeri (Cyrillic) (Azerbaijan)");
		values.put("be", "be | Belarusian");
		values.put("be-BY", "be-BY | Belarusian (Belarus)");
		values.put("bg", "bg | Bulgarian");
		values.put("bg-BG", "bg-BG | Bulgarian (Bulgaria)");
		values.put("bs-BA", "bg-BA | Bosnian (Bosnia and Herzegovina)");
		values.put("ca", "ca | Catalan");
		values.put("ca-ES", "ca-ES | Catalan (Spain)");
		values.put("cs", "cs | Czech");
		values.put("cs-CZ", "cd-CZ | Czech (Czech Republic)");
		values.put("cy", "cy | Welsh");
		values.put("cy-GB", "cy-GB | Welsh (United Kingdom)");
		values.put("da", "da | Danish");
		values.put("da-DK", "da-DK | Danish (Denmark)");
		values.put("de", "de | German");
		values.put("de-AT", "de-AT | German (Austria)");
		values.put("de-CH", "de-CH | German (Switzerland)");
		values.put("de-DE", "de-DE | German (Germany)");
		values.put("de-LI", "de-LI | German (Liechtenstein)");
		values.put("de-LU", "de-LU | German (Luxembourg)");
		values.put("dv", "dv | Divehi");
		values.put("dv-MV", "dv-MV | Divehi (Maldives)");
		values.put("el", "el | Greek");
		values.put("el-GR", "el-GR | Greek (Greece)");
		values.put("en", "en | English");
		values.put("en-AU", "en-AU | English (Australia)");
		values.put("en-BZ", "en-BZ | English (Belize)");
		values.put("en-CA", "en-CA | English (Canada)");
		values.put("en-CB", "en-CB | English (Caribbean)");
		values.put("en-GB", "en-GB | English (United Kingdom)");
		values.put("en-IE", "en-IE | English (Ireland)");
		values.put("en-JM", "en-JM | English (Jamaica)");
		values.put("en-NZ", "en-NZ | English (New Zealand)");
		values.put("en-PH", "en-PH | English (Republic of the Philippines)");
		values.put("en-TT", "en-TT | English (Trinidad and Tobago)");
		values.put("en-US", "en-US | English (United States)");
		values.put("en-ZA", "en-ZA | English (South Africa)");
		values.put("en-ZW", "en-ZW | English (Zimbabwe)");
		values.put("eo", "eo | Esperanto");
		values.put("es", "es | Spanish");
		values.put("es-AR", "es-AR | Spanish (Argentina)");
		values.put("es-BO", "es-BO | Spanish (Bolivia)");
		values.put("es-CL", "es-CL | Spanish (Chile)");
		values.put("es-CO", "es-CO | Spanish (Colombia)");
		values.put("es-CR", "es-CR | Spanish (Costa Rica)");
		values.put("es-DO", "es-DO | Spanish (Dominican Republic)");
		values.put("es-EC", "es-EC | Spanish (Ecuador)");
		values.put("es-ES", "es-ES | Spanish (Spain)");
		values.put("es-GT", "es-GT | Spanish (Guatemala)");
		values.put("es-HN", "es-HN | Spanish (Honduras)");
		values.put("es-MX", "es-MX | Spanish (Mexico)");
		values.put("es-NI", "es-NI | Spanish (Nicaragua)");
		values.put("es-PA", "es-PA | Spanish (Panama)");
		values.put("es-PE", "es-PE | Spanish (Peru)");
		values.put("es-PR", "es-PR | Spanish (Puerto Rico)");
		values.put("es-PY", "es-PY | Spanish (Paraguay)");
		values.put("es-SV", "es-SV | Spanish (El Salvador)");
		values.put("es-UY", "es-UY | Spanish (Uruguay)");
		values.put("es-VE", "es-VE | Spanish (Venezuela)");
		values.put("et", "et | Estonian");
		values.put("et-EE", "et-EE | Estonian (Estonia)");
		values.put("eu", "eu | Basque");
		values.put("eu-ES", "eu-ES | Basque (Spain)");
		values.put("fa", "fa | Farsi");
		values.put("fa-IR", "fa-IR | Farsi (Iran)");
		values.put("fi", "fi | Finnish");
		values.put("fi-FI", "fi-FI | Finnish (Finland)");
		values.put("fo", "fo | Faroese");
		values.put("fo-FO", "fo-FO | Faroese (Faroe Islands)");
		values.put("fr", "fr | French");
		values.put("fr-BE", "fr-BE | French (Belgium)");
		values.put("fr-CA", "fr-CA | French (Canada)");
		values.put("fr-CH", "fr-CH | French (Switzerland)");
		values.put("fr-FR", "fr-FR | French (France)");
		values.put("fr-LU", "fr-LU | French (Luxembourg)");
		values.put("fr-MC", "fr-MC | French (Principality of Monaco)");
		values.put("gl", "gl | Galician");
		values.put("gl-ES", "gl-ES | Galician (Spain)");
		values.put("gu", "gu | Gujarati");
		values.put("gu-IN", "gu-IN | Gujarati (India)");
		values.put("he", "he | Hebrew");
		values.put("he-IL", "he-IL | Hebrew (Israel)");
		values.put("hi", "hi | Hindi");
		values.put("hi-IN", "hi-IN | Hindi (India)");
		values.put("hr", "hr | Croatian");
		values.put("hr-BA", "hr-BA | Croatian (Bosnia and Herzegovina)");
		values.put("hr-HR", "hr-HR | Croatian (Croatia)");
		values.put("hu", "hu | Hungarian");
		values.put("hu-HU", "hu-HU | Hungarian (Hungary)");
		values.put("hy", "hy | Armenian");
		values.put("hy-AM", "hy-AM | Armenian (Armenia)");
		values.put("id", "id | Indonesian");
		values.put("id-ID", "id-ID | Indonesian (Indonesia)");
		values.put("is", "is | Icelandic");
		values.put("is-IS", "is-IS | Icelandic (Iceland)");
		values.put("it", "it | Italian");
		values.put("it-CH", "it-CH | Italian (Switzerland)");
		values.put("it-IT", "it-IT | Italian (Italy)");
		values.put("ja", "ja | Japanese");
		values.put("ja-JP", "ja-JP | Japanese (Japan)");
		values.put("ka", "ka | Georgian");
		values.put("ka-GE", "ka-GE | Georgian (Georgia)");
		values.put("kk", "kk | Kazakh");
		values.put("kk-KZ", "kk-kZ | Kazakh (Kazakhstan)");
		values.put("kn", "kn | Kannada");
		values.put("kn-IN", "kn-IN | Kannada (India)");
		values.put("ko", "ko | Korean");
		values.put("ko-KR", "ko-KR | Korean (Korea)");
		values.put("kok", "kok | Konkani");
		values.put("kok-IN", "kok-IN | Konkani (India)");
		values.put("ky", "ky | Kyrgyz");
		values.put("ky-KG", "ky-KG | Kyrgyz (Kyrgyzstan)");
		values.put("lt", "lt | Lithuanian");
		values.put("lt-LT", "lt-LT | Lithuanian (Lithuania)");
		values.put("lv", "lv | Latvian");
		values.put("lv-LV", "lv-LV | Latvian (Latvia)");
		values.put("mi", "mi | Maori");
		values.put("mi-NZ", "mi-NZ | Maori (New Zealand)");
		values.put("mk", "mk | FYRO Macedonian");
		values.put("mk-MK", "mk-MK | FYRO Macedonian (Former Yugoslav Republic of Macedonia)");
		values.put("mn", "mn | Mongolian");
		values.put("mn-MN", "mn-MN | Mongolian (Mongolia)");
		values.put("mr", "mr | Marathi");
		values.put("mr-IN", "mr-IN | Marathi (India)");
		values.put("ms", "ms | Malay");
		values.put("ms-BN", "ms-BN | Malay (Brunei Darussalam)");
		values.put("ms-MY", "ms-MY | Malay (Malaysia)");
		values.put("mt", "mt | Maltese");
		values.put("mt-MT", "mt-MT | Maltese (Malta)");
		values.put("nb", "nb | Norwegian (Bokm?l)");
		values.put("nb-NO", "nb-NO | Norwegian (Bokm?l) (Norway)");
		values.put("nl", "nl | Dutch");
		values.put("nl-BE", "nl-BE | Dutch (Belgium)");
		values.put("nl-NL", "nl-NL | Dutch (Netherlands)");
		values.put("nn-NO", "nn-NO | Norwegian (Nynorsk) (Norway)");
		values.put("ns", "ns | Northern Sotho");
		values.put("ns-ZA", "ns-ZA | Northern Sotho (South Africa)");
		values.put("pa", "pa | Punjabi");
		values.put("pa-IN", "pa-IN | Punjabi (India)");
		values.put("pl", "pl | Polish");
		values.put("pl-PL", "pl-PL | Polish (Poland)");
		values.put("ps", "ps | Pashto");
		values.put("ps-AR", "ps-AR | Pashto (Afghanistan)");
		values.put("pt", "pt | Portuguese");
		values.put("pt-BR", "pt-BR | Portuguese (Brazil)");
		values.put("pt-PT", "pt-PT | Portuguese (Portugal)");
		values.put("qu", "qu | Quechua");
		values.put("qu-BO", "qu-BO | Quechua (Bolivia)");
		values.put("qu-EC", "qu-EC | Quechua (Ecuador)");
		values.put("qu-PE", "qu-PE | Quechua (Peru)");
		values.put("ro", "ro | Romanian");
		values.put("ro-RO", "ro-RO | Romanian (Romania)");
		values.put("ru", "ru | Russian");
		values.put("ru-RU", "ru-RU | Russian (Russia)");
		values.put("sa", "sa | Sanskrit");
		values.put("sa-IN", "sa-IN | Sanskrit (India)");
		values.put("se", "se | Sami");
		values.put("se-FI", "se-FI | Sami (Finland)");
		values.put("se-NO", "se-NO | Sami (Norway)");
		values.put("se-SE", "se-SE | Sami (Sweden)");
		values.put("sk", "sk | Slovak");
		values.put("sk-SK", "sk-SK | Slovak (Slovakia)");
		values.put("sl", "sl | Slovenian");
		values.put("sl-SI", "sl-SI | Slovenian (Slovenia)");
		values.put("sq", "sq | Albanian");
		values.put("sq-AL", "sq-AL | Albanian (Albania)");
		values.put("sr-BA", "sr-BA | Serbian (Latin) (Bosnia and Herzegovina)");
		values.put("sr-Cyrl-BA", "sr-Cyrl-BA | Serbian (Cyrillic) (Bosnia and Herzegovina)");
		values.put("sr-SP", "sr-SP | Serbian (Latin) (Serbia and Montenegro)");
		values.put("sr-Cyrl-SP", "sr-Cyrl-SP | Serbian (Cyrillic) (Serbia and Montenegro)");
		values.put("sv", "sv | Swedish");
		values.put("sv-FI", "sv-FI | Swedish (Finland)");
		values.put("sv-SE", "sv-SE | Swedish (Sweden)");
		values.put("sw", "sw | Swahili");
		values.put("sw-KE", "sw-KE | Swahili (Kenya)");
		values.put("syr", "syr | Syriac");
		values.put("syr-SY", "syr-SY | Syriac (Syria)");
		values.put("ta", "ta | Tamil");
		values.put("ta-IN", "ta-IN | Tamil (India)");
		values.put("te", "te | Telugu");
		values.put("te-IN", "te-IN | Telugu (India)");
		values.put("th", "th | Thai");
		values.put("th-TH", "th-TH | Thai (Thailand)");
		values.put("tl", "tl | Tagalog");
		values.put("tl-PH", "tl-PH | Tagalog (Philippines)");
		values.put("tn", "tn | Tswana");
		values.put("tn-ZA", "tn-ZA | Tswana (South Africa)");
		values.put("tr", "tr | Turkish");
		values.put("tr-TR", "tr-TR | Turkish (Turkey)");
		values.put("tt", "tt | Tatar");
		values.put("tt-RU", "tt-RU | Tatar (Russia)");
		values.put("ts", "ts | Tsonga");
		values.put("uk", "uk | Ukrainian");
		values.put("uk-UA", "uk-UA | Ukrainian (Ukraine)");
		values.put("ur", "ur | Urdu");
		values.put("ur-PK", "ur-PK | Urdu (Islamic Republic of Pakistan)");
		values.put("uz", "uz | Uzbek (Latin)");
		values.put("uz-UZ", "uz-UZ | Uzbek (Latin) (Uzbekistan)");
		values.put("uz-Cyrl-UZ", "uz-Cyrl-UZ | Uzbek (Cyrillic) (Uzbekistan)");
		values.put("vi", "vi | Vietnamese");
		values.put("vi-VN", "vi-VN | Vietnamese (Viet Nam)");
		values.put("xh", "xh | Xhosa");
		values.put("xh-ZA", "xh-ZA | Xhosa (South Africa)");
		values.put("zh", "zh | Chinese");
		values.put("zh-CN", "zh-CN | Chinese (S)");
		values.put("zh-HK", "zh-HK | Chinese (Hong Kong)");
		values.put("zh-MO", "zh-MO | Chinese (Macau)");
		values.put("zh-SG", "zh-SG | Chinese (Singapore)");
		values.put("zh-TW", "zh-TW | Chinese (T)");
		values.put("zu", "zu | Zulu");
		values.put("zu-ZA", "zu-ZA | Zulu (South Africa)");
	}
	
	public TreeMap<String, String> getTreeMap() {
		return new TreeMap<String, String>(values);
	}
}
