/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.record.impl;

import java.io.Serializable;
import java.text.ParseException;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import tv.amwa.maj.constant.CommonConstants;
import tv.amwa.maj.integer.UInt16;
import tv.amwa.maj.io.xml.XMLBuilder;
import tv.amwa.maj.io.xml.XMLSerializable;
import tv.amwa.maj.misctype.FrameOffset;
import tv.amwa.maj.record.TimeStruct;
import tv.amwa.maj.record.TimecodeValue;
import tv.amwa.maj.record.impl.TimeStructImpl;

public final class TimecodeValueImpl
implements TimecodeValue,
Serializable,
XMLSerializable,
Comparable<TimecodeValue>,
Cloneable,
CommonConstants {
    private static final long serialVersionUID = 1296780910250948724L;
    private boolean dropFrame;
    @FrameOffset
    private long startTimecode;
    @UInt16
    private short framesPerSecond;
    public static final String TIMECODEVALUE_TAG = "TimecodeValue";
    public static final String STARTTIMECODE_TAG = "StartTimecode";
    public static final String FRAMESPERSECOND_TAG = "FramesPerSecond";
    public static final String DROPFRAME_TAG = "DropFrame";

    public TimecodeValueImpl(boolean drop, @FrameOffset long startFrame, @UInt16 short fps) throws IllegalArgumentException {
        if (fps <= 0) {
            throw new IllegalArgumentException("The frames per second value must be a positive number.");
        }
        this.dropFrame = drop;
        this.startTimecode = startFrame;
        this.framesPerSecond = fps;
    }

    public TimecodeValueImpl() {
        this.dropFrame = false;
        this.startTimecode = 0L;
        this.framesPerSecond = 1;
    }

    public TimecodeValueImpl(@UInt16 short fps, short hours, short minutes, short seconds, short frames, boolean drop) throws IllegalArgumentException {
        this(fps, hours, minutes, seconds, frames, 0, drop);
    }

    public TimecodeValueImpl(@UInt16 short fps, short hours, short minutes, short seconds, short frames, short framePair, boolean drop) {
        long value;
        if (fps <= 0) {
            throw new IllegalArgumentException("The frames per second value for a timecode must be a positive number.");
        }
        if (framePair < 0 || framePair > 1) {
            throw new IllegalArgumentException("The frame pair value for a timecode must be either 0 or 1.");
        }
        FrameTable frameTable = new FrameTable((short)fps);
        if (drop) {
            value = hours * frameTable.dropFpHour;
            value += (long)(minutes / 10 * frameTable.dropFpMin10);
            value += (long)(minutes % 10 * frameTable.dropFpMin);
        } else {
            value = hours * frameTable.fpHour;
            value += (long)(minutes * frameTable.fpMinute);
        }
        value += (long)(seconds * (fps > 30 ? fps / 2 : fps));
        value = fps > 30 ? value * 2L + (long)framePair : (value += (long)frames);
        this.setDropFrame(drop);
        this.setFramesPerSecond((short)fps);
        this.setStartTimecode(value);
    }

    @Override
    public boolean getDropFrame() {
        return this.dropFrame;
    }

    @Override
    public void setDropFrame(boolean drop) {
        this.dropFrame = drop;
    }

    @Override
    public short getFramesPerSecond() {
        return this.framesPerSecond;
    }

    @Override
    public void setFramesPerSecond(short framesPerSecond) {
        this.framesPerSecond = framesPerSecond;
    }

    @Override
    public long getStartTimecode() {
        return this.startTimecode;
    }

    @Override
    public void setStartTimecode(long startFrame) {
        this.startTimecode = startFrame;
    }

    public int hashCode() {
        return Long.valueOf(this.startTimecode).hashCode() ^ this.framesPerSecond << 16 ^ Boolean.valueOf(this.dropFrame).hashCode();
    }

    public final boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof TimecodeValue)) {
            return false;
        }
        TimecodeValue testValue = (TimecodeValue)o;
        if (this.dropFrame != testValue.getDropFrame()) {
            return false;
        }
        if (this.framesPerSecond != testValue.getFramesPerSecond()) {
            return false;
        }
        return this.startTimecode == testValue.getStartTimecode();
    }

    @Override
    public final int compareTo(TimecodeValue o) throws NullPointerException {
        TimecodeValueImpl testTimecode;
        long testInMillis;
        if (o == null) {
            throw new NullPointerException("Cannot compare timecode value with null.");
        }
        if (this.equals(o)) {
            return 0;
        }
        long thisInMillis = this.timeToThousandths(this);
        if (thisInMillis < (testInMillis = this.timeToThousandths(testTimecode = new TimecodeValueImpl(o.getDropFrame(), o.getStartTimecode(), o.getFramesPerSecond())))) {
            return -1;
        }
        if (thisInMillis > testInMillis) {
            return 1;
        }
        return 0;
    }

    private long timeToThousandths(TimecodeValueImpl timecode) {
        if (!timecode.getDropFrame()) {
            return (long)((double)timecode.getStartTimecode() * (1000.0 / (double)timecode.getFramesPerSecond()));
        }
        switch (timecode.getFramesPerSecond()) {
            case 24: {
                return timecode.getStartTimecode() * 1001000L / 24000L;
            }
            case 30: {
                return timecode.getStartTimecode() * 1001000L / 30000L;
            }
            case 48: {
                return timecode.getStartTimecode() * 1001000L / 48000L;
            }
            case 60: {
                return timecode.getStartTimecode() * 1001000L / 60000L;
            }
        }
        return timecode.getStartTimecode() * 1001000L / ((long)timecode.getFramesPerSecond() * 1000L);
    }

    @Override
    public String toString() {
        TimeComponents realTime = this.convertToActualTimeValues();
        StringBuffer sb = new StringBuffer(14);
        String value = Long.toString(realTime.hours);
        if (value.length() == 1) {
            sb.append('0');
        }
        sb.append(value);
        sb.append(':');
        value = Integer.toString(realTime.minutes);
        if (value.length() == 1) {
            sb.append('0');
        }
        sb.append(value);
        sb.append(':');
        value = Integer.toString(realTime.seconds);
        if (value.length() == 1) {
            sb.append('0');
        }
        sb.append(value);
        if (this.dropFrame) {
            sb.append(';');
        } else {
            sb.append(':');
        }
        value = Integer.toString(realTime.frameInSecond);
        if (value.length() == 1) {
            sb.append('0');
        }
        sb.append(value);
        if (realTime.framePair != null) {
            sb.append('.');
            sb.append(realTime.framePair);
        }
        return sb.toString();
    }

    @Override
    public TimeStruct convertToRealTime() throws NumberFormatException {
        long thousandths = this.timeToThousandths(this);
        long hours = thousandths / 3600000L;
        if (hours > 23L) {
            throw new NumberFormatException("Timecode value is too large to convert to a time structure value.");
        }
        int minutes = (int)((thousandths %= 3600000L) / 60000L);
        int seconds = (int)((thousandths %= 60000L) / 1000L);
        int fraction = (int)(thousandths % 1000L) / 4;
        return new TimeStructImpl((byte)hours, (byte)minutes, (byte)seconds, (byte)fraction);
    }

    public static final TimecodeValue parseTimecode(String timecodeText, @UInt16 short fps, boolean drop) throws NullPointerException, ParseException, IllegalArgumentException {
        short framePair;
        short frames;
        short seconds;
        short minutes;
        short hours;
        if (timecodeText == null) {
            throw new NullPointerException("The given timecode value as a string is null.");
        }
        if (fps < 0) {
            throw new IllegalArgumentException("When parsing a timecode value, the given frames per second value is negative.");
        }
        StringTokenizer timecodeTokens = new StringTokenizer(timecodeText, ":;.,");
        try {
            hours = Short.parseShort(timecodeTokens.nextToken());
            minutes = Short.parseShort(timecodeTokens.nextToken());
            seconds = Short.parseShort(timecodeTokens.nextToken());
            frames = Short.parseShort(timecodeTokens.nextToken());
        }
        catch (NumberFormatException nfe) {
            throw new ParseException("Parsing one of the values in the given string causes a number format exception:" + nfe.getMessage(), 0);
        }
        catch (NoSuchElementException nsee) {
            throw new ParseException("The given value is not formatted as a valid timecode value.", 0);
        }
        try {
            framePair = Short.parseShort(timecodeTokens.nextToken());
        }
        catch (NumberFormatException nfe) {
            throw new ParseException("Parsing the frane pair value of the given string causes a number format exception:" + nfe.getMessage(), 0);
        }
        catch (NoSuchElementException nsee) {
            framePair = 0;
        }
        return new TimecodeValueImpl(fps, hours, minutes, seconds, frames, framePair, drop);
    }

    public static final TimecodeValue parseTimecode(String timecodeText, @UInt16 short fps) throws NullPointerException, ParseException {
        if (timecodeText == null) {
            throw new NullPointerException("The given timecode value as a string is null.");
        }
        if (timecodeText.contains(";")) {
            return TimecodeValueImpl.parseTimecode(timecodeText, fps, true);
        }
        return TimecodeValueImpl.parseTimecode(timecodeText, fps, false);
    }

    public static final TimecodeValue parseTimecode(String timecodeText) throws NullPointerException, ParseException {
        if (timecodeText == null) {
            throw new NullPointerException("The given timecode value as a string is null.");
        }
        if (timecodeText.contains(";") || timecodeText.contains(",")) {
            if (timecodeText.endsWith(".0") || timecodeText.endsWith(".1")) {
                return TimecodeValueImpl.parseTimecode(timecodeText, (short)60, true);
            }
            return TimecodeValueImpl.parseTimecode(timecodeText, (short)30, true);
        }
        if (timecodeText.endsWith(".0") || timecodeText.endsWith(".1")) {
            return TimecodeValueImpl.parseTimecode(timecodeText, (short)50, false);
        }
        return TimecodeValueImpl.parseTimecode(timecodeText, (short)25, false);
    }

    public TimeComponents convertToActualTimeValues() {
        TimeComponents internal = new TimeComponents();
        if (!this.dropFrame) {
            long baseTimecode = this.framesPerSecond > 30 ? this.startTimecode / 2L : this.startTimecode;
            short baseFps = this.framesPerSecond > 30 ? (short)(this.framesPerSecond / 2) : this.framesPerSecond;
            internal.frameInSecond = (int)(baseTimecode % (long)baseFps);
            long totalSeconds = baseTimecode / (long)baseFps;
            internal.seconds = (int)totalSeconds % 60;
            long totalMinutes = totalSeconds / 60L;
            internal.minutes = (int)totalMinutes % 60;
            internal.hours = totalMinutes / 60L;
            internal.framePair = this.framesPerSecond > 30 ? Integer.valueOf((int)(this.startTimecode % 2L)) : null;
            return internal;
        }
        long baseTimecode = this.framesPerSecond > 30 ? this.startTimecode / 2L : this.startTimecode;
        internal.hours = baseTimecode / 107892L;
        int remainingFrames = (int)(baseTimecode % 107892L);
        int majorMinutes = remainingFrames / 17982;
        if ((remainingFrames %= 17982) < 1800) {
            internal.minutes = majorMinutes * 10;
            internal.seconds = remainingFrames / 30;
            internal.frameInSecond = remainingFrames % 30;
        } else {
            internal.minutes = majorMinutes * 10 + (remainingFrames -= 1800) / 1798 + 1;
            if ((remainingFrames %= 1798) < 28) {
                internal.seconds = 0;
                internal.frameInSecond = remainingFrames + 2;
            } else {
                internal.seconds = (remainingFrames += 2) / 30;
                internal.frameInSecond = remainingFrames % 30;
            }
        }
        internal.framePair = this.framesPerSecond > 30 ? Integer.valueOf((int)(this.startTimecode % 2L)) : null;
        return internal;
    }

    @Override
    public final TimecodeValue clone() {
        try {
            return (TimecodeValue)super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            cnse.printStackTrace();
            return null;
        }
    }

    @Override
    public void appendXMLChildren(Node parent) {
        XMLBuilder.appendComment(parent, "TimecodeValue represents a structure and is not a defined AAF XML element.");
        Element timecodeElement = XMLBuilder.createChild(parent, "http://www.smpte-ra.org/schemas/2001-2/2007/aaf", "aaf", TIMECODEVALUE_TAG);
        this.appendXMLGrandchildren(timecodeElement);
    }

    public void appendXMLGrandchildren(Node timecodeElement) {
        XMLBuilder.appendElement(timecodeElement, "http://www.smpte-ra.org/schemas/2001-2/2007/aaf", "aaf", STARTTIMECODE_TAG, this.startTimecode);
        XMLBuilder.appendElement(timecodeElement, "http://www.smpte-ra.org/schemas/2001-2/2007/aaf", "aaf", FRAMESPERSECOND_TAG, this.framesPerSecond);
        XMLBuilder.appendElement(timecodeElement, "http://www.smpte-ra.org/schemas/2001-2/2007/aaf", "aaf", DROPFRAME_TAG, this.dropFrame);
    }

    public static final TimecodeValueImpl calculateDuration(TimecodeValue startValue, TimecodeValue endValue) throws NullPointerException, IllegalArgumentException {
        if (startValue == null) {
            throw new NullPointerException("Cannot calculate a duration from a null start value.");
        }
        if (endValue == null) {
            throw new NullPointerException("Cannot calculate a duration from a null end value.");
        }
        if (startValue.getFramesPerSecond() != endValue.getFramesPerSecond()) {
            throw new IllegalArgumentException("Start and end timecode values must have the same number of frames per second.");
        }
        if (startValue.getDropFrame() != endValue.getDropFrame()) {
            throw new IllegalArgumentException("Start and end timecode values must have matching drop or non-drop specifications.");
        }
        if (startValue.getStartTimecode() > endValue.getStartTimecode()) {
            throw new IllegalArgumentException("Start timecode value must be before the end timecode value.");
        }
        return new TimecodeValueImpl(startValue.getDropFrame(), endValue.getStartTimecode() - startValue.getStartTimecode(), startValue.getFramesPerSecond());
    }

    public static final TimecodeValueImpl calculateEndTimecode(TimecodeValue startValue, TimecodeValue duration) throws NullPointerException, IllegalArgumentException {
        if (startValue == null) {
            throw new NullPointerException("Cannot calculate an end timecode from a null start value.");
        }
        if (duration == null) {
            throw new NullPointerException("Cannot calculate an end timecode from a null duration.");
        }
        if (startValue.getFramesPerSecond() != duration.getFramesPerSecond()) {
            throw new IllegalArgumentException("Start and duration timecode values must have the same number of frames per second.");
        }
        if (startValue.getDropFrame() != duration.getDropFrame()) {
            throw new IllegalArgumentException("Start and duration timecode values must have matching drop or non-drop specifications.");
        }
        return new TimecodeValueImpl(startValue.getDropFrame(), startValue.getStartTimecode() + duration.getStartTimecode(), startValue.getFramesPerSecond());
    }

    @Override
    public String getComment() {
        return null;
    }

    public class TimeComponents {
        public Integer framePair = null;
        public int frameInSecond;
        public int seconds;
        public int minutes;
        public long hours;
    }

    private static class FrameTable {
        final int dropFpMin;
        final int dropFpMin10;
        final int dropFpHour;
        final int fpMinute;
        final int fpHour;

        FrameTable(short fps) {
            short scaledFps = fps > 30 ? (short)(fps / 2) : fps;
            this.dropFpMin = 60 * scaledFps - 2;
            this.dropFpMin10 = 10 * this.dropFpMin + 2;
            this.dropFpHour = 6 * this.dropFpMin10;
            this.fpMinute = 60 * scaledFps;
            this.fpHour = 60 * this.fpMinute;
        }
    }
}

