/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.model.impl;

import java.io.Serializable;
import tv.amwa.maj.exception.PropertyNotPresentException;
import tv.amwa.maj.industry.MediaClass;
import tv.amwa.maj.industry.MediaProperty;
import tv.amwa.maj.industry.MediaPropertySetter;
import tv.amwa.maj.misctype.PositionType;
import tv.amwa.maj.misctype.TrackID;
import tv.amwa.maj.model.PackageMarker;
import tv.amwa.maj.model.impl.InterchangeObjectImpl;

@MediaClass(uuid1=0xD010101, uuid2=257, uuid3=24576, uuid4={6, 14, 43, 52, 2, 6, 1, 1}, definedName="PackageMarker", aliases={"PackageMarkerObject"}, symbol="PackageMarker", description="Provides mark-in and mark-out properties on material packages.")
public class PackageMarkerImpl
extends InterchangeObjectImpl
implements PackageMarker,
Cloneable,
Serializable {
    private static final long serialVersionUID = 4831780255667423820L;
    @TrackID
    private int timecaseReferenceTrackID;
    @PositionType
    private Long packageMarkInPosition = null;
    @PositionType
    private Long packageMarkOutPosition = null;

    @Override
    @MediaProperty(uuid1=100729091, uuid2=3584, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 12}, definedName="TimebaseReferenceTrackID", typeName="UInt32", optional=false, uniqueIdentifier=false, pid=0, symbol="TimebaseReferenceTrackID", description="Track identifier of the target track in the material package that provides the edit rate.")
    @TrackID
    public int getTimebaseReferenceTrackID() {
        return this.timecaseReferenceTrackID;
    }

    @Override
    @MediaPropertySetter(value="TimebaseReferenceTrackID")
    public void setTimebaseReferenceTrackID(@TrackID int timebaseReferenceTrackID) throws IllegalArgumentException {
        if (timebaseReferenceTrackID < 0) {
            throw new IllegalArgumentException("Cannot set the timebase referenced track identifeir to a negative value.");
        }
        this.timecaseReferenceTrackID = timebaseReferenceTrackID;
    }

    @Override
    @MediaProperty(uuid1=117571843, uuid2=270, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 10}, definedName="PackageMarkInPosition", typeName="PositionType", optional=true, uniqueIdentifier=false, pid=0, symbol="PackageMarkInPosition", description="Start of the optional sub-section on the material package's timebase reference track timeline.")
    @PositionType
    public long getPackageMarkInPosition() throws PropertyNotPresentException {
        if (this.packageMarkInPosition == null) {
            throw new PropertyNotPresentException("The optional package mark in position property is not present for this package marker.");
        }
        return this.packageMarkInPosition;
    }

    @Override
    @MediaPropertySetter(value="PackageMarkInPosition")
    public void setPackageMarkInPosition(@PositionType Long packageMarkInPosition) {
        this.packageMarkInPosition = packageMarkInPosition;
    }

    @Override
    @MediaProperty(uuid1=117571843, uuid2=516, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 10}, definedName="PackageMarkOutPosition", typeName="PositionType", optional=true, uniqueIdentifier=false, pid=0, symbol="PackageMarkOutPosition", description="Stop of the optional sub-section on the material package's timebase reference track timeline.")
    @PositionType
    public long getPackageMarkOutPosition() throws PropertyNotPresentException {
        if (this.packageMarkOutPosition == null) {
            throw new PropertyNotPresentException("The optional package mark out position property is not present for this package marker.");
        }
        return this.packageMarkOutPosition;
    }

    @Override
    @MediaPropertySetter(value="PackageMarkOutPosition")
    public void setPackageMarkOutPosition(@PositionType Long packageMarkOutPosition) {
        this.packageMarkOutPosition = packageMarkOutPosition;
    }

    @Override
    public PackageMarker clone() {
        return (PackageMarker)super.clone();
    }
}

