/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.model.impl;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import tv.amwa.maj.enumeration.CriteriaType;
import tv.amwa.maj.enumeration.PackageKind;
import tv.amwa.maj.exception.DuplicatePackageIDException;
import tv.amwa.maj.exception.EssenceNotFoundException;
import tv.amwa.maj.exception.PackageNotFoundException;
import tv.amwa.maj.exception.PropertyNotPresentException;
import tv.amwa.maj.industry.MediaClass;
import tv.amwa.maj.industry.MediaProperty;
import tv.amwa.maj.industry.MediaPropertyClear;
import tv.amwa.maj.industry.MediaPropertyContains;
import tv.amwa.maj.industry.MediaPropertyCount;
import tv.amwa.maj.industry.MediaPropertyRemove;
import tv.amwa.maj.industry.MediaSetAdd;
import tv.amwa.maj.industry.StrongReferenceSet;
import tv.amwa.maj.io.xml.XMLSerializable;
import tv.amwa.maj.model.AAFFileDescriptor;
import tv.amwa.maj.model.CompositionPackage;
import tv.amwa.maj.model.ContentStorage;
import tv.amwa.maj.model.EssenceData;
import tv.amwa.maj.model.EssenceDescriptor;
import tv.amwa.maj.model.MaterialPackage;
import tv.amwa.maj.model.Package;
import tv.amwa.maj.model.SourcePackage;
import tv.amwa.maj.model.impl.FilmDescriptorImpl;
import tv.amwa.maj.model.impl.InterchangeObjectImpl;
import tv.amwa.maj.model.impl.MaterialPackageImpl;
import tv.amwa.maj.model.impl.PhysicalDescriptorImpl;
import tv.amwa.maj.model.impl.SourcePackageImpl;
import tv.amwa.maj.model.impl.TapeDescriptorImpl;
import tv.amwa.maj.record.AUID;
import tv.amwa.maj.record.PackageID;
import tv.amwa.maj.union.SearchCriteria;
import tv.amwa.maj.union.impl.SearchByAUIDImpl;
import tv.amwa.maj.union.impl.SearchByMediaCriteriaImpl;
import tv.amwa.maj.union.impl.SearchByNameImpl;
import tv.amwa.maj.union.impl.SearchByPackageIDImpl;
import tv.amwa.maj.union.impl.SearchByPackageKindImpl;

@MediaClass(uuid1=0xD010101, uuid2=257, uuid3=6144, uuid4={6, 14, 43, 52, 2, 6, 1, 1}, definedName="ContentStorage", description="The ContentStorage class has the Package and EssenceData objects.", symbol="ContentStorage")
public class ContentStorageImpl
extends InterchangeObjectImpl
implements ContentStorage,
Serializable,
XMLSerializable,
Cloneable {
    private static final long serialVersionUID = 1286145068134374378L;
    private Set<Package> packages = Collections.synchronizedSet(new HashSet());
    private Set<EssenceData> essenceDataObjects = Collections.synchronizedSet(new HashSet());

    public ContentStorageImpl() {
    }

    public ContentStorageImpl(Set<Package> packages, Set<EssenceData> essenceData) throws NullPointerException {
        if (packages == null) {
            throw new NullPointerException("Cannot set the packages of a new content storage using a null set value.");
        }
        if (essenceData == null) {
            throw new NullPointerException("Cannot set the essence data of a new content storage using a null set value.");
        }
        for (Package packageItem : packages) {
            if (packageItem == null) continue;
            StrongReferenceSet.add(packages, packageItem);
        }
        for (EssenceData essenceItem : essenceData) {
            if (essenceItem == null) continue;
            StrongReferenceSet.add(essenceData, essenceItem);
        }
    }

    @Override
    @MediaSetAdd(value="EssenceDataObjects")
    public void addEssenceDataObject(EssenceData essenceDataObject) throws DuplicatePackageIDException, NullPointerException {
        if (essenceDataObject == null) {
            throw new NullPointerException("Cannot add essence data to content storage using null value.");
        }
        if (this.essenceDataObjects.contains(essenceDataObject)) {
            throw new DuplicatePackageIDException("Essence data with the same package id as the given value is already in the content storage.");
        }
        StrongReferenceSet.add(this.essenceDataObjects, essenceDataObject);
    }

    @Override
    @MediaSetAdd(value="Packages")
    public void addPackage(Package packageToAdd) throws NullPointerException, DuplicatePackageIDException {
        if (packageToAdd == null) {
            throw new NullPointerException("Cannot add a package to content storage using a null value.");
        }
        if (this.packages.contains(packageToAdd)) {
            throw new DuplicatePackageIDException("A package with the same package id as the given value is already in the content storage.");
        }
        StrongReferenceSet.add(this.packages, packageToAdd);
    }

    @MediaPropertyContains(value="Packages")
    public boolean containsPackage(Package packageToCheck) {
        return this.packages.contains(packageToCheck);
    }

    @Override
    @MediaPropertyCount(value="EssenceDataObjects")
    public int countEssenceDataObjects() {
        return this.essenceDataObjects.size();
    }

    @Override
    @MediaPropertyCount(value="Packages")
    public int countPackages() {
        return this.packages.size();
    }

    @Override
    public int countPackages(PackageKind packageKind) throws NullPointerException {
        if (packageKind == null) {
            throw new NullPointerException("Cannot count packages for a null package kind.");
        }
        int packageCount = 0;
        for (Package packageElement : this.packages) {
            switch (packageKind) {
                case AllPackages: {
                    ++packageCount;
                    break;
                }
                case CompositionPackage: {
                    if (!(packageElement instanceof CompositionPackage)) break;
                    ++packageCount;
                    break;
                }
                case MaterialPackage: {
                    if (!(packageElement instanceof MaterialPackage)) break;
                    ++packageCount;
                    break;
                }
                case FilmPackage: {
                    if (!(packageElement instanceof SourcePackage) || !(((SourcePackageImpl)packageElement).getEssenceDescription() instanceof FilmDescriptorImpl)) break;
                    ++packageCount;
                    break;
                }
                case PhysicalPackage: {
                    if (!(packageElement instanceof SourcePackage) || !(((SourcePackageImpl)packageElement).getEssenceDescription() instanceof PhysicalDescriptorImpl)) break;
                    ++packageCount;
                    break;
                }
                case PrimaryPackage: {
                    if (!(packageElement instanceof SourcePackage)) break;
                    ++packageCount;
                    break;
                }
                case TapePackage: {
                    if (!(packageElement instanceof SourcePackage) || !(((SourcePackageImpl)packageElement).getEssenceDescription() instanceof TapeDescriptorImpl)) break;
                    ++packageCount;
                    break;
                }
            }
        }
        return packageCount;
    }

    @MediaProperty(uuid1=100729092, uuid2=1282, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="EssenceDataObjects", aliases={"EssenceData", "ContentStorageEssenceData"}, typeName="EssenceDataStrongReferenceSet", optional=true, uniqueIdentifier=false, pid=6402, symbol="EssenceDataObjects")
    public Set<EssenceData> enumEssenceDataObjects() throws PropertyNotPresentException {
        if (this.essenceDataObjects.size() == 0) {
            throw new PropertyNotPresentException("No essence data objects are present in this content storage.");
        }
        return this.getEssenceDataObjects(CriteriaType.AnyRepresentation);
    }

    public Set<EssenceData> getEssenceDataObjects() throws PropertyNotPresentException {
        return this.enumEssenceDataObjects();
    }

    public Set<EssenceData> getEssenceDataObjects(CriteriaType mediaCriteria) throws NullPointerException {
        if (mediaCriteria == null || mediaCriteria == CriteriaType.AnyRepresentation) {
            return new HashSet<EssenceData>(this.essenceDataObjects);
        }
        Set<Package> matchedPackages = this.getPackages(new SearchByMediaCriteriaImpl(mediaCriteria));
        HashSet<EssenceData> matchedData = new HashSet<EssenceData>();
        for (Package packageItem : matchedPackages) {
            try {
                matchedData.add(this.lookupEssenceDataObject(packageItem.getPackageID()));
            }
            catch (PackageNotFoundException packageNotFoundException) {}
        }
        return matchedData;
    }

    @Override
    public EssenceData lookupEssenceDataObject(PackageID packageID) throws NullPointerException, PackageNotFoundException {
        if (packageID == null) {
            throw new NullPointerException("Cannot find essence data in content storage from a null package id value.");
        }
        for (EssenceData essenceItem : this.essenceDataObjects) {
            if (!essenceItem.getLinkedPackageID().equals(packageID)) continue;
            return essenceItem;
        }
        throw new PackageNotFoundException("Cannot find essence data in storage with the given package id.");
    }

    public Set<Package> enumPackages() {
        return this.getPackages();
    }

    @MediaProperty(uuid1=100729092, uuid2=1281, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="Packages", aliases={"Mobs"}, typeName="PackageStrongReferenceSet", optional=false, uniqueIdentifier=false, pid=6401, symbol="Packages")
    public Set<Package> getPackages() {
        return this.getPackages(new SearchByPackageKindImpl(PackageKind.AllPackages));
    }

    public static final Set<Package> initializePackages() {
        HashSet<Package> initialPackages = new HashSet<Package>(1);
        initialPackages.add(new MaterialPackageImpl(MaterialPackageImpl.initializePackageID(), "DefaultPackage"));
        return initialPackages;
    }

    public Set<Package> getPackages(SearchCriteria searchCriteria) {
        HashSet<Package> matchedPackages = new HashSet<Package>();
        block30: for (Package packageItem : this.packages) {
            block5 : switch (searchCriteria.getSearchTag()) {
                case ByName: {
                    try {
                        if (!packageItem.getPackageName().equals(((SearchByNameImpl)searchCriteria).getName())) continue block30;
                        matchedPackages.add(packageItem);
                    }
                    catch (PropertyNotPresentException propertyNotPresentException) {}
                    break;
                }
                case ByPackageID: {
                    if (packageItem.getPackageID().equals(((SearchByPackageIDImpl)searchCriteria).getPackageID())) {
                        matchedPackages.add(packageItem);
                    }
                    return matchedPackages;
                }
                case ByClass: {
                    if (!packageItem.getObjectClass().getAUID().equals(((SearchByAUIDImpl)searchCriteria).getAUID())) continue block30;
                    matchedPackages.add(packageItem);
                    break;
                }
                case ByPackageKind: {
                    PackageKind packageKind = ((SearchByPackageKindImpl)searchCriteria).getKind();
                    switch (packageKind) {
                        case AllPackages: {
                            return new HashSet<Package>(this.packages);
                        }
                        case MaterialPackage: {
                            if (!(packageItem instanceof MaterialPackage)) continue block30;
                            matchedPackages.add(packageItem);
                            break block5;
                        }
                        case CompositionPackage: {
                            if (!(packageItem instanceof CompositionPackage)) continue block30;
                            matchedPackages.add(packageItem);
                            break block5;
                        }
                        case FilmPackage: {
                            if (!(packageItem instanceof SourcePackage) || !(((SourcePackageImpl)packageItem).getEssenceDescription() instanceof FilmDescriptorImpl)) continue block30;
                            matchedPackages.add(packageItem);
                            break block5;
                        }
                        case PhysicalPackage: {
                            if (!(packageItem instanceof SourcePackage) || !(((SourcePackageImpl)packageItem).getEssenceDescription() instanceof PhysicalDescriptorImpl)) continue block30;
                            matchedPackages.add(packageItem);
                            break block5;
                        }
                        case PrimaryPackage: {
                            if (!(packageItem instanceof SourcePackage)) continue block30;
                            matchedPackages.add(packageItem);
                            break block5;
                        }
                        case TapePackage: {
                            if (!(packageItem instanceof SourcePackage) || !(((SourcePackageImpl)packageItem).getEssenceDescription() instanceof TapeDescriptorImpl)) continue block30;
                            matchedPackages.add(packageItem);
                            break block5;
                        }
                    }
                    break;
                }
                case ByCompositionPackageUsageCode: {
                    if (!(packageItem instanceof CompositionPackage)) break;
                    try {
                        if (!packageItem.getPackageUsage().equals(((SearchByAUIDImpl)searchCriteria).getAUID())) continue block30;
                        matchedPackages.add(packageItem);
                    }
                    catch (PropertyNotPresentException propertyNotPresentException) {}
                    break;
                }
                case ByMaterialPackageUsageCode: {
                    if (!(packageItem instanceof MaterialPackage)) break;
                    try {
                        if (!packageItem.getPackageUsage().equals(((SearchByAUIDImpl)searchCriteria).getAUID())) continue block30;
                        matchedPackages.add(packageItem);
                    }
                    catch (PropertyNotPresentException propertyNotPresentException) {}
                    break;
                }
                case BySourcePackageUsageCode: {
                    if (!(packageItem instanceof SourcePackage)) break;
                    try {
                        if (!packageItem.getPackageUsage().equals(((SearchByAUIDImpl)searchCriteria).getAUID())) continue block30;
                        matchedPackages.add(packageItem);
                    }
                    catch (PropertyNotPresentException propertyNotPresentException) {}
                    break;
                }
                case ByUsageCode: {
                    try {
                        if (!packageItem.getPackageUsage().equals(((SearchByAUIDImpl)searchCriteria).getAUID())) continue block30;
                        matchedPackages.add(packageItem);
                    }
                    catch (PropertyNotPresentException propertyNotPresentException) {}
                    break;
                }
                case ByMediaCrit: {
                    return new HashSet<Package>(this.packages);
                }
                default: {
                    return matchedPackages;
                }
            }
        }
        return matchedPackages;
    }

    @MediaPropertyContains(value="EssenceDataObjects")
    public boolean isEssenceDataObjectPresent(EssenceData essenceData) {
        return this.isEssenceDataPresent(essenceData.getLinkedPackageID());
    }

    @Override
    public boolean isEssenceDataPresent(PackageID filePackageID) throws NullPointerException {
        if (filePackageID == null) {
            throw new NullPointerException("Cannot check for the presence of essence data in content storage using null values.");
        }
        for (EssenceData essenceItem : this.essenceDataObjects) {
            if (!essenceItem.getLinkedPackageID().equals(filePackageID)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Package lookupPackage(PackageID packageID) throws NullPointerException, PackageNotFoundException {
        if (packageID == null) {
            throw new NullPointerException("Cannot check for the presence of packages in content storage using null values.");
        }
        for (Package packageElement : this.packages) {
            if (!packageElement.getPackageID().equals(packageID)) continue;
            return packageElement;
        }
        throw new PackageNotFoundException("A package with the given ID cannot be found.");
    }

    @Override
    @MediaPropertyRemove(value="EssenceDataObjects")
    public void removeEssenceDataObject(EssenceData essenceDataObject) throws NullPointerException, EssenceNotFoundException {
        if (essenceDataObject == null) {
            throw new NullPointerException("Cannot remove essence data from content storage using a null value");
        }
        if (!this.essenceDataObjects.contains(essenceDataObject)) {
            throw new EssenceNotFoundException("Cannot remove essence data from content storage as it is not currently stored.");
        }
        StrongReferenceSet.remove(this.essenceDataObjects, essenceDataObject);
    }

    @Override
    @MediaPropertyRemove(value="Packages")
    public void removePackage(Package packageToRemove) throws NullPointerException, PackageNotFoundException {
        if (packageToRemove == null) {
            throw new NullPointerException("Cannot remove a package using a null value.");
        }
        if (!this.packages.contains(packageToRemove)) {
            throw new PackageNotFoundException("Cannot remove package from content storage as it is not currently stored.");
        }
        StrongReferenceSet.remove(this.packages, packageToRemove);
    }

    @MediaPropertyClear(value="Packages")
    public void clearPackages() {
        this.packages.clear();
    }

    @MediaPropertyClear(value="EssenceDataObjects")
    public void clearEssenceDataObjects() {
        this.essenceDataObjects.clear();
    }

    @Override
    public ContentStorage clone() {
        return (ContentStorage)super.clone();
    }

    void addEssenceContainers(Set<AUID> essenceContainers) {
        for (Package packageItem : this.packages) {
            if (!(packageItem instanceof SourcePackageImpl)) continue;
            EssenceDescriptor descriptor = null;
            descriptor = ((SourcePackageImpl)packageItem).getEssenceDescription();
            if (!(descriptor instanceof AAFFileDescriptor)) continue;
            AAFFileDescriptor fileDescriptor = (AAFFileDescriptor)descriptor;
            essenceContainers.add(fileDescriptor.getContainerFormat().getAUID());
        }
    }

    @Override
    public String getComment() {
        return "local content storage persistent identifier: " + this.getPersistentID();
    }
}

