/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.io.xml;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import tv.amwa.maj.industry.AAFSpecifiedClasses;
import tv.amwa.maj.io.xml.LocalHandler;
import tv.amwa.maj.io.xml.MetadataObjectHandler;
import tv.amwa.maj.record.impl.ProductVersionImpl;
import tv.amwa.maj.record.impl.RGBAComponentImpl;

public class MasterContentHandler
implements ContentHandler,
AAFSpecifiedClasses {
    private final Map<String, Class<? extends LocalHandler>> handlers = Collections.synchronizedMap(new HashMap());
    private static final boolean DIAGNOSTICS = false;
    private XMLReader xmlReader = null;
    private Object result = null;
    private MasterContentHandler rootHandler;
    private InputSource inputSource = null;
    private Map<String, InputStream> streams = null;
    private Map<String, String> attributes;
    private MasterContentHandler parentHandler;
    private String elementName;
    private String namespace = null;
    private static final Class<?>[] coreHandlers = new Class[]{ProductVersionImpl.XMLHandler.class, RGBAComponentImpl.class};

    MasterContentHandler() {
        this.registerCoreHandlers();
    }

    MasterContentHandler(InputSource input) throws SAXException, NullPointerException {
        this.registerCoreHandlers();
        this.setInputSource(input);
        this.setUpParser();
    }

    MasterContentHandler(InputSource input, Map<String, InputStream> streams) throws SAXException, NullPointerException {
        this.registerCoreHandlers();
        this.setInputSource(input);
        this.setUpParser();
        this.streams = streams;
    }

    final void setUpParser() throws SAXException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(false);
            SAXParser saxParser = factory.newSAXParser();
            this.xmlReader = saxParser.getXMLReader();
            this.xmlReader.setFeature("http://xml.org/sax/features/namespaces", true);
            this.xmlReader.setContentHandler(this);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
    }

    final void parse() throws SAXException, IOException {
        this.result = null;
        this.xmlReader.parse(this.inputSource);
    }

    final void setInputSource(InputSource source) throws NullPointerException {
        if (source == null) {
            throw new NullPointerException("Cannot parse a null input source.");
        }
        this.inputSource = source;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
        if (this.rootHandler == null) {
            throw new SAXException("Unexpected end of XML document.");
        }
        this.result = this.rootHandler.getResult();
        if (this.result == null) {
            throw new SAXException("Unexpected null result for handler " + this.getClass().getName() + ".");
        }
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        throw new SAXException("Master document should not handle any element ends.");
    }

    @Override
    public final void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public final void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public final void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public final void setDocumentLocator(Locator locator) {
    }

    @Override
    public final void skippedEntity(String name) throws SAXException {
    }

    @Override
    public final void startDocument() throws SAXException {
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
        this.rootHandler = this.makeHandler(uri, localName, this, atts);
        this.xmlReader.setContentHandler(this.rootHandler);
    }

    final MasterContentHandler makeHandler(String namespace, String elementName, MasterContentHandler parentHandler, Attributes attributes) throws NullPointerException, SAXException {
        if (elementName == null) {
            throw new NullPointerException("Cannot find a handler in the registry using null element name.");
        }
        if (parentHandler == null) {
            throw new NullPointerException("Cannot make a new handler without a parent handler.");
        }
        Class<MasterContentHandler> handlerClass = this.handlers.get(elementName);
        if (handlerClass == null) {
            handlerClass = MetadataObjectHandler.class;
        }
        MasterContentHandler handler = null;
        try {
            handler = handlerClass.newInstance();
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        handler.setParentHandler(parentHandler);
        handler.setAttributes(attributes);
        handler.setElementName(namespace, elementName);
        return handler;
    }

    @Override
    public final void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    final Object getResult() {
        return this.result;
    }

    final void setResult(Object result) {
        this.result = result;
    }

    public final boolean registerHandler(Class<? extends LocalHandler> handler) throws NullPointerException, IllegalArgumentException {
        if (handler == null) {
            throw new NullPointerException("Cannot register a content handler using a null value.");
        }
        try {
            Field elementNameField = handler.getField("elementName");
            String elementName = (String)elementNameField.get(null);
            if (!this.handlers.containsKey(elementName)) {
                this.handlers.put(elementName, handler);
                return true;
            }
        }
        catch (IllegalArgumentException elementNameField) {
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("The given handler does not contain an accessible elementName static string value.");
        }
        catch (SecurityException e) {
            throw new IllegalArgumentException("The given handler does not contain an accessible elementName static string value.");
        }
        catch (NoSuchFieldException e) {
            throw new IllegalArgumentException("The given handler does not contain an accessible elementName static string value.");
        }
        return false;
    }

    Class<? extends LocalHandler> getHandlerClassForName(String elementName) {
        return this.handlers.get(elementName);
    }

    public final void registerHandlersForClass(Class<?> containsHandler) {
        Class<?>[] innerClasses;
        for (Class<?> innerClass : innerClasses = containsHandler.getClasses()) {
            if (Modifier.isAbstract(innerClass.getModifiers()) || !LocalHandler.class.isAssignableFrom(innerClass)) continue;
            this.registerHandler(innerClass);
        }
    }

    public final void registerCoreHandlers() {
        for (Class<?> clazz : coreHandlers) {
            try {
                Class<?> localHandler = clazz;
                this.registerHandler(localHandler);
            }
            catch (ClassCastException classCastException) {
            }
            catch (SecurityException securityException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        for (Class<?> clazz : interchangeable) {
            this.registerHandlersForClass(clazz);
        }
        for (Class<?> clazz : meta) {
            this.registerHandlersForClass(clazz);
        }
    }

    final MasterContentHandler getRootHandler() {
        return this.rootHandler;
    }

    final XMLReader getXMLReader() {
        if (this.xmlReader != null) {
            return this.xmlReader;
        }
        if (this.parentHandler != null) {
            return this.parentHandler.getXMLReader();
        }
        return null;
    }

    InputStream getInputStreamForName(String streamName) {
        if (this.streams == null) {
            return null;
        }
        return this.streams.get(streamName);
    }

    final void setAttributes(Attributes atts) {
        this.attributes = atts == null ? null : MasterContentHandler.makeAttributeMap(atts);
    }

    public final Map<String, String> getAttributesForThis() {
        return this.attributes;
    }

    static final Map<String, String> makeAttributeMap(Attributes attributes) throws NullPointerException {
        if (attributes == null) {
            throw new NullPointerException("Cannot create an attribute map using a null attributes set.");
        }
        int attributesLength = attributes.getLength();
        if (attributesLength == 0) {
            return null;
        }
        HashMap<String, String> attributeMap = new HashMap<String, String>(attributesLength);
        for (int x = 0; x < attributesLength; ++x) {
            attributeMap.put(attributes.getQName(x), attributes.getValue(x));
        }
        return attributeMap;
    }

    public final String getAttributeValueThisElement(String attributeName) throws NullPointerException {
        if (attributeName == null) {
            throw new NullPointerException("Cannot retrieve an attribute value from a null name.");
        }
        if (this.attributes != null) {
            return this.attributes.get(attributeName);
        }
        return null;
    }

    final void setParentHandler(MasterContentHandler parentHandler) {
        this.parentHandler = parentHandler;
    }

    final MasterContentHandler getParentHandler() {
        return this.parentHandler;
    }

    void setElementName(String elementName) {
        this.elementName = elementName;
        this.namespace = null;
    }

    void setElementName(String namespace, String elementName) {
        this.elementName = elementName;
        this.namespace = namespace;
    }

    public final String getElementName() {
        return this.elementName;
    }

    public final String getNamespace() {
        return this.namespace;
    }

    public final String getFullElementName() {
        if (this.namespace == null) {
            return this.elementName;
        }
        return "{" + this.namespace + "}" + this.elementName;
    }
}

