/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.io.mxf;

import java.nio.ByteBuffer;
import tv.amwa.maj.integer.UInt16;
import tv.amwa.maj.integer.UInt8Array;
import tv.amwa.maj.io.mxf.VBISampleCoding;
import tv.amwa.maj.io.mxf.VBIWrappingType;

public class VBILine {
    private ByteBuffer data;
    private int lineNumber;
    private VBIWrappingType wrappingType;
    private VBISampleCoding sampleCoding;
    @UInt16
    private short sampleCount;

    public VBILine(int lineNumber, VBIWrappingType wrappingType, VBISampleCoding sampleCoding) {
        this.lineNumber = lineNumber;
        this.wrappingType = wrappingType;
        this.sampleCoding = sampleCoding;
    }

    public VBILine(int field, int lineNumber, VBIWrappingType wrappingType, VBISampleCoding sampleCoding) {
        this.lineNumber = field == 2 ? 16384 + lineNumber : lineNumber;
        this.wrappingType = wrappingType;
        this.sampleCoding = sampleCoding;
    }

    public VBILine(int lineNumber, VBIWrappingType wrappingType, VBISampleCoding sampleCoding, @UInt16 short sampleCount, ByteBuffer lineData) {
        this.lineNumber = lineNumber;
        this.wrappingType = wrappingType;
        this.sampleCoding = sampleCoding;
        this.setData(sampleCount, lineData);
    }

    public VBILine(int field, int lineNumber, VBIWrappingType wrappingType, VBISampleCoding sampleCoding, @UInt16 short sampleCount, ByteBuffer lineData) {
        this.lineNumber = field == 2 ? 16384 + lineNumber : lineNumber;
        this.wrappingType = wrappingType;
        this.sampleCoding = sampleCoding;
        this.setData(sampleCount, lineData);
    }

    public void setData(@UInt16 short sampleCount, ByteBuffer lineData) {
        if (lineData.hasArray()) {
            this.data = ByteBuffer.wrap(lineData.array());
        } else {
            byte[] lineDataBytes = new byte[lineData.capacity()];
            lineData.get(lineDataBytes);
            this.data = ByteBuffer.wrap(lineDataBytes);
        }
        this.sampleCount = sampleCount;
    }

    public int getDataSize() {
        return this.data.capacity();
    }

    public int getFullDataSize() {
        return this.data.capacity() + 6;
    }

    public void writeData(@UInt8Array byte[] buffer) {
    }
}

