/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.union.impl;

import java.io.Serializable;
import tv.amwa.maj.enumeration.FadeType;
import tv.amwa.maj.exception.BadLengthException;
import tv.amwa.maj.exception.PropertyNotPresentException;
import tv.amwa.maj.misctype.LengthType;
import tv.amwa.maj.union.Fade;

public class FadeImpl
implements Fade,
Serializable,
Cloneable {
    private static final long serialVersionUID = 465034093344901022L;
    private long fadeInLength = 0L;
    private FadeType fadeInType = FadeType.None;
    private boolean fadeInPresent = false;
    private long fadeOutLength = 0L;
    private FadeType fadeOutType = FadeType.None;
    private boolean fadeOutPresent = false;
    static final String FADEINLENGTH_TAG = "FadeInLength";
    static final String FADEINTYPE_TAG = "FadeInType";
    static final String FADEOUTLENGTH_TAG = "FadeOutLength";
    static final String FADEOUTTYPE_TAG = "FadeOutType";

    public FadeImpl() {
    }

    public FadeImpl(@LengthType long fadeInLength, FadeType fadeInType, @LengthType long fadeOutLength, FadeType fadeOutType) throws BadLengthException {
        this.setFadeInLength(fadeInLength);
        this.setFadeInType(fadeInType);
        this.setFadeOutLength(fadeOutLength);
        this.setFadeOutType(fadeOutType);
    }

    public final void setPropertiesFromInterface(Fade castFrom) {
        try {
            this.setFadeInLength(castFrom.getFadeInLength());
            this.setFadeInType(castFrom.getFadeInType());
        }
        catch (PropertyNotPresentException pnpe) {
            this.setFadeInType(null);
        }
        catch (BadLengthException ble) {
            throw new IllegalArgumentException("Fade.setPropertiesFromInterface(): " + ble);
        }
        try {
            this.setFadeOutLength(castFrom.getFadeOutLength());
            this.setFadeOutType(castFrom.getFadeOutType());
        }
        catch (PropertyNotPresentException pnpe) {
            this.setFadeOutType(null);
        }
        catch (BadLengthException ble) {
            throw new IllegalArgumentException("Fade.setPropertiesFromInterface(): " + ble);
        }
    }

    @Override
    @LengthType
    public long getFadeInLength() throws PropertyNotPresentException {
        if (!this.fadeInPresent) {
            throw new PropertyNotPresentException("The optional fade in property is not present in this fade value.");
        }
        return this.fadeInLength;
    }

    @Override
    public FadeType getFadeInType() throws PropertyNotPresentException {
        if (!this.fadeInPresent) {
            throw new PropertyNotPresentException("The optional fade in property is not present in this fade value.");
        }
        return this.fadeInType;
    }

    @Override
    @LengthType
    public long getFadeOutLength() throws PropertyNotPresentException {
        if (!this.fadeOutPresent) {
            throw new PropertyNotPresentException("The optional fade in property is not present in this fade value.");
        }
        return this.fadeOutLength;
    }

    @Override
    public FadeType getFadeOutType() throws PropertyNotPresentException {
        if (!this.fadeOutPresent) {
            throw new PropertyNotPresentException("The optional fade in property is not present in this fade value.");
        }
        return this.fadeOutType;
    }

    @Override
    public boolean isFadeInPresent() {
        return this.fadeInPresent;
    }

    @Override
    public boolean isFadeOutPresent() {
        return this.fadeOutPresent;
    }

    @Override
    public void setFadeInLength(@LengthType long fadeInLength) throws BadLengthException {
        if (fadeInLength < 0L) {
            throw new BadLengthException("Cannot set the fade in length to a negative value.");
        }
        this.fadeInPresent = true;
        this.fadeInLength = fadeInLength;
    }

    @Override
    public void setFadeInType(FadeType fadeInType) {
        if (fadeInType == null) {
            this.fadeInPresent = false;
        } else {
            this.fadeInType = fadeInType;
            this.fadeInPresent = true;
        }
    }

    @Override
    public void setFadeOutLength(@LengthType long fadeOutLength) throws BadLengthException {
        if (fadeOutLength < 0L) {
            throw new BadLengthException("Cannot set the fade out length to a negative value.");
        }
        this.fadeOutPresent = true;
        this.fadeOutLength = fadeOutLength;
    }

    @Override
    public void setFadeOutType(FadeType fadeOutType) {
        if (fadeOutType == null) {
            this.fadeOutPresent = false;
        } else {
            this.fadeOutType = fadeOutType;
            this.fadeOutPresent = true;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof Fade)) {
            return false;
        }
        Fade testFade = (Fade)o;
        if (!this.fadeInPresent) {
            return !testFade.isFadeInPresent();
        }
        if (!this.fadeOutPresent) {
            return !testFade.isFadeOutPresent();
        }
        try {
            if (this.fadeInLength != testFade.getFadeInLength()) {
                return false;
            }
            if (this.fadeInType != testFade.getFadeInType()) {
                return false;
            }
        }
        catch (PropertyNotPresentException pnpe) {
            return false;
        }
        try {
            if (this.fadeOutLength != testFade.getFadeOutLength()) {
                return false;
            }
            if (this.fadeOutType != testFade.getFadeOutType()) {
                return false;
            }
        }
        catch (PropertyNotPresentException pnpe) {
            return false;
        }
        return true;
    }

    public int hashCode() {
        return Long.valueOf(this.fadeInLength).hashCode() ^ Long.valueOf(this.fadeOutLength).hashCode() ^ this.fadeInType.hashCode() ^ this.fadeOutType.hashCode() ^ Boolean.valueOf(this.fadeInPresent).hashCode() ^ Boolean.valueOf(this.fadeOutPresent).hashCode() << 16;
    }

    public FadeImpl clone() {
        try {
            return (FadeImpl)super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            cnse.printStackTrace();
            return null;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.fadeInPresent) {
            sb.append("  <FadeInLength>" + this.fadeInLength + "</" + FADEINLENGTH_TAG + ">\n");
            sb.append("  <FadeInType>" + this.fadeInType.name() + "</" + FADEINTYPE_TAG + ">\n");
        }
        if (this.fadeOutPresent) {
            sb.append("  <FadeOutLength>" + this.fadeOutLength + "</" + FADEOUTLENGTH_TAG + ">\n");
            sb.append("  <FadeOutType>" + this.fadeOutType.name() + "</" + FADEOUTTYPE_TAG + ">\n");
        }
        if (sb.length() == 0) {
            return "<Fade />";
        }
        sb.insert(0, "<Fade>\n");
        sb.append("</Fade>");
        return sb.toString();
    }
}

