/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.util;

import java.io.File;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedMap;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import tv.amwa.maj.enumeration.TypeCategory;
import tv.amwa.maj.industry.MediaEngine;
import tv.amwa.maj.industry.Warehouse;
import tv.amwa.maj.meta.ClassDefinition;
import tv.amwa.maj.record.AUID;
import tv.amwa.maj.util.GenerationCore;

public class AutoGeneration
extends GenerationCore {
    public static final void main(String[] args) {
        if (args.length < 2) {
            System.out.println("Usage: java tv.amwa.maj.util.AutoGeneration <base_package_name> <metadictionary_XML_file>");
            System.exit(1);
        }
        GenerationCore.DictionaryContext context = null;
        try {
            File file = new File(args[1]);
            if (file.exists()) {
                DocumentBuilderFactory fact = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = fact.newDocumentBuilder();
                Document doc = builder.parse(args[1]);
                Element node = doc.getDocumentElement();
                context = AutoGeneration.processRoot(node);
            } else {
                System.out.println("File not found!");
            }
        }
        catch (Exception e) {
            System.err.println(e.getClass().getName() + " thrown: " + e.getMessage());
            e.printStackTrace();
        }
        context.basePackageName = args[0];
        if (!AutoGeneration.makeDirectories(context)) {
            System.out.println("Unable to create the required directory structure.");
            System.exit(1);
        }
        boolean success = true;
        success &= AutoGeneration.writeFile(context.interfaceDir, "Constants.java", AutoGeneration.generateConstants(context));
        for (GenerationCore.ClassData classData : classList.values()) {
            success &= AutoGeneration.writeFile(context.interfaceDir, classData.name + ".java", AutoGeneration.generateInterface(context.basePackageName, classData));
            success &= AutoGeneration.writeFile(context.implementationDir, classData.name + "Impl.java", AutoGeneration.generateImplementation(context.basePackageName, classData));
        }
        for (GenerationCore.TypeData typeData : typeList.values()) {
            if (!(typeData instanceof GenerationCore.TypeDataEnumeration)) continue;
            success &= AutoGeneration.writeFile(context.interfaceDir, typeData.name + ".java", AutoGeneration.generateEnumeration(context.basePackageName, (GenerationCore.TypeDataEnumeration)typeData));
        }
        for (GenerationCore.TypeData typeData : typeList.values()) {
            if (!(typeData instanceof GenerationCore.TypeDataExtendibleEnumeration)) continue;
            success &= AutoGeneration.writeFile(context.interfaceDir, typeData.name + ".java", AutoGeneration.generateExtendibleEnumeration(context.basePackageName, typeData.name, typeData.symbol));
        }
        for (GenerationCore.TypeData typeData : typeList.values()) {
            if (!(typeData instanceof GenerationCore.TypeDataRecord)) continue;
            success &= AutoGeneration.writeFile(context.interfaceDir, typeData.name + ".java", AutoGeneration.generateRecordInterface(context.basePackageName, (GenerationCore.TypeDataRecord)typeData));
            success &= AutoGeneration.writeFile(context.implementationDir, typeData.name + "Impl.java", AutoGeneration.generateRecordImplementation(context.basePackageName, (GenerationCore.TypeDataRecord)typeData));
        }
        success &= AutoGeneration.writeFile(context.interfaceDir, "TypeDefinitions.java", AutoGeneration.generateTypeDefinitions(context.basePackageName));
        context.factoryName = context.preferredPrefix != null && context.preferredPrefix.length() > 0 ? AutoGeneration.upperFirstLetter(context.preferredPrefix) + "Factory" : "Factory";
        if (success &= AutoGeneration.writeFile(context.interfaceDir, context.factoryName + ".java", AutoGeneration.generateFactory(context))) {
            System.out.println("Successfully generated all files for package " + context.basePackageName + ".");
        } else {
            System.out.println("Problem encountered generating files for package " + context.basePackageName + ".");
        }
    }

    static String generateInterface(String packageName, GenerationCore.ClassData classData) {
        GenerationCore.StringIndenter building = new GenerationCore.StringIndenter();
        building.setPackageName(packageName);
        building.startJavadoc();
        building.wrapComment("<p>" + classData.description + "</p>", 80);
        building.blankComment();
        building.wrapComment("@author Auto generation.", 80);
        building.endComment();
        building.addImport("tv.amwa.maj.industry.MediaEntity");
        building.append("public interface " + classData.name);
        building.increment("extends");
        building.append("    MediaEntity,");
        if (weakReferenceTargets.containsKey(classData.name)) {
            building.append("    WeakReferenceTarget,");
            building.addImport("tv.amwa.maj.industry.WeakReferenceTarget");
        }
        if (classData.parentClass == null || classData.parentClass.length() == 0) {
            building.appendNL("    Cloneable {");
        } else {
            building.append("    Cloneable,");
            if (classList.containsKey(classData.parentClass)) {
                building.appendNL("    " + classData.parentClass + " {");
            } else {
                Class<?>[] interfaces;
                ClassDefinition widerClass = Warehouse.lookForClass(classData.parentClass);
                for (Class<?> iface : interfaces = widerClass.getJavaImplementation().getInterfaces()) {
                    if (!iface.getName().contains(classData.parentClass)) continue;
                    building.appendNL("    " + classData.parentClass + " {");
                    building.addImport(iface.getCanonicalName());
                    break;
                }
            }
        }
        for (GenerationCore.PropertyData property : propertyList.values()) {
            if (!property.memberOf.equals(classData.name)) continue;
            AutoGeneration.addInterfaceGetter(building, property);
            AutoGeneration.addInterfaceSetter(building, property);
        }
        building.startJavadoc();
        building.wrapComment("<p>Create a cloned copy of this " + AutoGeneration.camelToWords(classData.name) + ".</p>", 80);
        building.blankComment();
        building.wrapComment("@return Cloned copy of this " + AutoGeneration.camelToWords(classData.name) + ".", 80);
        building.endComment();
        building.appendNL("public " + classData.name + " clone();");
        building.reset("}");
        return building.toString();
    }

    static void addInterfaceGetter(GenerationCore.StringIndenter building, GenerationCore.PropertyData property) {
        GenerationCore.TypeData typeData = AutoGeneration.typeByName(property.type);
        building.addImport(typeData.getImports());
        String annotation = typeData.getAnnotation();
        annotation = annotation == null ? "" : "@" + annotation + " ";
        building.startJavadoc();
        building.wrapComment("<p>Returns the " + AutoGeneration.lowerFirstLetter(property.description) + "</p>", 80);
        building.blankComment();
        if (property.isOptional) {
            building.wrapComment("<p>This is an optional property.</p>", 80);
            building.blankComment();
        }
        building.wrapComment("@return " + AutoGeneration.firstSentence(property.description), 80);
        if (property.isOptional) {
            building.append(" *");
            building.wrapComment("@throws PropertyNotPresentException The optional " + AutoGeneration.camelToWords(property.name) + " property is not present for this " + AutoGeneration.camelToWords(property.memberOf) + ".", 80);
        }
        building.endComment();
        switch (typeData.getTypeCategory()) {
            case VariableArray: {
                building.append("public List<? extends " + AutoGeneration.typeByName(property.type).getJavaGetName() + "> get" + property.name + "()" + (property.isOptional ? "" : ";\n"));
                building.addImport("java.util.List");
                break;
            }
            case FixedArray: {
                building.append("public " + annotation + AutoGeneration.typeByName(property.type).getJavaGetName() + "[] get" + property.name + "()" + (property.isOptional ? "" : ";\n"));
                break;
            }
            case Set: {
                building.append("public Set<? extends " + AutoGeneration.typeByName(property.type).getJavaGetName() + "> get" + property.name + "()" + (property.isOptional ? "" : ";\n"));
                building.addImport("java.util.Set");
                break;
            }
            default: {
                building.append("public " + annotation + AutoGeneration.typeByName(property.type).getJavaGetName() + " get" + property.name + "()" + (property.isOptional ? "" : ";\n"));
            }
        }
        if (property.isOptional) {
            building.appendNL("    throws PropertyNotPresentException;");
            building.addImport("tv.amwa.maj.exception.PropertyNotPresentException");
        }
    }

    static void addInterfaceSetter(GenerationCore.StringIndenter building, GenerationCore.PropertyData property) {
        GenerationCore.TypeData typeData = AutoGeneration.typeByName(property.type);
        building.addImport(typeData.getImports());
        String annotation = typeData.getAnnotation();
        annotation = annotation == null ? "" : "@" + annotation + " ";
        switch (typeData.getTypeCategory()) {
            case Set: {
                AutoGeneration.setTypeInterfaceMethods(building, property, typeData, annotation);
                break;
            }
            case VariableArray: {
                AutoGeneration.variableArrayInterfaceMethods(building, property, typeData, annotation);
                break;
            }
            case FixedArray: {
                AutoGeneration.fixedArrayInterfaceMethods(building, property, typeData, annotation);
                break;
            }
            default: {
                AutoGeneration.defaultInterfaceSetter(building, property, typeData, annotation);
            }
        }
    }

    private static void defaultInterfaceSetter(GenerationCore.StringIndenter building, GenerationCore.PropertyData property, GenerationCore.TypeData typeData, String annotation) {
        building.startJavadoc();
        building.wrapComment("<p>Sets the " + AutoGeneration.lowerFirstLetter(property.description) + "</p>", 80);
        building.blankComment();
        if (property.isOptional) {
            building.wrapComment("<p>Set this optional property to <code>null</code> to omit it.</p>", 80);
            building.blankComment();
        }
        building.wrapComment("@param " + AutoGeneration.lowerFirstLetter(property.name) + " " + AutoGeneration.firstSentence(property.description), 80);
        if (!property.isOptional && AutoGeneration.isNullableType(typeData)) {
            building.blankComment();
            building.wrapComment("@throws NullPointerException Cannot set the required " + AutoGeneration.camelToWords(property.name) + " with a <code>null</code> value.", 80);
        }
        if (typeData.getThrowsIllegal()) {
            if (property.isOptional) {
                building.blankComment();
            }
            building.wrapComment("@throws IllegalArgumentException Cannot set the " + AutoGeneration.camelToWords(property.name) + " property with the given value.", 80);
        }
        building.endComment();
        building.append("public void set" + property.name + "(");
        building.append("        " + annotation + typeData.getJavaSetName(property.isOptional) + " " + AutoGeneration.lowerFirstLetter(property.name) + ")");
        Vector<String> exceptional = new Vector<String>();
        if (!property.isOptional && AutoGeneration.isNullableType(typeData)) {
            exceptional.add("NullPointerException");
        }
        if (typeData.getThrowsIllegal()) {
            exceptional.add("IllegalArgumentException");
        }
        building.addThrowsClause(exceptional, true);
    }

    private static void setTypeInterfaceMethods(GenerationCore.StringIndenter building, GenerationCore.PropertyData property, GenerationCore.TypeData typeData, String annotation) {
        building.startJavadoc();
        building.wrapComment("<p>Add " + AutoGeneration.aOrAn(AutoGeneration.camelToWords(typeData.getJavaGetName())) + " to the set of " + AutoGeneration.camelToWords(property.name) + " for this " + AutoGeneration.camelToWords(property.memberOf) + ". This is a " + AutoGeneration.lowerFirstLetter(property.description) + "</p>", 80);
        building.blankComment();
        if (property.isOptional) {
            building.wrapComment("<p>This is an optional property. Adding a value when it is omitted will make it present.</p>", 80);
            building.blankComment();
        }
        building.wrapComment("@param " + AutoGeneration.lowerFirstLetter(AutoGeneration.makeSingular(property.name)) + " Element to add to the set of " + AutoGeneration.camelToWords(property.name) + ".", 80);
        building.blankComment();
        building.wrapComment("@throws NullPointerException Cannot add a null " + AutoGeneration.camelToWords(typeData.getJavaGetName()) + " to the set of " + AutoGeneration.camelToWords(property.name) + ".", 80);
        if (typeData.getThrowsIllegal()) {
            building.wrapComment("@throws IllegalArgumentException The given value cannot be set as an element of the set of " + AutoGeneration.camelToWords(property.name) + ".", 80);
        }
        building.endComment();
        building.append("public void add" + AutoGeneration.makeSingular(property.name) + "(");
        building.append("         " + annotation + typeData.getJavaSetName(property.isOptional) + " " + AutoGeneration.lowerFirstLetter(AutoGeneration.makeSingular(property.name)) + ")");
        Vector<String> exceptional = new Vector<String>();
        exceptional.add("NullPointerException");
        if (typeData.getThrowsIllegal()) {
            exceptional.add("IllegalArgumentException");
        }
        building.addThrowsClause(exceptional, true);
        building.startJavadoc();
        building.wrapComment("<p>Test to see if the given " + AutoGeneration.camelToWords(typeData.getJavaGetName()) + " is contained in this set of " + AutoGeneration.camelToWords(property.name) + ". Testing for containment in the " + AutoGeneration.lowerFirstLetter(property.description) + "</p>", 80);
        building.blankComment();
        building.wrapComment("@param " + AutoGeneration.lowerFirstLetter(AutoGeneration.makeSingular(property.name)) + " The " + AutoGeneration.camelToWords(typeData.getJavaGetName()) + " to test for.", 80);
        building.wrapComment("@return Is the given " + AutoGeneration.camelToWords(typeData.getJavaGetName()) + " present in the set of " + AutoGeneration.camelToWords(property.name) + "?", 80);
        building.blankComment();
        building.wrapComment("@throws NullPointerException Cannot check for containment using a <code>null</code> value.", 80);
        building.endComment();
        building.append("public boolean contains" + AutoGeneration.makeSingular(property.name) + "(");
        building.append("        " + typeData.getJavaGetName() + " " + AutoGeneration.lowerFirstLetter(AutoGeneration.makeSingular(property.name)) + ")");
        exceptional.clear();
        exceptional.add("NullPointerException");
        building.addThrowsClause(exceptional, true);
        building.startJavadoc();
        building.wrapComment("<p>Remove a value equal to the given " + AutoGeneration.camelToWords(typeData.getJavaGetName()) + " from the set of " + AutoGeneration.camelToWords(property.name) + ". Element will be removed from the " + AutoGeneration.lowerFirstLetter(property.description) + "</p>", 80);
        building.blankComment();
        if (!property.isOptional) {
            building.wrapComment("<p>This property is required. If the last element is removed, you should add in a new element to satisfy the required constraint.</p>", 80);
            building.blankComment();
        }
        building.wrapComment("@param " + AutoGeneration.lowerFirstLetter(AutoGeneration.makeSingular(property.name)) + " The " + AutoGeneration.camelToWords(typeData.getJavaGetName()) + " to remove from the set.", 80);
        building.wrapComment("@return Has the given element been removed from the set of " + AutoGeneration.camelToWords(property.name) + "?", 80);
        building.blankComment();
        building.wrapComment("@throws NullPointerException Cannot remove a <code>null</code> value from a set.", 80);
        building.endComment();
        building.append("public boolean remove" + AutoGeneration.makeSingular(property.name) + "(");
        building.append("        " + typeData.getJavaGetName() + " " + AutoGeneration.lowerFirstLetter(AutoGeneration.makeSingular(property.name)) + ")");
        exceptional.clear();
        exceptional.add("NullPointerException");
        building.addThrowsClause(exceptional, true);
        AutoGeneration.sharedInterfaceMethods(building, property, typeData, annotation);
    }

    private static void variableArrayInterfaceMethods(GenerationCore.StringIndenter building, GenerationCore.PropertyData property, GenerationCore.TypeData typeData, String annotation) {
        building.startJavadoc();
        building.wrapComment("<p>Append " + AutoGeneration.aOrAn(AutoGeneration.camelToWords(typeData.getJavaGetName())) + " to the list of " + AutoGeneration.camelToWords(property.name) + ". The element is appended to the " + AutoGeneration.lowerFirstLetter(property.description) + "</p>", 80);
        building.blankComment();
        building.wrapComment("@param " + AutoGeneration.lowerFirstLetter(AutoGeneration.makeSingular(property.name)) + " The " + AutoGeneration.camelToWords(typeData.getJavaGetName()) + " to append to the list of " + AutoGeneration.camelToWords(property.name) + ".", 80);
        building.blankComment();
        building.wrapComment("@throws NullPointerException Cannot append a <code>null</code> to the list of " + AutoGeneration.camelToWords(property.name) + ".", 80);
        if (typeData.getThrowsIllegal()) {
            building.wrapComment("@throws IllegalArgumentException The given value is outside the acceptable range for this property.", 80);
        }
        building.blankComment();
        building.wrapComment("@see #prepend" + AutoGeneration.makeSingular(property.name) + "(" + typeData.getJavaGetName() + ")", 80);
        building.wrapComment("@see #insert" + AutoGeneration.makeSingular(property.name) + "(int, " + typeData.getJavaGetName() + ")", 80);
        building.endComment();
        building.append("public void append" + AutoGeneration.makeSingular(property.name) + "(");
        building.append("        " + annotation + typeData.getJavaGetName() + " " + AutoGeneration.lowerFirstLetter(AutoGeneration.makeSingular(property.name)) + ")");
        Vector<String> exceptional = new Vector<String>();
        exceptional.add("NullPointerException");
        if (typeData.getThrowsIllegal()) {
            exceptional.add("IllegalArgumentException");
        }
        building.addThrowsClause(exceptional, true);
        building.startJavadoc();
        building.wrapComment("<p>Prepend " + AutoGeneration.aOrAn(AutoGeneration.camelToWords(typeData.getJavaGetName())) + " to the list of " + AutoGeneration.camelToWords(property.name) + ". The element is prepended to the " + AutoGeneration.lowerFirstLetter(property.description) + "</p>", 80);
        building.blankComment();
        building.wrapComment("@param " + AutoGeneration.lowerFirstLetter(AutoGeneration.makeSingular(property.name)) + " The " + AutoGeneration.camelToWords(typeData.getJavaGetName()) + " to prepend to the list of " + AutoGeneration.camelToWords(property.name) + ".", 80);
        building.blankComment();
        building.wrapComment("@throws NullPointerException Cannot prepend a <code>null</code> to the list of " + AutoGeneration.camelToWords(property.name) + ".", 80);
        if (typeData.getThrowsIllegal()) {
            building.wrapComment("@throws IllegalArgumentException The given value is outside the acceptable range for this property.", 80);
        }
        building.blankComment();
        building.wrapComment("@see #append" + AutoGeneration.makeSingular(property.name) + "(" + typeData.getJavaGetName() + ")", 80);
        building.wrapComment("@see #insert" + AutoGeneration.makeSingular(property.name) + "(int, " + typeData.getJavaGetName() + ")", 80);
        building.endComment();
        building.append("public void prepend" + AutoGeneration.makeSingular(property.name) + "(");
        building.append("        " + annotation + typeData.getJavaGetName() + " " + AutoGeneration.lowerFirstLetter(AutoGeneration.makeSingular(property.name)) + ")");
        exceptional.clear();
        exceptional.add("NullPointerException");
        if (typeData.getThrowsIllegal()) {
            exceptional.add("IllegalArgumentException");
        }
        building.addThrowsClause(exceptional, true);
        building.startJavadoc();
        building.wrapComment("<p>Insert " + AutoGeneration.aOrAn(AutoGeneration.camelToWords(typeData.getJavaGetName())) + " into the list of " + AutoGeneration.camelToWords(property.name) + " at the given index. The element is prepended to the " + AutoGeneration.lowerFirstLetter(property.description) + "</p>", 80);
        building.blankComment();
        building.wrapComment("@param index Index in the list of " + AutoGeneration.camelToWords(property.name) + " where the element is to be inserted.", 80);
        building.wrapComment("@param " + AutoGeneration.lowerFirstLetter(AutoGeneration.makeSingular(property.name)) + " The " + AutoGeneration.camelToWords(typeData.getJavaGetName()) + " to insert into the list of " + AutoGeneration.camelToWords(property.name) + ".", 80);
        building.blankComment();
        building.wrapComment("@throws NullPointerException Cannot insert a <code>null</code> to the list of " + AutoGeneration.camelToWords(property.name) + ".", 80);
        building.wrapComment("@throws IndexOutOfBoundsException The given index is outside the acceptable range for the current list of " + AutoGeneration.camelToWords(property.name) + ".", 80);
        if (typeData.getThrowsIllegal()) {
            building.wrapComment("@throws IllegalArgumentException The given value is outside the acceptable range for this property.", 80);
        }
        building.blankComment();
        building.wrapComment("@see #append" + AutoGeneration.makeSingular(property.name) + "(" + typeData.getJavaGetName() + ")", 80);
        building.wrapComment("@see #prepend" + AutoGeneration.makeSingular(property.name) + "(" + typeData.getJavaGetName() + ")", 80);
        building.endComment();
        building.append("public void insert" + AutoGeneration.makeSingular(property.name) + "At(");
        building.append("        int index,");
        building.append("        " + annotation + typeData.getJavaGetName() + " " + AutoGeneration.lowerFirstLetter(AutoGeneration.makeSingular(property.name)) + ")");
        exceptional.clear();
        exceptional.add("NullPointerException");
        exceptional.add("IndexOutOfBoundsException");
        if (typeData.getThrowsIllegal()) {
            exceptional.add("IllegalArgumentException");
        }
        building.addThrowsClause(exceptional, true);
        building.startJavadoc();
        building.wrapComment("<p>Determines whether the given " + AutoGeneration.camelToWords(AutoGeneration.makeSingular(property.name)) + " is contained in the list of " + AutoGeneration.camelToWords(property.name) + ". This is the list of " + AutoGeneration.lowerFirstLetter(property.description) + "</p>", 80);
        building.blankComment();
        building.wrapComment("@param " + AutoGeneration.lowerFirstLetter(AutoGeneration.makeSingular(property.name)) + " The " + AutoGeneration.camelToWords(AutoGeneration.makeSingular(property.name)) + " to test for in the list of " + AutoGeneration.camelToWords(property.name) + ".", 80);
        building.wrapComment("@return Is the given " + AutoGeneration.camelToWords(AutoGeneration.makeSingular(property.name)) + " contained in the list of " + AutoGeneration.camelToWords(property.name) + "?", 80);
        building.blankComment();
        building.wrapComment("@throws NullPointerException Cannot check for the containment of a <code>null</code> value.", 80);
        building.endComment();
        building.append("public boolean contains" + AutoGeneration.makeSingular(property.name) + "(");
        building.append("        " + annotation + typeData.getJavaGetName() + " " + AutoGeneration.lowerFirstLetter(AutoGeneration.makeSingular(property.name)) + ")");
        exceptional.clear();
        exceptional.add("NullPointerException");
        building.addThrowsClause(exceptional, true);
        building.startJavadoc();
        building.wrapComment("<p>Get the " + AutoGeneration.camelToWords(AutoGeneration.makeSingular(property.name)) + " at the given index into the list of " + AutoGeneration.camelToWords(property.name) + ". This is the " + AutoGeneration.lowerFirstLetter(property.description) + "</p>", 80);
        building.blankComment();
        building.wrapComment("@param index Index of the element to retrieve from the list of " + AutoGeneration.camelToWords(property.name) + ".", 80);
        building.wrapComment("@return The " + AutoGeneration.camelToWords(AutoGeneration.makeSingular(property.name)) + " at the given index.", 80);
        building.blankComment();
        building.wrapComment("@throws IndexOutOfBoundsException The given index is outside the acceptable range for the current list of " + AutoGeneration.camelToWords(property.name) + ".", 80);
        building.blankComment();
        building.wrapComment("@see #get" + property.name + "()", 80);
        building.endComment();
        building.append("public " + annotation + typeData.getJavaGetName() + " get" + AutoGeneration.makeSingular(property.name) + "At(");
        building.append("        int index)");
        exceptional.clear();
        exceptional.add("IndexOutOfBoundsException");
        building.addThrowsClause(exceptional, true);
        building.startJavadoc();
        building.wrapComment("<p>Remove the " + AutoGeneration.camelToWords(AutoGeneration.makeSingular(property.name)) + " at the given index into the list of " + AutoGeneration.camelToWords(property.name) + ". This is the " + AutoGeneration.lowerFirstLetter(property.description) + "</p>", 80);
        building.blankComment();
        building.wrapComment("@param index Index of the element to remove from the list of " + AutoGeneration.camelToWords(property.name) + ".", 80);
        building.blankComment();
        building.wrapComment("@throws IndexOutOfBoundsException The given index is outside the acceptable range for the current list of " + AutoGeneration.camelToWords(property.name) + ".", 80);
        building.endComment();
        building.append("public void remove" + AutoGeneration.makeSingular(property.name) + "At(");
        building.append("        int index)");
        exceptional.clear();
        exceptional.add("IndexOutOfBoundsException");
        building.addThrowsClause(exceptional, true);
        AutoGeneration.sharedInterfaceMethods(building, property, typeData, annotation);
    }

    private static void fixedArrayInterfaceMethods(GenerationCore.StringIndenter building, GenerationCore.PropertyData property, GenerationCore.TypeData typeData, String annotation) {
        building.startJavadoc();
        building.wrapComment("<p>Sets the " + AutoGeneration.lowerFirstLetter(property.description) + "</p>", 80);
        building.blankComment();
        if (property.isOptional) {
            building.wrapComment("<p>Set this optional property to <code>null</code> to omit it.</p>", 80);
            building.blankComment();
        }
        building.wrapComment("@param " + AutoGeneration.lowerFirstLetter(property.name) + " " + AutoGeneration.firstSentence(property.description), 80);
        building.blankComment();
        building.wrapComment("@throws NullPointerException Cannot set the required " + AutoGeneration.camelToWords(property.name) + " with a <code>null</code> value or one of the elements of the given array is <code>null</code>.", 80);
        if (typeData.getThrowsIllegal()) {
            if (property.isOptional) {
                building.blankComment();
            }
            building.wrapComment("@throws IllegalArgumentException Cannot set the " + AutoGeneration.camelToWords(property.name) + " property with the given value.", 80);
        }
        building.endComment();
        building.append("public void set" + property.name + "(");
        building.append("        " + annotation + typeData.getJavaSetName(property.isOptional) + " " + AutoGeneration.lowerFirstLetter(property.name) + "[])");
        Vector<String> exceptional = new Vector<String>();
        exceptional.add("NullPointerException");
        if (typeData.getThrowsIllegal()) {
            exceptional.add("IllegalArgumentException");
        }
        building.addThrowsClause(exceptional, true);
    }

    private static void sharedInterfaceMethods(GenerationCore.StringIndenter building, GenerationCore.PropertyData property, GenerationCore.TypeData typeData, String annotation) {
        building.startJavadoc();
        building.wrapComment("<p>Clears the set of " + AutoGeneration.camelToWords(property.name) + ", which is a " + AutoGeneration.lowerFirstLetter(property.description) + "</p>", 80);
        building.blankComment();
        if (!property.isOptional) {
            building.wrapComment("<p>This is a required property. Elements should be added back in directly after calling this method to satisfy the required constraint.</p>", 80);
        } else {
            building.wrapComment("<p>Calling this method will omit this optional property.</p>", 80);
        }
        building.endComment();
        building.appendNL("public void clear" + property.name + "();");
        building.startJavadoc();
        building.wrapComment("<p>Counts the number of elements in the set of " + AutoGeneration.camelToWords(property.name) + ". This set is a " + AutoGeneration.lowerFirstLetter(property.description) + "</p>", 80);
        building.blankComment();
        building.wrapComment("@return Number of elements in the set of " + AutoGeneration.camelToWords(property.name) + ".", 80);
        building.endComment();
        building.appendNL("public int count" + property.name + "();");
    }

    static String generateImplementation(String basePackageName, GenerationCore.ClassData classData) {
        MessageDigest messageDigest;
        GenerationCore.StringIndenter building = new GenerationCore.StringIndenter();
        building.setPackageName(basePackageName + ".impl");
        building.startJavadoc();
        building.wrapComment("<p>" + classData.description + " Implementation.</p>", 80);
        building.blankComment();
        building.wrapComment("@author Auto generation.", 80);
        building.endComment();
        building.addImport("tv.amwa.maj.industry.MediaClass");
        building.addImport(basePackageName + ".Constants");
        building.append("@MediaClass(");
        building.increment("definedName = \"" + classData.name + "\",");
        building.append("uuid1 = 0x" + AutoGeneration.padHexTo8(classData.identification.getData1()) + ", uuid2 = (short) 0x" + AutoGeneration.padHexTo4(classData.identification.getData2()) + ", uuid3 = (short) 0x" + AutoGeneration.padHexTo4(classData.identification.getData3()) + ",");
        building.append("uuid4 = { " + AutoGeneration.bytesToText(classData.identification.getData4()) + " },");
        if (classData.description != null) {
            building.append("description = \"" + classData.description.replace("\"", "\\\"") + "\",");
        } else {
            building.append("description = \"\",");
        }
        building.append("namespace = Constants.XML_NAMESPACE,");
        building.append("prefix = Constants.XML_PREFIX,");
        building.append("symbol = \"" + classData.symbol + "\")");
        building.reset("public " + (classData.isConcrete ? "" : "abstract ") + "class " + classData.name + "Impl");
        if (classData.parentClass != null && classData.parentClass.length() > 0) {
            building.append("    extends");
            if (classList.containsKey(classData.parentClass)) {
                building.append("        " + classData.parentClass + "Impl");
            } else {
                ClassDefinition widerClass = Warehouse.lookForClass(classData.parentClass);
                building.append("        " + classData.parentClass + "Impl");
                building.addImport(widerClass.getJavaImplementation().getCanonicalName());
            }
        }
        building.addImport(basePackageName + "." + classData.name);
        building.addImport("tv.amwa.maj.io.xml.XMLSerializable");
        building.addImport("tv.amwa.maj.constant.CommonConstants");
        building.addImport("java.io.Serializable");
        building.increment("implements");
        building.append("    " + classData.name + ",");
        building.append("    CommonConstants,");
        building.append("    Serializable,");
        building.append("    XMLSerializable,");
        if (weakReferenceTargets.containsKey(classData.name)) {
            building.addImport("tv.amwa.maj.industry.WeakReferenceTarget");
            building.append("    WeakReferenceTarget,");
        }
        building.appendNL("    Cloneable {");
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new InternalError("Unable to find MD5 checksum algorithm.");
        }
        messageDigest.update(classData.identification.getAUIDValue());
        for (GenerationCore.PropertyData property : propertyList.values()) {
            if (!property.memberOf.equals(classData.name)) continue;
            messageDigest.update(property.identification.getAUIDValue());
        }
        byte[] uidBytes = messageDigest.digest();
        long uid = (long)uidBytes[0] << 56 ^ (long)uidBytes[1] << 48 ^ (long)uidBytes[2] << 40 ^ (long)uidBytes[3] << 32 ^ (long)uidBytes[4] << 24 ^ (long)uidBytes[5] << 16 ^ (long)uidBytes[6] << 8 ^ (long)uidBytes[7];
        building.appendNL("private static final long serialVersionUID = " + uid + "l;");
        block16: for (GenerationCore.PropertyData property : propertyList.values()) {
            if (!property.memberOf.equals(classData.name)) continue;
            GenerationCore.TypeData typeData = AutoGeneration.typeByName(property.type);
            building.addImport(typeData.getImports());
            String annotation = typeData.getAnnotation();
            annotation = annotation == null ? "" : "@" + annotation + " ";
            switch (typeData.getTypeCategory()) {
                case WeakObjRef: {
                    building.append("private WeakReference<" + typeData.getJavaGetName() + "> " + AutoGeneration.lowerFirstLetter(property.name) + ";");
                    building.addImport("tv.amwa.maj.industry.WeakReference");
                    String weakRefType = ((GenerationCore.TypeDataWeakObjectReference)typeData).referencedType;
                    if (classList.containsKey(weakRefType)) {
                        building.addImport(basePackageName + "." + weakRefType);
                        continue block16;
                    }
                    building.addImport(typeData.getImports());
                    continue block16;
                }
                case Set: {
                    GenerationCore.TypeDataSet setType = (GenerationCore.TypeDataSet)typeData;
                    GenerationCore.TypeData setElementType = AutoGeneration.typeByName(setType.elementType);
                    building.addImport("java.util.Set");
                    switch (setElementType.getTypeCategory()) {
                        case WeakObjRef: {
                            building.append("private WeakReferenceSet<" + typeData.getJavaGetName() + "> " + AutoGeneration.lowerFirstLetter(property.name) + " =");
                            building.append("        new WeakReferenceSet<" + typeData.getJavaGetName() + ">();");
                            building.addImport("tv.amwa.maj.industry.WeakReferenceSet");
                            if (classList.containsKey(((GenerationCore.TypeDataWeakObjectReference)setElementType).referencedType)) {
                                building.addImport(basePackageName + "." + typeData.getJavaGetName());
                                continue block16;
                            }
                            building.addImport(setElementType.getImports());
                            continue block16;
                        }
                    }
                    building.append("private Set<" + typeData.getJavaSetName(true) + "> " + AutoGeneration.lowerFirstLetter(property.name) + " =");
                    building.append("        Collections.synchronizedSet(new HashSet<" + typeData.getJavaSetName(true) + ">());");
                    building.addImport("tv.amwa.maj.industry.StrongReferenceSet");
                    building.addImport("java.util.Collections");
                    building.addImport("java.util.HashSet");
                    if (setElementType instanceof GenerationCore.TypeDataStrongObjectReference && classList.containsKey(((GenerationCore.TypeDataStrongObjectReference)setElementType).referencedType)) {
                        building.addImport(basePackageName + "." + typeData.getJavaSetName(true));
                        continue block16;
                    }
                    building.addImport(setElementType.getImports());
                    continue block16;
                }
                case VariableArray: {
                    GenerationCore.TypeDataVariableArray varialbeArrayType = (GenerationCore.TypeDataVariableArray)typeData;
                    GenerationCore.TypeData arrayElementType = AutoGeneration.typeByName(varialbeArrayType.elementType);
                    switch (arrayElementType.getTypeCategory()) {
                        case WeakObjRef: {
                            building.append("private WeakReferenceVector<" + typeData.getJavaGetName() + "> " + AutoGeneration.lowerFirstLetter(property.name) + " =");
                            building.append("        new WeakReferenceVector<" + typeData.getJavaGetName() + ">();");
                            building.addImport("tv.amwa.maj.industry.WeakReferenceVector");
                            if (classList.containsKey(((GenerationCore.TypeDataWeakObjectReference)arrayElementType).referencedType)) {
                                building.addImport(basePackageName + "." + typeData.getJavaGetName());
                                continue block16;
                            }
                            building.addImport(arrayElementType.getImports());
                            continue block16;
                        }
                    }
                    building.append("private List<" + typeData.getJavaSetName(true) + "> " + AutoGeneration.lowerFirstLetter(property.name) + " =");
                    building.append("        Collections.synchronizedList(new Vector<" + typeData.getJavaSetName(true) + ">());");
                    building.addImport("tv.amwa.maj.industry.StrongReferenceVector");
                    building.addImport("java.util.Collections");
                    building.addImport("java.util.List");
                    building.addImport("java.util.Vector");
                    if (arrayElementType instanceof GenerationCore.TypeDataStrongObjectReference && classList.containsKey(((GenerationCore.TypeDataStrongObjectReference)arrayElementType).referencedType)) {
                        building.addImport(basePackageName + "." + typeData.getJavaSetName(true));
                        continue block16;
                    }
                    building.addImport(arrayElementType.getImports());
                    continue block16;
                }
                case StrongObjRef: {
                    building.append("private " + annotation + typeData.getJavaSetName(property.isOptional) + " " + AutoGeneration.lowerFirstLetter(property.name) + ";");
                    String strongRefType = ((GenerationCore.TypeDataStrongObjectReference)typeData).referencedType;
                    if (classList.containsKey(strongRefType)) {
                        building.addImport(basePackageName + "." + strongRefType);
                        continue block16;
                    }
                    building.addImport(typeData.getImports());
                    continue block16;
                }
                case Record: 
                case Enum: {
                    if (!typeList.containsKey(typeData.name)) break;
                    building.addImport(basePackageName + "." + typeData.name);
                }
            }
            building.append("private " + annotation + typeData.getJavaSetName(property.isOptional) + " " + AutoGeneration.lowerFirstLetter(property.name) + ";");
        }
        building.append("");
        building.appendNL("public " + classData.name + "Impl() { }");
        for (GenerationCore.PropertyData property : propertyList.values()) {
            if (!property.memberOf.equals(classData.name)) continue;
            AutoGeneration.addImplementationGetter(building, property);
            AutoGeneration.addImplementationSetter(building, property);
        }
        if (weakReferenceTargets.containsKey(classData.name)) {
            building.appendNL("public AUID getAUID() {");
            building.increment("return get" + (String)weakReferenceTargets.get(classData.name) + "();");
            building.decrementNL("}");
            building.appendNL("public String getWeakTargetReference() {");
            building.increment("return getAUID().toString();");
            building.decrementNL("}");
        }
        if (classData.parentClass == null || classData.parentClass.length() == 0) {
            AutoGeneration.addRootClassMethods(building, classData);
        } else {
            building.appendNL("public " + classData.name + " clone() {");
            building.increment("return (" + classData.name + ") super.clone();");
            building.decrementNL("}");
        }
        building.reset("}");
        return building.toString();
    }

    static void addImplementationGetter(GenerationCore.StringIndenter building, GenerationCore.PropertyData property) {
        GenerationCore.TypeData typeData = AutoGeneration.typeByName(property.type);
        building.addImport(typeData.getImports());
        String annotation = typeData.getAnnotation();
        annotation = annotation == null ? "" : "@" + annotation + " ";
        building.addImport("tv.amwa.maj.industry.MediaProperty");
        building.append("@MediaProperty(");
        building.increment("definedName = \"" + property.name + "\",");
        building.append("uuid1 = 0x" + AutoGeneration.padHexTo8(property.identification.getData1()) + ", uuid2 = (short) 0x" + AutoGeneration.padHexTo4(property.identification.getData2()) + ", uuid3 = (short) 0x" + AutoGeneration.padHexTo4(property.identification.getData3()) + ",");
        building.append("uuid4 = { " + AutoGeneration.bytesToText(property.identification.getData4()) + " },");
        building.append("typeName = \"" + property.type + "\",");
        building.append("optional = " + property.isOptional + ",");
        building.append("uniqueIdentifier = " + property.isUniqueIdentifier + ",");
        building.append("pid = 0x" + AutoGeneration.padHexTo4(property.localIdentification) + ",");
        building.append("description = \"" + property.description.replace("\"", "\\\"") + "\",");
        building.append("symbol = \"" + property.symbol + "\")");
        Vector<String> exceptional = new Vector<String>();
        switch (typeData.getTypeCategory()) {
            case VariableArray: {
                building.decrement("public List<" + typeData.getJavaGetName() + "> get" + property.name + "()");
                exceptional.clear();
                if (property.isOptional) {
                    exceptional.add("PropertyNotPresentException");
                    building.addImport("tv.amwa.maj.exception.PropertyNotPresentException");
                }
                building.addThrowsClause(exceptional, false);
                if (property.isOptional) {
                    building.append("if (count" + property.name + "() == 0)");
                    building.appendNL("    throw new PropertyNotPresentException(\"No " + AutoGeneration.camelToWords(AutoGeneration.makeSingular(property.name)) + " elements are present for the list of " + AutoGeneration.camelToWords(property.name) + ".\");");
                    if (AutoGeneration.typeByName(((GenerationCore.TypeDataVariableArray)typeData).elementType).getTypeCategory() == TypeCategory.WeakObjRef) {
                        building.append("return " + AutoGeneration.lowerFirstLetter(property.name) + ".getOptionalList();");
                        break;
                    }
                    building.addImport("tv.amwa.maj.industry.StrongReferenceVector");
                    building.append("return StrongReferenceVector.getOptionalList(" + AutoGeneration.lowerFirstLetter(property.name) + ");");
                    break;
                }
                if (AutoGeneration.typeByName(((GenerationCore.TypeDataVariableArray)typeData).elementType).getTypeCategory() == TypeCategory.WeakObjRef) {
                    building.append("return " + AutoGeneration.lowerFirstLetter(property.name) + ".getRequiredList();");
                    break;
                }
                building.addImport("tv.amwa.maj.industry.StrongReferenceVector");
                building.append("return StrongReferenceVector.getRequiredList(" + AutoGeneration.lowerFirstLetter(property.name) + ");");
                break;
            }
            case Set: {
                building.decrement("public Set<" + typeData.getJavaGetName() + "> get" + property.name + "()");
                exceptional.clear();
                if (property.isOptional) {
                    exceptional.add("PropertyNotPresentException");
                    building.addImport("tv.amwa.maj.exception.PropertyNotPresentException");
                }
                building.addThrowsClause(exceptional, false);
                if (property.isOptional) {
                    building.append("if (count" + property.name + "() == 0)");
                    building.appendNL("    throw new PropertyNotPresentException(\"No " + AutoGeneration.camelToWords(AutoGeneration.makeSingular(property.name)) + " elements are present for the set of " + AutoGeneration.camelToWords(property.name) + ".\");");
                    if (AutoGeneration.typeByName(((GenerationCore.TypeDataSet)typeData).elementType).getTypeCategory() == TypeCategory.WeakObjRef) {
                        building.append("return " + AutoGeneration.lowerFirstLetter(property.name) + ".getOptionalSet();");
                        break;
                    }
                    building.addImport("tv.amwa.maj.industry.StrongReferenceSet");
                    building.append("return StrongReferenceSet.getOptionalSet(" + AutoGeneration.lowerFirstLetter(property.name) + ");");
                    break;
                }
                if (AutoGeneration.typeByName(((GenerationCore.TypeDataSet)typeData).elementType).getTypeCategory() == TypeCategory.WeakObjRef) {
                    building.append("return " + AutoGeneration.lowerFirstLetter(property.name) + ".getRequiredSet();");
                    break;
                }
                building.addImport("tv.amwa.maj.industry.StrongReferenceSet");
                building.append("return StrongReferenceSet.getRequiredSet(" + AutoGeneration.lowerFirstLetter(property.name) + ");");
                break;
            }
            default: {
                building.decrement("public " + annotation + typeData.getJavaGetName() + " get" + property.name + "()");
                exceptional.clear();
                if (property.isOptional) {
                    exceptional.add("PropertyNotPresentException");
                    building.addImport("tv.amwa.maj.exception.PropertyNotPresentException");
                }
                building.addThrowsClause(exceptional, false);
                if (property.isOptional) {
                    building.append("if (" + AutoGeneration.lowerFirstLetter(property.name) + " == null)");
                    building.appendNL("    throw new PropertyNotPresentException(\"The optional " + AutoGeneration.camelToWords(property.name) + " property is not present for this " + AutoGeneration.camelToWords(property.memberOf) + ".\");");
                }
                if (typeData.getTypeCategory() == TypeCategory.StrongObjRef || typeData.getTypeCategory() == TypeCategory.Record) {
                    building.append("return " + AutoGeneration.lowerFirstLetter(property.name) + ";");
                    break;
                }
                if (typeData.getTypeCategory() == TypeCategory.WeakObjRef) {
                    building.append("return " + AutoGeneration.lowerFirstLetter(property.name) + ".getTarget();");
                    break;
                }
                building.append("return " + AutoGeneration.lowerFirstLetter(property.name) + ";");
            }
        }
        building.decrementNL("}");
    }

    static void addImplementationSetter(GenerationCore.StringIndenter building, GenerationCore.PropertyData property) {
        GenerationCore.TypeData typeData = AutoGeneration.typeByName(property.type);
        building.addImport(typeData.getImports());
        String annotation = typeData.getAnnotation();
        annotation = annotation == null ? "" : "@" + annotation + " ";
        switch (typeData.getTypeCategory()) {
            case Set: {
                AutoGeneration.setTypeImplementationMethods(building, property, typeData, annotation);
                break;
            }
            case VariableArray: {
                AutoGeneration.variableArrayImplementationMethods(building, property, typeData, annotation);
                break;
            }
            default: {
                AutoGeneration.defaultImplementationSetter(building, property, typeData, annotation);
            }
        }
    }

    static void defaultImplementationSetter(GenerationCore.StringIndenter building, GenerationCore.PropertyData property, GenerationCore.TypeData typeData, String annotation) {
        building.addImport("tv.amwa.maj.industry.MediaPropertySetter");
        building.append("@MediaPropertySetter(\"" + property.name + "\")");
        building.append("public void set" + property.name + "(");
        building.append("        " + annotation + typeData.getJavaSetName(property.isOptional) + " " + AutoGeneration.lowerFirstLetter(property.name) + ")");
        Vector<String> exceptional = new Vector<String>();
        if (!property.isOptional && AutoGeneration.isNullableType(typeData)) {
            exceptional.add("NullPointerException");
        }
        if (typeData.getThrowsIllegal()) {
            exceptional.add("IllegalArgumentException");
        }
        building.addThrowsClause(exceptional, false);
        if (property.isOptional) {
            building.append("if (" + AutoGeneration.lowerFirstLetter(property.name) + " == null) {");
            building.increment("this." + AutoGeneration.lowerFirstLetter(property.name) + " = null;");
            building.append("return;");
            building.decrementNL("}");
        } else if (AutoGeneration.isNullableType(typeData)) {
            building.append("if (" + AutoGeneration.lowerFirstLetter(property.name) + " == null)");
            building.appendNL("    throw new NullPointerException(\"Cannot set the required " + AutoGeneration.camelToWords(property.name) + " with a null value.\");");
        }
        if (typeData.getTypeCategory() == TypeCategory.StrongObjRef || typeData.getTypeCategory() == TypeCategory.Record) {
            building.append("this." + AutoGeneration.lowerFirstLetter(property.name) + " = " + AutoGeneration.lowerFirstLetter(property.name) + ";");
        } else if (typeData.getTypeCategory() == TypeCategory.WeakObjRef) {
            building.append("this." + AutoGeneration.lowerFirstLetter(property.name) + " = new WeakReference<" + typeData.getJavaGetName() + ">(" + AutoGeneration.lowerFirstLetter(property.name) + ");");
        } else {
            building.append("this." + AutoGeneration.lowerFirstLetter(property.name) + " = " + AutoGeneration.lowerFirstLetter(property.name) + ";");
        }
        building.decrementNL("}");
    }

    private static void setTypeImplementationMethods(GenerationCore.StringIndenter building, GenerationCore.PropertyData property, GenerationCore.TypeData typeData, String annotation) {
        Vector<String> exceptional = new Vector<String>();
        building.addImport("tv.amwa.maj.industry.MediaSetAdd");
        building.append("@MediaSetAdd(\"" + property.name + "\")");
        building.append("public void add" + AutoGeneration.makeSingular(property.name) + "(");
        building.append("         " + annotation + typeData.getJavaSetName(property.isOptional) + " " + AutoGeneration.lowerFirstLetter(AutoGeneration.makeSingular(property.name)) + ")");
        exceptional.clear();
        exceptional.add("NullPointerException");
        if (typeData.getThrowsIllegal()) {
            exceptional.add("IllegalArgumentException");
        }
        building.addThrowsClause(exceptional, false);
        building.append("if (" + AutoGeneration.lowerFirstLetter(AutoGeneration.makeSingular(property.name)) + " == null)");
        building.appendNL("    throw new NullPointerException(\"Cannot add a null value to the set of " + AutoGeneration.camelToWords(property.name) + ".\");");
        if (AutoGeneration.typeByName(((GenerationCore.TypeDataSet)typeData).elementType).getTypeCategory() == TypeCategory.WeakObjRef) {
            building.append("this." + AutoGeneration.lowerFirstLetter(property.name) + ".add(" + AutoGeneration.lowerFirstLetter(AutoGeneration.makeSingular(property.name)) + ");");
        } else {
            building.append("StrongReferenceSet.add(this." + AutoGeneration.lowerFirstLetter(property.name) + ", " + AutoGeneration.lowerFirstLetter(AutoGeneration.makeSingular(property.name)) + ");");
        }
        building.decrementNL("}");
        building.addImport("tv.amwa.maj.industry.MediaPropertyContains");
        building.append("@MediaPropertyContains(\"" + property.name + "\")");
        building.append("public boolean contains" + AutoGeneration.makeSingular(property.name) + "(");
        building.append("         " + annotation + typeData.getJavaSetName(property.isOptional) + " " + AutoGeneration.lowerFirstLetter(AutoGeneration.makeSingular(property.name)) + ")");
        exceptional.clear();
        exceptional.add("NullPointerException");
        building.addThrowsClause(exceptional, false);
        building.append("if (" + AutoGeneration.lowerFirstLetter(AutoGeneration.makeSingular(property.name)) + " == null)");
        building.appendNL("    throw new NullPointerException(\"Cannot check for containment in the set of " + AutoGeneration.camelToWords(property.name) + " with a null value.\");");
        if (AutoGeneration.typeByName(((GenerationCore.TypeDataSet)typeData).elementType).getTypeCategory() == TypeCategory.WeakObjRef) {
            building.append("return this." + AutoGeneration.lowerFirstLetter(property.name) + ".contains(" + AutoGeneration.lowerFirstLetter(AutoGeneration.makeSingular(property.name)) + ");");
        } else {
            building.append("return StrongReferenceSet.contains(this." + AutoGeneration.lowerFirstLetter(property.name) + ", " + AutoGeneration.lowerFirstLetter(AutoGeneration.makeSingular(property.name)) + ");");
        }
        building.decrementNL("}");
        building.addImport("tv.amwa.maj.industry.MediaPropertyRemove");
        building.append("@MediaPropertyRemove(\"" + property.name + "\")");
        building.append("public boolean remove" + AutoGeneration.makeSingular(property.name) + "(");
        building.append("         " + annotation + typeData.getJavaSetName(property.isOptional) + " " + AutoGeneration.lowerFirstLetter(AutoGeneration.makeSingular(property.name)) + ")");
        exceptional.clear();
        exceptional.add("NullPointerException");
        building.addThrowsClause(exceptional, false);
        building.append("if (" + AutoGeneration.lowerFirstLetter(AutoGeneration.makeSingular(property.name)) + " == null)");
        building.appendNL("    throw new NullPointerException(\"Cannot remove from the set of " + AutoGeneration.camelToWords(property.name) + " using a null value.\");");
        if (AutoGeneration.typeByName(((GenerationCore.TypeDataSet)typeData).elementType).getTypeCategory() == TypeCategory.WeakObjRef) {
            building.append("return this." + AutoGeneration.lowerFirstLetter(property.name) + ".remove(" + AutoGeneration.lowerFirstLetter(AutoGeneration.makeSingular(property.name)) + ");");
        } else {
            building.append("return StrongReferenceSet.remove(this." + AutoGeneration.lowerFirstLetter(property.name) + ", " + AutoGeneration.lowerFirstLetter(AutoGeneration.makeSingular(property.name)) + ");");
        }
        building.decrementNL("}");
        AutoGeneration.sharedImplementationMethods(building, property, typeData, annotation);
    }

    private static void variableArrayImplementationMethods(GenerationCore.StringIndenter building, GenerationCore.PropertyData property, GenerationCore.TypeData typeData, String annotation) {
        Vector<String> exceptional = new Vector<String>();
        building.addImport("tv.amwa.maj.industry.MediaListAppend");
        building.append("@MediaListAppend(\"" + property.name + "\")");
        building.append("public void append" + AutoGeneration.makeSingular(property.name) + "(");
        building.append("         " + annotation + typeData.getJavaSetName(property.isOptional) + " " + AutoGeneration.lowerFirstLetter(AutoGeneration.makeSingular(property.name)) + ")");
        exceptional.clear();
        exceptional.add("NullPointerException");
        if (typeData.getThrowsIllegal()) {
            exceptional.add("IllegalArgumentException");
        }
        building.addThrowsClause(exceptional, false);
        building.append("if (" + AutoGeneration.lowerFirstLetter(AutoGeneration.makeSingular(property.name)) + " == null)");
        building.appendNL("    throw new NullPointerException(\"Cannot append a null value to the list of " + AutoGeneration.camelToWords(property.name) + ".\");");
        if (AutoGeneration.typeByName(((GenerationCore.TypeDataVariableArray)typeData).elementType).getTypeCategory() == TypeCategory.WeakObjRef) {
            building.append("this." + AutoGeneration.lowerFirstLetter(property.name) + ".append(" + AutoGeneration.lowerFirstLetter(AutoGeneration.makeSingular(property.name)) + ");");
        } else {
            building.append("StrongReferenceVector.append(this." + AutoGeneration.lowerFirstLetter(property.name) + ", " + AutoGeneration.lowerFirstLetter(AutoGeneration.makeSingular(property.name)) + ");");
        }
        building.decrementNL("}");
        building.addImport("tv.amwa.maj.industry.MediaListPrepend");
        building.append("@MediaListPrepend(\"" + property.name + "\")");
        building.append("public void prepend" + AutoGeneration.makeSingular(property.name) + "(");
        building.append("        " + annotation + typeData.getJavaSetName(property.isOptional) + " " + AutoGeneration.lowerFirstLetter(AutoGeneration.makeSingular(property.name)) + ")");
        exceptional.clear();
        exceptional.add("NullPointerException");
        if (typeData.getThrowsIllegal()) {
            exceptional.add("IllegalArgumentException");
        }
        building.addThrowsClause(exceptional, false);
        building.append("if (" + AutoGeneration.lowerFirstLetter(AutoGeneration.makeSingular(property.name)) + " == null)");
        building.appendNL("    throw new NullPointerException(\"Cannot prepend a null value to the list of " + AutoGeneration.camelToWords(property.name) + ".\");");
        if (AutoGeneration.typeByName(((GenerationCore.TypeDataVariableArray)typeData).elementType).getTypeCategory() == TypeCategory.WeakObjRef) {
            building.append("this." + AutoGeneration.lowerFirstLetter(property.name) + ".prepend(" + AutoGeneration.lowerFirstLetter(AutoGeneration.makeSingular(property.name)) + ");");
        } else {
            building.append("StrongReferenceVector.prepend(this." + AutoGeneration.lowerFirstLetter(property.name) + ", " + AutoGeneration.lowerFirstLetter(AutoGeneration.makeSingular(property.name)) + ");");
        }
        building.decrementNL("}");
        building.addImport("tv.amwa.maj.industry.MediaListInsertAt");
        building.append("@MediaListInsertAt(\"" + property.name + "\")");
        building.append("public void insert" + AutoGeneration.makeSingular(property.name) + "At(");
        building.append("        int index,");
        building.append("        " + annotation + typeData.getJavaSetName(property.isOptional) + " " + AutoGeneration.lowerFirstLetter(AutoGeneration.makeSingular(property.name)) + ")");
        exceptional.clear();
        exceptional.add("NullPointerException");
        exceptional.add("IndexOutOfBoundsException");
        if (typeData.getThrowsIllegal()) {
            exceptional.add("IllegalArgumentException");
        }
        building.addThrowsClause(exceptional, false);
        building.append("if (" + AutoGeneration.lowerFirstLetter(AutoGeneration.makeSingular(property.name)) + " == null)");
        building.appendNL("    throw new NullPointerException(\"Cannot insert a null value into the list of " + AutoGeneration.camelToWords(property.name) + ".\");");
        if (AutoGeneration.typeByName(((GenerationCore.TypeDataVariableArray)typeData).elementType).getTypeCategory() == TypeCategory.WeakObjRef) {
            building.append("this." + AutoGeneration.lowerFirstLetter(property.name) + ".insert(index, " + AutoGeneration.lowerFirstLetter(AutoGeneration.makeSingular(property.name)) + ");");
        } else {
            building.append("StrongReferenceVector.insert(this." + AutoGeneration.lowerFirstLetter(property.name) + ", index, " + AutoGeneration.lowerFirstLetter(AutoGeneration.makeSingular(property.name)) + ");");
        }
        building.decrementNL("}");
        building.addImport("tv.amwa.maj.industry.MediaListGetAt");
        building.append("@MediaListGetAt(\"" + property.name + "\")");
        building.append("public " + annotation + typeData.getJavaSetName(property.isOptional) + " get" + AutoGeneration.makeSingular(property.name) + "At(");
        building.append("        int index)");
        exceptional.clear();
        exceptional.add("IndexOutOfBoundsException");
        building.addThrowsClause(exceptional, false);
        if (AutoGeneration.typeByName(((GenerationCore.TypeDataVariableArray)typeData).elementType).getTypeCategory() == TypeCategory.WeakObjRef) {
            building.append("return this." + AutoGeneration.lowerFirstLetter(property.name) + ".getAt(index)");
        } else {
            building.append("return StrongReferenceVector.getAt(this." + AutoGeneration.lowerFirstLetter(property.name) + ", index);");
        }
        building.decrementNL("}");
        building.addImport("tv.amwa.maj.industry.MediaListRemoveAt");
        building.append("@MediaListRemoveAt(\"" + property.name + "\")");
        building.append("public void remove" + AutoGeneration.makeSingular(property.name) + "At(");
        building.append("        int index)");
        exceptional.clear();
        exceptional.add("IndexOutOfBoundsException");
        building.addThrowsClause(exceptional, false);
        if (AutoGeneration.typeByName(((GenerationCore.TypeDataVariableArray)typeData).elementType).getTypeCategory() == TypeCategory.WeakObjRef) {
            building.append("this." + AutoGeneration.lowerFirstLetter(property.name) + ".removeAt(index)");
        } else {
            building.append("StrongReferenceVector.remove(this." + AutoGeneration.lowerFirstLetter(property.name) + ", index);");
        }
        building.decrementNL("}");
        building.addImport("tv.amwa.maj.industry.MediaPropertyRemove");
        building.append("@MediaPropertyRemove(\"" + property.name + "\")");
        building.append("public boolean remove" + AutoGeneration.makeSingular(property.name) + "(");
        building.append("        " + annotation + typeData.getJavaSetName(property.isOptional) + " " + AutoGeneration.lowerFirstLetter(AutoGeneration.makeSingular(property.name)) + ")");
        exceptional.clear();
        exceptional.add("NullPointerException");
        building.addThrowsClause(exceptional, false);
        building.append("if (" + AutoGeneration.lowerFirstLetter(AutoGeneration.makeSingular(property.name)) + " == null)");
        building.appendNL("    throw new NullPointerException(\"Cannot remove a null value from the list of " + AutoGeneration.camelToWords(property.name) + ".\");");
        if (AutoGeneration.typeByName(((GenerationCore.TypeDataVariableArray)typeData).elementType).getTypeCategory() == TypeCategory.WeakObjRef) {
            building.append("return this." + AutoGeneration.lowerFirstLetter(property.name) + ".remove(" + AutoGeneration.lowerFirstLetter(AutoGeneration.makeSingular(property.name)) + ");");
        } else {
            building.append("return StrongReferenceVector.remove(this." + AutoGeneration.lowerFirstLetter(property.name) + ", " + AutoGeneration.lowerFirstLetter(AutoGeneration.makeSingular(property.name)) + ");");
        }
        building.decrementNL("}");
        building.addImport("tv.amwa.maj.industry.MediaPropertyContains");
        building.append("@MediaPropertyContains(\"" + property.name + "\")");
        building.append("public boolean contains" + AutoGeneration.makeSingular(property.name) + "(");
        building.append("        " + annotation + typeData.getJavaSetName(property.isOptional) + " " + AutoGeneration.lowerFirstLetter(AutoGeneration.makeSingular(property.name)) + ")");
        exceptional.clear();
        exceptional.add("NullPointerException");
        building.addThrowsClause(exceptional, false);
        building.append("if (" + AutoGeneration.lowerFirstLetter(AutoGeneration.makeSingular(property.name)) + " == null)");
        building.appendNL("    throw new NullPointerException(\"Cannot test for containment in the list of " + AutoGeneration.camelToWords(property.name) + " using a null value.\");");
        if (AutoGeneration.typeByName(((GenerationCore.TypeDataVariableArray)typeData).elementType).getTypeCategory() == TypeCategory.WeakObjRef) {
            building.append("return this." + AutoGeneration.lowerFirstLetter(property.name) + ".contains(" + AutoGeneration.lowerFirstLetter(AutoGeneration.makeSingular(property.name)) + ");");
        } else {
            building.append("return StrongReferenceVector.contains(this." + AutoGeneration.lowerFirstLetter(property.name) + ", " + AutoGeneration.lowerFirstLetter(AutoGeneration.makeSingular(property.name)) + ");");
        }
        building.decrementNL("}");
        AutoGeneration.sharedImplementationMethods(building, property, typeData, annotation);
    }

    private static void sharedImplementationMethods(GenerationCore.StringIndenter building, GenerationCore.PropertyData property, GenerationCore.TypeData typeData, String annotation) {
        building.addImport("tv.amwa.maj.industry.MediaPropertyClear");
        building.append("@MediaPropertyClear(\"" + property.name + "\")");
        building.appendNL("public void clear" + property.name + "() {");
        building.increment(AutoGeneration.lowerFirstLetter(property.name) + ".clear();");
        building.decrementNL("}");
        building.addImport("tv.amwa.maj.industry.MediaPropertyCount");
        building.append("@MediaPropertyCount(\"" + property.name + "\")");
        building.appendNL("public int count" + property.name + "() {");
        TypeCategory targetCategory = null;
        targetCategory = typeData instanceof GenerationCore.TypeDataSet ? AutoGeneration.typeByName(((GenerationCore.TypeDataSet)typeData).elementType).getTypeCategory() : AutoGeneration.typeByName(((GenerationCore.TypeDataVariableArray)typeData).elementType).getTypeCategory();
        if (targetCategory == TypeCategory.WeakObjRef) {
            building.increment("return " + AutoGeneration.lowerFirstLetter(property.name) + ".count();");
        } else {
            building.increment("return " + AutoGeneration.lowerFirstLetter(property.name) + ".size();");
        }
        building.decrementNL("}");
    }

    private static void addRootClassMethods(GenerationCore.StringIndenter building, GenerationCore.ClassData classData) {
        building.addImport("tv.amwa.maj.industry.MediaEngine");
        building.append("@Override");
        building.append("public boolean equals(");
        building.incrementNL("    Object o) {");
        building.append("return MediaEngine.equals(this, o);");
        building.decrementNL("}");
        building.append("@Override");
        building.appendNL("public int hashCode() {");
        building.increment("return MediaEngine.hashCode(this);");
        building.decrementNL("}");
        building.append("@Override");
        building.appendNL("public String toString() {");
        building.increment("return MediaEngine.toString(this);");
        building.decrementNL("}");
        building.appendNL("public " + classData.name + " clone() {");
        building.increment("try {");
        building.increment("return (" + classData.name + ") super.clone();");
        building.decrement("}");
        building.append("catch (CloneNotSupportedException cnse) {");
        building.increment("// Should never happen as all classes implement Cloneable");
        building.append("throw new InternalError(cnse.getMessage());");
        building.decrement("}");
        building.decrementNL("}");
        building.append("public void appendXMLChildren(");
        building.appendNL("        org.w3c.dom.Node node) { }");
        building.appendNL("public String getComment() {");
        building.increment("return null;");
        building.decrementNL("}");
        building.append("private long persistentID = 0l;");
        building.append("@SuppressWarnings(\"unused\")");
        building.appendNL("private int persistentIndex = 0;");
        building.appendNL("public long getPersistentID() {");
        building.increment("return persistentID;");
        building.decrementNL("}");
        building.append("public void setPersistentIndex(");
        building.incrementNL("    int index) {");
        building.append("this.persistentIndex = index;");
        building.decrementNL("}");
    }

    static final String generateTypeDefinitions(String basePackageName) {
        GenerationCore.StringIndenter building = new GenerationCore.StringIndenter();
        building.setPackageName(basePackageName);
        building.addImport("tv.amwa.maj.industry.Forge");
        building.startJavadoc();
        building.wrapComment("<p>Extension type definitions defined for this package.</p>", 80);
        building.blankComment();
        building.wrapComment("@see tv.amwa.maj.meta.TypeDefinition", 80);
        building.wrapComment("@see tv.amwa.maj.industry.Warehouse", 80);
        building.wrapComment("@see tv.amwa.maj.industry.TypeDefinitions", 80);
        building.endComment();
        building.append("public interface TypeDefinitions {");
        building.increment("");
        HashSet<AUID> alreadyDone = new HashSet<AUID>();
        for (GenerationCore.TypeData typeData : typeList.values()) {
            if (!(typeData instanceof GenerationCore.TypeDataCharacter)) continue;
            AutoGeneration.appendAndCheck(typeData, building, alreadyDone);
        }
        for (GenerationCore.TypeData typeData : typeList.values()) {
            if (!(typeData instanceof GenerationCore.TypeDataInteger)) continue;
            AutoGeneration.appendAndCheck(typeData, building, alreadyDone);
        }
        for (GenerationCore.TypeData typeData : typeList.values()) {
            if (!(typeData instanceof GenerationCore.TypeDataEnumeration)) continue;
            AutoGeneration.appendAndCheck(typeData, building, alreadyDone);
        }
        for (GenerationCore.TypeData typeData : typeList.values()) {
            if (!(typeData instanceof GenerationCore.TypeDataExtendibleEnumeration)) continue;
            AutoGeneration.appendAndCheck(typeData, building, alreadyDone);
        }
        for (GenerationCore.TypeData typeData : typeList.values()) {
            if (!(typeData instanceof GenerationCore.TypeDataIndirect)) continue;
            AutoGeneration.appendAndCheck(typeData, building, alreadyDone);
        }
        for (GenerationCore.TypeData typeData : typeList.values()) {
            if (!(typeData instanceof GenerationCore.TypeDataOpaque)) continue;
            AutoGeneration.appendAndCheck(typeData, building, alreadyDone);
        }
        for (GenerationCore.TypeData typeData : typeList.values()) {
            if (!(typeData instanceof GenerationCore.TypeDataStream)) continue;
            AutoGeneration.appendAndCheck(typeData, building, alreadyDone);
        }
        for (GenerationCore.TypeData typeData : typeList.values()) {
            if (!(typeData instanceof GenerationCore.TypeDataString)) continue;
            AutoGeneration.appendAndCheck(typeData, building, alreadyDone);
        }
        for (GenerationCore.TypeData typeData : typeList.values()) {
            if (!(typeData instanceof GenerationCore.TypeDataRename)) continue;
            AutoGeneration.appendAndCheck(typeData, building, alreadyDone);
        }
        for (GenerationCore.TypeData typeData : typeList.values()) {
            if (!(typeData instanceof GenerationCore.TypeDataWeakObjectReference)) continue;
            AutoGeneration.appendAndCheck(typeData, building, alreadyDone);
        }
        for (GenerationCore.TypeData typeData : typeList.values()) {
            if (!(typeData instanceof GenerationCore.TypeDataStrongObjectReference)) continue;
            AutoGeneration.appendAndCheck(typeData, building, alreadyDone);
        }
        for (GenerationCore.TypeData typeData : typeList.values()) {
            if (!(typeData instanceof GenerationCore.TypeDataFixedArray)) continue;
            AutoGeneration.appendAndCheck(typeData, building, alreadyDone);
        }
        for (GenerationCore.TypeData typeData : typeList.values()) {
            if (!(typeData instanceof GenerationCore.TypeDataRecord)) continue;
            AutoGeneration.appendAndCheck(typeData, building, alreadyDone);
        }
        for (GenerationCore.TypeData typeData : typeList.values()) {
            if (!(typeData instanceof GenerationCore.TypeDataSet)) continue;
            AutoGeneration.appendAndCheck(typeData, building, alreadyDone);
        }
        for (GenerationCore.TypeData typeData : typeList.values()) {
            if (!(typeData instanceof GenerationCore.TypeDataVariableArray)) continue;
            AutoGeneration.appendAndCheck(typeData, building, alreadyDone);
        }
        building.reset("}");
        return building.toString();
    }

    static final void appendAndCheck(GenerationCore.TypeData typeData, GenerationCore.StringIndenter building, Set<AUID> alreadyWritten) {
        if (alreadyWritten.contains(typeData.identification)) {
            return;
        }
        typeData.appendTypeDescription(building);
        alreadyWritten.add(typeData.identification);
    }

    static final String generateEnumeration(String basePackageName, GenerationCore.TypeDataEnumeration enumeration) {
        GenerationCore.StringIndenter building = new GenerationCore.StringIndenter();
        building.setPackageName(basePackageName);
        building.addImport("tv.amwa.maj.industry.MediaEnumerationValue");
        building.addImport("tv.amwa.maj.integer.Int64");
        building.startJavadoc();
        if (enumeration.description != null && enumeration.description.length() > 0) {
            building.wrapComment("<p>" + enumeration.description + "</p>", 80);
        } else {
            building.wrapComment("<p>" + AutoGeneration.upperFirstLetter(AutoGeneration.camelToWords(enumeration.name)) + " enumeration.</p>", 80);
        }
        building.blankComment();
        building.wrapComment("@see TypeDefinitions#" + enumeration.name, 80);
        building.blankComment();
        building.wrapComment("@author Auto generation", 80);
        building.endComment();
        building.append("public enum " + enumeration.name);
        building.incrementNL("implements MediaEnumerationValue {");
        for (int x = 0; x < enumeration.names.size(); ++x) {
            building.append("/** <p>" + AutoGeneration.upperFirstLetter(AutoGeneration.camelToWords(enumeration.names.get(x))) + " element.</p> */");
            building.append(enumeration.names.get(x) + " (" + enumeration.values.get(x) + "l),");
        }
        building.appendNL(";");
        building.appendNL("private final long value;");
        building.appendNL(enumeration.name + "(long value) { this.value = value; }");
        building.appendNL("@Int64 public long value() { return value; }");
        building.appendNL("public String symbol() {");
        building.increment("return \"" + enumeration.name + "_\" + name();");
        building.decrementNL("}");
        building.reset("}");
        return building.toString();
    }

    static final String generateExtendibleEnumeration(String basePackageName, String extendibleEnumerationName, String extendibleEnumerationSymbol) {
        GenerationCore.StringIndenter building = new GenerationCore.StringIndenter();
        building.setPackageName(basePackageName);
        building.addImport("tv.amwa.maj.industry.ExtendibleEnumerationItem");
        building.addImport("tv.amwa.maj.record.AUID");
        building.addImport("tv.amwa.maj.industry.Forge");
        building.startJavadoc();
        building.wrapComment("<p>Constants for extendible enumeration " + AutoGeneration.camelToWords(extendibleEnumerationName) + ".</p>", 80);
        building.blankComment();
        building.wrapComment("@see TypeDefinitions#" + extendibleEnumerationName, 80);
        building.blankComment();
        building.wrapComment("@author Auto generation", 80);
        building.endComment();
        building.append("public interface " + extendibleEnumerationName + " {");
        building.increment("");
        SortedMap<String, AUID> enumeration = Warehouse.lookupExtendibleEnumeration(extendibleEnumerationSymbol);
        if (enumeration != null) {
            for (String elementName : enumeration.keySet()) {
                building.startJavadoc();
                building.wrapComment("<p>Element " + AutoGeneration.camelToWords(elementName) + " of extendible enumeration " + AutoGeneration.camelToWords(extendibleEnumerationName) + ".</p>", 80);
                building.endComment();
                AUID elementValue = (AUID)enumeration.get(elementName);
                building.append("@ExtendibleEnumerationItem(target = \"" + extendibleEnumerationSymbol + "\")");
                building.append("public final static AUID " + elementName + " = ");
                building.append("        Forge.makeAUID(0x" + AutoGeneration.padHexTo8(elementValue.getData1()) + ", (short) 0x" + AutoGeneration.padHexTo4(elementValue.getData2()) + ", (short) 0x" + AutoGeneration.padHexTo4(elementValue.getData3()) + ",");
                building.appendNL("                new byte[] { " + AutoGeneration.bytesToText(elementValue.getData4()) + " } );");
            }
        }
        building.reset("}");
        return building.toString();
    }

    static final String generateRecordInterface(String basePackageName, GenerationCore.TypeDataRecord recordType) {
        int x;
        GenerationCore.StringIndenter building = new GenerationCore.StringIndenter();
        building.setPackageName(basePackageName);
        building.startJavadoc();
        if (recordType.description != null && recordType.description.length() > 0) {
            building.wrapComment("<p>" + recordType.description + " Interface.</p>", 80);
        } else {
            building.wrapComment("<p>Interface to values of the " + AutoGeneration.camelToWords(recordType.name) + " record type.</p>", 80);
        }
        building.blankComment();
        building.wrapComment("@author Auto generation", 80);
        building.blankComment();
        building.wrapComment("@see TypeDefinitions#" + recordType.name, 80);
        building.endComment();
        building.append("public interface " + recordType.name);
        building.incrementNL("    extends Cloneable {");
        building.startJavadoc();
        building.wrapComment("<p>Names of the members of a " + AutoGeneration.camelToWords(recordType.name) + " value. The indexes of this array correspond with the indexes of the {@linkplain #MEMBER_TYPES member types array}.</p>", 80);
        building.blankComment();
        building.wrapComment("@see #MEMBER_TYPES", 80);
        building.endComment();
        building.append("public final static String[] MEMBER_NAMES = new String[] {");
        for (x = 0; x < recordType.memberNames.size(); ++x) {
            building.append("    \"" + recordType.memberNames.get(x) + "\",");
        }
        building.appendNL("};");
        building.startJavadoc();
        building.wrapComment("<p>Types of the members of a " + AutoGeneration.camelToWords(recordType.name) + " value. The indexes of this array correspond with the indexes of the {@linkplain #MEMBER_NAMES member names array}.</p>", 80);
        building.blankComment();
        building.wrapComment("@see #MEMBER_NAMES", 80);
        building.endComment();
        building.addImport("tv.amwa.maj.meta.TypeDefinition");
        building.append("public final static TypeDefinition[] MEMBER_TYPES = new TypeDefinition[] {");
        for (x = 0; x < recordType.memberTypes.size(); ++x) {
            String memberTypeName = recordType.memberTypes.get(x);
            if (typeList.containsKey(memberTypeName)) {
                building.append("    TypeDefinitions." + recordType.memberTypes.get(x) + ",");
                continue;
            }
            building.append("    tv.amwa.maj.industry.TypeDefinitions." + recordType.memberTypes.get(x) + ",");
        }
        building.appendNL("};");
        Vector<String> exceptional = new Vector<String>();
        for (int x2 = 0; x2 < recordType.memberNames.size(); ++x2) {
            GenerationCore.TypeData elementType = AutoGeneration.typeByName(recordType.memberTypes.get(x2));
            String annotation = elementType.getAnnotation();
            annotation = annotation == null ? "" : "@" + annotation + " ";
            building.addImport(elementType.getImports());
            building.startJavadoc();
            building.wrapComment("<p>Returns the " + AutoGeneration.lowerFirstLetter(AutoGeneration.camelToWords(recordType.memberNames.get(x2))) + " member of record type " + AutoGeneration.camelToWords(recordType.name) + ".</p>", 80);
            building.blankComment();
            building.wrapComment("@return " + AutoGeneration.upperFirstLetter(AutoGeneration.camelToWords(recordType.memberNames.get(x2))) + ".", 80);
            if (elementType instanceof GenerationCore.TypeDataExtendibleEnumeration) {
                building.blankComment();
                building.wrapComment("@see #get" + AutoGeneration.upperFirstLetter(recordType.memberNames.get(x2)) + "Name()", 80);
            }
            building.endComment();
            building.appendNL("public " + annotation + elementType.getJavaGetName() + (elementType instanceof GenerationCore.TypeDataFixedArray ? "[]" : "") + " get" + AutoGeneration.upperFirstLetter(recordType.memberNames.get(x2)) + "();");
            building.startJavadoc();
            building.wrapComment("<p>Sets the " + AutoGeneration.lowerFirstLetter(AutoGeneration.camelToWords(recordType.memberNames.get(x2))) + " member of record type " + AutoGeneration.camelToWords(recordType.name) + ".</p>", 80);
            building.blankComment();
            building.wrapComment("@param " + AutoGeneration.lowerFirstLetter(recordType.memberNames.get(x2)) + " " + AutoGeneration.upperFirstLetter(AutoGeneration.camelToWords(recordType.memberNames.get(x2))) + ".", 80);
            if (!(elementType instanceof GenerationCore.TypeDataInteger) || elementType.getThrowsIllegal()) {
                building.blankComment();
            }
            if (!(elementType instanceof GenerationCore.TypeDataInteger)) {
                building.wrapComment("@throws NullPointerException Cannot set the member value with a <code>null</code>.", 80);
            }
            if (elementType.getThrowsIllegal()) {
                building.wrapComment("@throws IllegalArgumentException The given value is illegal for the required type.", 80);
            }
            if (elementType instanceof GenerationCore.TypeDataExtendibleEnumeration) {
                building.blankComment();
                building.wrapComment("@see #set" + AutoGeneration.upperFirstLetter(recordType.memberNames.get(x2)) + "(String)", 80);
            }
            building.endComment();
            building.append("public void set" + AutoGeneration.upperFirstLetter(recordType.memberNames.get(x2)) + "(");
            building.append("        " + annotation + elementType.getJavaSetName(false) + (elementType instanceof GenerationCore.TypeDataFixedArray ? "[]" : "") + " " + AutoGeneration.lowerFirstLetter(recordType.memberNames.get(x2)) + ")");
            exceptional.clear();
            if (!(elementType instanceof GenerationCore.TypeDataInteger)) {
                exceptional.add("NullPointerException");
            }
            if (elementType.getThrowsIllegal()) {
                exceptional.add("IllegalArgumentException");
            }
            building.addThrowsClause(exceptional, true);
            if (!(elementType instanceof GenerationCore.TypeDataExtendibleEnumeration)) continue;
            building.startJavadoc();
            building.wrapComment("<p>Returns the " + AutoGeneration.lowerFirstLetter(AutoGeneration.camelToWords(recordType.memberNames.get(x2))) + " member of record type " + AutoGeneration.camelToWords(recordType.name) + " by its name.</p>", 80);
            building.blankComment();
            building.wrapComment("@return " + AutoGeneration.upperFirstLetter(AutoGeneration.camelToWords(recordType.memberNames.get(x2))) + ".", 80);
            building.blankComment();
            building.wrapComment("@see #get" + AutoGeneration.upperFirstLetter(recordType.memberNames.get(x2)) + "()", 80);
            building.endComment();
            building.appendNL("public String get" + AutoGeneration.upperFirstLetter(recordType.memberNames.get(x2)) + "Name();");
            building.startJavadoc();
            building.wrapComment("<p>Sets the " + AutoGeneration.lowerFirstLetter(AutoGeneration.camelToWords(recordType.memberNames.get(x2))) + " member of record type " + AutoGeneration.camelToWords(recordType.name) + " by its name.</p>", 80);
            building.blankComment();
            building.wrapComment("@param " + AutoGeneration.lowerFirstLetter(recordType.memberNames.get(x2)) + " " + AutoGeneration.upperFirstLetter(AutoGeneration.camelToWords(recordType.memberNames.get(x2))) + ".", 80);
            building.blankComment();
            building.wrapComment("@throws NullPointerException Cannot set the value with a <code>null</code>.", 80);
            building.wrapComment("@throws IlleggalArgumentException The given name is not known for this extendible enumeration type.", 80);
            building.blankComment();
            building.wrapComment("@see #set" + AutoGeneration.upperFirstLetter(recordType.memberNames.get(x2)) + "(tv.amwa.maj.record.AUID)", 80);
            building.endComment();
            building.append("public void set" + AutoGeneration.upperFirstLetter(recordType.memberNames.get(x2)) + "(");
            building.append("        String " + AutoGeneration.lowerFirstLetter(recordType.memberNames.get(x2)) + ")");
            exceptional.clear();
            exceptional.add("NullPointerException");
            exceptional.add("IllegalArgumentException");
            building.addThrowsClause(exceptional, true);
        }
        building.startJavadoc();
        building.wrapComment("<p>Create a cloned copy of this " + AutoGeneration.camelToWords(recordType.name) + " value.</p>", 80);
        building.blankComment();
        building.wrapComment("@return Cloned copy of this " + AutoGeneration.camelToWords(recordType.name) + " value.", 80);
        building.endComment();
        building.appendNL("public " + recordType.name + " clone();");
        building.reset("}");
        return building.toString();
    }

    static final String generateRecordImplementation(String basePackageName, GenerationCore.TypeDataRecord recordType) {
        String memberName;
        GenerationCore.TypeData elementType;
        int x;
        String memberName2;
        GenerationCore.TypeData elementType2;
        int x2;
        GenerationCore.StringIndenter building = new GenerationCore.StringIndenter();
        building.setPackageName(basePackageName + ".impl");
        building.startJavadoc();
        if (recordType.description != null && recordType.description.length() > 0) {
            building.wrapComment("<p>" + recordType.description + " Implmentation.</p>", 80);
        } else {
            building.wrapComment("<p>Implementation for values of the " + AutoGeneration.camelToWords(recordType.name) + " record type.</p>", 80);
        }
        building.blankComment();
        building.wrapComment("@author Auto generation", 80);
        building.blankComment();
        building.wrapComment("@see TypeDefinitions#" + recordType.name, 80);
        building.endComment();
        building.addImport(basePackageName + "." + recordType.name);
        building.addImport(basePackageName + ".Constants");
        building.addImport("java.io.Serializable");
        building.addImport("tv.amwa.maj.io.xml.XMLSerializable;");
        building.append("public class " + recordType.name + "Impl");
        building.increment("implements");
        building.increment(recordType.name + ",");
        building.append("Serializable,");
        building.append("XMLSerializable,");
        building.append("Constants,");
        building.append("Cloneable {");
        building.decrement("");
        for (int x3 = 0; x3 < recordType.memberNames.size(); ++x3) {
            GenerationCore.TypeData elementType3 = AutoGeneration.typeByName(recordType.memberTypes.get(x3));
            String annotation = elementType3.getAnnotation();
            annotation = annotation == null ? "" : "@" + annotation + " ";
            building.addImport(elementType3.getImports());
            if (typeList.containsKey(elementType3.name) && (elementType3.getTypeCategory() == TypeCategory.Enum || elementType3.getTypeCategory() == TypeCategory.Record)) {
                building.addImport(basePackageName + "." + elementType3.name);
            }
            building.append("private " + annotation + elementType3.getJavaSetName(false) + (elementType3 instanceof GenerationCore.TypeDataFixedArray ? "[]" : "") + " " + AutoGeneration.lowerFirstLetter(recordType.memberNames.get(x3)) + ";");
        }
        building.append("");
        building.appendNL("public " + recordType.name + "Impl() { }");
        Vector<String> exceptional = new Vector<String>();
        for (x2 = 0; x2 < recordType.memberNames.size(); ++x2) {
            elementType2 = AutoGeneration.typeByName(recordType.memberTypes.get(x2));
            String annotation = elementType2.getAnnotation();
            annotation = annotation == null ? "" : "@" + annotation + " ";
            building.addImport(elementType2.getImports());
            building.appendNL("public " + annotation + elementType2.getJavaGetName() + (elementType2 instanceof GenerationCore.TypeDataFixedArray ? "[]" : "") + " get" + AutoGeneration.upperFirstLetter(recordType.memberNames.get(x2)) + "() {");
            building.increment("return this." + AutoGeneration.lowerFirstLetter(recordType.memberNames.get(x2)) + ";");
            building.decrementNL("}");
            building.append("public void set" + AutoGeneration.upperFirstLetter(recordType.memberNames.get(x2)) + "(");
            building.append("        " + annotation + elementType2.getJavaSetName(false) + (elementType2 instanceof GenerationCore.TypeDataFixedArray ? "[]" : "") + " " + AutoGeneration.lowerFirstLetter(recordType.memberNames.get(x2)) + ")");
            exceptional.clear();
            if (!(elementType2 instanceof GenerationCore.TypeDataInteger)) {
                exceptional.add("NullPointerException");
            }
            if (elementType2.getThrowsIllegal()) {
                exceptional.add("IllegalArgumentException");
            }
            building.addThrowsClause(exceptional, false);
            if (!(elementType2 instanceof GenerationCore.TypeDataInteger)) {
                building.append("if (" + AutoGeneration.lowerFirstLetter(recordType.memberNames.get(x2)) + " == null)");
                building.appendNL("    throw new NullPointerException(\"Cannot set the " + AutoGeneration.camelToWords(recordType.memberNames.get(x2)) + " member of a " + AutoGeneration.camelToWords(recordType.name) + " value with a null value.\");");
            }
            building.append("this." + AutoGeneration.lowerFirstLetter(recordType.memberNames.get(x2)) + " = " + AutoGeneration.lowerFirstLetter(recordType.memberNames.get(x2)) + ";");
            building.decrementNL("}");
            if (!(elementType2 instanceof GenerationCore.TypeDataExtendibleEnumeration)) continue;
            building.appendNL("public String get" + AutoGeneration.upperFirstLetter(recordType.memberNames.get(x2)) + "Name() {");
            building.increment("try {");
            if (typeList.containsKey(elementType2.name)) {
                building.increment("return " + basePackageName + ".TypeDefinitions." + elementType2.name + ".getNameFromAUID(" + AutoGeneration.lowerFirstLetter(recordType.memberNames.get(x2)) + ");");
            } else {
                building.increment("return tv.amwa.maj.industry.TypeDefinitions." + elementType2.name + ".getNameFromAUID(" + AutoGeneration.lowerFirstLetter(recordType.memberNames.get(x2)) + ");");
            }
            building.decrement("}");
            building.addImport("tv.amwa.maj.exception.BadParameterException");
            building.append("catch (BadParameterException bpe) {");
            building.increment("System.err.println(\"A stored identifier is not registered for extendible enumeration " + AutoGeneration.camelToWords(elementType2.name) + ".\");");
            building.append("return null;");
            building.decrement("}");
            building.decrementNL("}");
            building.append("public void set" + AutoGeneration.upperFirstLetter(recordType.memberNames.get(x2)) + "(");
            building.append("        String " + AutoGeneration.lowerFirstLetter(recordType.memberNames.get(x2)) + ")");
            exceptional.clear();
            exceptional.add("NullPointerException");
            exceptional.add("IllegalArgumentException");
            building.addThrowsClause(exceptional, false);
            building.append("if (" + AutoGeneration.lowerFirstLetter(recordType.memberNames.get(x2)) + " == null)");
            building.appendNL("    throw new NullPointerException(\"Cannot set the " + AutoGeneration.camelToWords(recordType.memberNames.get(x2)) + " member of a " + AutoGeneration.camelToWords(recordType.name) + " value with a null value.\");");
            building.append("try {");
            if (typeList.containsKey(elementType2.name)) {
                building.increment("set" + AutoGeneration.upperFirstLetter(recordType.memberNames.get(x2)) + "(" + basePackageName + ".TypeDefinitions." + elementType2.name + ".getAUIDFromName(" + AutoGeneration.lowerFirstLetter(recordType.memberNames.get(x2)) + "));");
            } else {
                building.increment("set" + AutoGeneration.upperFirstLetter(recordType.memberNames.get(x2)) + "(tv.amwa.maj.industry.TypeDefinitions." + elementType2.name + ".getAUIDFromName(" + AutoGeneration.lowerFirstLetter(recordType.memberNames.get(x2)) + "));");
            }
            building.decrement("}");
            building.addImport("tv.amwa.maj.exception.BadParameterException");
            building.append("catch (BadParameterException bpe) {");
            building.increment("throw new IllegalArgumentException(\"The given element name is not recognised for extendible enumeration " + AutoGeneration.camelToWords(elementType2.name) + ".\");");
            building.decrement("}");
            building.decrementNL("}");
        }
        building.appendNL("public " + recordType.name + " clone() {");
        building.increment("try {");
        building.increment("return (" + recordType.name + ") super.clone();");
        building.decrement("}");
        building.append("catch (CloneNotSupportedException cnse) {");
        building.increment("// Implements Cloneable so should never happen");
        building.append("throw new InternalError(cnse.getMessage());");
        building.decrement("}");
        building.decrementNL("}");
        building.appendNL("public int hashCode() {");
        building.incrementNL("int hashcode = 0;");
        block18: for (x2 = 0; x2 < recordType.memberNames.size(); ++x2) {
            elementType2 = AutoGeneration.typeByName(recordType.memberTypes.get(x2));
            memberName2 = AutoGeneration.lowerFirstLetter(recordType.memberNames.get(x2));
            switch (elementType2.getTypeCategory()) {
                case Int: {
                    building.append("hashcode ^= (int) " + memberName2 + ";");
                    continue block18;
                }
                case Record: 
                case Enum: 
                case ExtEnum: {
                    building.append("hashcode ^= " + memberName2 + ".hashCode();");
                    continue block18;
                }
                case FixedArray: {
                    building.addImport("java.util.Arrays");
                    building.append("hashcode ^= Arrays.hashCode(" + memberName2 + ");");
                }
            }
        }
        building.append("");
        building.append("return hashcode;");
        building.decrementNL("}");
        building.append("public boolean equals(");
        building.appendNL("        Object o) {");
        building.increment("if (o == null) return false;");
        building.append("if (this == o) return true;");
        building.appendNL("if (!(o instanceof " + recordType.name + ")) return false;");
        building.appendNL(recordType.name + " testValue = (" + recordType.name + ") o;");
        block19: for (x2 = 0; x2 < recordType.memberNames.size(); ++x2) {
            elementType2 = AutoGeneration.typeByName(recordType.memberTypes.get(x2));
            memberName2 = AutoGeneration.lowerFirstLetter(recordType.memberNames.get(x2));
            switch (elementType2.getTypeCategory()) {
                case Enum: 
                case Int: {
                    building.append("if (" + memberName2 + " != testValue.get" + AutoGeneration.upperFirstLetter(memberName2) + "())");
                    building.append("    return false;");
                    continue block19;
                }
                case Record: 
                case ExtEnum: {
                    building.append("if (!(" + memberName2 + ".equals(testValue.get" + AutoGeneration.upperFirstLetter(memberName2) + "())))");
                    building.append("    return false;");
                    continue block19;
                }
                case FixedArray: {
                    building.addImport("java.util.Arrays");
                    building.append("if (!(Arrays.equals(" + memberName2 + ", testValue.get" + AutoGeneration.upperFirstLetter(memberName2) + "())))");
                    building.append("    return false;");
                }
            }
        }
        building.append("");
        building.append("return true;");
        building.decrementNL("}");
        building.addImport("org.w3c.dom.Node");
        building.addImport("org.w3c.dom.DocumentFragment");
        building.addImport("tv.amwa.maj.io.xml.XMLBuilder");
        building.append("public void appendXMLChildren(");
        building.appendNL("        Node parent) {");
        String elementName = AutoGeneration.lowerFirstLetter(recordType.name) + "Value";
        building.incrementNL("Node " + elementName + ";");
        building.append("if (parent instanceof DocumentFragment)");
        building.append("    " + elementName + " = XMLBuilder.createChild(parent, XML_NAMESPACE, XML_PREFIX, \"" + recordType.name + "\");");
        building.append("else");
        building.appendNL("    " + elementName + " = parent;");
        block20: for (x = 0; x < recordType.memberNames.size(); ++x) {
            elementType = AutoGeneration.typeByName(recordType.memberTypes.get(x));
            memberName = AutoGeneration.lowerFirstLetter(recordType.memberNames.get(x));
            switch (elementType.getTypeCategory()) {
                case Int: {
                    building.append("XMLBuilder.appendElement(" + elementName + ", XML_NAMESPACE, XML_PREFIX,");
                    building.appendNL("        \"" + AutoGeneration.upperFirstLetter(memberName) + "\", " + memberName + ");");
                    continue block20;
                }
                case Enum: {
                    building.append("XMLBuilder.appendElement(" + elementName + ", XML_NAMESPACE, XML_PREFIX,");
                    building.appendNL("        \"" + AutoGeneration.upperFirstLetter(memberName) + "\", " + memberName + ".symbol());");
                    continue block20;
                }
                case Record: 
                case ExtEnum: {
                    building.append("XMLBuilder.appendElement(" + elementName + ", XML_NAMESPACE, XML_PREFIX,");
                    building.appendNL("        \"" + AutoGeneration.upperFirstLetter(memberName) + "\", " + memberName + ".toString());");
                    continue block20;
                }
                case FixedArray: {
                    building.append("Node " + memberName + "Node = XMLBuilder.createChild(" + elementName + ", XML_NAMESPACE, XML_PREFIX, \"" + memberName + "\");");
                    building.append("for ( " + elementType.getJavaGetName() + " value : " + memberName + ")");
                    building.append("    XMLBuilder.appendElement(" + memberName + "Node, XML_NAMESPACE, XML_PREFIX,");
                    building.appendNL("            \"" + ((GenerationCore.TypeDataFixedArray)elementType).elementType + "\", value);");
                    continue block20;
                }
            }
        }
        building.decrementNL("}");
        building.appendNL("public String getComment() {");
        building.increment("return null;");
        building.decrementNL("}");
        building.appendNL("public String toString() {");
        building.increment("return XMLBuilder.toXMLNonMetadata(this);");
        building.decrementNL("}");
        building.addImport("java.util.regex.Pattern");
        building.addImport("java.util.regex.Matcher");
        for (x = 0; x < recordType.memberNames.size(); ++x) {
            elementType = AutoGeneration.typeByName(recordType.memberTypes.get(x));
            memberName = AutoGeneration.lowerFirstLetter(recordType.memberNames.get(x));
            building.append("private final static Pattern " + memberName + "Pattern = ");
            if (elementType instanceof GenerationCore.TypeDataFixedArray) {
                building.append("    Pattern.compile(\"<\\\\w*\\\\:?" + AutoGeneration.upperFirstLetter(memberName) + "\\\\>\" +");
                building.append("            \"(<\\\\w*\\\\:?" + ((GenerationCore.TypeDataFixedArray)elementType).elementType + "\\\\>\\\\S*<\\\\/\\\\w*\\\\:?" + ((GenerationCore.TypeDataFixedArray)elementType).elementType + "\\\\>)*\" +");
                building.append("            \"<\\\\/\\\\w*\\\\:?" + AutoGeneration.upperFirstLetter(memberName) + "\\\\>\");");
                continue;
            }
            building.append("    Pattern.compile(\"<\\\\w*\\\\:?" + AutoGeneration.upperFirstLetter(memberName) + "\\\\>(\\\\S*)<\\\\/\\\\w*\\\\:?" + AutoGeneration.upperFirstLetter(memberName) + "\\\\>\");");
        }
        building.addImport("java.text.ParseException");
        building.append("");
        building.append("// TODO best to replace this with something more type specific");
        building.append("public final static " + recordType.name + " parseFactory(");
        building.append("        String valueAsString)");
        building.append("    throws NullPointerException,");
        building.appendNL("        ParseException {");
        building.increment("if (valueAsString == null)");
        building.appendNL("    throw new NullPointerException(\"Cannot create a " + AutoGeneration.camelToWords(recordType.name) + " value from a null string value.\");");
        building.append("Matcher matcher;");
        building.appendNL(recordType.name + " value = new " + recordType.name + "Impl();");
        for (x = 0; x < recordType.memberNames.size(); ++x) {
            elementType = AutoGeneration.typeByName(recordType.memberTypes.get(x));
            memberName = AutoGeneration.lowerFirstLetter(recordType.memberNames.get(x));
            building.append("try {");
            building.increment("matcher = " + memberName + "Pattern.matcher(valueAsString);");
            if (elementType instanceof GenerationCore.TypeDataFixedArray) {
                GenerationCore.TypeDataFixedArray fixedType = (GenerationCore.TypeDataFixedArray)elementType;
                GenerationCore.TypeData fixedElementType = AutoGeneration.typeByName(fixedType.elementType);
                building.appendNL(elementType.getJavaSetName(false) + "[] " + memberName + "Value = new " + elementType.getJavaSetName(false) + "[" + fixedType.elementCount + "];");
                building.append("for ( int x = 0 ; x < matcher.groupCount() ; x++ ) {");
                building.increment("String elementValue = matcher.group(x);");
                building.append("elementValue = elementValue.substring(elementValue.indexOf('>') + 1);");
                building.append("elementValue = elementValue.substring(0, elementValue.indexOf('<'));");
                if (typeList.containsKey(fixedType.elementType)) {
                    building.append(memberName + "Value[x] = (" + fixedElementType.getJavaSetName(true) + ") " + basePackageName + ".TypeDefinitions." + fixedElementType.name + ".createValue(elementValue).getValue();");
                } else {
                    building.append(memberName + "Value[x] = (" + fixedElementType.getJavaSetName(true) + ") tv.amwa.maj.industry.TypeDefinitions." + fixedElementType.name + ".createValue(elementValue).getValue();");
                }
                building.decrement("}");
            } else {
                building.append("if (matcher.find())");
                building.append("    value.set" + AutoGeneration.upperFirstLetter(memberName) + "(");
                if (typeList.containsKey(elementType.name)) {
                    building.append("            (" + elementType.getJavaSetName(true) + ") " + basePackageName + ".TypeDefinitions." + elementType.name + ".createValue(matcher.group(1)).getValue());");
                } else {
                    building.append("            (" + elementType.getJavaSetName(true) + ") tv.amwa.maj.industry.TypeDefinitions." + elementType.name + ".createValue(matcher.group(1)).getValue());");
                }
                building.append("else");
                building.append("    throw new ParseException(\"Unable to find and parse a value for member " + AutoGeneration.camelToWords(memberName) + " of type " + AutoGeneration.camelToWords(recordType.name) + ".\", 0);");
            }
            building.decrement("}");
            building.append("catch (ClassCastException cce) {");
            building.increment("throw new ParseException(\"Unable to parse a value for member " + AutoGeneration.camelToWords(memberName) + " of type " + AutoGeneration.camelToWords(recordType.name) + ".\", 0);");
            building.decrementNL("}");
        }
        building.append("return value;");
        building.decrementNL("}");
        building.reset("}");
        return building.toString();
    }

    static final String generateConstants(GenerationCore.DictionaryContext context) {
        GenerationCore.StringIndenter building = new GenerationCore.StringIndenter();
        building.setPackageName(context.basePackageName);
        building.startJavadoc();
        building.wrapComment("<p>Constant values, including the XML namespace, for package <code>" + context.basePackageName + "</code>.</p>", 80);
        building.blankComment();
        building.wrapComment("@author Auto generation", 80);
        building.endComment();
        building.append("public interface Constants {");
        building.increment("");
        building.startJavadoc();
        building.wrapComment("<p>Namespace for all symbols of the extension namespace.</p>", 80);
        building.blankComment();
        building.wrapComment("@see #XML_PREFIX", 80);
        building.endComment();
        building.append("public final static String XML_NAMESPACE =");
        building.appendNL("    \"" + context.schemeURI + "\";");
        building.startJavadoc();
        building.wrapComment("<p>Prefix for all symbols of the extension namespace.</p>", 80);
        building.blankComment();
        building.wrapComment("@see #XML_NAMESPACE", 80);
        building.endComment();
        building.appendNL("public final static String XML_PREFIX = \"" + context.preferredPrefix + "\";");
        building.addImport("tv.amwa.maj.record.AUID");
        building.addImport("tv.amwa.maj.industry.Forge");
        building.startJavadoc();
        building.wrapComment("<p>Identification of the extension namespace.</p>", 80);
        building.endComment();
        building.append("public final static AUID EXTENSION_ID = Forge.makeAUID(");
        building.append("        0x" + AutoGeneration.padHexTo8(context.schemeID.getData1()) + ", (short) 0x" + AutoGeneration.padHexTo4(context.schemeID.getData2()) + ", (short) 0x" + AutoGeneration.padHexTo4(context.schemeID.getData3()) + ",");
        building.appendNL("        new byte[] { " + AutoGeneration.bytesToText(context.schemeID.getData4()) + " } );");
        building.reset("}");
        return building.toString();
    }

    static final String generateFactory(GenerationCore.DictionaryContext context) {
        GenerationCore.StringIndenter building = new GenerationCore.StringIndenter();
        building.setPackageName(context.basePackageName);
        building.startJavadoc();
        building.wrapComment("<p>Factory for all types and classes of symbolespace <code>" + context.schemeURI + "</code>. Contains methods to initialize the MAJ media engine and warehouses with the types of this symbol space.</p>", 80);
        if (context.extensionDescription != null && context.extensionDescription.length() > 0) {
            building.blankComment();
            building.wrapComment("<p>" + context.extensionDescription + "</p>", 80);
        }
        building.blankComment();
        building.wrapComment("@author Auto generation", 80);
        building.blankComment();
        building.wrapComment("@see TypeDefinitions", 80);
        building.wrapComment("@see tv.amwa.maj.industry.MediaEngine", 80);
        building.wrapComment("@see tv.amwa.maj.industry.Warehouse", 80);
        building.endComment();
        building.append("public class " + context.factoryName + "{");
        building.increment("");
        building.appendNL("private static boolean initialized = false;");
        building.startJavadoc();
        building.wrapComment("<p>List of all the implementing classes defined for this symbol space.</p>", 80);
        building.blankComment();
        building.wrapComment("@see #initialize()", 80);
        building.endComment();
        building.append("public final static Class<?>[] CLASSES = new Class<?>[] {");
        for (String className : classList.keySet()) {
            building.append("        " + context.basePackageName + ".impl." + className + "Impl.class,");
        }
        building.appendNL("};");
        building.startJavadoc();
        building.wrapComment("<p>Initialize all the types of this symbol space and make them available through the MAJ {@linkplain tv.amwa.maj.industry.MediaEngine media engine}. The media engine and associated APIs can then make, serialize and deserialize values to all supported XML formats, binary formats and persistance providers.</p>", 80);
        building.blankComment();
        building.wrapComment("@see tv.amwa.maj.industry.MediaEngine#initializeAAF()", 80);
        building.wrapComment("@see #CLASSES", 80);
        building.endComment();
        building.append("public final static void initialize() {");
        building.increment("");
        building.addImport("tv.amwa.maj.industry.Warehouse");
        building.appendNL("if (initialized) return;");
        building.append("// Register all of the symbolspace classes");
        building.append("for ( Class<?> extensionClass : CLASSES )");
        building.appendNL("    Warehouse.lookForClass(extensionClass);");
        building.append("// Register all of the initial extendible enumeration values");
        for (GenerationCore.TypeData typeData : typeList.values()) {
            if (!(typeData instanceof GenerationCore.TypeDataExtendibleEnumeration)) continue;
            building.append("try {");
            building.append("    Warehouse.registerExtendibleEnumerationElements(" + typeData.name + ".class);");
            building.append("}");
            building.append("catch (Exception e) {");
            building.append("    System.err.println(\"Unable to register items for extendible enumeration " + typeData.name + ".\");");
            building.appendNL("}");
        }
        building.append("// Register all of the extension type definitions");
        building.appendNL("Warehouse.registerTypes(TypeDefinitions.class, Constants.XML_NAMESPACE, Constants.XML_PREFIX);");
        Vector<String> recordRegistrations = new Vector<String>();
        for (GenerationCore.TypeData typeData : typeList.values()) {
            if (!(typeData instanceof GenerationCore.TypeDataRecord)) continue;
            recordRegistrations.add(typeData.name);
        }
        if (recordRegistrations.size() > 0) {
            building.addImport("tv.amwa.maj.meta.TypeDefinitionRecordImpl");
            building.append("// Set up all record type mappings from interface to implementation");
            for (String registration : recordRegistrations) {
                building.append("TypeDefinitionRecordImpl.registerInterfaceMapping(");
                building.append("        " + context.basePackageName + "." + registration + ".class,");
                building.append("        " + context.basePackageName + ".impl." + registration + "Impl.class);");
            }
            building.append("");
        }
        building.appendNL("initialized = true;");
        building.decrementNL("}");
        building.addImport("tv.amwa.maj.industry.MetadataObject");
        building.addImport("tv.amwa.maj.industry.Forge");
        building.startJavadoc();
        building.wrapComment("<p>Create a new instance of a class defined in this symbol space from its name and initial property values.</p>", 80);
        building.blankComment();
        building.wrapComment("@param className Name of the class in this symbol space to create.", 80);
        building.wrapComment("@param properties List of property identifier and value pairs to use to make a value of the required type.", 80);
        building.wrapComment("@return Newly created value of the named class.", 80);
        building.blankComment();
        building.wrapComment("@throws NullPointerException Cannot create a new instance from a <code>null</code> name or <code>null</code> property specifications.", 80);
        building.wrapComment("@throws IllegalArgumentException Unable to use the given properties to create a value of the name class or the named class does not exist.", 80);
        building.blankComment();
        building.wrapComment("@see tv.amwa.maj.industry.Forge#makeByName(String, String, Object...)", 80);
        building.endComment();
        building.append("@SuppressWarnings(\"unchecked\")");
        building.append("public final static <T extends MetadataObject> T make(");
        building.increment("    String className,");
        building.append("    Object... properties)");
        building.append("throws NullPointerException,");
        building.appendNL("    IllegalArgumentException {");
        building.append("return (T) Forge.makeByName(Constants.XML_NAMESPACE, className, properties);");
        building.decrementNL("}");
        for (String recordTypeName : recordRegistrations) {
            String memberName;
            int x;
            GenerationCore.TypeDataRecord recordType = (GenerationCore.TypeDataRecord)typeList.get(recordTypeName);
            building.addImport("java.text.ParseException");
            building.startJavadoc();
            building.wrapComment("<p>Parse a string to create a value of " + AutoGeneration.camelToWords(recordTypeName) + " type.</p>", 80);
            building.blankComment();
            building.wrapComment("@param valueAsString Value formatted as a string, often in a pseudo-XML format.", 80);
            building.wrapComment("@return New " + AutoGeneration.camelToWords(recordTypeName) + " value created from the given string.", 80);
            building.blankComment();
            building.wrapComment("@throws NullPointerException The given string value is <code>null</code>.", 80);
            building.wrapComment("@throws ParseException Error parsing the given string to create a " + AutoGeneration.camelToWords(recordTypeName) + " value.", 80);
            building.endComment();
            building.append("public final static " + recordTypeName + " parse" + recordTypeName + "(");
            building.increment("    String valueAsString)");
            building.append("throws NullPointerException,");
            building.appendNL("    ParseException {");
            building.append("return " + context.basePackageName + ".impl." + recordTypeName + "Impl.parseFactory(valueAsString);");
            building.decrementNL("}");
            building.startJavadoc();
            building.wrapComment("<p>Create a " + AutoGeneration.camelToWords(recordTypeName) + " value from the member element values.</p>", 80);
            building.wrapComment("@return Newly created " + AutoGeneration.camelToWords(recordTypeName) + " value.", 80);
            building.blankComment();
            building.wrapComment("@throws NullPointerException One or more of the member element values is <code>null</code>.", 80);
            building.wrapComment("@throws IllegalArgumentException One or more of the member element values is illegal for its type.", 80);
            building.blankComment();
            building.wrapComment("@see #parse" + AutoGeneration.upperFirstLetter(recordTypeName) + "(String)", 80);
            building.endComment();
            building.append("public final static " + recordTypeName + " create" + recordTypeName + "(");
            for (x = 0; x < recordType.memberNames.size(); ++x) {
                memberName = recordType.memberNames.get(x);
                GenerationCore.TypeData memberType = AutoGeneration.typeByName(recordType.memberTypes.get(x));
                building.addImport(memberType.getImports());
                building.append("        " + memberType.getJavaSetName(false) + (memberType instanceof GenerationCore.TypeDataFixedArray ? "[] " : " ") + AutoGeneration.lowerFirstLetter(memberName) + (x == recordType.memberNames.size() - 1 ? ")" : ","));
            }
            building.increment("throws NullPointerException,");
            building.appendNL("    IllegalArgumentException {");
            building.append(recordTypeName + " " + AutoGeneration.lowerFirstLetter(recordTypeName) + "Value =");
            building.appendNL("         new " + context.basePackageName + ".impl." + recordTypeName + "Impl();");
            for (x = 0; x < recordType.memberNames.size(); ++x) {
                memberName = recordType.memberNames.get(x);
                building.append(AutoGeneration.lowerFirstLetter(recordTypeName) + "Value.set" + AutoGeneration.upperFirstLetter(memberName) + "(" + memberName + ");");
            }
            building.append("");
            building.append("return " + AutoGeneration.lowerFirstLetter(recordTypeName) + "Value;");
            building.decrement("}");
        }
        building.reset("}");
        return building.toString();
    }

    static {
        MediaEngine.initializeAAF();
    }
}

