/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.model.impl;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import tv.amwa.maj.constant.CodecConstant;
import tv.amwa.maj.constant.CodecDescription;
import tv.amwa.maj.exception.DuplicateEssenceKindException;
import tv.amwa.maj.exception.ObjectNotFoundException;
import tv.amwa.maj.industry.MediaClass;
import tv.amwa.maj.industry.MediaListAppend;
import tv.amwa.maj.industry.MediaListGetAt;
import tv.amwa.maj.industry.MediaListInsertAt;
import tv.amwa.maj.industry.MediaListPrepend;
import tv.amwa.maj.industry.MediaListRemoveAt;
import tv.amwa.maj.industry.MediaProperty;
import tv.amwa.maj.industry.MediaPropertyClear;
import tv.amwa.maj.industry.MediaPropertyContains;
import tv.amwa.maj.industry.MediaPropertyCount;
import tv.amwa.maj.industry.MediaPropertyRemove;
import tv.amwa.maj.industry.MediaPropertySetter;
import tv.amwa.maj.industry.Warehouse;
import tv.amwa.maj.industry.WeakReference;
import tv.amwa.maj.industry.WeakReferenceVector;
import tv.amwa.maj.meta.ClassDefinition;
import tv.amwa.maj.misctype.AAFString;
import tv.amwa.maj.model.AAFFileDescriptor;
import tv.amwa.maj.model.CodecDefinition;
import tv.amwa.maj.model.DataDefinition;
import tv.amwa.maj.model.impl.AAFFileDescriptorImpl;
import tv.amwa.maj.model.impl.DataDefinitionImpl;
import tv.amwa.maj.model.impl.DefinitionObjectImpl;
import tv.amwa.maj.record.AUID;

@MediaClass(uuid1=0xD010101, uuid2=257, uuid3=7936, uuid4={6, 14, 43, 52, 2, 6, 1, 1}, definedName="CodecDefinition", description="The CodecDefinition specifies an essence codec.", symbol="CodecDefinition")
public class CodecDefinitionImpl
extends DefinitionObjectImpl
implements CodecDefinition,
Serializable,
CodecConstant,
Cloneable {
    private static final long serialVersionUID = -715077536381810314L;
    private WeakReference<ClassDefinition> fileDescriptorClass;
    private WeakReferenceVector<DataDefinition> codecDataDefinitions = new WeakReferenceVector();
    private static final Map<String, CodecDefinition> definitionsByName = new HashMap<String, CodecDefinition>(20);
    private static final Map<AUID, CodecDefinition> definitionsById = new HashMap<AUID, CodecDefinition>(10);

    public static final int registerCodecsFromClass(Class<?> classWithCodecs) throws NullPointerException {
        Field[] fields;
        if (classWithCodecs == null) {
            throw new NullPointerException("Cannot register parameter definitions using a null class.");
        }
        int registered = 0;
        for (Field field : fields = classWithCodecs.getFields()) {
            int modifiers = field.getModifiers();
            if (!Modifier.isPublic(modifiers) && !Modifier.isStatic(modifiers)) continue;
            try {
                Object value = field.get(null);
                if (!(value instanceof AUID) || !field.isAnnotationPresent(CodecDescription.class)) continue;
                CodecDescription codecMetadata = field.getAnnotation(CodecDescription.class);
                HashSet<DataDefinition> dataDefinitions = new HashSet<DataDefinition>(2);
                for (String dataDefName : codecMetadata.dataDefinitions()) {
                    dataDefinitions.add(DataDefinitionImpl.forName(dataDefName));
                }
                ClassDefinition fileDescriptorClass = codecMetadata.fileDescriptorClass().equals("") ? Warehouse.lookForClass(AAFFileDescriptorImpl.class) : Warehouse.lookForClass(codecMetadata.fileDescriptorClass());
                CodecDefinitionImpl definedCodec = new CodecDefinitionImpl((AUID)value, field.getName(), fileDescriptorClass, dataDefinitions);
                if (codecMetadata.description().length() > 0) {
                    definedCodec.setDescription(codecMetadata.description());
                }
                CodecDefinitionImpl.registerCodecDefinition(definedCodec);
                for (String alias : codecMetadata.aliases()) {
                    definitionsByName.put(alias, definedCodec);
                }
                ++registered;
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return registered;
    }

    public static final boolean registerCodecDefinition(CodecDefinition definedCodec) throws NullPointerException {
        if (definedCodec == null) {
            throw new NullPointerException("Cannot register a new codec definition using a null value.");
        }
        boolean alreadyContained = definitionsById.containsKey(definedCodec.getAUID());
        definitionsByName.put(definedCodec.getName(), definedCodec);
        definitionsByName.put("CodecDef_" + definedCodec.getName(), definedCodec);
        definitionsById.put(definedCodec.getAUID(), definedCodec);
        return alreadyContained;
    }

    public static final CodecDefinition forName(String codecName) throws NullPointerException {
        if (codecName == null) {
            throw new NullPointerException("Cannot retrieve a codec definition with a null name.");
        }
        return definitionsByName.get(codecName);
    }

    public static final CodecDefinition forIdentification(AUID identification) throws NullPointerException {
        if (identification == null) {
            throw new NullPointerException("Cannot retrieve a codec definition with a null identification.");
        }
        return definitionsById.get(identification);
    }

    public static final CodecDefinition forAUID(AUID identification) throws NullPointerException {
        return CodecDefinitionImpl.forIdentification(identification);
    }

    public static final Collection<String> inventory() {
        TreeSet<String> inventory = new TreeSet<String>();
        for (AUID definitionID : definitionsById.keySet()) {
            inventory.add(definitionsById.get(definitionID).getName());
        }
        return inventory;
    }

    public static final int count() {
        return definitionsById.size();
    }

    public CodecDefinitionImpl() {
    }

    public CodecDefinitionImpl(AUID identification, @AAFString String name, ClassDefinition fileDescriptorClass, Set<DataDefinition> dataDefinitions) throws NullPointerException, IllegalArgumentException {
        if (identification == null) {
            throw new NullPointerException("Cannot create a codec definition with a null identification.");
        }
        if (name == null) {
            throw new NullPointerException("Cannot create a codec definition with a null name.");
        }
        if (fileDescriptorClass == null) {
            throw new NullPointerException("Cannot create a codec definition with a null file descriptor class.");
        }
        if (dataDefinitions == null) {
            throw new NullPointerException("Cannot create a codec definition with a null set of data definitions.");
        }
        if (dataDefinitions.size() == 0) {
            throw new IllegalArgumentException("Cannot create a codec definition with an empty set of data definitions.");
        }
        this.setAUID(identification);
        this.setName(name);
        this.setFileDescriptorClass(fileDescriptorClass);
        for (DataDefinition definition : dataDefinitions) {
            if (definition == null) continue;
            this.codecDataDefinitions.append(definition);
        }
    }

    @Override
    @MediaListAppend(value="CodecDataDefinitions")
    public void appendEssenceKind(DataDefinition essenceKind) throws NullPointerException, DuplicateEssenceKindException {
        if (essenceKind == null) {
            throw new NullPointerException("Cannot add a null essence kind.");
        }
        if (this.codecDataDefinitions.contains(essenceKind)) {
            throw new DuplicateEssenceKindException("The given essence kind is already represented in this codec definition.");
        }
        this.codecDataDefinitions.append(essenceKind);
    }

    @Override
    @MediaPropertyCount(value="CodecDataDefinitions")
    public int countEssenceKinds() {
        return this.codecDataDefinitions.count();
    }

    public Set<AUID> getCodecFlavours() {
        return null;
    }

    @MediaProperty(uuid1=100729092, uuid2=769, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="CodecDataDefinitions", aliases={"DataDefinitions", "CodecDefinitionDataDefinitions"}, typeName="DataDefinitionWeakReferenceVector", optional=false, uniqueIdentifier=false, pid=8962, symbol="CodecDataDefinitions")
    public List<DataDefinition> getEssenceKinds() {
        return this.codecDataDefinitions.getRequiredList();
    }

    public static final List<DataDefinition> initializeCodecDataDefinitions() {
        ArrayList<DataDefinition> initialDefinitions = new ArrayList<DataDefinition>(1);
        initialDefinitions.add(DataDefinitionImpl.forName("Unknown"));
        return initialDefinitions;
    }

    @Override
    @MediaProperty(uuid1=100729092, uuid2=263, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="FileDescriptorClass", typeName="ClassDefinitionWeakReference", optional=false, uniqueIdentifier=false, pid=8961, symbol="FileDescriptorClass")
    public ClassDefinition getFileDescriptorClass() {
        return this.fileDescriptorClass.getTarget();
    }

    @Override
    @MediaPropertySetter(value="FileDescriptorClass")
    public void setFileDescriptorClass(ClassDefinition fileClass) throws NullPointerException, IllegalArgumentException {
        if (fileClass == null) {
            throw new NullPointerException("Cannot set the file descriptor class for this codec definition using a null value.");
        }
        if (!AAFFileDescriptor.class.isAssignableFrom(fileClass.getJavaImplementation())) {
            throw new IllegalArgumentException("The given file descriptor class " + fileClass.getName() + " for this codec definition is not a sub-class of file descriptor.");
        }
        this.fileDescriptorClass = new WeakReference<ClassDefinition>(fileClass);
    }

    public static final ClassDefinition initializeFileDescriptorClass() {
        return Warehouse.lookForClass("SoundDescriptor");
    }

    @Override
    @MediaPropertyContains(value="CodecDataDefinitions")
    public boolean isEssenceKindSupported(DataDefinition essenceKind) throws NullPointerException {
        return this.codecDataDefinitions.contains(essenceKind);
    }

    @Override
    @MediaPropertyRemove(value="CodecDataDefinitions")
    public void removeEssenceKind(DataDefinition essenceKind) throws NullPointerException, ObjectNotFoundException, IllegalArgumentException {
        if (essenceKind == null) {
            throw new NullPointerException("Cannot remove an essence kind from the codec's data definitions using a null value.");
        }
        if (this.codecDataDefinitions.count() == 1) {
            throw new IllegalArgumentException("Cannot remove an essence kind as the set of data definitions cannot be empty.");
        }
        if (!this.codecDataDefinitions.contains(essenceKind)) {
            throw new ObjectNotFoundException("Cannot remove the essence kind from the data definitions as it is not known.");
        }
        this.codecDataDefinitions.remove(essenceKind);
    }

    @Override
    @MediaPropertyClear(value="CodecDataDefinitions")
    public void clearEssenceKinds() {
        this.codecDataDefinitions.clear();
    }

    @Override
    public CodecDefinitionImpl clone() {
        return (CodecDefinitionImpl)super.clone();
    }

    @Override
    public String getWeakTargetReference() {
        if (this.getName().startsWith("CodecDef_")) {
            return this.getName();
        }
        return "CodecDef_" + this.getName();
    }

    @Override
    @MediaListGetAt(value="CodecDataDefinitions")
    public DataDefinition getEssenceKindAt(int index) throws IndexOutOfBoundsException {
        return this.codecDataDefinitions.getAt(index);
    }

    @Override
    @MediaListInsertAt(value="CodecDataDefinitions")
    public void insertEssenceKind(int index, DataDefinition essenceKind) throws NullPointerException, DuplicateEssenceKindException, IndexOutOfBoundsException {
        if (essenceKind == null) {
            throw new NullPointerException("Cannot add a null essence kind.");
        }
        if (this.codecDataDefinitions.contains(essenceKind)) {
            throw new DuplicateEssenceKindException("The given essence kind is already represented in this codec definition.");
        }
        this.codecDataDefinitions.insert(index, essenceKind);
    }

    @Override
    @MediaListPrepend(value="CodecDataDefinitions")
    public void prependEssenceKind(DataDefinition essenceKind) throws NullPointerException, DuplicateEssenceKindException {
        if (essenceKind == null) {
            throw new NullPointerException("Cannot add a null essence kind.");
        }
        if (this.codecDataDefinitions.contains(essenceKind)) {
            throw new DuplicateEssenceKindException("The given essence kind is already represented in this codec definition.");
        }
        this.codecDataDefinitions.prepend(essenceKind);
    }

    @Override
    @MediaListRemoveAt(value="CodecDataDefinitions")
    public void removeEssenceKindAt(int index) throws IndexOutOfBoundsException {
        this.codecDataDefinitions.removeAt(index);
    }

    static {
        CodecDefinitionImpl.registerCodecsFromClass(CodecConstant.class);
    }
}

