/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.meta.impl;

import java.io.Serializable;
import org.w3c.dom.Node;
import tv.amwa.maj.constant.CommonConstants;
import tv.amwa.maj.exception.PropertyNotPresentException;
import tv.amwa.maj.industry.MediaClass;
import tv.amwa.maj.industry.MediaEngine;
import tv.amwa.maj.industry.MediaProperty;
import tv.amwa.maj.industry.MediaPropertySetter;
import tv.amwa.maj.industry.WeakReference;
import tv.amwa.maj.industry.WeakReferenceTarget;
import tv.amwa.maj.io.xml.XMLBuilder;
import tv.amwa.maj.meta.MetaDefinition;
import tv.amwa.maj.model.impl.DefinitionType;
import tv.amwa.maj.record.AUID;
import tv.amwa.maj.record.impl.AUIDImpl;

@MediaClass(uuid1=0xD010101, uuid2=548, uuid3=0, uuid4={6, 14, 43, 52, 2, 6, 1, 1}, definedName="MetaDefinition", description="The MetaDefinition class is an abstract class that defines a class, type, or property in an AAF file.", symbol="MetaDefinition", namespace="http://www.smpte-ra.org/schemas/2001-2/2007/aaf", prefix="aaf")
public abstract class MetaDefinitionImpl
implements MetaDefinition,
DefinitionType,
WeakReferenceTarget,
Serializable,
CommonConstants,
Cloneable {
    private static final long serialVersionUID = 613837427379296528L;
    private AUID identification;
    private String name = null;
    private String description = null;
    String symbol;
    String namespace = null;
    String prefix = null;
    private String[] aliases;
    private boolean aafNamesInUse = false;
    private static int nameCount = 1;

    @Override
    @MediaProperty(uuid1=100729095, uuid2=4864, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="MetaDefinitionIdentification", aliases={"Identification", "AUID"}, typeName="AUID", optional=false, uniqueIdentifier=true, pid=5, symbol="MetaDefinitionIdentification")
    public final AUID getAUID() {
        return this.identification.clone();
    }

    public AUID getIdentification() {
        return this.identification.clone();
    }

    public static final AUID initializeMetaDefinitionIdentification() {
        return AUIDImpl.randomAUID();
    }

    @MediaPropertySetter(value="MetaDefinitionIdentification")
    public final void setIdentification(AUID identification) throws NullPointerException {
        if (identification == null) {
            throw new NullPointerException("Cannot set the identity of a meta definition with a null id.");
        }
        this.identification = identification.clone();
    }

    @Override
    @MediaProperty(uuid1=100729095, uuid2=5121, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="MetaDefinitionDescription", aliases={"Description"}, typeName="UTF16String", optional=true, uniqueIdentifier=false, pid=7, symbol="MetaDefinitionDescription")
    public final String getDescription() throws PropertyNotPresentException {
        if (this.description == null) {
            throw new PropertyNotPresentException("The optional description property is not present for this meta definition.");
        }
        return this.description;
    }

    @Override
    @MediaPropertySetter(value="MetaDefinitionDescription")
    public final void setDescription(String description) {
        this.description = description;
    }

    @Override
    @MediaProperty(uuid1=50463745, uuid2=513, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="MetaDefinitionName", aliases={"Name"}, typeName="UTF16String", optional=false, uniqueIdentifier=false, pid=6, symbol="MetaDefinitionName")
    public final String getName() {
        return this.aafNamesInUse ? this.nameToAAFName(this.name) : this.name;
    }

    @Override
    @MediaPropertySetter(value="MetaDefinitionName")
    public final void setName(String name) throws NullPointerException {
        if (name == null) {
            throw new NullPointerException("Cannoe set the name of a meta definition name with a null string value.");
        }
        this.name = this.aafNamesInUse ? this.aafNameToName(name) : name;
    }

    public static final String initializeMetaDefinitionName() {
        return "DefaultMetaDefinitionName" + nameCount++;
    }

    String getSymbolName() {
        return this.name.replaceAll("\\W", "_");
    }

    @Override
    public final boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof WeakReference) {
            o = ((WeakReference)o).getTarget();
        }
        if (!(o instanceof MetaDefinition)) {
            return false;
        }
        return this.identification.equals(((MetaDefinition)o).getAUID());
    }

    @Override
    public boolean deepEquals(Object o) {
        return MediaEngine.deepEquals(this, o);
    }

    @Override
    public final int hashCode() {
        return this.identification.hashCode();
    }

    @Override
    public String toString() {
        return MediaEngine.toString(this);
    }

    public void appendXMLChildren(Node parent) {
    }

    public String getComment() {
        return null;
    }

    @Override
    public String getSymbol() {
        if (this.symbol == null) {
            return this.name;
        }
        return this.symbol;
    }

    @Override
    public void setSymbol(String symbol) throws NullPointerException {
        if (symbol == null) {
            throw new NullPointerException("Cannot set a meta definition symbol to null.");
        }
        this.symbol = symbol;
    }

    @Override
    public String getWeakTargetReference() {
        return this.getName();
    }

    @Override
    public String getNamespace() {
        return "unknown";
    }

    @Override
    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getPrefix() {
        return "unknown";
    }

    @Override
    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setAliases(String[] aliases) {
        this.aliases = aliases == null ? new String[0] : aliases;
    }

    @Override
    public String[] getAliases() {
        return this.aliases;
    }

    @Override
    public boolean getAAFNamesInUse() {
        return this.aafNamesInUse;
    }

    @Override
    public void setAAFNamesInUse(boolean aafNamesInUse) {
        this.aafNamesInUse = aafNamesInUse;
    }

    public String nameToAAFName(String name) {
        return name;
    }

    public String aafNameToName(String name) {
        return name;
    }

    @Override
    public void appendMetadictXML(Node metadict, String namespace, String prefix) {
        XMLBuilder.appendElement(metadict, namespace, prefix, "Symbol", this.getSymbol());
        XMLBuilder.appendElement(metadict, namespace, prefix, "Name", this.name);
        XMLBuilder.appendElement(metadict, namespace, prefix, "Identification", this.identification.toString());
        XMLBuilder.appendElement(metadict, namespace, prefix, "Description", this.description != null ? this.description : "");
    }

    @Override
    public MetaDefinition clone() {
        try {
            return (MetaDefinition)super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new InternalError(cnse.getMessage());
        }
    }
}

