/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.io.mxf;

import java.util.List;
import tv.amwa.maj.io.mxf.MXFLength;
import tv.amwa.maj.io.mxf.MXFPosition;

public abstract class ListOfFiles {
    private NewFileHandler handler;
    private String baseFileName;
    private List<String> followingNames;
    private boolean fileList;
    private int listOrigin;
    private int listIncrement;
    private int listNumber;
    private int listEnd;
    private int fileNumber;
    private int filesRemaining;
    private boolean atEOF = false;
    private String currentFileName;
    @MXFPosition
    private long rangeStart = -1L;
    @MXFPosition
    private long rangeEnd = -1L;
    @MXFLength
    private long rangeDuration = -1L;

    public ListOfFiles(String fileName) {
        if (fileName == null) {
            fileName = "";
        }
        if (fileName.length() > 0) {
            this.parseFileName(fileName);
        } else {
            this.baseFileName = fileName;
            this.fileList = false;
        }
    }

    public ListOfFiles() {
        this.baseFileName = "";
        this.fileList = false;
    }

    public void setFileName(String fileName) {
        this.followingNames.clear();
        this.parseFileName(fileName);
    }

    public void addFileName(String fileName) throws NullPointerException {
        if (fileName == null) {
            throw new NullPointerException("Cannot add a null file name to a list of files.");
        }
        if (this.baseFileName.length() == 0) {
            this.parseFileName(fileName);
        } else {
            this.followingNames.add(fileName);
        }
    }

    public void setNewFileHandler(NewFileHandler handler) {
        this.handler = handler;
    }

    @MXFPosition
    public long getRangeStart() {
        return this.rangeStart;
    }

    @MXFPosition
    public long getRangeEnd() {
        return this.rangeEnd;
    }

    @MXFPosition
    public long getRangeDuration() {
        return this.rangeDuration;
    }

    public String getCurrentFileName() {
        return this.currentFileName;
    }

    public abstract boolean openFile();

    public abstract void closeFile();

    public abstract boolean isFileOpen();

    public boolean isFileList() {
        return this.fileList;
    }

    public boolean getNextFile() {
        return false;
    }

    void parseFileName(String fileName) {
    }

    boolean atEOF() {
        return this.atEOF;
    }

    public abstract class NewFileHandler {
        public abstract void newFile(String var1);
    }
}

