/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.enumeration;

import tv.amwa.maj.industry.MediaEnumerationValue;
import tv.amwa.maj.integer.Int64;

public enum TypeCategory implements MediaEnumerationValue
{
    Unknown(0),
    Int(1),
    Character(2),
    StrongObjRef(3),
    WeakObjRef(4),
    Rename(5),
    Enum(6),
    FixedArray(7),
    VariableArray(8),
    Set(9),
    Record(10),
    Stream(11),
    String(12),
    ExtEnum(13),
    Indirect(14),
    Opaque(15),
    Encrypted(16);

    private final int value;

    private TypeCategory(int value) {
        this.value = value;
    }

    @Override
    @Int64
    public long value() {
        return this.value;
    }

    public static final TypeCategory fromOrdinal(int categoryIdentifier) {
        switch (categoryIdentifier) {
            case 1: {
                return Int;
            }
            case 2: {
                return Character;
            }
            case 3: {
                return StrongObjRef;
            }
            case 4: {
                return WeakObjRef;
            }
            case 5: {
                return Rename;
            }
            case 6: {
                return Enum;
            }
            case 7: {
                return FixedArray;
            }
            case 8: {
                return VariableArray;
            }
            case 9: {
                return Set;
            }
            case 10: {
                return Record;
            }
            case 11: {
                return Stream;
            }
            case 12: {
                return String;
            }
            case 13: {
                return ExtEnum;
            }
            case 14: {
                return Indirect;
            }
            case 15: {
                return Opaque;
            }
        }
        return Unknown;
    }

    @Override
    public String symbol() {
        return this.name();
    }
}

