/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.model.impl;

import java.io.Serializable;
import tv.amwa.maj.exception.AdjacentTransitionException;
import tv.amwa.maj.exception.BadLengthException;
import tv.amwa.maj.exception.BadPropertyException;
import tv.amwa.maj.exception.BadSampleOffsetException;
import tv.amwa.maj.exception.EventSemanticsException;
import tv.amwa.maj.exception.InsufficientTransitionMaterialException;
import tv.amwa.maj.exception.InvalidDataDefinitionException;
import tv.amwa.maj.exception.LeadingTransitionException;
import tv.amwa.maj.exception.PropertyNotPresentException;
import tv.amwa.maj.exception.TimecodeNotFoundException;
import tv.amwa.maj.extensions.quantel.QSegment;
import tv.amwa.maj.industry.MediaClass;
import tv.amwa.maj.industry.MediaProperty;
import tv.amwa.maj.industry.MediaPropertySetter;
import tv.amwa.maj.industry.Stream;
import tv.amwa.maj.integer.Int32;
import tv.amwa.maj.integer.Int64;
import tv.amwa.maj.model.Component;
import tv.amwa.maj.model.Segment;
import tv.amwa.maj.model.Sequence;
import tv.amwa.maj.model.TimecodeSegment;
import tv.amwa.maj.model.impl.ComponentImpl;
import tv.amwa.maj.model.impl.SequenceImpl;
import tv.amwa.maj.model.impl.TrackImpl;
import tv.amwa.maj.record.Rational;
import tv.amwa.maj.record.TimecodeValue;
import tv.amwa.maj.union.impl.TimecodeClipImpl;

@MediaClass(uuid1=0xD010101, uuid2=257, uuid3=768, uuid4={6, 14, 43, 52, 2, 6, 1, 1}, definedName="Segment", description="The Segment class represents a Component that is independent of any surrounding object.", symbol="Segment", isConcrete=false)
public class SegmentImpl
extends ComponentImpl
implements Segment,
QSegment,
Serializable,
Cloneable {
    private Stream segmentBlob = null;
    private Integer cutPoint = null;
    private Segment trackRenderSequence = null;
    private Integer packLayerKeyIndicator = null;
    private Segment trackKeyRenderSequence = null;
    private Stream trackBlob = null;
    private Long keyOffset = null;
    private String trackName = null;
    private static final long serialVersionUID = -2420966923728552880L;

    @Override
    @MediaProperty(uuid1=268864273, uuid2=28834, uuid3=19796, uuid4={-81, -47, 64, -100, -77, -111, -102, -26}, definedName="Segment blob", symbol="Segment_blob", aliases={"Segment_blob"}, typeName="Stream", optional=true, uniqueIdentifier=false, pid=0, prefix="q", namespace="http://www.quantel.com/genQ/extensions")
    public Stream getSegmentBlob() throws PropertyNotPresentException {
        if (this.segmentBlob == null) {
            throw new PropertyNotPresentException("The optional segment blob property is not present for this Quantel segment.");
        }
        return this.segmentBlob;
    }

    @Override
    @MediaPropertySetter(value="Segment blob")
    public void setSegmentBlob(Stream segmentBlob) {
        this.segmentBlob = segmentBlob;
    }

    @Override
    @MediaProperty(uuid1=654032966, uuid2=17044, uuid3=18848, uuid4={-111, -65, 49, -16, 45, -27, 99, 53}, definedName="CutPoint", symbol="CutPoint", aliases={"CutPoint"}, typeName="Int32", optional=true, uniqueIdentifier=false, pid=0, prefix="q", namespace="http://www.quantel.com/genQ/extensions")
    @Int32
    public int getCutPoint() throws PropertyNotPresentException {
        if (this.cutPoint == null) {
            throw new PropertyNotPresentException("The optional cut point property is not present for this Quantel segment.");
        }
        return this.cutPoint;
    }

    @Override
    @MediaPropertySetter(value="CutPoint")
    public void setCutPoint(@Int32 Integer cutPoint) {
        this.cutPoint = cutPoint;
    }

    @Override
    @MediaProperty(uuid1=-559922832, uuid2=-24250, uuid3=18996, uuid4={-128, -127, 116, -23, -74, 43, -107, 60}, definedName="Track render sequence", symbol="Track_render_sequence", aliases={"Track_render_sequence"}, typeName="SegmentStrongReference", optional=true, uniqueIdentifier=false, pid=0, prefix="q", namespace="http://www.quantel.com/genQ/extensions")
    public Segment getTrackRenderSequence() throws PropertyNotPresentException {
        if (this.trackRenderSequence == null) {
            throw new PropertyNotPresentException("The optional track render sequence property is not present for this Quantel segment.");
        }
        return this.trackRenderSequence;
    }

    @Override
    @MediaPropertySetter(value="Track render sequence")
    public void setTrackRenderSequence(Segment trackRenderSequence) {
        this.trackRenderSequence = trackRenderSequence;
    }

    @Override
    @MediaProperty(uuid1=2112948090, uuid2=20357, uuid3=19644, uuid4={-104, -114, -101, -68, -63, 14, 20, 110}, definedName="Pack layer key indicator", symbol="Pack_layer_key_indicator", aliases={"Pack_layer_key_indicator"}, typeName="Int32", optional=true, uniqueIdentifier=false, pid=0, prefix="q", namespace="http://www.quantel.com/genQ/extensions")
    @Int32
    public int getPackLayerKeyIndicator() throws PropertyNotPresentException {
        if (this.packLayerKeyIndicator == null) {
            throw new PropertyNotPresentException("The optional pack layer key indicator property is not present for this Quantel segment.");
        }
        return this.packLayerKeyIndicator;
    }

    @Override
    @MediaPropertySetter(value="Pack layer key indicator")
    public void setPackLayerKeyIndicator(@Int32 Integer packLayerKeyIndicator) {
        this.packLayerKeyIndicator = packLayerKeyIndicator;
    }

    @Override
    @MediaProperty(uuid1=-286713187, uuid2=5294, uuid3=17408, uuid4={-98, 31, 72, -123, 25, 101, 81, -40}, definedName="Track key render sequence", symbol="Track_key_render_sequence", aliases={"Track_key_render_sequence"}, typeName="SegmentStrongReference", optional=true, uniqueIdentifier=false, pid=0, prefix="q", namespace="http://www.quantel.com/genQ/extensions")
    public Segment getTrackKeyRenderSequence() throws PropertyNotPresentException {
        if (this.trackKeyRenderSequence == null) {
            throw new PropertyNotPresentException("The optional track key render sequence property is not present for this Quantel segment.");
        }
        return this.trackKeyRenderSequence;
    }

    @Override
    @MediaPropertySetter(value="Track key render sequence")
    public void setTrackKeyRenderSequence(Segment trackKeyRenderSequence) {
        this.trackKeyRenderSequence = trackKeyRenderSequence;
    }

    @Override
    @MediaProperty(uuid1=1061222067, uuid2=15670, uuid3=18894, uuid4={-89, -117, -95, -102, -120, -16, 77, -53}, definedName="Track blob", symbol="Track_blob", aliases={"Track_blob"}, typeName="Stream", optional=true, uniqueIdentifier=false, pid=0, prefix="q", namespace="http://www.quantel.com/genQ/extensions")
    public Stream getTrackBlob() throws PropertyNotPresentException {
        if (this.trackBlob == null) {
            throw new PropertyNotPresentException("THe optional track blob property is not present for this Quantel segment.");
        }
        return this.trackBlob;
    }

    @Override
    @MediaPropertySetter(value="Track blob")
    public void setTrackBlob(Stream trackBlob) {
        this.trackBlob = trackBlob;
    }

    @Override
    @MediaProperty(uuid1=1285663196, uuid2=-25282, uuid3=18666, uuid4={-91, 57, 109, -51, -5, 100, -16, -19}, definedName="Key offset", symbol="Key_offset", aliases={"Key_offset"}, typeName="Int64", optional=true, uniqueIdentifier=false, pid=0, prefix="q", namespace="http://www.quantel.com/genQ/extensions")
    @Int64
    public long getKeyOffset() throws PropertyNotPresentException {
        if (this.keyOffset == null) {
            throw new PropertyNotPresentException("The optional key offset property is not present for this Quantel segment.");
        }
        return this.keyOffset;
    }

    @Override
    @MediaPropertySetter(value="Key offset")
    public void setKeyOffset(@Int64 Long keyOffset) {
        this.keyOffset = keyOffset;
    }

    @Override
    @MediaProperty(uuid1=-773215508, uuid2=18897, uuid3=17711, uuid4={-123, -23, 89, -125, -79, -69, 71, 45}, definedName="TrackName", symbol="TrackName", aliases={"TrackName"}, typeName="UTF16String", optional=true, uniqueIdentifier=false, pid=0, prefix="q", namespace="http://www.quantel.com/genQ/extensions")
    public String getTrackName() throws PropertyNotPresentException {
        if (this.trackName == null) {
            throw new PropertyNotPresentException("The optional track name property is not present for this Quantel segment.");
        }
        return this.trackName;
    }

    @Override
    @MediaPropertySetter(value="TrackName")
    public void setTrackName(String trackName) {
        this.trackName = trackName;
    }

    @Override
    public TimecodeValue segmentOffsetToTC(long offset) throws TimecodeNotFoundException {
        throw new TimecodeNotFoundException("Timecode value was not found for this segment.");
    }

    @Override
    public long segmentTCToOffset(TimecodeValue timecode, Rational editRate) throws NullPointerException, TimecodeNotFoundException, BadSampleOffsetException {
        if (timecode == null) {
            throw new NullPointerException("Cannot calculate segment timecode offset using a null timecode value.");
        }
        if (editRate == null) {
            throw new NullPointerException("Cannot calculate segment timecode offset using a null edit rate value.");
        }
        throw new TimecodeNotFoundException("Timecode value was not found for this segment.");
    }

    @Override
    public Segment clone() {
        return (Segment)super.clone();
    }

    @Override
    public Sequence generateSequence() {
        SequenceImpl sequence = new SequenceImpl(this.getComponentDataDefinition());
        try {
            sequence.appendComponentObject(this);
        }
        catch (InvalidDataDefinitionException invalidDataDefinitionException) {
        }
        catch (LeadingTransitionException leadingTransitionException) {
        }
        catch (EventSemanticsException e) {
            e.printStackTrace();
        }
        catch (BadPropertyException e) {
            e.printStackTrace();
        }
        catch (BadLengthException e) {
            e.printStackTrace();
        }
        catch (AdjacentTransitionException adjacentTransitionException) {
        }
        catch (InsufficientTransitionMaterialException insufficientTransitionMaterialException) {
            // empty catch block
        }
        return sequence;
    }

    static TimecodeClipImpl offsetToTimecodeClip(Segment relativeTo, long offset) {
        try {
            return new TimecodeClipImpl(null, relativeTo.getComponentLength(), 0L);
        }
        catch (BadPropertyException bpe) {
            return new TimecodeClipImpl(null, 0L, 0L);
        }
    }

    static TimecodeClipImpl offsetToTimecodeClip(TimecodeSegment relativeTo, long offset) {
        try {
            return new TimecodeClipImpl(relativeTo, relativeTo.getComponentLength(), 0L);
        }
        catch (BadPropertyException bpe) {
            return null;
        }
    }

    static TrackImpl.FoundSegment findSubSegment(Segment toSearch, long offset) {
        try {
            Segment subSegment = null;
            long segmentLength = toSearch.getComponentLength();
            long beginPosition = 0L;
            long endPosition = segmentLength;
            if (beginPosition <= offset && offset < endPosition) {
                subSegment = toSearch;
            } else if (beginPosition == endPosition && offset == 0L) {
                subSegment = toSearch;
            } else {
                return null;
            }
            TrackImpl.FoundSegment foundSegment = new TrackImpl.FoundSegment();
            foundSegment.rootObject = subSegment;
            foundSegment.differencePosition = offset;
            return foundSegment;
        }
        catch (BadPropertyException e) {
            return null;
        }
    }

    static TrackImpl.FoundSegment findSubSegment(Sequence toSearch, long offset) {
        try {
            Component subSegment = null;
            long segmentLength = toSearch.getComponentLength();
            long beginPosition = 0L;
            long endPosition = segmentLength;
            if (beginPosition <= offset && offset < endPosition) {
                for (Component component : toSearch.getComponentObjects()) {
                    segmentLength = component.getComponentLength();
                    if (beginPosition <= offset && offset < (endPosition += segmentLength)) {
                        subSegment = component;
                        break;
                    }
                    beginPosition = endPosition;
                }
            } else if (beginPosition == endPosition && offset == 0L) {
                subSegment = toSearch;
            } else {
                return null;
            }
            TrackImpl.FoundSegment foundSegment = new TrackImpl.FoundSegment();
            foundSegment.rootObject = subSegment;
            foundSegment.differencePosition = offset;
            return foundSegment;
        }
        catch (BadPropertyException e) {
            e.printStackTrace();
            return null;
        }
    }
}

