/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.model.impl;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import tv.amwa.maj.constant.OperationConstant;
import tv.amwa.maj.constant.OperationDescription;
import tv.amwa.maj.exception.ObjectAlreadyAttachedException;
import tv.amwa.maj.exception.ObjectNotFoundException;
import tv.amwa.maj.exception.PropertyNotPresentException;
import tv.amwa.maj.industry.MediaClass;
import tv.amwa.maj.industry.MediaListAppend;
import tv.amwa.maj.industry.MediaListInsertAt;
import tv.amwa.maj.industry.MediaListPrepend;
import tv.amwa.maj.industry.MediaListRemoveAt;
import tv.amwa.maj.industry.MediaProperty;
import tv.amwa.maj.industry.MediaPropertyClear;
import tv.amwa.maj.industry.MediaPropertyCount;
import tv.amwa.maj.industry.MediaPropertySetter;
import tv.amwa.maj.industry.MediaSetAdd;
import tv.amwa.maj.industry.WeakReference;
import tv.amwa.maj.industry.WeakReferenceSet;
import tv.amwa.maj.industry.WeakReferenceTarget;
import tv.amwa.maj.industry.WeakReferenceVector;
import tv.amwa.maj.misctype.AAFString;
import tv.amwa.maj.model.DataDefinition;
import tv.amwa.maj.model.OperationDefinition;
import tv.amwa.maj.model.ParameterDefinition;
import tv.amwa.maj.model.impl.DataDefinitionImpl;
import tv.amwa.maj.model.impl.DefinitionObjectImpl;
import tv.amwa.maj.model.impl.ParameterDefinitionImpl;
import tv.amwa.maj.record.AUID;
import tv.amwa.maj.record.impl.AUIDImpl;

@MediaClass(uuid1=0xD010101, uuid2=257, uuid3=7168, uuid4={6, 14, 43, 52, 2, 6, 1, 1}, definedName="OperationDefinition", description="The OperationDefinition class identifies an operation that is performed on an array of Segments.", symbol="OperationDefinition")
public class OperationDefinitionImpl
extends DefinitionObjectImpl
implements OperationDefinition,
Serializable,
OperationConstant,
Cloneable,
WeakReferenceTarget {
    private static final long serialVersionUID = -658385965548109802L;
    private WeakReference<DataDefinition> operationDataDefinition;
    private Boolean isTimeWarp = null;
    private WeakReferenceVector<OperationDefinition> degradeTo = new WeakReferenceVector();
    private AUID operationCategory = null;
    private int operationInputCount;
    private Integer bypass = null;
    private WeakReferenceSet<ParameterDefinition> operationParametersDefined = new WeakReferenceSet();
    private static final Map<String, OperationDefinition> definitionsByName = new HashMap<String, OperationDefinition>(100);
    private static final Map<AUID, OperationDefinition> definitionsById = new HashMap<AUID, OperationDefinition>(30);

    public static final int registerOperationsFromClass(Class<?> classWithOperations) throws NullPointerException {
        Field[] fields;
        if (classWithOperations == null) {
            throw new NullPointerException("Cannot register operation definitions using a null class.");
        }
        int registered = 0;
        for (Field field : fields = classWithOperations.getFields()) {
            int modifiers = field.getModifiers();
            if (!Modifier.isPublic(modifiers) && !Modifier.isStatic(modifiers)) continue;
            try {
                Object value = field.get(null);
                if (!(value instanceof AUID) || !field.isAnnotationPresent(OperationDescription.class)) continue;
                OperationDescription operationMetadata = field.getAnnotation(OperationDescription.class);
                OperationDefinitionImpl definedOperation = new OperationDefinitionImpl((AUID)value, field.getName(), DataDefinitionImpl.forName(operationMetadata.dataDefinition()), operationMetadata.numberInputs());
                if (operationMetadata.description().length() > 0) {
                    definedOperation.setDescription(operationMetadata.description());
                }
                if (operationMetadata.operationCategory().length() > 0) {
                    definedOperation.setOperationCategory(AUIDImpl.parseFactory(operationMetadata.operationCategory()));
                }
                if (operationMetadata.bypass() != Integer.MIN_VALUE) {
                    definedOperation.setBypass(operationMetadata.bypass());
                } else {
                    definedOperation.setBypass(null);
                }
                for (String parameterName : operationMetadata.parametersDefined()) {
                    ParameterDefinition parameter = ParameterDefinitionImpl.forName(parameterName);
                    if (parameter != null) {
                        definedOperation.addParameterDefinition(parameter);
                        continue;
                    }
                    System.err.println("Could not find parameter " + parameterName + " for operation " + definedOperation.getName() + ".");
                }
                for (String operationName : operationMetadata.degradeTo()) {
                    OperationDefinition operation = OperationDefinitionImpl.forName(operationName);
                    if (operation != null) {
                        definedOperation.appendDegradeToOperation(operation);
                        continue;
                    }
                    System.err.println("Could not find degrade to operation " + operationName + " for operation " + definedOperation.getName() + ".");
                }
                definedOperation.setIsTimeWarp(operationMetadata.isTimeWarp());
                OperationDefinitionImpl.registerOperationDefinition(definedOperation);
                for (String alias : operationMetadata.aliases()) {
                    definitionsByName.put(alias, definedOperation);
                }
                ++registered;
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return registered;
    }

    public static final boolean registerOperationDefinition(OperationDefinition definedOperation) throws NullPointerException {
        if (definedOperation == null) {
            throw new NullPointerException("Cannot register a new operation definition using a null value.");
        }
        boolean alreadyContained = definitionsById.containsKey(definedOperation.getAUID());
        definitionsByName.put(definedOperation.getName(), definedOperation);
        definitionsByName.put("OperationDef_" + definedOperation.getName(), definedOperation);
        definitionsById.put(definedOperation.getAUID(), definedOperation);
        return alreadyContained;
    }

    public static final OperationDefinition forName(String operationName) throws NullPointerException {
        if (operationName == null) {
            throw new NullPointerException("Cannot retrieve a operation definition with a null name.");
        }
        return definitionsByName.get(operationName);
    }

    public static final OperationDefinition forIdentification(AUID identification) throws NullPointerException {
        if (identification == null) {
            throw new NullPointerException("Cannot retrieve a operation definition with a null identification.");
        }
        return definitionsById.get(identification);
    }

    public static final OperationDefinition forAUID(AUID identification) throws NullPointerException {
        return OperationDefinitionImpl.forIdentification(identification);
    }

    public static final Collection<String> inventory() {
        TreeSet<String> inventory = new TreeSet<String>();
        for (AUID definitionID : definitionsById.keySet()) {
            inventory.add(definitionsById.get(definitionID).getName());
        }
        return inventory;
    }

    public static final int count() {
        return definitionsById.size();
    }

    public OperationDefinitionImpl() {
    }

    public OperationDefinitionImpl(AUID identifier, @AAFString String name, DataDefinition dataDefinition, int numInputs) throws NullPointerException {
        if (identifier == null) {
            throw new NullPointerException("Cannot create an operation definition with a null id.");
        }
        if (dataDefinition == null) {
            throw new NullPointerException("Cannot create an operation definition with a null data definition.");
        }
        this.setAUID(identifier);
        this.setName(name);
        this.setOperationDataDefinition(dataDefinition);
        this.setOperationInputCount(numInputs);
    }

    @Override
    @MediaSetAdd(value="OperationParametersDefined")
    public void addParameterDefinition(ParameterDefinition parameterDefinition) throws NullPointerException, ObjectAlreadyAttachedException {
        if (parameterDefinition == null) {
            throw new NullPointerException("Cannot add a null parameter definition to this operation definition.");
        }
        if (this.operationParametersDefined.contains(parameterDefinition)) {
            throw new ObjectAlreadyAttachedException("The given parameter definition is already attached to this operation definition.");
        }
        this.operationParametersDefined.add(parameterDefinition);
    }

    @Override
    @MediaListAppend(value="DegradeTo")
    public void appendDegradeToOperation(OperationDefinition operationDefinition) throws NullPointerException {
        if (operationDefinition == null) {
            throw new NullPointerException("Cannot append a null operation to the list of degrade-to operations.");
        }
        this.degradeTo.append(operationDefinition);
    }

    @Override
    @MediaPropertyCount(value="DegradeTo")
    public int countDegradeToOperations() {
        return this.degradeTo.count();
    }

    @Override
    @MediaPropertyClear(value="DegradeTo")
    public void clearDegradeToOperations() {
        this.degradeTo = new WeakReferenceVector();
    }

    @Override
    @MediaPropertyCount(value="OperationParametersDefined")
    public int countOperationParametersDefined() {
        return this.operationParametersDefined.count();
    }

    @MediaPropertyClear(value="OperationParametersDefined")
    public void clearOperationParametersDefined() {
        this.operationParametersDefined.clear();
    }

    @Override
    @MediaProperty(uuid1=0x5300505, uuid2=0, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 1}, definedName="Bypass", typeName="UInt32", optional=true, uniqueIdentifier=false, pid=7688, symbol="Bypass")
    public int getBypass() throws PropertyNotPresentException {
        if (this.bypass == null) {
            throw new PropertyNotPresentException("The optional bypass property is not present in this operation definition.");
        }
        return this.bypass;
    }

    @Override
    @MediaPropertySetter(value="Bypass")
    public void setBypass(Integer bypass) {
        if (bypass != null && bypass < 0) {
            throw new IllegalArgumentException("Cannot set the bypass value for this operation definition to a negative value.");
        }
        this.bypass = bypass;
    }

    @Override
    @MediaProperty(uuid1=87033098, uuid2=0, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="OperationCategory", typeName="OperationCategoryType", optional=true, uniqueIdentifier=false, pid=7686, symbol="OperationCategory")
    public AUID getOperationCategory() throws PropertyNotPresentException {
        if (this.operationCategory == null) {
            throw new PropertyNotPresentException("The optional operation category is not set for this operation definition.");
        }
        return this.operationCategory.clone();
    }

    @Override
    @MediaPropertySetter(value="OperationCategory")
    public void setOperationCategory(AUID operationCategory) {
        if (operationCategory == null) {
            this.operationCategory = null;
            return;
        }
        this.operationCategory = operationCategory.clone();
    }

    @Override
    @MediaProperty(uuid1=87033097, uuid2=0, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="OperationDataDefinition", aliases={"DataDefinition", "OperationDefinitionDataDefinition"}, typeName="DataDefinitionWeakReference", optional=false, uniqueIdentifier=false, pid=7681, symbol="OperationDataDefinition")
    public DataDefinition getOperationDataDefinition() {
        return this.operationDataDefinition.getTarget();
    }

    @Override
    @MediaPropertySetter(value="OperationDataDefinition")
    public void setOperationDataDefinition(DataDefinition operationDdataDefinition) throws NullPointerException {
        if (operationDdataDefinition == null) {
            throw new NullPointerException("Cannot set the data definition of the operation definition with a null value.");
        }
        this.operationDataDefinition = new WeakReference<DataDefinition>(operationDdataDefinition);
    }

    public static final DataDefinition initializeOperationDataDefinition() {
        return DataDefinitionImpl.forName("Unknown");
    }

    @MediaProperty(uuid1=100729092, uuid2=1025, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="DegradeTo", typeName="OperationDefinitionWeakReferenceVector", optional=true, uniqueIdentifier=false, pid=7683, symbol="DegradeTo")
    public List<OperationDefinition> getDegradeToOperations() throws PropertyNotPresentException {
        if (this.degradeTo.count() == 0) {
            throw new PropertyNotPresentException("No degrade to operations are present for this operation definition.");
        }
        return this.degradeTo.getOptionalList();
    }

    @Override
    @MediaProperty(uuid1=87033092, uuid2=0, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 1}, definedName="OperationInputCount", aliases={"NumberInputs"}, typeName="Int32", optional=false, uniqueIdentifier=false, pid=7687, symbol="OperationInputCount")
    public int getOperationInputCount() {
        return this.operationInputCount;
    }

    @Override
    @MediaPropertySetter(value="OperationInputCount")
    public void setOperationInputCount(int operationInputCount) {
        this.operationInputCount = operationInputCount;
    }

    public static final int initializeOperationInputCount() {
        return 0;
    }

    @MediaProperty(uuid1=100729092, uuid2=770, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="OperationParametersDefined", aliases={"ParametersDefined", "ParameterDefinitions"}, typeName="ParameterDefinitionWeakReferenceSet", optional=true, uniqueIdentifier=false, pid=7689, symbol="OperationParametersDefined")
    public Set<ParameterDefinition> getOperationParametersDefined() throws PropertyNotPresentException {
        if (this.operationParametersDefined.count() == 0) {
            throw new PropertyNotPresentException("No parameter definitions are present in this operation definition.");
        }
        return this.operationParametersDefined.getOptionalSet();
    }

    @Override
    @MediaListInsertAt(value="DegradeTo")
    public void insertDegradeToOperationAt(int index, OperationDefinition operationDefinition) throws NullPointerException, IndexOutOfBoundsException {
        if (operationDefinition == null) {
            throw new NullPointerException("Cannot insert a null operation into the list of operation definitions.");
        }
        try {
            this.degradeTo.insert(index, operationDefinition);
        }
        catch (IndexOutOfBoundsException ioobe) {
            throw new IndexOutOfBoundsException("The given index is out of bounds for the current list of degrade operations.");
        }
    }

    @Override
    public boolean isTimeWarp() {
        return this.getIsTimeWarp();
    }

    @Override
    @MediaProperty(uuid1=0x5300503, uuid2=0, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 1}, definedName="IsTimeWarp", typeName="Boolean", optional=true, uniqueIdentifier=false, pid=7682, symbol="IsTimeWarp")
    public boolean getIsTimeWarp() {
        if (this.isTimeWarp == null) {
            return false;
        }
        return this.isTimeWarp;
    }

    @Override
    @MediaPropertySetter(value="IsTimeWarp")
    public void setIsTimeWarp(Boolean isTimeWarp) {
        this.isTimeWarp = isTimeWarp;
    }

    @Override
    public ParameterDefinition lookupOperationParameter(AUID parameterDefinition) throws NullPointerException, ObjectNotFoundException {
        if (parameterDefinition == null) {
            throw new NullPointerException("Cannot look for a parameter definition for an operation with a null value.");
        }
        for (ParameterDefinition definition : this.operationParametersDefined.getRequiredSet()) {
            if (!definition.getAUID().equals(parameterDefinition)) continue;
            return definition;
        }
        throw new ObjectNotFoundException("A parameter definition with the given id could not be found in this operation definition.");
    }

    @Override
    @MediaListPrepend(value="DegradeTo")
    public void prependDegradeToOperation(OperationDefinition operationDefinition) throws NullPointerException {
        if (operationDefinition == null) {
            throw new NullPointerException("Cannot prepend a null operation definition to the list of degrade to operations.");
        }
        this.degradeTo.prepend(operationDefinition);
    }

    @Override
    @MediaListRemoveAt(value="DegradeTo")
    public void removeDegradeToOperationAt(int index) throws IndexOutOfBoundsException {
        try {
            this.degradeTo.removeAt(index);
        }
        catch (IndexOutOfBoundsException ioobe) {
            throw new IndexOutOfBoundsException("The given index is outside the range of acceptable indexes for the current list of degrade to operations.");
        }
    }

    @Override
    public OperationDefinition clone() {
        return (OperationDefinition)super.clone();
    }

    public String getOperationCategoryString() {
        return AUIDImpl.toPersistentForm(this.operationCategory);
    }

    public void setOperationCategoryString(String operationCategory) {
        this.operationCategory = AUIDImpl.fromPersistentForm(operationCategory);
    }

    static {
        OperationDefinitionImpl.registerOperationsFromClass(OperationConstant.class);
    }
}

