/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.io.mxf.impl;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import tv.amwa.maj.industry.MetadataObject;
import tv.amwa.maj.industry.PropertyValue;
import tv.amwa.maj.meta.ClassDefinition;
import tv.amwa.maj.meta.PropertyDefinition;
import tv.amwa.maj.meta.impl.TypeDefinitionObjectReferenceImpl;
import tv.amwa.maj.meta.impl.TypeDefinitionSetImpl;
import tv.amwa.maj.meta.impl.TypeDefinitionVariableArrayImpl;
import tv.amwa.maj.record.AUID;
import tv.amwa.maj.record.impl.AUIDImpl;

public class ResolutionEntry {
    private PropertyDefinition property;
    private MetadataObject target;
    private PropertyValue unresolvedValue;

    public ResolutionEntry(PropertyDefinition property, MetadataObject target, PropertyValue unresolvedValue) {
        this.property = property;
        this.target = target;
        this.unresolvedValue = unresolvedValue;
    }

    public boolean resolve(Map<AUIDImpl, MetadataObject> referenceTable) {
        boolean resolutionComplete = true;
        switch (this.property.getTypeDefinition().getTypeCategory()) {
            case WeakObjRef: {
                PropertyValue resolvedReference = ResolutionEntry.resolveReference(this.unresolvedValue, referenceTable);
                if (resolvedReference != null) {
                    this.property.setPropertyValue(this.target, resolvedReference);
                    return true;
                }
                return true;
            }
            case StrongObjRef: {
                PropertyValue resolvedReference = ResolutionEntry.resolveReference(this.unresolvedValue, referenceTable);
                if (resolvedReference != null) {
                    try {
                        Field injectionPoint = ResolutionEntry.findInjectionPoint(this.property);
                        injectionPoint.setAccessible(true);
                        injectionPoint.set(this.target, resolvedReference.getValue());
                    }
                    catch (Exception e) {
                        System.err.println("Could not inject a value into property " + this.property.getName() + ".");
                        this.property.setPropertyValue(this.target, resolvedReference);
                    }
                    return true;
                }
                System.err.println("Cannot resolve strong reference for property " + this.property.getName() + ".");
                return false;
            }
            case Set: {
                Set<PropertyValue> unresolvedValues = ((TypeDefinitionSetImpl)this.unresolvedValue.getType()).getElements(this.unresolvedValue);
                HashSet<PropertyValue> resolvedValues = new HashSet<PropertyValue>(unresolvedValues.size());
                HashSet<Object> injectionSet = new HashSet<Object>(unresolvedValues.size());
                for (PropertyValue element : unresolvedValues) {
                    PropertyValue resolvedReference = ResolutionEntry.resolveReference(element, referenceTable);
                    if (resolvedReference != null) {
                        resolvedValues.add(resolvedReference);
                        injectionSet.add(resolvedReference.getValue());
                        continue;
                    }
                    System.err.println("Unable to resolve a set reference for property " + this.property.getName() + ".");
                    resolutionComplete = false;
                }
                try {
                    Field injectionPoint = ResolutionEntry.findInjectionPoint(this.property);
                    injectionPoint.setAccessible(true);
                    injectionPoint.set(this.target, injectionSet);
                }
                catch (Exception e) {
                    System.err.println("Could not inject a value into property " + this.property.getName() + ".");
                    this.property.setPropertyValue(this.target, this.property.getTypeDefinition().createValue(resolvedValues));
                }
                return resolutionComplete;
            }
            case VariableArray: {
                List<PropertyValue> unresolvedListValues = ((TypeDefinitionVariableArrayImpl)this.unresolvedValue.getType()).getElements(this.unresolvedValue);
                Vector<PropertyValue> resolvedListValues = new Vector<PropertyValue>(unresolvedListValues.size());
                Vector<Object> injectionList = new Vector<Object>(unresolvedListValues.size());
                for (PropertyValue element : unresolvedListValues) {
                    PropertyValue resolvedReference = ResolutionEntry.resolveReference(element, referenceTable);
                    if (resolvedReference != null) {
                        resolvedListValues.add(resolvedReference);
                        injectionList.add(resolvedReference.getValue());
                        continue;
                    }
                    System.err.println("Unable to resolve a variable array reference for property " + this.property.getName() + ".");
                    resolutionComplete = false;
                }
                try {
                    Field injectionPoint = ResolutionEntry.findInjectionPoint(this.property);
                    injectionPoint.setAccessible(true);
                    injectionPoint.set(this.target, injectionList);
                }
                catch (Exception e) {
                    System.err.println("Could not inject a value into property " + this.property.getName() + ".");
                    this.property.setPropertyValue(this.target, this.property.getTypeDefinition().createValue(resolvedListValues));
                }
                return resolutionComplete;
            }
        }
        return true;
    }

    private static final PropertyValue resolveReference(PropertyValue unresolvedReference, Map<AUIDImpl, MetadataObject> referenceTable) {
        if (unresolvedReference instanceof TypeDefinitionObjectReferenceImpl.UnresolvedReferenceValue) {
            TypeDefinitionObjectReferenceImpl.UnresolvedReferenceValue unresolvedProperty = (TypeDefinitionObjectReferenceImpl.UnresolvedReferenceValue)unresolvedReference;
            AUID instanceID = unresolvedProperty.getValue();
            MetadataObject referencedBaseValue = referenceTable.get(instanceID);
            if (referencedBaseValue == null) {
                try {
                    Class<?> baseClassImplementation = ((TypeDefinitionObjectReferenceImpl)unresolvedProperty.getType()).getObjectType().getJavaImplementation();
                    Method forIdentification = baseClassImplementation.getMethod("forIdentification", AUID.class);
                    referencedBaseValue = (MetadataObject)forIdentification.invoke(null, instanceID);
                }
                catch (Exception e) {
                    return null;
                }
            }
            if (referencedBaseValue == null) {
                return null;
            }
            PropertyValue referencedValue = unresolvedReference.getType().createValue(referencedBaseValue);
            return referencedValue;
        }
        return null;
    }

    private static final Field findInjectionPoint(PropertyDefinition property) {
        try {
            ClassDefinition memberOf = property.getMemberOf();
            Class<?> memberClass = memberOf.getJavaImplementation();
            return memberClass.getDeclaredField(Character.toLowerCase(property.getName().charAt(0)) + property.getName().substring(1));
        }
        catch (NoSuchFieldException nsfe) {
            return null;
        }
    }
}

