/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.io.aaf;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.Entry;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.w3c.dom.Node;
import tv.amwa.maj.enumeration.ByteOrder;
import tv.amwa.maj.exception.EndOfDataException;
import tv.amwa.maj.industry.Stream;
import tv.amwa.maj.io.xml.XMLSerializable;

public class AAFStream
implements Stream,
Cloneable,
Serializable,
XMLSerializable {
    private static final long serialVersionUID = 3734599745445480486L;
    private String ssPath;
    private String fileName;
    private ByteOrder byteOrder;
    private long position = 0L;
    private long limit = -1L;
    private static Map<String, FileInputStream> fileStreams = Collections.synchronizedMap(new HashMap());

    public AAFStream() {
    }

    public AAFStream(String ssPath, String canonicalFileName, ByteOrder byteOrder) throws NullPointerException {
        if (ssPath == null) {
            throw new NullPointerException("Cannot create an AAF stream using a null structured storage path.");
        }
        if (canonicalFileName == null) {
            throw new NullPointerException("Cannot create an AAF stream using a null file name.");
        }
        if (byteOrder == null) {
            throw new NullPointerException("Cannot create an AAF stream without specification of the byte order of the stream.");
        }
        this.ssPath = ssPath;
        this.fileName = canonicalFileName;
        this.byteOrder = byteOrder;
    }

    public AAFStream(URI streamReference) {
    }

    @Override
    public void close() {
        FileInputStream fis;
        if (fileStreams.containsKey(this.fileName) && (fis = fileStreams.get(this.fileName)) != null) {
            try {
                fis.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            fileStreams.remove(this.fileName);
        }
    }

    public void open() throws IOException {
        if (!fileStreams.containsKey(this.fileName)) {
            FileInputStream fis = new FileInputStream(this.fileName);
            fileStreams.put(this.fileName, fis);
        }
    }

    public DocumentEntry getDocumentEntry() throws IOException {
        FileInputStream fis;
        if (!fileStreams.containsKey(this.fileName)) {
            this.open();
        }
        if ((fis = fileStreams.get(this.fileName)) == null) {
            return null;
        }
        POIFSFileSystem poifsfs = new POIFSFileSystem((InputStream)fis);
        StringTokenizer tokenizer = new StringTokenizer(this.ssPath, File.separator);
        DirectoryNode currentDir = poifsfs.getRoot();
        Entry nextEntry = null;
        while (tokenizer.hasMoreElements()) {
            nextEntry = currentDir.getEntry(tokenizer.nextToken());
            if (!(nextEntry instanceof DirectoryEntry)) continue;
            currentDir = (DirectoryEntry)nextEntry;
        }
        if (!(nextEntry instanceof DocumentEntry)) {
            return null;
        }
        return (DocumentEntry)nextEntry;
    }

    public DocumentInputStream getDocumentInputStream() throws IOException {
        return new DocumentInputStream(this.getDocumentEntry());
    }

    @Override
    public long getLength() throws IOException {
        long length = this.getDocumentEntry().getSize();
        if (this.limit == -1L) {
            this.limit = length;
        }
        return length;
    }

    @Override
    public long getLimit() throws IOException {
        if (this.limit == -1L) {
            this.limit = this.getLength();
        }
        return this.limit;
    }

    @Override
    public long getPosition() throws IOException {
        return this.position;
    }

    @Override
    public ByteBuffer read(int noOfBytes) throws EndOfDataException, IOException, IllegalArgumentException {
        DocumentInputStream dis = this.getDocumentInputStream();
        long actualSkip = dis.skip(this.position);
        if (actualSkip < this.position) {
            throw new EndOfDataException("Position plus length is longer than the AAF stream.");
        }
        byte[] bytes = new byte[noOfBytes];
        this.position += (long)dis.read(bytes);
        return ByteBuffer.wrap(bytes);
    }

    @Override
    public void setLimit(long limit) throws IllegalArgumentException {
        if (limit < 0L) {
            throw new IllegalArgumentException("Cannot set the limit to a negative value.");
        }
        try {
            if (limit > this.getLength()) {
                throw new IllegalArgumentException("Cannot set the limit greater than the length.");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.limit = limit;
    }

    @Override
    public void setPosition(long position) throws IllegalArgumentException, IOException {
        if (position < 0L) {
            throw new IllegalArgumentException("Cannot set the position to a negative value.");
        }
        if (position > this.getLimit()) {
            throw new IllegalArgumentException("Cannot set the position beyond the limit for this AAF stream.");
        }
        this.position = position;
    }

    @Override
    public int write(ByteBuffer buffer) throws EndOfDataException, IOException {
        return 0;
    }

    @Override
    public AAFStream clone() {
        try {
            return (AAFStream)super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new InternalError();
        }
    }

    @Override
    public void appendXMLChildren(Node parent) {
    }

    @Override
    public String getComment() {
        return "AAFStream: " + this.ssPath + ", " + this.fileName + ", " + this.byteOrder;
    }

    public String toString() {
        return "<!-- " + this.getComment() + " -->";
    }

    @Override
    public URI getStreamURI() {
        return null;
    }

    @Override
    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }
}

