/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.model.impl;

import java.io.Serializable;
import tv.amwa.maj.exception.PropertyNotPresentException;
import tv.amwa.maj.industry.MediaClass;
import tv.amwa.maj.industry.MediaProperty;
import tv.amwa.maj.industry.MediaPropertySetter;
import tv.amwa.maj.integer.UInt32;
import tv.amwa.maj.model.HTMLClip;
import tv.amwa.maj.model.impl.DataDefinitionImpl;
import tv.amwa.maj.model.impl.TextClipImpl;
import tv.amwa.maj.record.PackageID;

@MediaClass(uuid1=0xD010101, uuid2=257, uuid3=4864, uuid4={6, 14, 43, 52, 2, 6, 1, 1}, definedName="HTMLClip", description="Reference to HTML text essence.", symbol="HTMLClip")
public class HTMLClipImpl
extends TextClipImpl
implements HTMLClip,
Serializable,
Cloneable {
    private static final long serialVersionUID = -4233608050787321967L;
    private String beginAnchor = null;
    private String endAnchor = null;

    public HTMLClipImpl() {
    }

    public HTMLClipImpl(PackageID sourceID, @UInt32 int sourceTrackID) throws NullPointerException, IllegalArgumentException {
        if (sourceID == null) {
            throw new NullPointerException("Cannot create an HTML clip with a null source id.");
        }
        if (sourceTrackID < 0) {
            throw new IllegalArgumentException("Cannot create an HTML clip with a negative track id reference.");
        }
        this.setComponentDataDefinition(DataDefinitionImpl.forIdentification(DataDefinitionImpl.Auxiliary));
        this.setLengthPresent(false);
        this.setSourcePackageID(sourceID);
        this.setSourceTrackID(sourceTrackID);
    }

    @Override
    @MediaProperty(uuid1=87033345, uuid2=256, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="BeginAnchor", typeName="UTF16String", optional=true, uniqueIdentifier=false, pid=5121, symbol="BeginAnchor")
    public String getBeginAnchor() throws PropertyNotPresentException {
        if (this.beginAnchor == null) {
            throw new PropertyNotPresentException("The optional begin anchor property is not present in this HTML clip.");
        }
        return this.beginAnchor;
    }

    @Override
    @MediaPropertySetter(value="BeginAnchor")
    public void setBeginAnchor(String beginAnchor) {
        this.beginAnchor = beginAnchor;
    }

    @Override
    @MediaProperty(uuid1=87033346, uuid2=256, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="EndAnchor", typeName="UTF16String", optional=true, uniqueIdentifier=false, pid=5122, symbol="EndAnchor")
    public String getEndAnchor() throws PropertyNotPresentException {
        if (this.endAnchor == null) {
            throw new PropertyNotPresentException("The optional end anchor property is not present in this HTML clip.");
        }
        return this.endAnchor;
    }

    @Override
    @MediaPropertySetter(value="EndAnchor")
    public void setEndAnchor(String endAnchor) {
        this.endAnchor = endAnchor;
    }

    @Override
    public HTMLClip clone() {
        return (HTMLClip)super.clone();
    }
}

