/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.model.impl;

import java.io.Serializable;
import tv.amwa.maj.enumeration.AuxBitsModeType;
import tv.amwa.maj.enumeration.ChannelStatusModeType;
import tv.amwa.maj.enumeration.EmphasisType;
import tv.amwa.maj.enumeration.UserDataModeType;
import tv.amwa.maj.exception.BadSizeException;
import tv.amwa.maj.industry.MediaClass;
import tv.amwa.maj.industry.MediaListGetAt;
import tv.amwa.maj.industry.MediaProperty;
import tv.amwa.maj.industry.MediaPropertyClear;
import tv.amwa.maj.industry.MediaPropertyCount;
import tv.amwa.maj.industry.MediaPropertySetter;
import tv.amwa.maj.integer.UInt16;
import tv.amwa.maj.integer.UInt32;
import tv.amwa.maj.io.xml.XMLSerializable;
import tv.amwa.maj.model.AES3PCMDescriptor;
import tv.amwa.maj.model.ContainerDefinition;
import tv.amwa.maj.model.impl.WAVEPCMDescriptorImpl;
import tv.amwa.maj.record.Rational;

@MediaClass(uuid1=0xD010101, uuid2=257, uuid3=18176, uuid4={6, 14, 43, 52, 2, 6, 1, 1}, definedName="AES3PCMDescriptor", description="Describes audio essence in the AES3 audio file format.", symbol="AES3PCMDescriptor")
public class AES3PCMDescriptorImpl
extends WAVEPCMDescriptorImpl
implements AES3PCMDescriptor,
Serializable,
XMLSerializable,
Cloneable {
    private static final long serialVersionUID = -3658407306887688052L;
    private EmphasisType emphasis = null;
    private Short blockStartOffset = null;
    private AuxBitsModeType auxBitsMode = null;
    private ChannelStatusModeType[] channelStatusMode = null;
    private byte[][] fixedChannelStatusData = null;
    private UserDataModeType[] userDataMode = null;
    private byte[][] fixedUserData = null;

    public AES3PCMDescriptorImpl() {
        this.setChannelCount(1);
    }

    public AES3PCMDescriptorImpl(ContainerDefinition containerFormat, Rational audioSamplingRate, @UInt32 int channels, @UInt32 int quantizationBits, @UInt16 short blockAlign, @UInt32 int averageBPS) throws NullPointerException, IllegalArgumentException {
        super(containerFormat, audioSamplingRate, channels, quantizationBits, blockAlign, averageBPS);
    }

    @Override
    @MediaProperty(uuid1=67241217, uuid2=256, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 5}, definedName="AuxBitsMode", typeName="AuxBitsModeType", optional=true, uniqueIdentifier=false, pid=15624, symbol="AuxBitsMode")
    public AuxBitsModeType getAuxBitsMode() {
        if (this.auxBitsMode == null) {
            return AUXBITSMODE_DEFAULT;
        }
        return this.auxBitsMode;
    }

    @Override
    @MediaPropertySetter(value="AuxBitsMode")
    public void setAuxBitsMode(AuxBitsModeType auxBitsMode) {
        this.auxBitsMode = auxBitsMode == null ? null : auxBitsMode;
    }

    @Override
    @MediaProperty(uuid1=67240706, uuid2=768, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 5}, definedName="BlockStartOffset", typeName="UInt16", optional=true, uniqueIdentifier=false, pid=15631, symbol="BlockStartOffset")
    public short getBlockStartOffset() {
        if (this.blockStartOffset == null) {
            return 0;
        }
        return this.blockStartOffset;
    }

    @Override
    @MediaPropertySetter(value="BlockStartOffset")
    public void setBlockStartOffset(Short blockStartOffset) throws IllegalArgumentException {
        if (blockStartOffset == null) {
            this.blockStartOffset = null;
            return;
        }
        if (blockStartOffset < 0) {
            throw new IllegalArgumentException("Cannot set the block start offset of this AES3 PCM descriptor to a negative value.");
        }
        this.blockStartOffset = blockStartOffset;
    }

    @Override
    @MediaProperty(uuid1=67241217, uuid2=512, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 5}, definedName="ChannelStatusMode", typeName="ChannelStatusModeArray", optional=true, uniqueIdentifier=false, pid=15632, symbol="ChannelStatusMode")
    public ChannelStatusModeType[] getChannelStatusMode() {
        if (this.channelStatusMode == null) {
            ChannelStatusModeType[] defaultStatus = new ChannelStatusModeType[this.getChannelCount()];
            for (int x = 0; x < defaultStatus.length; ++x) {
                defaultStatus[x] = ChannelStatusModeType.None;
            }
            return defaultStatus;
        }
        return (ChannelStatusModeType[])this.channelStatusMode.clone();
    }

    @MediaPropertySetter(value="ChannelStatusMode")
    public void setChannelStatusMode(ChannelStatusModeType[] channelStatusMode) throws NullPointerException, BadSizeException {
        if (channelStatusMode == null) {
            this.channelStatusMode = null;
            return;
        }
        if (channelStatusMode.length != this.getChannelCount()) {
            throw new BadSizeException("The array of channel status mode values must be the same length as the number of channels of this AES3PCMDescriptor.");
        }
        this.channelStatusMode = new ChannelStatusModeType[channelStatusMode.length];
        for (int x = 0; x < channelStatusMode.length; ++x) {
            if (channelStatusMode[x] == null) {
                throw new NullPointerException("Cannot set the channel status mode for channel " + x + " to a null value for this AES3 PCM descriptor.");
            }
            this.channelStatusMode[x] = channelStatusMode[x];
        }
    }

    @Override
    @MediaListGetAt(value="ChannelStatusMode")
    public ChannelStatusModeType getChannelStatusModeAt(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.getChannelCount()) {
            throw new IndexOutOfBoundsException("The given channel index is outside the acceptable range for a AES3 PCM descriptor describing audio with " + this.getChannelCount() + " channels.");
        }
        if (this.channelStatusMode == null) {
            return ChannelStatusModeType.None;
        }
        return this.channelStatusMode[index];
    }

    @Override
    public void setChannelStatusModeAt(int index, ChannelStatusModeType channelStatusMode) throws IndexOutOfBoundsException {
        if (channelStatusMode == null) {
            throw new NullPointerException("Cannot set an element of the channel status mode array to null for this AES3 PCM descriptor.");
        }
        if (index < 0 || index >= this.getChannelCount()) {
            throw new IndexOutOfBoundsException("The given channel index is outside the acceptable range for a AES3 PCM descriptor describing audio with " + this.getChannelCount() + " channels.");
        }
        if (this.channelStatusMode == null) {
            this.channelStatusMode = new ChannelStatusModeType[this.getChannelCount()];
            for (int x = 0; x < this.channelStatusMode.length; ++x) {
                this.channelStatusMode[x] = ChannelStatusModeType.None;
            }
        }
        this.channelStatusMode[index] = channelStatusMode;
    }

    @MediaPropertyCount(value="ChannelStatusMode")
    public int countChannelStatusMode() {
        if (this.channelStatusMode != null) {
            return this.channelStatusMode.length;
        }
        return 0;
    }

    @MediaPropertyClear(value="ChannelStatusMode")
    public void clearChannelStatusMode() {
        this.channelStatusMode = null;
    }

    @Override
    @MediaProperty(uuid1=67241217, uuid2=1536, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 5}, definedName="Emphasis", typeName="EmphasisType", optional=true, uniqueIdentifier=false, pid=15629, symbol="Emphasis")
    public EmphasisType getEmphasis() {
        if (this.emphasis == null) {
            return EMPHASIS_DEFAULT;
        }
        return this.emphasis;
    }

    @Override
    @MediaPropertySetter(value="Emphasis")
    public void setEmphasis(EmphasisType emphasisType) {
        this.emphasis = emphasisType;
    }

    @Override
    @MediaProperty(uuid1=67241217, uuid2=768, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 5}, definedName="FixedChannelStatusData", typeName="UInt8Array", optional=true, uniqueIdentifier=false, pid=15633, symbol="FixedChannelStatusData")
    public byte[] getFixedChannelStatusData() {
        byte[] persistentStatusData = new byte[this.getChannelCount() * 24];
        if (this.fixedChannelStatusData == null) {
            for (int x = 0; x < this.getChannelCount(); ++x) {
                System.arraycopy(AES3Minimum, 0, persistentStatusData, x * 24, 24);
            }
        } else {
            for (int x = 0; x < this.getChannelCount(); ++x) {
                System.arraycopy(this.fixedChannelStatusData[x], 0, persistentStatusData, x * 24, 24);
            }
        }
        return persistentStatusData;
    }

    @MediaPropertySetter(value="FixedChannelStatusData")
    public void setFixedChannelStatusData(byte[] fixedChannelStatusData) throws BadSizeException {
        if (fixedChannelStatusData == null) {
            this.fixedChannelStatusData = null;
            return;
        }
        if (fixedChannelStatusData.length < this.getChannelCount() * 24) {
            throw new BadSizeException("The fixed channel status data must contain exactly 24-bytes per channel.");
        }
        this.fixedChannelStatusData = new byte[this.getChannelCount()][24];
        for (int x = 0; x < this.getChannelCount(); ++x) {
            System.arraycopy(fixedChannelStatusData, 24 * x, this.fixedChannelStatusData[x], 0, 24);
        }
    }

    @MediaPropertyClear(value="FixedChannelStatusData")
    public void clearFixedChannelStatusData() {
        this.fixedChannelStatusData = null;
    }

    @Override
    public byte[] getFixedChannelStatusDataAt(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.getChannelCount()) {
            throw new IndexOutOfBoundsException("The given index is outside the acceptable range for an AES3 PCM descriptor with " + this.getChannelCount() + " channels.");
        }
        if (this.fixedChannelStatusData == null) {
            return (byte[])AES3Minimum.clone();
        }
        return (byte[])this.fixedChannelStatusData[index].clone();
    }

    @Override
    public void setFixedChannelStatusDataAt(int index, byte[] fixedChannelStatusData) throws NullPointerException, IndexOutOfBoundsException, BadSizeException {
        if (index < 0 || index >= this.getChannelCount()) {
            throw new IndexOutOfBoundsException("The given index is outside the acceptable range for an AES3 PCM descriptor with " + this.getChannelCount() + " channels.");
        }
        if (fixedChannelStatusData == null) {
            throw new NullPointerException("Cannot set fixed channel status data using a null value for this AES3 PCM Descriptor.");
        }
        if (fixedChannelStatusData.length != 24) {
            throw new BadSizeException("The given fixed channel status data must be exactly 24-bytes in length.");
        }
        if (this.fixedChannelStatusData == null) {
            this.fixedChannelStatusData = new byte[this.getChannelCount()][24];
            for (int x = 0; x < this.fixedChannelStatusData.length; ++x) {
                this.fixedChannelStatusData[x] = (byte[])AES3Minimum.clone();
            }
        }
        System.arraycopy(fixedChannelStatusData, 0, this.fixedChannelStatusData[index], 0, 24);
    }

    @Override
    public void omitChannelStatusData() {
        this.fixedChannelStatusData = null;
        this.channelStatusMode = null;
    }

    @Override
    @MediaProperty(uuid1=67241217, uuid2=1280, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 5}, definedName="FixedUserData", typeName="UInt8Array", optional=true, uniqueIdentifier=false, pid=15635, symbol="FixedUserData")
    public byte[] getFixedUserData() {
        byte[] persistentUserData = new byte[this.getChannelCount() * 24];
        if (this.fixedUserData == null) {
            for (int x = 0; x < this.getChannelCount(); ++x) {
                System.arraycopy(AES3DefaultUserData, 0, persistentUserData, x * 24, 24);
            }
        } else {
            for (int x = 0; x < this.getChannelCount(); ++x) {
                System.arraycopy(this.fixedUserData[x], 0, persistentUserData, x * 24, 24);
            }
        }
        return persistentUserData;
    }

    @MediaPropertySetter(value="FixedUserData")
    public void setFixedUserData(byte[] fixedUserData) throws BadSizeException {
        if (fixedUserData == null) {
            this.fixedUserData = null;
            return;
        }
        if (this.getChannelCount() == 0) {
            this.fixedUserData = new byte[1][fixedUserData.length];
            this.fixedUserData[0] = (byte[])fixedUserData.clone();
            return;
        }
        if (fixedUserData.length < this.getChannelCount() * 24) {
            throw new BadSizeException("The fixed user data byte array must contain exactly 24-bytes per channel.");
        }
        this.fixedUserData = new byte[this.getChannelCount()][24];
        for (int x = 0; x < this.getChannelCount(); ++x) {
            System.arraycopy(fixedUserData, x * 24, this.fixedUserData[x], 0, 24);
        }
    }

    @MediaPropertyClear(value="FixedUserData")
    public void clearFixedUserData() {
        this.fixedUserData = null;
    }

    @Override
    public byte[] getFixedUserDataAt(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.getChannelCount()) {
            throw new IndexOutOfBoundsException("The given index is outside the acceptable range for this AES3 PCM descriptor for audio essence with " + this.getChannelCount() + " channels.");
        }
        if (this.fixedUserData == null) {
            return (byte[])AES3DefaultUserData.clone();
        }
        return (byte[])this.fixedUserData[index].clone();
    }

    @Override
    public void setFixedUserDataAt(int index, byte[] fixedUserData) throws NullPointerException, IndexOutOfBoundsException, BadSizeException {
        if (index < 0 || index >= this.getChannelCount()) {
            throw new IndexOutOfBoundsException("The given index is outside the acceptable range for this AES3 PCM descriptor for audio essence with " + this.getChannelCount() + " channels.");
        }
        if (fixedUserData == null) {
            throw new NullPointerException("Cannot set the fixed user data for a channel using a null value for this AES3 PCM descriptor.");
        }
        if (fixedUserData.length != 24) {
            throw new BadSizeException("The size of the fixed user data array must be exactly 24-bytes.");
        }
        if (this.fixedUserData == null) {
            this.fixedUserData = new byte[this.getChannelCount()][24];
            for (int x = 0; x < this.fixedUserData.length; ++x) {
                this.fixedUserData[x] = (byte[])AES3DefaultUserData.clone();
            }
        }
        System.arraycopy(fixedUserData, 0, this.fixedUserData[index], 0, 24);
    }

    @Override
    @MediaProperty(uuid1=67241217, uuid2=1024, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 5}, definedName="UserDataMode", typeName="UserDataModeArray", optional=true, uniqueIdentifier=false, pid=15634, symbol="UserDataMode")
    public UserDataModeType[] getUserDataMode() {
        if (this.userDataMode == null) {
            UserDataModeType[] defaultMode = new UserDataModeType[this.getChannelCount()];
            for (int x = 0; x < defaultMode.length; ++x) {
                defaultMode[x] = UserDataModeType.NotDefined;
            }
            return defaultMode;
        }
        return (UserDataModeType[])this.userDataMode.clone();
    }

    @MediaPropertySetter(value="UserDataMode")
    public void setUserDataMode(UserDataModeType[] userDataMode) throws NullPointerException, BadSizeException {
        if (userDataMode == null) {
            this.userDataMode = null;
            return;
        }
        if (userDataMode.length != this.getChannelCount()) {
            throw new BadSizeException("The number of elements in the user data mode array must be the same as the number of channels of the described AES3 PCM essence.");
        }
        this.userDataMode = new UserDataModeType[userDataMode.length];
        for (int x = 0; x < userDataMode.length; ++x) {
            if (userDataMode[x] == null) {
                throw new NullPointerException("Cannot set the value of the user data mode for channel " + x + " to a null value for this AES3 PCM descriptor.");
            }
            this.userDataMode[x] = userDataMode[x];
        }
    }

    @MediaPropertyClear(value="UserDataMode")
    public void clearUserDataMode() {
        this.userDataMode = null;
    }

    @Override
    public UserDataModeType getUserDataModeAt(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.getChannelCount()) {
            throw new IndexOutOfBoundsException("The given index is outside the acceptable range for an AES3 PCM descriptor for essence with " + this.getChannelCount() + " channels.");
        }
        if (this.userDataMode == null) {
            return UserDataModeType.NotDefined;
        }
        return this.userDataMode[index];
    }

    @Override
    public void setUserDataModeAt(int index, UserDataModeType userDataMode) throws NullPointerException, IndexOutOfBoundsException {
        if (index < 0 || index >= this.getChannelCount()) {
            throw new IndexOutOfBoundsException("The given index is outside the acceptable range for an AES3 PCM descriptor for essence with " + this.getChannelCount() + " channels.");
        }
        if (userDataMode == null) {
            throw new NullPointerException("Cannot set the user data mode for any channel to null for this AES3 PCM descriptor.");
        }
        if (this.userDataMode == null) {
            this.userDataMode = new UserDataModeType[this.getChannelCount()];
            for (int x = 0; x < this.userDataMode.length; ++x) {
                this.userDataMode[x] = UserDataModeType.NotDefined;
            }
        }
        this.userDataMode[index] = userDataMode;
    }

    @Override
    public void omitUserData() {
        this.userDataMode = null;
        this.fixedUserData = null;
    }

    @Override
    public AES3PCMDescriptor clone() {
        return (AES3PCMDescriptor)super.clone();
    }

    @Override
    public String getComment() {
        return "Element yet to be confirmed as valid AAF XML";
    }
}

