/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.io.xml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import tv.amwa.maj.constant.CommonConstants;
import tv.amwa.maj.industry.MediaEngine;
import tv.amwa.maj.industry.Warehouse;
import tv.amwa.maj.io.xml.MetaDictionaryGenerator;
import tv.amwa.maj.io.xml.XMLBuilder;
import tv.amwa.maj.meta.ClassDefinition;
import tv.amwa.maj.meta.MetaDefinition;
import tv.amwa.maj.meta.PropertyDefinition;
import tv.amwa.maj.meta.TypeDefinition;
import tv.amwa.maj.meta.TypeDefinitionCharacter;
import tv.amwa.maj.meta.TypeDefinitionEnumeration;
import tv.amwa.maj.meta.TypeDefinitionExtendibleEnumeration;
import tv.amwa.maj.meta.TypeDefinitionFixedArray;
import tv.amwa.maj.meta.TypeDefinitionIndirect;
import tv.amwa.maj.meta.TypeDefinitionInteger;
import tv.amwa.maj.meta.TypeDefinitionOpaque;
import tv.amwa.maj.meta.TypeDefinitionRecord;
import tv.amwa.maj.meta.TypeDefinitionRename;
import tv.amwa.maj.meta.TypeDefinitionSet;
import tv.amwa.maj.meta.TypeDefinitionStream;
import tv.amwa.maj.meta.TypeDefinitionString;
import tv.amwa.maj.meta.TypeDefinitionStrongObjectReference;
import tv.amwa.maj.meta.TypeDefinitionVariableArray;
import tv.amwa.maj.meta.TypeDefinitionWeakObjectReference;

public class XSDGenerator
implements CommonConstants {
    public static final String XSD_NAMESPACE = "http://www.w3.org/2001/XMLSchema";
    public static final String XSD_PREFIX = "xs";
    public static final String XLINK_NAMESPACE = "http://www.w3.org/1999/xlink";
    public static final String XLINK_PREFIX = "xlink";

    public static final DocumentFragment generateBaslineXSD() {
        MediaEngine.initializeAAF();
        Collection<ClassDefinition> baselineClasses = MetaDictionaryGenerator.makeBaselineClasses();
        return XSDGenerator.generateXSD(baselineClasses, "http://www.smpte-ra.org/schemas/2001-2/2007/aaf", "aaf", "AAF", "Preface");
    }

    public static final String generateBaselineXSDAsAString() {
        return XMLBuilder.transformNodeToString(XSDGenerator.generateBaslineXSD());
    }

    public static final DocumentFragment generateXSD(Collection<ClassDefinition> classes, String targetNamespace, String targetPrefix, String rootElement, String rootClass) throws NullPointerException {
        if (classes == null) {
            throw new NullPointerException("Cannot create a Reg-XML XSD for a null set of class definitions.");
        }
        if (targetNamespace == null) {
            throw new NullPointerException("Cannot create a Reg-XML XSD for a null target namespace.");
        }
        DocumentFragment xsdFragment = XMLBuilder.createDocumentFragment();
        xsdFragment.appendChild(xsdFragment.getOwnerDocument().createComment("Schema generated by the Media Authoring with Java API (MAJ API)"));
        Element schemaElement = XMLBuilder.createChild(xsdFragment, XSD_NAMESPACE, XSD_PREFIX, "schema");
        XMLBuilder.setAttribute(schemaElement, "", "", "targetNamespace", targetNamespace);
        XMLBuilder.setAttribute(schemaElement, "", "", "elementFormDefault", "qualified");
        XMLBuilder.setAttribute(schemaElement, "", "", "attributeFormDefault", "unqualified");
        schemaElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xlink", XLINK_NAMESPACE);
        schemaElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + targetPrefix, targetNamespace);
        schemaElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:reg", targetNamespace);
        Element includeElement = XMLBuilder.createChild(schemaElement, XSD_NAMESPACE, XSD_PREFIX, "include");
        XMLBuilder.setAttribute(includeElement, "", "", "schemaLocation", "metadict.xsd");
        Element importElement = XMLBuilder.createChild(schemaElement, XSD_NAMESPACE, XSD_PREFIX, "import");
        XMLBuilder.setAttribute(importElement, "", "", "namespace", XLINK_NAMESPACE);
        XMLBuilder.setAttribute(importElement, "", "", "schemaLocation", "xlink.xsd");
        XSDGenerator.makeDataTypes(schemaElement, targetNamespace, targetPrefix);
        XSDGenerator.makeGlobalAttributes(schemaElement, targetNamespace, targetPrefix);
        XSDGenerator.makeRootElement(schemaElement, targetNamespace, targetPrefix, rootElement, rootClass);
        XSDGenerator.makeRecordTypes(schemaElement, targetNamespace, targetPrefix);
        ArrayList<ClassDefinition> classList = new ArrayList<ClassDefinition>(classes.size() * 2);
        ArrayList<PropertyDefinition> propertyList = new ArrayList<PropertyDefinition>(classes.size() * 20);
        ArrayList<TypeDefinitionInteger> integerList = new ArrayList<TypeDefinitionInteger>();
        ArrayList<TypeDefinitionEnumeration> enumerationList = new ArrayList<TypeDefinitionEnumeration>();
        ArrayList<TypeDefinitionCharacter> characterList = new ArrayList<TypeDefinitionCharacter>();
        ArrayList<TypeDefinitionString> stringList = new ArrayList<TypeDefinitionString>();
        ArrayList<TypeDefinitionExtendibleEnumeration> extEnumList = new ArrayList<TypeDefinitionExtendibleEnumeration>();
        ArrayList<TypeDefinitionIndirect> indirectList = new ArrayList<TypeDefinitionIndirect>();
        ArrayList<TypeDefinitionOpaque> opaqueList = new ArrayList<TypeDefinitionOpaque>();
        ArrayList<TypeDefinitionStream> streamList = new ArrayList<TypeDefinitionStream>();
        ArrayList<TypeDefinitionWeakObjectReference> weakRefList = new ArrayList<TypeDefinitionWeakObjectReference>();
        ArrayList<TypeDefinitionStrongObjectReference> strongRefList = new ArrayList<TypeDefinitionStrongObjectReference>();
        ArrayList<TypeDefinitionRecord> recordList = new ArrayList<TypeDefinitionRecord>();
        ArrayList<TypeDefinitionFixedArray> fixedArrayList = new ArrayList<TypeDefinitionFixedArray>();
        ArrayList<TypeDefinitionSet> setList = new ArrayList<TypeDefinitionSet>();
        ArrayList<TypeDefinitionVariableArray> variableArrayList = new ArrayList<TypeDefinitionVariableArray>();
        ArrayList<TypeDefinitionRename> renameList = new ArrayList<TypeDefinitionRename>();
        HashSet<MetaDefinition> baseline = new HashSet<MetaDefinition>();
        boolean aafMode = false;
        if (rootElement != null && rootElement.equals("AAF")) {
            aafMode = true;
        }
        for (ClassDefinition classItem : classes) {
            MetaDictionaryGenerator.addPropertiesAndTypes(classItem, baseline, classList, propertyList, aafMode);
        }
        boolean allTypesChecked = false;
        while (!allTypesChecked) {
            HashSet<MetaDefinition> newForBaseline = new HashSet<MetaDefinition>();
            allTypesChecked = true;
            block19: for (MetaDefinition metaDefinition : baseline) {
                if (!(metaDefinition instanceof TypeDefinition)) continue;
                TypeDefinition typeDefinition = (TypeDefinition)metaDefinition;
                switch (typeDefinition.getTypeCategory()) {
                    case Int: {
                        if (integerList.contains(typeDefinition)) break;
                        integerList.add((TypeDefinitionInteger)typeDefinition);
                        break;
                    }
                    case Enum: {
                        TypeDefinitionEnumeration enumerationType;
                        if (!enumerationList.contains(typeDefinition)) {
                            enumerationList.add((TypeDefinitionEnumeration)typeDefinition);
                        }
                        if (baseline.contains((enumerationType = (TypeDefinitionEnumeration)typeDefinition).getElementType())) break;
                        newForBaseline.add(enumerationType.getElementType());
                        allTypesChecked = false;
                        break;
                    }
                    case Character: {
                        if (characterList.contains(typeDefinition)) break;
                        characterList.add((TypeDefinitionCharacter)typeDefinition);
                        break;
                    }
                    case String: {
                        TypeDefinitionString stringType;
                        if (!stringList.contains(typeDefinition)) {
                            stringList.add((TypeDefinitionString)typeDefinition);
                        }
                        if (baseline.contains((stringType = (TypeDefinitionString)typeDefinition).getElementType())) break;
                        newForBaseline.add(stringType.getElementType());
                        allTypesChecked = false;
                        break;
                    }
                    case ExtEnum: {
                        if (extEnumList.contains(typeDefinition)) break;
                        extEnumList.add((TypeDefinitionExtendibleEnumeration)typeDefinition);
                        break;
                    }
                    case Indirect: {
                        if (indirectList.contains(typeDefinition)) break;
                        indirectList.add((TypeDefinitionIndirect)typeDefinition);
                        break;
                    }
                    case Opaque: {
                        if (opaqueList.contains(typeDefinition)) break;
                        opaqueList.add((TypeDefinitionOpaque)typeDefinition);
                        break;
                    }
                    case Stream: {
                        if (streamList.contains(typeDefinition)) break;
                        streamList.add((TypeDefinitionStream)typeDefinition);
                        break;
                    }
                    case Record: {
                        if (!recordList.contains(typeDefinition)) {
                            recordList.add((TypeDefinitionRecord)typeDefinition);
                        }
                        TypeDefinitionRecord recordType = (TypeDefinitionRecord)typeDefinition;
                        for (int u = 0; u < recordType.getCount(); ++u) {
                            if (baseline.contains(recordType.getMemberType(u))) continue;
                            newForBaseline.add(recordType.getMemberType(u));
                            allTypesChecked = false;
                        }
                        continue block19;
                    }
                    case WeakObjRef: {
                        TypeDefinitionWeakObjectReference weakRefType;
                        if (!weakRefList.contains(typeDefinition)) {
                            weakRefList.add((TypeDefinitionWeakObjectReference)typeDefinition);
                        }
                        if (classList.contains((weakRefType = (TypeDefinitionWeakObjectReference)typeDefinition).getObjectType())) break;
                        MetaDictionaryGenerator.addPropertiesAndTypes(weakRefType.getObjectType(), newForBaseline, classList, propertyList, aafMode);
                        allTypesChecked = false;
                        break;
                    }
                    case StrongObjRef: {
                        TypeDefinitionStrongObjectReference strongRefType;
                        if (!strongRefList.contains(typeDefinition)) {
                            strongRefList.add((TypeDefinitionStrongObjectReference)typeDefinition);
                        }
                        if (classList.contains((strongRefType = (TypeDefinitionStrongObjectReference)typeDefinition).getObjectType())) break;
                        MetaDictionaryGenerator.addPropertiesAndTypes(strongRefType.getObjectType(), newForBaseline, classList, propertyList, aafMode);
                        allTypesChecked = false;
                        break;
                    }
                    case FixedArray: {
                        TypeDefinitionFixedArray fixedArrayType;
                        if (!fixedArrayList.contains(typeDefinition)) {
                            fixedArrayList.add((TypeDefinitionFixedArray)typeDefinition);
                        }
                        if (baseline.contains((fixedArrayType = (TypeDefinitionFixedArray)typeDefinition).getType())) break;
                        newForBaseline.add(fixedArrayType.getType());
                        allTypesChecked = false;
                        break;
                    }
                    case Set: {
                        TypeDefinitionSet setType;
                        if (!setList.contains(typeDefinition)) {
                            setList.add((TypeDefinitionSet)typeDefinition);
                        }
                        if (baseline.contains((setType = (TypeDefinitionSet)typeDefinition).getElementType())) break;
                        newForBaseline.add(setType.getElementType());
                        allTypesChecked = false;
                        break;
                    }
                    case VariableArray: {
                        TypeDefinitionVariableArray variableArrayType;
                        if (!variableArrayList.contains(typeDefinition)) {
                            variableArrayList.add((TypeDefinitionVariableArray)typeDefinition);
                        }
                        if (baseline.contains((variableArrayType = (TypeDefinitionVariableArray)typeDefinition).getType())) break;
                        newForBaseline.add(variableArrayType.getType());
                        allTypesChecked = false;
                        break;
                    }
                    case Rename: {
                        TypeDefinitionRename renameType;
                        if (!renameList.contains(typeDefinition)) {
                            renameList.add((TypeDefinitionRename)typeDefinition);
                        }
                        if (baseline.contains((renameType = (TypeDefinitionRename)typeDefinition).getBaseType())) break;
                        newForBaseline.add(renameType.getBaseType());
                        allTypesChecked = false;
                        break;
                    }
                }
            }
            baseline.addAll(newForBaseline);
        }
        Map<ClassDefinition, Set<ClassDefinition>> typeHierarchy = XSDGenerator.buildTypeHierarchy(classList);
        for (ClassDefinition classItem : classList) {
            XSDGenerator.makeClassElement(schemaElement, classItem, targetNamespace, targetPrefix, aafMode);
        }
        for (PropertyDefinition propertyItem : propertyList) {
            XSDGenerator.makePropertyElement(schemaElement, propertyItem, targetNamespace, targetPrefix);
        }
        for (TypeDefinitionInteger integerType : integerList) {
            XSDGenerator.makeIntegerTypeElement(schemaElement, integerType, targetPrefix);
        }
        for (TypeDefinitionEnumeration enumerationType : enumerationList) {
            XSDGenerator.makeEnumerationTypeElement(schemaElement, enumerationType, targetPrefix);
        }
        for (TypeDefinitionCharacter characterType : characterList) {
            XSDGenerator.makeCharacterTypeElement(schemaElement, characterType, targetPrefix);
        }
        for (TypeDefinitionString stringType : stringList) {
            XSDGenerator.makeCharacterTypeElement(schemaElement, stringType, targetPrefix);
        }
        for (TypeDefinitionExtendibleEnumeration extEnumType : extEnumList) {
            XSDGenerator.makeExtendibleEnumerationTypeElement(schemaElement, extEnumType, targetPrefix);
        }
        for (TypeDefinitionIndirect indirectType : indirectList) {
            XSDGenerator.makeIndirectTypeElement(schemaElement, indirectType, targetPrefix);
        }
        for (TypeDefinitionOpaque opaqueType : opaqueList) {
            XSDGenerator.makeOpaqueTypeElement(schemaElement, opaqueType, targetPrefix);
        }
        for (TypeDefinitionStream streamType : streamList) {
            XSDGenerator.makeStreamTypeElement(schemaElement, streamType, targetPrefix);
        }
        for (TypeDefinitionFixedArray fixedArrayType : fixedArrayList) {
            XSDGenerator.makeFixedArrayTypeElement(schemaElement, fixedArrayType, targetPrefix, typeHierarchy);
        }
        for (TypeDefinitionRecord recordType : recordList) {
            XSDGenerator.makeRecordTypeElement(schemaElement, recordType, targetPrefix);
        }
        for (TypeDefinitionWeakObjectReference weakRefType : weakRefList) {
            XSDGenerator.makeWeakReferenceTypeElement(schemaElement, weakRefType, targetPrefix);
        }
        for (TypeDefinitionStrongObjectReference strongRefType : strongRefList) {
            XSDGenerator.makeStrongReferenceTypeElement(schemaElement, strongRefType, targetPrefix, typeHierarchy);
        }
        for (TypeDefinitionSet setType : setList) {
            XSDGenerator.makeSetTypeElement(schemaElement, setType, targetPrefix, typeHierarchy);
        }
        for (TypeDefinitionVariableArray variableArrayType : variableArrayList) {
            XSDGenerator.makeVariableArrayTypeElement(schemaElement, variableArrayType, targetPrefix, typeHierarchy, stringList);
        }
        for (TypeDefinitionRename renameType : renameList) {
            XSDGenerator.makeRenameTypeElement(schemaElement, renameType, targetPrefix);
        }
        XSDGenerator.makeReferenceElements(schemaElement, variableArrayList, fixedArrayList, setList, stringList, targetPrefix);
        return xsdFragment;
    }

    public static final String generateXSDAsAString(Collection<ClassDefinition> classes, String targetNamespace, String targetPrefix, String rootElement, String rootClass) throws NullPointerException {
        return XMLBuilder.transformNodeToString(XSDGenerator.generateXSD(classes, targetNamespace, targetPrefix, rootElement, rootClass));
    }

    static void makeRootElement(Element schemaElement, String targetNamespace, String targetPrefix, String rootElementName, String rootClassName) {
        Element rootElement = XSDGenerator.element(rootElementName, XSDGenerator.complexType(XSDGenerator.sequence(XSDGenerator.optionalElement("Extensions", XSDGenerator.complexType(XSDGenerator.sequence(XSDGenerator.listRefElement(targetPrefix, "Extension", XSDGenerator.end(schemaElement))))), XSDGenerator.elementRef(targetPrefix, rootClassName, XSDGenerator.end(schemaElement))), XSDGenerator.requiredAttribute("version", targetPrefix, "VersionType", XSDGenerator.end(schemaElement))));
        Element uniqueID = XMLBuilder.createChild(rootElement, XSD_NAMESPACE, XSD_PREFIX, "unique");
        XMLBuilder.setAttribute(uniqueID, "", "", "name", "_U_MDSchemeID");
        Element selector = XMLBuilder.createChild(uniqueID, XSD_NAMESPACE, XSD_PREFIX, "selector");
        XMLBuilder.setAttribute(selector, "", "", "xpath", targetPrefix + ":Extensions/" + targetPrefix + ":Extension");
        Element field = XMLBuilder.createChild(uniqueID, XSD_NAMESPACE, XSD_PREFIX, "field");
        XMLBuilder.setAttribute(field, "", "", "xpath", targetPrefix + ":SchemeID");
        Element uniqueURI = XMLBuilder.createChild(rootElement, XSD_NAMESPACE, XSD_PREFIX, "unique");
        XMLBuilder.setAttribute(uniqueURI, "", "", "name", "_U_MDSchemeURI");
        selector = XMLBuilder.createChild(uniqueURI, XSD_NAMESPACE, XSD_PREFIX, "selector");
        XMLBuilder.setAttribute(selector, "", "", "xpath", targetPrefix + ":Extensions/" + targetPrefix + ":Extension");
        field = XMLBuilder.createChild(uniqueURI, XSD_NAMESPACE, XSD_PREFIX, "field");
        XMLBuilder.setAttribute(field, "", "", "xpath", targetPrefix + ":SchemeURI");
        schemaElement.appendChild(rootElement);
    }

    static final void makeRecordTypes(Element schemaElement, String targetNamespace, String targetPrefix) {
    }

    static final void makeDataTypes(Element schemaElement, String targetNamespace, String targetPrefix) {
        schemaElement.appendChild(XSDGenerator.simpleType("TargetType", XSDGenerator.union("xs:token", XSDGenerator.simpleType(XSDGenerator.restriction(targetPrefix, "AUID", XSDGenerator.end(schemaElement))), XSDGenerator.simpleType(XSDGenerator.restriction(targetPrefix, "PackageIDType", XSDGenerator.end(schemaElement))), XSDGenerator.simpleType(XSDGenerator.restriction(XSD_PREFIX, "string", XSDGenerator.pattern("([^\\s]+\\s)?[^\\s]+", XSDGenerator.end(schemaElement)))))));
        schemaElement.appendChild(XSDGenerator.simpleType("ByteOrderType", XSDGenerator.restriction(XSD_PREFIX, "string", XSDGenerator.enumeration("BigEndian", XSDGenerator.end(schemaElement)), XSDGenerator.enumeration("LittleEndian", XSDGenerator.end(schemaElement)))));
        schemaElement.appendChild(XSDGenerator.simpleType("HexByteArrayType", XSDGenerator.restriction(XSD_PREFIX, "string", XSDGenerator.pattern("(\\s*[0-9a-fA-F][0-9a-fA-F])*\\s*", XSDGenerator.end(schemaElement)))));
    }

    static final void makeGlobalAttributes(Element schemaElement, String targetNamespace, String targetPrefix) {
        schemaElement.appendChild(XSDGenerator.attribute("uid", targetPrefix, "TargetType", XSDGenerator.end(schemaElement)));
        schemaElement.appendChild(XSDGenerator.attribute("byteOrder", targetPrefix, "ByteOrderType", XSDGenerator.end(schemaElement)));
        schemaElement.appendChild(XSDGenerator.attribute("stream", XSD_PREFIX, "ENTITY", XSDGenerator.end(schemaElement)));
        schemaElement.appendChild(XSDGenerator.attribute("actualType", targetPrefix, "TargetType", XSDGenerator.end(schemaElement)));
        schemaElement.appendChild(XSDGenerator.attribute("escaped", XSD_PREFIX, "boolean", XSDGenerator.end(schemaElement)));
        schemaElement.appendChild(XSDGenerator.attribute("path", XSD_PREFIX, "string", XSDGenerator.end(schemaElement)));
    }

    static final void makeClassElement(Element schemaElement, ClassDefinition classItem, String targetNamespace, String targetPrefix, boolean aafMode) {
        Element complexType;
        Element uid = XSDGenerator.attributeRefRequired(targetPrefix, "uid", XSDGenerator.end(schemaElement));
        Element path = XSDGenerator.attributeRefOptional(targetPrefix, "path", XSDGenerator.end(schemaElement));
        Document document = schemaElement.getOwnerDocument();
        Element all = document.createElementNS(XSD_NAMESPACE, "xs:all");
        for (PropertyDefinition propertyItem : classItem.getAllPropertyDefinitions()) {
            if (aafMode && !MediaEngine.isBaseline(propertyItem)) continue;
            if (propertyItem.getIsOptional() || aafMode && propertyItem.getSymbol().equals("ObjectClass")) {
                all.appendChild(XSDGenerator.optionalElementRef(targetPrefix, propertyItem.getSymbol(), XSDGenerator.end(schemaElement)));
                continue;
            }
            all.appendChild(XSDGenerator.elementRef(targetPrefix, propertyItem.getSymbol(), XSDGenerator.end(schemaElement)));
        }
        Element element = complexType = classItem.isUniquelyIdentified() ? XSDGenerator.complexType(all, uid, path) : XSDGenerator.complexType(all, path);
        if (classItem.isConcrete()) {
            schemaElement.appendChild(XSDGenerator.element(classItem.getSymbol(), complexType));
        } else {
            schemaElement.appendChild(XSDGenerator.abstractElement(classItem.getSymbol(), complexType));
        }
    }

    static final void makePropertyElement(Element schemaElement, PropertyDefinition propertyItem, String targetNamespace, String targetPrefix) {
        if (propertyItem.getMemberOf().getSymbol().equals("Preface") && propertyItem.getSymbol().equals("ByteOrder")) {
            schemaElement.appendChild(XSDGenerator.element("ByteOrder", targetPrefix, "ByteOrderType", XSDGenerator.end(schemaElement)));
            return;
        }
        schemaElement.appendChild(XSDGenerator.element(propertyItem.getSymbol(), targetPrefix, propertyItem.getTypeDefinition().getSymbol(), XSDGenerator.end(schemaElement)));
    }

    static final void makeIntegerTypeElement(Element schemaElement, TypeDefinitionInteger integerType, String targetPrefix) {
        String xsdlIntegerTypeName = null;
        switch (integerType.getSize()) {
            case 1: {
                xsdlIntegerTypeName = integerType.isSigned() ? "byte" : "unsignedByte";
                break;
            }
            case 2: {
                xsdlIntegerTypeName = integerType.isSigned() ? "short" : "unsignedShort";
                break;
            }
            case 4: {
                xsdlIntegerTypeName = integerType.isSigned() ? "integer" : "unsignedInt";
                break;
            }
            default: {
                xsdlIntegerTypeName = integerType.isSigned() ? "long" : "unsignedLong";
            }
        }
        schemaElement.appendChild(XSDGenerator.simpleType(integerType.getSymbol(), XSDGenerator.union("xs:" + xsdlIntegerTypeName, XSDGenerator.simpleType(XSDGenerator.restriction(XSD_PREFIX, "string", XSDGenerator.pattern("0x[0-9a-fA-F]{1," + integerType.getSize() * 2 + "}", XSDGenerator.end(schemaElement)))))));
    }

    static final void makeEnumerationTypeElement(Element schemaElement, TypeDefinitionEnumeration enumerationType, String targetPrefix) {
        Element restriction = XSDGenerator.restriction(XSD_PREFIX, "token", XSDGenerator.end(schemaElement));
        for (int x = 0; x < enumerationType.countElements(); ++x) {
            String elementName = enumerationType.getElementName(x);
            if (elementName.startsWith("_")) {
                elementName = elementName.substring(1);
            }
            restriction.appendChild(XSDGenerator.enumeration(elementName, XSDGenerator.end(schemaElement)));
        }
        schemaElement.appendChild(XSDGenerator.simpleType(enumerationType.getSymbol(), restriction));
    }

    static final void makeCharacterTypeElement(Element schemaElement, TypeDefinition characterType, String targetPrefix) {
        schemaElement.appendChild(XSDGenerator.complexType(characterType.getSymbol(), XSDGenerator.simpleContent(XSDGenerator.extension(XSD_PREFIX, "string", XSDGenerator.attributeRefOptional(targetPrefix, "escaped", XSDGenerator.end(schemaElement))))));
    }

    static final void makeExtendibleEnumerationTypeElement(Element schemaElement, TypeDefinitionExtendibleEnumeration extEnumType, String targetPrefix) {
        Element restriction = XSDGenerator.restriction(XSD_PREFIX, "string", XSDGenerator.end(schemaElement));
        for (int x = 0; x < extEnumType.countElements(); ++x) {
            restriction.appendChild(XSDGenerator.enumeration(Warehouse.extendibleEnumerationFullName(extEnumType.getElementValue(x)), XSDGenerator.end(schemaElement)));
        }
        schemaElement.appendChild(XSDGenerator.simpleType(extEnumType.getSymbol(), XSDGenerator.union(XSDGenerator.simpleType(restriction))));
    }

    static final void makeIndirectTypeElement(Element schemaElement, TypeDefinitionIndirect indirectType, String targetPrefix) {
        Document document = schemaElement.getOwnerDocument();
        Element any = document.createElementNS(XSD_NAMESPACE, "xs:any");
        XMLBuilder.setAttribute(any, "", "", "minOccurs", "0");
        XMLBuilder.setAttribute(any, "", "", "maxOccurs", "unbounded");
        XMLBuilder.setAttribute(any, "", "", "processContents", "skip");
        schemaElement.appendChild(XSDGenerator.complexType(indirectType.getSymbol(), XSDGenerator.mixedComplexContent(XSDGenerator.restriction(XSD_PREFIX, "anyType", XSDGenerator.sequence(any), XSDGenerator.attributeRefRequired(targetPrefix, "actualType", XSDGenerator.end(schemaElement)), XSDGenerator.attributeRefOptional(targetPrefix, "escaped", XSDGenerator.end(schemaElement))))));
    }

    static final void makeOpaqueTypeElement(Element schemaElement, TypeDefinitionOpaque opaqueType, String targetPrefix) {
        schemaElement.appendChild(XSDGenerator.complexType(opaqueType.getSymbol(), XSDGenerator.simpleContent(XSDGenerator.extension(targetPrefix, "HexByteArrayType", XSDGenerator.attributeRefRequired(targetPrefix, "actualType", XSDGenerator.end(schemaElement)), XSDGenerator.attributeRefRequired(targetPrefix, "byteOrder", XSDGenerator.end(schemaElement))))));
    }

    static final void makeStreamTypeElement(Element schemaElement, TypeDefinitionStream streamType, String targetPrefix) {
        schemaElement.appendChild(XSDGenerator.complexType(streamType.getSymbol(), XSDGenerator.attributeRefOptional(targetPrefix, "stream", XSDGenerator.end(schemaElement)), XSDGenerator.attributeRefOptional(XLINK_PREFIX, "href", XSDGenerator.end(schemaElement)), XSDGenerator.attributeRefOptional(targetPrefix, "byteOrder", XSDGenerator.end(schemaElement))));
    }

    static final void makeFixedArrayTypeElement(Element schemaElement, TypeDefinitionFixedArray fixedArrayType, String targetPrefix, Map<ClassDefinition, Set<ClassDefinition>> typeHierarchy) {
        if (!(fixedArrayType.getType() instanceof TypeDefinitionStrongObjectReference)) {
            Element element = XSDGenerator.elementRef(targetPrefix, fixedArrayType.getType().getSymbol(), XSDGenerator.end(schemaElement));
            XMLBuilder.setAttribute(element, "", "", "minOccurs", Integer.toString(fixedArrayType.getCount()));
            XMLBuilder.setAttribute(element, "", "", "maxOccurs", Integer.toString(fixedArrayType.getCount()));
            schemaElement.appendChild(XSDGenerator.complexType(fixedArrayType.getSymbol(), XSDGenerator.sequence(element)));
            return;
        }
        Element choice = XSDGenerator.choice(XSDGenerator.end(schemaElement));
        XMLBuilder.setAttribute(choice, "", "", "minOccurs", Integer.toString(fixedArrayType.getCount()));
        XMLBuilder.setAttribute(choice, "", "", "maxOccurs", Integer.toString(fixedArrayType.getCount()));
        Set<ClassDefinition> descendents = XSDGenerator.getAllDescendents(((TypeDefinitionStrongObjectReference)fixedArrayType.getType()).getObjectType(), typeHierarchy);
        descendents.add(((TypeDefinitionStrongObjectReference)fixedArrayType.getType()).getObjectType());
        for (ClassDefinition child : descendents) {
            if (!child.isConcrete()) continue;
            choice.appendChild(XSDGenerator.elementRef(targetPrefix, child.getSymbol(), XSDGenerator.end(schemaElement)));
        }
        schemaElement.appendChild(XSDGenerator.complexType(fixedArrayType.getSymbol(), choice));
    }

    static final void makeRecordTypeElement(Element schemaElement, TypeDefinitionRecord recordType, String targetPrefix) {
        if (recordType.getSymbol().equals("AUID")) {
            XSDGenerator.makeAUIDType(schemaElement, recordType, targetPrefix);
            return;
        }
        if (recordType.getSymbol().equals("DateStruct")) {
            XSDGenerator.makeDateStructType(schemaElement, recordType, targetPrefix);
            return;
        }
        if (recordType.getSymbol().equals("PackageIDType")) {
            XSDGenerator.makePackageIDType(schemaElement, recordType, targetPrefix);
            return;
        }
        if (recordType.getSymbol().equals("Rational")) {
            XSDGenerator.makeRationalType(schemaElement, recordType, targetPrefix);
            return;
        }
        if (recordType.getSymbol().equals("TimeStruct")) {
            XSDGenerator.makeTimeStructType(schemaElement, recordType, targetPrefix);
            return;
        }
        if (recordType.getSymbol().equals("TimeStamp")) {
            XSDGenerator.makeTimeStampType(schemaElement, recordType, targetPrefix);
            return;
        }
        if (recordType.getSymbol().equals("VersionType")) {
            XSDGenerator.makeVersionType(schemaElement, recordType, targetPrefix);
            return;
        }
        Element sequence = XSDGenerator.sequence(XSDGenerator.end(schemaElement));
        for (int x = 0; x < recordType.getCount(); ++x) {
            sequence.appendChild(XSDGenerator.element(XSDGenerator.upperFirstLetter(recordType.getMemberName(x)), targetPrefix, recordType.getMemberType(x).getSymbol(), XSDGenerator.end(schemaElement)));
        }
        schemaElement.appendChild(XSDGenerator.complexType(recordType.getSymbol(), sequence));
    }

    static final void makeAUIDType(Element schemaElement, TypeDefinitionRecord recordType, String targetPrefix) {
        schemaElement.appendChild(XSDGenerator.simpleType("AUID", XSDGenerator.restriction(XSD_PREFIX, "anyURI", XSDGenerator.pattern("urn:smpte:ul:([0-9a-fA-F]{8}\\.){3}[0-9a-fA-F]{8}", XSDGenerator.end(schemaElement)), XSDGenerator.pattern("urn:uuid:[0-9a-fA-F]{8}-([0-9a-fA-F]{4}-){3}[0-9a-fA-F]{12}", XSDGenerator.end(schemaElement)))));
    }

    static final void makeDateStructType(Element schemaElement, TypeDefinitionRecord recordType, String targetPrefix) {
        schemaElement.appendChild(XSDGenerator.simpleType("DateStruct", XSDGenerator.union(XSDGenerator.simpleType(XSDGenerator.restriction(XSD_PREFIX, "date", XSDGenerator.pattern(".+(((\\+|\\-)\\d\\d:\\d\\d)|Z)", XSDGenerator.end(schemaElement)))), XSDGenerator.simpleType(XSDGenerator.restriction(XSD_PREFIX, "string", XSDGenerator.pattern("0000-00-00Z", XSDGenerator.end(schemaElement)))))));
    }

    static final void makePackageIDType(Element schemaElement, TypeDefinitionRecord recordType, String targetPrefix) {
        schemaElement.appendChild(XSDGenerator.simpleType("PackageIDType", XSDGenerator.restriction(XSD_PREFIX, "string", XSDGenerator.pattern("urn:smpte:umid:([0-9a-fA-F]{8}\\.){7}[0-9a-fA-F]{8}", XSDGenerator.end(schemaElement)))));
    }

    static final void makeRationalType(Element schemaElement, TypeDefinitionRecord recordType, String targetPrefix) {
        schemaElement.appendChild(XSDGenerator.simpleType("Rational", XSDGenerator.restriction(XSD_PREFIX, "string", XSDGenerator.pattern("\\-?\\d{1,10}(/\\-?\\d{1,10})?", XSDGenerator.end(schemaElement)))));
    }

    static final void makeTimeStructType(Element schemaElement, TypeDefinitionRecord recordType, String targetPrefix) {
        schemaElement.appendChild(XSDGenerator.simpleType("TimeStruct", XSDGenerator.union(XSDGenerator.simpleType(XSDGenerator.restriction(XSD_PREFIX, "time", XSDGenerator.pattern(".+(((\\+|\\-)\\d\\d:\\d\\d)|Z)", XSDGenerator.end(schemaElement)))), XSDGenerator.simpleType(XSDGenerator.restriction(XSD_PREFIX, "string", XSDGenerator.pattern("00:00:00Z", XSDGenerator.end(schemaElement)))))));
    }

    static final void makeTimeStampType(Element schemaElement, TypeDefinitionRecord recordType, String targetPrefix) {
        schemaElement.appendChild(XSDGenerator.simpleType("TimeStamp", XSDGenerator.union(XSDGenerator.simpleType(XSDGenerator.restriction(XSD_PREFIX, "dateTime", XSDGenerator.pattern(".+(((\\+|\\-)\\d\\d:\\d\\d)|Z)", XSDGenerator.end(schemaElement)))), XSDGenerator.simpleType(XSDGenerator.restriction(XSD_PREFIX, "string", XSDGenerator.pattern("0000-00-00T00:00:00Z", XSDGenerator.end(schemaElement)))))));
    }

    static final void makeVersionType(Element schemaElement, TypeDefinitionRecord recordType, String targetPrefix) {
        schemaElement.appendChild(XSDGenerator.simpleType("VersionType", XSDGenerator.restriction(XSD_PREFIX, "string", XSDGenerator.pattern("\\-?\\d{1,3}\\.\\-?\\d{1,3}", XSDGenerator.end(schemaElement)))));
    }

    static final void makeWeakReferenceTypeElement(Element schemaElement, TypeDefinitionWeakObjectReference weakRefType, String targetPrefix) {
        schemaElement.appendChild(XSDGenerator.simpleType(weakRefType.getSymbol(), XSDGenerator.restriction(targetPrefix, "TargetType", XSDGenerator.end(schemaElement))));
    }

    static final void makeStrongReferenceTypeElement(Element schemaElement, TypeDefinitionStrongObjectReference strongRefType, String targetPrefix, Map<ClassDefinition, Set<ClassDefinition>> hierarchy) {
        Set<ClassDefinition> descendents = XSDGenerator.getAllDescendents(strongRefType.getObjectType(), hierarchy);
        descendents.add(strongRefType.getObjectType());
        Element choice = XSDGenerator.choice(XSDGenerator.end(schemaElement));
        for (ClassDefinition child : descendents) {
            if (!child.isConcrete()) continue;
            choice.appendChild(XSDGenerator.elementRef(targetPrefix, child.getSymbol(), XSDGenerator.end(schemaElement)));
        }
        schemaElement.appendChild(XSDGenerator.complexType(strongRefType.getSymbol(), choice));
    }

    static final void makeSetTypeElement(Element schemaElement, TypeDefinitionSet setRefType, String targetPrefix, Map<ClassDefinition, Set<ClassDefinition>> hierarchy) {
        if (setRefType.getElementType() instanceof TypeDefinitionStrongObjectReference) {
            Set<ClassDefinition> descendents = XSDGenerator.getAllDescendents(((TypeDefinitionStrongObjectReference)setRefType.getElementType()).getObjectType(), hierarchy);
            descendents.add(((TypeDefinitionStrongObjectReference)setRefType.getElementType()).getObjectType());
            Element choice = XSDGenerator.choice(XSDGenerator.end(schemaElement));
            XMLBuilder.setAttribute(choice, "", "", "minOccurs", "0");
            XMLBuilder.setAttribute(choice, "", "", "maxOccurs", "unbounded");
            for (ClassDefinition child : descendents) {
                if (!child.isConcrete()) continue;
                choice.appendChild(XSDGenerator.elementRef(targetPrefix, child.getSymbol(), XSDGenerator.end(schemaElement)));
            }
            schemaElement.appendChild(XSDGenerator.complexType(setRefType.getSymbol(), choice));
            return;
        }
        schemaElement.appendChild(XSDGenerator.complexType(setRefType.getSymbol(), XSDGenerator.sequence(XSDGenerator.listRefElement(targetPrefix, setRefType.getElementType().getSymbol(), XSDGenerator.end(schemaElement)))));
    }

    static final void makeVariableArrayTypeElement(Element schemaElement, TypeDefinitionVariableArray variableArrayType, String targetPrefix, Map<ClassDefinition, Set<ClassDefinition>> hierarchy, List<TypeDefinitionString> stringList) {
        switch (variableArrayType.getType().getTypeCategory()) {
            case StrongObjRef: {
                XSDGenerator.makeVariableArrayStrongRef(schemaElement, variableArrayType, targetPrefix, hierarchy);
                return;
            }
            case Character: {
                XSDGenerator.makeVariableArrayStringArray(schemaElement, variableArrayType, targetPrefix, hierarchy, stringList);
                return;
            }
            case Int: {
                if (variableArrayType.getSymbol().equals("DataValue")) {
                    XSDGenerator.makeVariableArrayDataValue(schemaElement, variableArrayType, targetPrefix, hierarchy);
                    return;
                }
                if (!variableArrayType.getSymbol().contains("StringArray")) break;
                XSDGenerator.makeVariableArrayStringArray(schemaElement, variableArrayType, targetPrefix, hierarchy, stringList);
                return;
            }
        }
        schemaElement.appendChild(XSDGenerator.complexType(variableArrayType.getSymbol(), XSDGenerator.sequence(XSDGenerator.listRefElement(targetPrefix, variableArrayType.getType().getSymbol(), XSDGenerator.end(schemaElement)))));
    }

    static final void makeVariableArrayStrongRef(Element schemaElement, TypeDefinitionVariableArray variableArrayType, String targetPrefix, Map<ClassDefinition, Set<ClassDefinition>> hierarchy) {
        Set<ClassDefinition> descendents = XSDGenerator.getAllDescendents(((TypeDefinitionStrongObjectReference)variableArrayType.getType()).getObjectType(), hierarchy);
        descendents.add(((TypeDefinitionStrongObjectReference)variableArrayType.getType()).getObjectType());
        Element choice = XSDGenerator.choice(XSDGenerator.end(schemaElement));
        XMLBuilder.setAttribute(choice, "", "", "minOccurs", "0");
        XMLBuilder.setAttribute(choice, "", "", "maxOccurs", "unbounded");
        for (ClassDefinition child : descendents) {
            if (!child.isConcrete()) continue;
            choice.appendChild(XSDGenerator.elementRef(targetPrefix, child.getSymbol(), XSDGenerator.end(schemaElement)));
        }
        schemaElement.appendChild(XSDGenerator.complexType(variableArrayType.getSymbol(), choice));
    }

    static final void makeVariableArrayStringArray(Element schemaElement, TypeDefinitionVariableArray variableArrayType, String targetPrefix, Map<ClassDefinition, Set<ClassDefinition>> hierarchy, List<TypeDefinitionString> stringList) {
        TypeDefinition targetStringType = null;
        for (TypeDefinitionString stringTypeItem : stringList) {
            if (!stringTypeItem.getElementType().equals(variableArrayType.getType())) continue;
            targetStringType = stringTypeItem;
            break;
        }
        if (targetStringType == null) {
            targetStringType = variableArrayType.getType();
        }
        schemaElement.appendChild(XSDGenerator.complexType(variableArrayType.getSymbol(), XSDGenerator.sequence(XSDGenerator.listRefElement(targetPrefix, targetStringType.getSymbol(), XSDGenerator.end(schemaElement)))));
    }

    static final void makeVariableArrayDataValue(Element schemaElement, TypeDefinitionVariableArray variableArrayType, String targetPrefix, Map<ClassDefinition, Set<ClassDefinition>> hierarchy) {
        schemaElement.appendChild(XSDGenerator.simpleType("DataValue", XSDGenerator.restriction(targetPrefix, "HexByteArrayType", XSDGenerator.end(schemaElement))));
    }

    static final void makeRenameTypeElement(Element schemaElement, TypeDefinitionRename renameType, String targetPrefix) {
        Document document = schemaElement.getOwnerDocument();
        Element dummySchema = document.createElementNS(XSD_NAMESPACE, "xs:DUMMY");
        TypeDefinition baseType = renameType.getBaseType();
        switch (baseType.getTypeCategory()) {
            case Int: {
                XSDGenerator.makeIntegerTypeElement(dummySchema, (TypeDefinitionInteger)baseType, targetPrefix);
                break;
            }
            case Character: {
                XSDGenerator.makeCharacterTypeElement(dummySchema, (TypeDefinitionCharacter)baseType, targetPrefix);
                break;
            }
            case String: {
                XSDGenerator.makeCharacterTypeElement(dummySchema, (TypeDefinitionString)baseType, targetPrefix);
                break;
            }
            case Enum: {
                XSDGenerator.makeEnumerationTypeElement(dummySchema, (TypeDefinitionEnumeration)baseType, targetPrefix);
                break;
            }
            case ExtEnum: {
                XSDGenerator.makeExtendibleEnumerationTypeElement(dummySchema, (TypeDefinitionExtendibleEnumeration)baseType, targetPrefix);
                break;
            }
            case Indirect: {
                XSDGenerator.makeIndirectTypeElement(dummySchema, (TypeDefinitionIndirect)baseType, targetPrefix);
                break;
            }
            case Opaque: {
                XSDGenerator.makeOpaqueTypeElement(dummySchema, (TypeDefinitionOpaque)baseType, targetPrefix);
                break;
            }
            case Record: {
                XSDGenerator.makeRecordTypeElement(dummySchema, (TypeDefinitionRecord)baseType, targetPrefix);
                break;
            }
            case Rename: {
                XSDGenerator.makeRenameTypeElement(dummySchema, (TypeDefinitionRename)baseType, targetPrefix);
                break;
            }
            case Stream: {
                XSDGenerator.makeStreamTypeElement(dummySchema, (TypeDefinitionStream)baseType, targetPrefix);
                break;
            }
            case WeakObjRef: {
                XSDGenerator.makeWeakReferenceTypeElement(dummySchema, (TypeDefinitionWeakObjectReference)baseType, targetPrefix);
                break;
            }
            case StrongObjRef: {
                XSDGenerator.makeStrongReferenceTypeElement(dummySchema, (TypeDefinitionStrongObjectReference)baseType, targetPrefix, new HashMap<ClassDefinition, Set<ClassDefinition>>());
                break;
            }
            case FixedArray: {
                XSDGenerator.makeFixedArrayTypeElement(dummySchema, (TypeDefinitionFixedArray)baseType, targetPrefix, new HashMap<ClassDefinition, Set<ClassDefinition>>());
                break;
            }
            case VariableArray: {
                XSDGenerator.makeVariableArrayTypeElement(dummySchema, (TypeDefinitionVariableArray)baseType, targetPrefix, new HashMap<ClassDefinition, Set<ClassDefinition>>(), new ArrayList<TypeDefinitionString>());
                break;
            }
            case Set: {
                XSDGenerator.makeSetTypeElement(dummySchema, (TypeDefinitionSet)baseType, targetPrefix, new HashMap<ClassDefinition, Set<ClassDefinition>>());
                break;
            }
            default: {
                return;
            }
        }
        Element firstChild = (Element)dummySchema.getFirstChild();
        String referenceName = firstChild.getAttribute("name");
        if (firstChild.getNodeName().equals("xs:simpleType")) {
            schemaElement.appendChild(XSDGenerator.simpleType(renameType.getSymbol(), XSDGenerator.restriction(targetPrefix, referenceName, XSDGenerator.end(schemaElement))));
        } else {
            schemaElement.appendChild(XSDGenerator.complexType(renameType.getSymbol(), XSDGenerator.complexContent(XSDGenerator.extension(targetPrefix, referenceName, XSDGenerator.end(schemaElement)))));
        }
    }

    static final void makeReferenceElements(Element schemaElement, List<TypeDefinitionVariableArray> variableArrayList, List<TypeDefinitionFixedArray> fixedArrayList, List<TypeDefinitionSet> setList, List<TypeDefinitionString> stringList, String targetPrefix) {
        TypeDefinition elementType;
        HashSet<TypeDefinition> elementsOut = new HashSet<TypeDefinition>();
        HashSet<TypeDefinition> combinedSet = new HashSet<TypeDefinition>(variableArrayList.size() + fixedArrayList.size() + setList.size());
        combinedSet.addAll(variableArrayList);
        combinedSet.addAll(fixedArrayList);
        combinedSet.addAll(setList);
        for (TypeDefinition typeDefinition : combinedSet) {
            elementType = null;
            if (typeDefinition instanceof TypeDefinitionSet) {
                elementType = ((TypeDefinitionSet)typeDefinition).getElementType();
            }
            if (typeDefinition instanceof TypeDefinitionVariableArray) {
                elementType = ((TypeDefinitionVariableArray)typeDefinition).getType();
            }
            if (typeDefinition instanceof TypeDefinitionFixedArray) {
                elementType = ((TypeDefinitionFixedArray)typeDefinition).getType();
            }
            while (elementType instanceof TypeDefinitionRename) {
                elementType = ((TypeDefinitionRename)elementType).getBaseType();
            }
            switch (elementType.getTypeCategory()) {
                case Int: 
                case Enum: 
                case ExtEnum: 
                case Record: 
                case WeakObjRef: {
                    XSDGenerator.outputRefElement(elementType, schemaElement, elementsOut, targetPrefix);
                    break;
                }
            }
        }
        for (TypeDefinitionSet typeDefinitionSet : setList) {
            elementType = typeDefinitionSet.getElementType();
            while (elementType instanceof TypeDefinitionRename) {
                elementType = ((TypeDefinitionRename)elementType).getBaseType();
            }
            switch (elementType.getTypeCategory()) {
                case Int: 
                case Character: {
                    XSDGenerator.outputRefElement(elementType, schemaElement, elementsOut, targetPrefix);
                    break;
                }
            }
        }
        for (TypeDefinitionString typeDefinitionString : stringList) {
            XSDGenerator.outputRefElement(typeDefinitionString, schemaElement, elementsOut, targetPrefix);
        }
    }

    static final void outputRefElement(TypeDefinition type, Element schemaElement, Set<TypeDefinition> elementsOut, String targetPrefix) {
        if (!elementsOut.contains(type)) {
            schemaElement.appendChild(XSDGenerator.element(type.getSymbol(), targetPrefix, type.getSymbol(), XSDGenerator.end(schemaElement)));
            elementsOut.add(type);
        }
    }

    static final Element element(String name, Element child) {
        Document document = child.getOwnerDocument();
        Element element = document.createElementNS(XSD_NAMESPACE, "xs:element");
        XMLBuilder.setAttribute(element, "", "", "name", name);
        XSDGenerator.mother(element, child);
        return element;
    }

    static final Element element(String name, String targetPrefix, String type, Element child) {
        Document document = child.getOwnerDocument();
        Element element = document.createElementNS(XSD_NAMESPACE, "xs:element");
        XMLBuilder.setAttribute(element, "", "", "name", name);
        XMLBuilder.setAttribute(element, "", "", "type", targetPrefix + ":" + type);
        XSDGenerator.mother(element, child);
        return element;
    }

    static final Element optionalElement(String name, Element child) {
        Element element = XSDGenerator.element(name, child);
        XMLBuilder.setAttribute(element, "", "", "minOccurs", "0");
        return element;
    }

    static final Element optionalElementRef(String targetPrefix, String ref, Element child) {
        Element element = XSDGenerator.elementRef(targetPrefix, ref, child);
        XMLBuilder.setAttribute(element, "", "", "minOccurs", "0");
        return element;
    }

    static final Element abstractElement(String name, Element child) {
        Element element = XSDGenerator.element(name, child);
        XMLBuilder.setAttribute(element, "", "", "abstract", "true");
        return element;
    }

    static final Element listRefElement(String targetPrefix, String ref, Element child) {
        Document document = child.getOwnerDocument();
        Element element = document.createElementNS(XSD_NAMESPACE, "xs:element");
        XMLBuilder.setAttribute(element, "", "", "ref", targetPrefix + ":" + ref);
        XMLBuilder.setAttribute(element, "", "", "minOccurs", "0");
        XMLBuilder.setAttribute(element, "", "", "maxOccurs", "unbounded");
        return element;
    }

    static final Element elementRef(String targetPrefix, String ref, Element child) {
        Document document = child.getOwnerDocument();
        Element element = document.createElementNS(XSD_NAMESPACE, "xs:element");
        XMLBuilder.setAttribute(element, "", "", "ref", targetPrefix + ":" + ref);
        return element;
    }

    static final Element complexType(Element ... children) {
        Document document = children[0].getOwnerDocument();
        Element sequence = document.createElementNS(XSD_NAMESPACE, "xs:complexType");
        for (Element element : children) {
            XSDGenerator.mother(sequence, element);
        }
        return sequence;
    }

    static final Element complexType(String name, Element ... children) {
        Element complexType = XSDGenerator.complexType(children);
        XMLBuilder.setAttribute(complexType, "", "", "name", name);
        return complexType;
    }

    static final Element sequence(Element ... children) {
        Document document = children[0].getOwnerDocument();
        Element sequence = document.createElementNS(XSD_NAMESPACE, "xs:sequence");
        for (Element element : children) {
            XSDGenerator.mother(sequence, element);
        }
        return sequence;
    }

    static final Element choice(Element ... children) {
        Document document = children[0].getOwnerDocument();
        Element sequence = document.createElementNS(XSD_NAMESPACE, "xs:choice");
        for (Element element : children) {
            XSDGenerator.mother(sequence, element);
        }
        return sequence;
    }

    static final Element end(Element bluff) {
        Document document = bluff.getOwnerDocument();
        return document.createElement("BLUFF");
    }

    static final Element mother(Element mother, Element child) {
        if (!child.getNodeName().equals("BLUFF")) {
            mother.appendChild(child);
        }
        return mother;
    }

    static final Element requiredAttribute(String name, String targetPrefix, String type, Element child) {
        Document document = child.getOwnerDocument();
        Element attributeElement = document.createElementNS(XSD_NAMESPACE, "xs:attribute");
        XMLBuilder.setAttribute(attributeElement, "", "", "name", name);
        XMLBuilder.setAttribute(attributeElement, "", "", "type", targetPrefix + ":" + type);
        XMLBuilder.setAttribute(attributeElement, "", "", "use", "required");
        return XSDGenerator.mother(attributeElement, child);
    }

    static final Element attribute(String name, String targetPrefix, String type, Element child) {
        Document document = child.getOwnerDocument();
        Element attributeElement = document.createElementNS(XSD_NAMESPACE, "xs:attribute");
        XMLBuilder.setAttribute(attributeElement, "", "", "name", name);
        XMLBuilder.setAttribute(attributeElement, "", "", "type", targetPrefix + ":" + type);
        return XSDGenerator.mother(attributeElement, child);
    }

    static final Element attributeRef(String targetPrefix, String ref, Element child) {
        Document document = child.getOwnerDocument();
        Element attributeElement = document.createElementNS(XSD_NAMESPACE, "xs:attribute");
        XMLBuilder.setAttribute(attributeElement, "", "", "ref", targetPrefix + ":" + ref);
        return XSDGenerator.mother(attributeElement, child);
    }

    static final Element attributeRefRequired(String targetPrefix, String ref, Element child) {
        Element attributeElement = XSDGenerator.attributeRef(targetPrefix, ref, child);
        XMLBuilder.setAttribute(attributeElement, "", "", "use", "required");
        return attributeElement;
    }

    static final Element attributeRefOptional(String targetPrefix, String ref, Element child) {
        Element attributeElement = XSDGenerator.attributeRef(targetPrefix, ref, child);
        XMLBuilder.setAttribute(attributeElement, "", "", "use", "optional");
        return attributeElement;
    }

    static final Element simpleType(String name, Element child) {
        Element element = XSDGenerator.simpleType(child);
        XMLBuilder.setAttribute(element, "", "", "name", name);
        return element;
    }

    static final Element simpleType(Element child) {
        Document document = child.getOwnerDocument();
        return XSDGenerator.mother(document.createElementNS(XSD_NAMESPACE, "xs:simpleType"), child);
    }

    static final Element union(String memberTypes, Element ... children) {
        Element union = XSDGenerator.union(children);
        XMLBuilder.setAttribute(union, "", "", "memberTypes", memberTypes);
        return union;
    }

    static final Element union(Element ... children) {
        Document document = children[0].getOwnerDocument();
        Element union = document.createElementNS(XSD_NAMESPACE, "xs:union");
        for (Element element : children) {
            XSDGenerator.mother(union, element);
        }
        return union;
    }

    static final Element restriction(String targetPrefix, String base, Element ... children) {
        Document document = children[0].getOwnerDocument();
        Element restriction = document.createElementNS(XSD_NAMESPACE, "xs:restriction");
        for (Element child : children) {
            XSDGenerator.mother(restriction, child);
        }
        XMLBuilder.setAttribute(restriction, "", "", "base", targetPrefix + ":" + base);
        return restriction;
    }

    static final Element extension(String targetPrefix, String base, Element ... children) {
        Document document = children[0].getOwnerDocument();
        Element restriction = document.createElementNS(XSD_NAMESPACE, "xs:extension");
        for (Element child : children) {
            XSDGenerator.mother(restriction, child);
        }
        XMLBuilder.setAttribute(restriction, "", "", "base", targetPrefix + ":" + base);
        return restriction;
    }

    static final Element pattern(String value, Element child) {
        Document document = child.getOwnerDocument();
        Element pattern = XSDGenerator.mother(document.createElementNS(XSD_NAMESPACE, "xs:pattern"), child);
        XMLBuilder.setAttribute(pattern, "", "", "value", value);
        return pattern;
    }

    static final Element enumeration(String value, Element child) {
        Document document = child.getOwnerDocument();
        Element pattern = XSDGenerator.mother(document.createElementNS(XSD_NAMESPACE, "xs:enumeration"), child);
        XMLBuilder.setAttribute(pattern, "", "", "value", value);
        return pattern;
    }

    static final Element complexContent(Element ... children) {
        Document document = children[0].getOwnerDocument();
        Element complexContent = document.createElementNS(XSD_NAMESPACE, "xs:complexContent");
        for (Element child : children) {
            XSDGenerator.mother(complexContent, child);
        }
        return complexContent;
    }

    static final Element mixedComplexContent(Element ... children) {
        Element complexContent = XSDGenerator.complexContent(children);
        XMLBuilder.setAttribute(complexContent, "", "", "mixed", "true");
        return complexContent;
    }

    static final Element simpleContent(Element ... children) {
        Document document = children[0].getOwnerDocument();
        Element simpleContent = document.createElementNS(XSD_NAMESPACE, "xs:simpleContent");
        for (Element child : children) {
            XSDGenerator.mother(simpleContent, child);
        }
        return simpleContent;
    }

    static final String upperFirstLetter(String bumpMeUp) {
        if (bumpMeUp == null) {
            return null;
        }
        switch (bumpMeUp.length()) {
            case 0: {
                return bumpMeUp;
            }
            case 1: {
                return Character.toString(Character.toUpperCase(bumpMeUp.charAt(0)));
            }
        }
        return Character.toUpperCase(bumpMeUp.charAt(0)) + bumpMeUp.substring(1);
    }

    static final Map<ClassDefinition, Set<ClassDefinition>> buildTypeHierarchy(Collection<ClassDefinition> classes) {
        HashMap<ClassDefinition, Set<ClassDefinition>> hierarchy = new HashMap<ClassDefinition, Set<ClassDefinition>>(classes.size());
        for (ClassDefinition classItem : classes) {
            if (!hierarchy.containsKey(classItem)) {
                hierarchy.put(classItem, new HashSet());
            }
            if (classItem.isRoot()) continue;
            ClassDefinition parent = classItem.getParent();
            HashSet<ClassDefinition> children = (HashSet<ClassDefinition>)hierarchy.get(parent);
            if (children == null) {
                children = new HashSet<ClassDefinition>();
                hierarchy.put(parent, children);
            }
            children.add(classItem);
        }
        return hierarchy;
    }

    static final Set<ClassDefinition> getAllDescendents(ClassDefinition classItem, Map<ClassDefinition, Set<ClassDefinition>> hierarchy) {
        HashSet<ClassDefinition> descendents = new HashSet<ClassDefinition>();
        if (hierarchy.containsKey(classItem)) {
            Set<ClassDefinition> children = hierarchy.get(classItem);
            for (ClassDefinition child : children) {
                descendents.add(child);
                descendents.addAll(XSDGenerator.getAllDescendents(child, hierarchy));
            }
        }
        return descendents;
    }

    public static final void main(String[] args) {
        System.out.println(XSDGenerator.generateBaselineXSDAsAString());
    }
}

