/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.io.mxf.impl;

import tv.amwa.maj.integer.UInt32;
import tv.amwa.maj.io.mxf.MXFLength;
import tv.amwa.maj.io.mxf.MXFPosition;
import tv.amwa.maj.io.mxf.impl.PartitionImpl;

public class PartitionInformation
implements Comparable<PartitionInformation> {
    private PartitionImpl partition = null;
    @MXFPosition
    private long byteOffset = -1L;
    @UInt32
    private int bodySID = 0;
    @UInt32
    private int indexSID = 0;
    private boolean knownSIDs = false;
    @MXFPosition
    private long streamOffset = -1L;
    @MXFLength
    private long streamByteCount = -1L;
    @MXFPosition
    private long estimatedStreamOffset = -1L;
    @MXFLength
    private long estimatedStreamByteCount = -1L;
    @MXFPosition
    private long essenceStart = -1L;

    public PartitionInformation(PartitionImpl partition, @MXFPosition long offset, @UInt32 int sid) {
        this.partition = partition;
        this.byteOffset = offset;
        this.bodySID = sid;
    }

    public PartitionInformation() {
    }

    @Override
    public int compareTo(PartitionInformation o) {
        if (this.byteOffset < o.getByteOffset()) {
            return -1;
        }
        if (this.byteOffset == o.getByteOffset()) {
            return 0;
        }
        return 1;
    }

    public PartitionImpl getPartition() {
        return this.partition;
    }

    public void setPartition(PartitionImpl partition) {
        this.partition = partition;
    }

    @UInt32
    public int getBodySID() {
        return this.bodySID;
    }

    public void setBodySID(@UInt32 int bodySID) throws IllegalArgumentException {
        if (bodySID < 0) {
            throw new IllegalArgumentException("Cannot set the body SID to a negative value.");
        }
        this.bodySID = bodySID;
    }

    @UInt32
    public int getIndexSID() {
        return this.indexSID;
    }

    public void setIndexSID(@UInt32 int indexSID) throws IllegalArgumentException {
        if (indexSID < 0) {
            throw new IllegalArgumentException("Cannot set the index SID to a negative value.");
        }
        this.indexSID = indexSID;
    }

    public boolean areSIDsKnown() {
        return this.knownSIDs;
    }

    public void setAreSIDsKnown(boolean knownSIDs) {
        this.knownSIDs = knownSIDs;
    }

    public void setSIDs(@UInt32 int bodySID, @UInt32 int indexSID) throws IllegalArgumentException {
        this.setBodySID(bodySID);
        this.setIndexSID(indexSID);
        this.knownSIDs = true;
    }

    @MXFPosition
    public long getByteOffset() {
        return this.byteOffset;
    }

    public void setByteOffset(@MXFPosition long byteOffset) {
        this.byteOffset = byteOffset;
    }

    @MXFPosition
    public long getStreamOffset() {
        return this.streamOffset;
    }

    public void setStreamOffset(@MXFPosition long streamOffset) {
        this.streamOffset = streamOffset;
    }

    @MXFPosition
    public long getEstimatedStreamOffset() {
        return this.estimatedStreamOffset;
    }

    public void setEstimatedStreamOffset(@MXFPosition long estimatedStreamOffset) {
        this.estimatedStreamOffset = estimatedStreamOffset;
    }

    @MXFPosition
    public long getEssenceStart() {
        return this.essenceStart;
    }

    public void setEssenceStart(@MXFPosition long essenceStart) {
        this.essenceStart = essenceStart;
    }
}

