##  Copyright (c) MediaArea.net SARL. All Rights Reserved.
##
##  Use of this source code is governed by a BSD-style license that can
##  be found in the License.html file in the root of the source tree.
##

$ErrorActionPreference = "Stop"

#-----------------------------------------------------------------------
# Setup
$release_directory = Split-Path -Parent $MyInvocation.MyCommand.Path
$version = Get-Content (Join-Path $release_directory "..\Project\version.txt") -Raw

#-----------------------------------------------------------------------
# Cleanup
$artifact = Join-Path $release_directory "embARC_GUI_${version}_Windows_x64.exe"
if (Test-Path $artifact) {
    Remove-Item $artifact -Force
}

Push-Location (Split-Path $release_directory -Parent)
    & ./gradlew.bat clean
Pop-Location

#-----------------------------------------------------------------------
# Build
Push-Location (Split-Path $release_directory -Parent)
    & ./gradlew.bat build
Pop-Location

#-----------------------------------------------------------------------
# Package .exe
Push-Location (Split-Path $release_directory -Parent)
    $distDir = "build/distributions/windows"
    New-Item -ItemType Directory -Path $distDir -Force
    
    & jpackage --type exe `
               --name embARC `
               --app-version $version `
               --input build/libs `
               --main-jar "embARC-${version}.jar" `
               --main-class com.portalmedia.embarc.gui.Launcher `
               --dest $distDir `
               --vendor "Library of Congress" `
               --description "embARC - metadata embedded for archival content" `
               --icon "icons/embARC.ico"
Pop-Location

#-----------------------------------------------------------------------
# Sign .app
#pushd "${release_directory}/.."
#    if [ -n "${MACOS_CODESIGN_IDENTITY}" ] ; then
#        ./Project/Mac/sign-app-bundle.sh build/distributions/macos/embARC.app com.portalmedia.embarc.gui "${MACOS_CODESIGN_IDENTITY}"
#    fi
#popd

#-----------------------------------------------------------------------
# Package .dmg
#pushd "${release_directory}/.."
#    ./Project/Mac/create-dmg.sh embARC ${version} ./build/distributions/macos/embARC.app
#popd

#-----------------------------------------------------------------------
# Sign .dmg
#pushd "${release_directory}/.."
#    if [ -n "${MACOS_CODESIGN_IDENTITY}" ] ; then
#        ./Project/Mac/sign-app-bundle.sh embARC_GUI_${version}_Mac.dmg com.portalmedia.embarc.gui "${MACOS_CODESIGN_IDENTITY}"
#    fi
#popd

#-----------------------------------------------------------------------
# Export artifacts
Move-Item -Path (Join-Path (Split-Path $release_directory -Parent) "embARC_GUI_${version}_Windows_x64.exe") -Destination $release_directory -Force
