/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.union.impl;

import java.io.Serializable;
import tv.amwa.maj.record.AUID;
import tv.amwa.maj.union.SearchByAUID;
import tv.amwa.maj.union.SearchTag;
import tv.amwa.maj.union.impl.SearchCriteriaImpl;

public class SearchByAUIDImpl
extends SearchCriteriaImpl
implements SearchByAUID,
Serializable,
Cloneable {
    private static final long serialVersionUID = 8151301802260779701L;
    private AUID identification;

    public SearchByAUIDImpl(SearchTag tag, AUID identification) throws NullPointerException, IllegalArgumentException {
        this.setAUID(identification);
        this.setTag(tag);
    }

    @Override
    public AUID getAUID() {
        return this.identification;
    }

    @Override
    public void setAUID(AUID identification) throws NullPointerException {
        if (identification == null) {
            throw new NullPointerException("The given identification for this AUID search criteria is null.");
        }
        this.identification = identification.clone();
    }

    @Override
    public void setTag(SearchTag tag) throws NullPointerException, IllegalArgumentException {
        if (tag == null) {
            throw new NullPointerException("Cannot set the type of a search by AUID criteria with a null search tag.");
        }
        if (tag == SearchTag.ByMediaCrit || tag == SearchTag.ByPackageID || tag == SearchTag.ByPackageKind || tag == SearchTag.ByName || tag == SearchTag.NoSearch) {
            throw new IllegalArgumentException("Search criteria tag is not compatible with searching using AUIDs.");
        }
        this.setSearchTag(tag);
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof SearchByAUID)) {
            return false;
        }
        SearchByAUID testCriteria = (SearchByAUID)o;
        if (testCriteria.getSearchTag() != this.getSearchTag()) {
            return false;
        }
        return this.identification.equals(testCriteria.getAUID());
    }

    public String toString() {
        return "<" + this.getSearchTag().name() + " identification=\"" + this.identification.toString() + "\"/>";
    }

    public SearchByAUIDImpl clone() throws CloneNotSupportedException {
        return (SearchByAUIDImpl)super.clone();
    }

    public int hashCode() {
        return this.identification.hashCode() ^ this.getSearchTag().hashCode();
    }
}

