/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.io.mxf.impl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import tv.amwa.maj.exception.EndOfDataException;
import tv.amwa.maj.exception.InsufficientSpaceException;
import tv.amwa.maj.industry.MediaEngine;
import tv.amwa.maj.industry.PropertyValue;
import tv.amwa.maj.io.mxf.BodyPartitionPack;
import tv.amwa.maj.io.mxf.FixedLengthPack;
import tv.amwa.maj.io.mxf.FooterPartitionPack;
import tv.amwa.maj.io.mxf.HeaderMetadata;
import tv.amwa.maj.io.mxf.HeaderPartitionPack;
import tv.amwa.maj.io.mxf.IndexTable;
import tv.amwa.maj.io.mxf.IndexTableSegment;
import tv.amwa.maj.io.mxf.MXFBuilder;
import tv.amwa.maj.io.mxf.MXFConstants;
import tv.amwa.maj.io.mxf.Partition;
import tv.amwa.maj.io.mxf.PartitionPack;
import tv.amwa.maj.io.mxf.PrimerPack;
import tv.amwa.maj.io.mxf.UL;
import tv.amwa.maj.io.mxf.impl.BodyPartitionImpl;
import tv.amwa.maj.io.mxf.impl.FooterPartitionImpl;
import tv.amwa.maj.io.mxf.impl.HeaderMetadataImpl;
import tv.amwa.maj.io.mxf.impl.HeaderPartitionImpl;
import tv.amwa.maj.io.mxf.impl.IndexTableSegmentImpl;
import tv.amwa.maj.io.mxf.impl.MXFFileImpl;
import tv.amwa.maj.io.mxf.impl.PartitionPackImpl;
import tv.amwa.maj.io.mxf.impl.PrimerPackImpl;
import tv.amwa.maj.meta.ClassDefinition;
import tv.amwa.maj.model.Preface;

public abstract class PartitionImpl
implements Partition,
Cloneable {
    private HeaderMetadata headerMetadata = null;
    private IndexTableSegment indexTableSegment = null;
    private long endOfPartitionPack = -1L;
    private MXFFileImpl localMXFFile;
    private long initialSize = -1L;
    private long actualSize = 0L;
    private static final PrimerPack indexPrimer = IndexTable.indexPrimer;

    @Override
    public abstract PartitionPack getPartitionPack();

    @Override
    public abstract void setPartitionPackPadding(long var1) throws IllegalArgumentException;

    void setEndOfPartitionPack(long endOfPartitionPack) {
        this.endOfPartitionPack = endOfPartitionPack;
    }

    void setMXFFile(MXFFileImpl mxfFile) {
        this.localMXFFile = mxfFile;
    }

    @Override
    public boolean hasHeaderMetadata() {
        return this.getPartitionPack().getHeaderByteCount() != 0L;
    }

    @Override
    public boolean hasIndexTable() {
        return this.getPartitionPack().getIndexSID() != 0;
    }

    @Override
    public boolean hasEssenceContainer() {
        return this.getPartitionPack().getBodySID() != 0;
    }

    @Override
    public Partition clone() {
        try {
            return (Partition)super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new InternalError(cnse.getMessage());
        }
    }

    @Override
    public HeaderMetadata readHeaderMetadata() throws NullPointerException {
        if (this.localMXFFile == null) {
            throw new NullPointerException("Cannot read a header from a null mxf file.");
        }
        if (this.getPartitionPack().getHeaderByteCount() == 0L) {
            this.headerMetadata = null;
            return null;
        }
        this.localMXFFile.seek(this.endOfPartitionPack);
        ByteBuffer primerAndPreface = this.localMXFFile.read((int)this.getPartitionPack().getHeaderByteCount());
        this.headerMetadata = HeaderMetadataImpl.createFromBuffer(primerAndPreface);
        return this.headerMetadata;
    }

    @Override
    public void writeHeaderMetadata(Preface preface, long headerByteCount) throws NullPointerException, InsufficientSpaceException, IOException {
        if (this.localMXFFile == null) {
            throw new NullPointerException("Cannot replace the header metadata in a null MXF file.");
        }
        if (preface == null) {
            throw new NullPointerException("Cannot replace the header metadata using a null preface.");
        }
        long currentHeaderSize = this.getPartitionPack().getHeaderByteCount();
        if (headerByteCount != currentHeaderSize) {
            if (headerByteCount > this.initialSize) {
                throw new InsufficientSpaceException("Not enough room in this partition for the space required by the header metadata.");
            }
            if (currentHeaderSize == 0L && !this.hasEssenceContainer() && !this.hasIndexTable()) {
                this.getPartitionPack().setHeaderByteCount(headerByteCount);
            } else {
                if (headerByteCount > currentHeaderSize) {
                    throw new InsufficientSpaceException("Space requested for header metadata is larger than existing header metadata. Please recalculate partition table.");
                }
                headerByteCount = currentHeaderSize;
            }
        }
        PrimerPackImpl primerPack = new PrimerPackImpl();
        primerPack.addLocalTagEntry((short)15370, MXFConstants.InstanceUID);
        long lengthOfAllSets = PrimerPackImpl.addPropertiesForObject(primerPack, preface);
        if (lengthOfAllSets + MXFBuilder.lengthOfFixedLengthPack(primerPack) > headerByteCount) {
            throw new InsufficientSpaceException("Not enough space to write the primer pack and header metadata to the file.");
        }
        ByteBuffer primerAndPreface = ByteBuffer.allocate((int)this.getPartitionPack().getHeaderByteCount());
        primerAndPreface.rewind();
        MXFBuilder.writeFixedLengthPack(primerPack, primerAndPreface);
        ArrayList<PropertyValue> stillToWrite = new ArrayList<PropertyValue>();
        MXFBuilder.writeLocalSet(preface, primerAndPreface, (PrimerPack)primerPack, stillToWrite);
        while (stillToWrite.size() > 0) {
            PropertyValue headItem = (PropertyValue)stillToWrite.remove(0);
            MXFBuilder.writeLocalSet(headItem, primerAndPreface, (PrimerPack)primerPack, stillToWrite);
        }
        if (primerAndPreface.remaining() > 24) {
            MXFBuilder.writeKey((UL)MXFConstants.KLVFill, primerAndPreface);
            MXFBuilder.writeBERLength(primerAndPreface.remaining() - 8, 8, primerAndPreface);
        }
        while (primerAndPreface.hasRemaining()) {
            primerAndPreface.put((byte)0);
        }
        primerAndPreface.rewind();
        this.writePartitionPack();
        this.localMXFFile.seek(this.endOfPartitionPack);
        this.localMXFFile.write(primerAndPreface);
    }

    @Override
    public void writeIndexTableSegment(IndexTableSegment indexTableSegment, long segmentLength) throws NullPointerException, InsufficientSpaceException, IOException {
        if (this.localMXFFile == null) {
            throw new NullPointerException("Cannot replace the header metadata in a null MXF file.");
        }
        if (indexTableSegment == null) {
            throw new NullPointerException("Cannot replace the index table metadata using a null index table segment.");
        }
        long currentIndexSize = this.getPartitionPack().getIndexByteCount();
        if (segmentLength != currentIndexSize) {
            if (segmentLength > this.initialSize) {
                throw new InsufficientSpaceException("Not enough room in this partition for the space required by the index table segment.");
            }
            if (currentIndexSize == 0L && !this.hasHeaderMetadata()) {
                this.getPartitionPack().setIndexByteCount(segmentLength);
            } else {
                if (segmentLength > currentIndexSize) {
                    throw new InsufficientSpaceException("Space requested for an index table segment is larger than existing header metadata. Please recalculate partition table.");
                }
                segmentLength = currentIndexSize;
            }
        }
        long indexSegmentSize = MXFBuilder.lengthOfLocalSet(indexTableSegment);
        ByteBuffer indexBuffer = ByteBuffer.allocate((int)(indexSegmentSize + 20L));
        indexBuffer.rewind();
        MXFBuilder.writeLocalSet(indexTableSegment, indexBuffer, indexPrimer, new ArrayList<PropertyValue>());
        indexBuffer.rewind();
        this.writePartitionPack();
        this.localMXFFile.seek(this.endOfPartitionPack + this.getPartitionPack().getHeaderByteCount());
        this.localMXFFile.write(indexBuffer);
    }

    @Override
    public void writeSingleIndexSegment(IndexTableSegment indexTableSegment) throws NullPointerException, InsufficientSpaceException, IOException {
        if (this.localMXFFile == null) {
            throw new NullPointerException("Cannot replace the header metadata in a null MXF file.");
        }
        if (indexTableSegment == null) {
            throw new NullPointerException("Cannot replace the index table metadata using a null index table segment.");
        }
        long indexSegmentSize = MXFBuilder.lengthOfLocalSet(indexTableSegment);
        ByteBuffer indexBuffer = ByteBuffer.allocate((int)(indexSegmentSize + 20L));
        indexBuffer.rewind();
        MXFBuilder.writeLocalSet(indexTableSegment, indexBuffer, indexPrimer, new ArrayList<PropertyValue>());
        indexBuffer.rewind();
        this.localMXFFile.write(indexBuffer);
    }

    public void writePartitionPack() throws NullPointerException, InsufficientSpaceException, IOException {
        ByteBuffer partitionPackBuffer = ByteBuffer.allocate(this.getPartitionPack().getEncodedSize() + 20);
        PartitionPack thePack = this.getPartitionPack();
        ClassDefinition theClass = MediaEngine.getClassDefinition(thePack);
        MXFBuilder.writeKey((UL)theClass.getAUID(), partitionPackBuffer);
        MXFBuilder.writeBERLength(thePack.getEncodedSize(), 4, partitionPackBuffer);
        MXFBuilder.writeFixedLengthPack((FixedLengthPack)((Object)this.getPartitionPack()), partitionPackBuffer);
        partitionPackBuffer.rewind();
        this.localMXFFile.seek(this.getPartitionPack().getThisPartition());
        this.localMXFFile.write(partitionPackBuffer);
        this.endOfPartitionPack = this.getPartitionPack().getThisPartition() + (long)this.getPartitionPack().getEncodedSize() + 20L;
    }

    @Override
    public IndexTableSegment readIndexTableSegment() throws NullPointerException {
        if (this.localMXFFile == null) {
            throw new NullPointerException("Cannot read a header from a null mxf file.");
        }
        if (!this.hasIndexTable()) {
            this.indexTableSegment = null;
            return null;
        }
        this.localMXFFile.seek(this.endOfPartitionPack + this.getPartitionPack().getHeaderByteCount());
        ByteBuffer indexBuffer = this.localMXFFile.read((int)this.getPartitionPack().getIndexByteCount());
        this.indexTableSegment = IndexTableSegmentImpl.createFromBuffer(indexBuffer);
        return this.indexTableSegment;
    }

    protected MXFFileImpl getMXFFile() {
        return this.localMXFFile;
    }

    protected long getEndOfParitionPack() {
        return this.endOfPartitionPack;
    }

    @Override
    public long getInitialSize() {
        return this.initialSize;
    }

    @Override
    public void setInitialDataSize(long initialSize) {
        this.initialSize = initialSize;
    }

    @Override
    public long getActualSize() {
        return this.actualSize;
    }

    public void setActualSize(long actualSize) {
        this.actualSize = actualSize;
    }

    @Override
    public void updateSizes() {
        long maxKnownSize;
        int packSize = this.getPartitionPack().getEncodedSize() + 20;
        long initialPlusPack = this.initialSize + (long)packSize;
        this.actualSize = initialPlusPack > (maxKnownSize = (long)packSize + this.getPartitionPack().getHeaderByteCount() + this.getPartitionPack().getIndexByteCount()) ? initialPlusPack : maxKnownSize;
    }

    public static final Partition partitionFactory(MXFFileImpl mxfFile) throws EndOfDataException {
        PartitionPack partitionPack = PartitionPackImpl.readPartitionPack(mxfFile);
        PartitionImpl createdPartition = null;
        if (partitionPack instanceof HeaderPartitionPack) {
            HeaderPartitionImpl headerPartition = new HeaderPartitionImpl();
            headerPartition.setPartitionPack((HeaderPartitionPack)partitionPack);
            createdPartition = headerPartition;
        }
        if (partitionPack instanceof BodyPartitionPack) {
            BodyPartitionImpl bodyPartition = new BodyPartitionImpl();
            bodyPartition.setPartitionPack((BodyPartitionPack)partitionPack);
            createdPartition = bodyPartition;
        }
        if (partitionPack instanceof FooterPartitionPack) {
            FooterPartitionImpl footerPartition = new FooterPartitionImpl();
            footerPartition.setPartitionPack((FooterPartitionPack)partitionPack);
            createdPartition = footerPartition;
        }
        if (createdPartition == null) {
            return null;
        }
        createdPartition.setPartitionPackPadding(MXFBuilder.skipKLVFill(mxfFile));
        ((PartitionImpl)createdPartition).setEndOfPartitionPack(mxfFile.tell());
        ((PartitionImpl)createdPartition).setMXFFile(mxfFile);
        return createdPartition;
    }

    public String toString() {
        return "Partition details: \n" + this.getPartitionPack().toString() + "\n";
    }
}

