/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.model.impl;

import java.io.Serializable;
import tv.amwa.maj.exception.PropertyNotPresentException;
import tv.amwa.maj.exception.TraversalNotPossibleException;
import tv.amwa.maj.industry.MediaClass;
import tv.amwa.maj.industry.MediaProperty;
import tv.amwa.maj.industry.MediaPropertySetter;
import tv.amwa.maj.io.xml.XMLSerializable;
import tv.amwa.maj.model.Component;
import tv.amwa.maj.model.DataDefinition;
import tv.amwa.maj.model.Segment;
import tv.amwa.maj.model.Track;
import tv.amwa.maj.model.impl.DataDefinitionImpl;
import tv.amwa.maj.model.impl.FillerImpl;
import tv.amwa.maj.model.impl.InterchangeObjectImpl;
import tv.amwa.maj.model.impl.SegmentImpl;
import tv.amwa.maj.record.Rational;
import tv.amwa.maj.record.impl.RationalImpl;

@MediaClass(uuid1=0xD010101, uuid2=257, uuid3=14336, uuid4={6, 14, 43, 52, 2, 6, 1, 1}, definedName="Track", aliases={"MobSlot"}, description="The Track class represents an individual track in a Package.", symbol="Track", isConcrete=false)
public class TrackImpl
extends InterchangeObjectImpl
implements Track,
Serializable,
XMLSerializable,
Cloneable {
    private static final long serialVersionUID = -2911988693521900535L;
    private int trackID;
    private String trackName = null;
    private Integer essenceTrackNumber = null;
    private Segment trackSegment;

    @Override
    public DataDefinition getDataDefinition() {
        return this.trackSegment.getComponentDataDefinition();
    }

    @Override
    @MediaProperty(uuid1=17236226, uuid2=256, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="TrackName", aliases={"SlotName"}, typeName="UTF16String", optional=true, uniqueIdentifier=false, pid=18434, symbol="TrackName")
    public String getTrackName() throws PropertyNotPresentException {
        if (this.trackName == null) {
            throw new PropertyNotPresentException("The optional name property is not present for this track.");
        }
        return this.trackName;
    }

    @Override
    @MediaPropertySetter(value="TrackName")
    public void setTrackName(String trackName) {
        this.trackName = trackName;
    }

    @Override
    @MediaProperty(uuid1=17039619, uuid2=0, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="EssenceTrackNumber", aliases={"PhysicalTrackNumber", "PhysicalNumber", "TrackNumber"}, typeName="UInt32", optional=true, uniqueIdentifier=false, pid=18436, symbol="EssenceTrackNumber")
    public int getEssenceTrackNumber() throws PropertyNotPresentException {
        if (this.essenceTrackNumber == null) {
            throw new PropertyNotPresentException("The physical track number is not set for this track.");
        }
        return this.essenceTrackNumber;
    }

    @Override
    @MediaPropertySetter(value="EssenceTrackNumber")
    public void setEssenceTrackNumber(Integer essenceTrackNumber) throws IllegalArgumentException {
        if (essenceTrackNumber == null) {
            this.essenceTrackNumber = null;
            return;
        }
        if (essenceTrackNumber < 0) {
            throw new IllegalArgumentException("Cannot set the essence track number for this track to a negative value.");
        }
        this.essenceTrackNumber = essenceTrackNumber;
    }

    @Override
    @MediaProperty(uuid1=100729092, uuid2=516, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="TrackSegment", aliases={"Segment", "MobSlotSegment"}, typeName="SegmentStrongReference", optional=false, uniqueIdentifier=false, pid=18435, symbol="TrackSegment")
    public Segment getTrackSegment() {
        return this.trackSegment;
    }

    @Override
    @MediaPropertySetter(value="TrackSegment")
    public void setTrackSegment(Segment trackSegment) throws NullPointerException {
        if (trackSegment == null) {
            throw new NullPointerException("Cannot set the segment for this package using a null value.");
        }
        this.trackSegment = trackSegment;
    }

    public Segment initializeTrackSegment() {
        return new FillerImpl(DataDefinitionImpl.forName("Unknown"), 0L);
    }

    @Override
    @MediaProperty(uuid1=0x1070101, uuid2=0, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="TrackID", aliases={"SlotID"}, typeName="UInt32", optional=false, uniqueIdentifier=false, pid=18433, symbol="TrackID")
    public int getTrackID() {
        return this.trackID;
    }

    @Override
    @MediaPropertySetter(value="TrackID")
    public void setTrackID(int trackID) throws IllegalArgumentException {
        if (trackID < 0) {
            throw new IllegalArgumentException("Cannot set the track id of a track to a negative value.");
        }
        this.trackID = trackID;
    }

    public static final int initializeTrackID() {
        return 0;
    }

    FoundSegment findSegment(long offset) throws TraversalNotPossibleException {
        SegmentImpl segment = (SegmentImpl)this.getTrackSegment();
        FoundSegment foundSegment = SegmentImpl.findSubSegment(segment, offset);
        if (foundSegment == null) {
            throw new TraversalNotPossibleException("Cannot find the segment at the given offset in this track.");
        }
        return foundSegment;
    }

    @Override
    public Track clone() {
        return (Track)super.clone();
    }

    @Override
    public String getComment() {
        return "local track persistent id: " + this.getPersistentID();
    }

    static class FoundSegment {
        Component rootObject = null;
        Rational sourceRate = new RationalImpl(0, 1);
        long differencePosition = 0L;

        FoundSegment() {
        }
    }
}

