/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.model.impl;

import java.io.Serializable;
import tv.amwa.maj.constant.ParameterConstant;
import tv.amwa.maj.exception.ParameterNotFoundException;
import tv.amwa.maj.industry.MediaClass;
import tv.amwa.maj.industry.MediaProperty;
import tv.amwa.maj.industry.MediaPropertySetter;
import tv.amwa.maj.meta.TypeDefinition;
import tv.amwa.maj.model.Parameter;
import tv.amwa.maj.model.ParameterDefinition;
import tv.amwa.maj.model.impl.InterchangeObjectImpl;
import tv.amwa.maj.model.impl.ParameterDefinitionImpl;
import tv.amwa.maj.record.AUID;
import tv.amwa.maj.record.impl.AUIDImpl;

@MediaClass(uuid1=0xD010101, uuid2=257, uuid3=15360, uuid4={6, 14, 43, 52, 2, 6, 1, 1}, definedName="Parameter", description="The Parameter class specifies an effect control value.", symbol="Parameter", isConcrete=false)
public class ParameterImpl
extends InterchangeObjectImpl
implements Parameter,
Serializable,
Cloneable {
    private static final long serialVersionUID = -5979416040720344072L;
    private AUID parameterDefinitionReference;

    @Override
    public ParameterDefinition getParameterDefinition() {
        return ParameterDefinitionImpl.forIdentification(this.parameterDefinitionReference).clone();
    }

    public void setParameterDefinitionReference(AUID parameterDefinitionReference) throws NullPointerException, ParameterNotFoundException {
        if (parameterDefinitionReference == null) {
            throw new NullPointerException("Cannot set the parameter definition reference from a null value.");
        }
        ParameterDefinition parameterDefinition = ParameterDefinitionImpl.forIdentification(parameterDefinitionReference);
        if (parameterDefinition == null) {
            throw new ParameterNotFoundException("The given parameter identifier does not map to a known parameter.");
        }
        this.parameterDefinitionReference = parameterDefinitionReference.clone();
    }

    @MediaPropertySetter(value="ParameterDefinitionReference")
    public void setParameterDefinitionReferenceFromStream(AUID parameterDefinitionReference) throws NullPointerException {
        if (parameterDefinitionReference == null) {
            throw new NullPointerException("Cannot set the parameter definition reference from a null value.");
        }
        this.parameterDefinitionReference = parameterDefinitionReference.clone();
    }

    public void setParameterDefinition(ParameterDefinition parameterDefinition) throws NullPointerException {
        if (parameterDefinition == null) {
            throw new NullPointerException("Cannot set the parameter type for this parameter with a null definition.");
        }
        this.parameterDefinitionReference = parameterDefinition.getAUID().clone();
    }

    public static final AUID initializeParameterDefinitionReference() {
        return ParameterConstant.Level;
    }

    @Override
    @MediaProperty(uuid1=100729092, uuid2=260, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="ParameterDefinitionReference", aliases={"Definition"}, typeName="AUID", optional=false, uniqueIdentifier=false, pid=19457, symbol="ParameterDefinitionReference")
    public AUID getParameterDefinitionReference() {
        return this.parameterDefinitionReference.clone();
    }

    @Override
    public TypeDefinition getTypeDefinition() {
        return ParameterDefinitionImpl.forIdentification(this.parameterDefinitionReference).getParameterType();
    }

    @Override
    public Parameter clone() {
        return (Parameter)super.clone();
    }

    @Override
    public String getComment() {
        return "local parameter persistent id is " + this.getPersistentID() + " and the parameter is named " + ParameterDefinitionImpl.forIdentification(this.parameterDefinitionReference).getName();
    }

    public String getParameterDefinitionReferenceString() {
        return AUIDImpl.toPersistentForm(this.parameterDefinitionReference);
    }

    public void setParameterDefinitionReferenceString(String parameterDefinitionReference) {
        this.parameterDefinitionReference = AUIDImpl.fromPersistentForm(parameterDefinitionReference);
    }
}

