/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.model.impl;

import java.io.Serializable;
import tv.amwa.maj.enumeration.CompressEnable;
import tv.amwa.maj.enumeration.CriteriaType;
import tv.amwa.maj.enumeration.MediaOpenMode;
import tv.amwa.maj.exception.InvalidDataDefinitionException;
import tv.amwa.maj.exception.NotTapePackageException;
import tv.amwa.maj.exception.PropertyNotPresentException;
import tv.amwa.maj.exception.TrackExistsException;
import tv.amwa.maj.exception.TrackNotFoundException;
import tv.amwa.maj.industry.MediaClass;
import tv.amwa.maj.industry.MediaProperty;
import tv.amwa.maj.industry.MediaPropertySetter;
import tv.amwa.maj.industry.Stream;
import tv.amwa.maj.integer.Int32;
import tv.amwa.maj.integer.UInt32;
import tv.amwa.maj.io.file.EssenceAccess;
import tv.amwa.maj.io.file.EssenceMultiAccess;
import tv.amwa.maj.misctype.AAFString;
import tv.amwa.maj.model.DataDefinition;
import tv.amwa.maj.model.Locator;
import tv.amwa.maj.model.MaterialPackage;
import tv.amwa.maj.model.PackageMarker;
import tv.amwa.maj.model.Segment;
import tv.amwa.maj.model.SourcePackage;
import tv.amwa.maj.model.impl.EventTrackImpl;
import tv.amwa.maj.model.impl.PackageImpl;
import tv.amwa.maj.model.impl.SegmentImpl;
import tv.amwa.maj.model.impl.StaticTrackImpl;
import tv.amwa.maj.model.impl.TimelineTrackImpl;
import tv.amwa.maj.record.AUID;
import tv.amwa.maj.record.PackageID;
import tv.amwa.maj.record.Rational;
import tv.amwa.maj.record.impl.RationalImpl;
import tv.amwa.maj.record.impl.TimeStampImpl;
import tv.amwa.maj.union.MultiCreateItem;
import tv.amwa.maj.union.SourceReferenceValue;

@MediaClass(uuid1=0xD010101, uuid2=257, uuid3=13824, uuid4={6, 14, 43, 52, 2, 6, 1, 1}, definedName="MaterialPackage", aliases={"MasterMob"}, description="The MaterialPackage class provides access to the SourcePackages and EssenceData objects.", symbol="MaterialPackage")
public class MaterialPackageImpl
extends PackageImpl
implements MaterialPackage,
Serializable,
Cloneable {
    private static final long serialVersionUID = -2143970498731098833L;
    private PackageMarker packageMarker = null;
    private Integer rushIngestTCDropframe = null;
    private Integer videoRushFirstLineIsF2 = null;
    private Integer videoRushChromaRange = null;
    private Integer videoRushProductionTCUserBits = null;
    private Integer audioRushChannels = null;
    private Integer videoRushProductionTCType = null;
    private Integer videoRushKeycodeUserBits = null;
    private Integer videoRushYAspect = null;
    private Integer videoRushProductionTCTimeBits = null;
    private Integer videoRushDominance = null;
    private Integer videoRushBlackLevel = null;
    private Integer audioRushSampleBits = null;
    private Integer rushIngestTCFPS = null;
    private Integer videoRushPlaneSize = null;
    private Integer videoRushVtrTCType = null;
    private Integer audioRushFrameRateNumerator = null;
    private String rushFilePath = null;
    private Integer rushIsFileSequence = null;
    private Integer videoRushRenderable = null;
    private Integer videoRushHosepipedRight = null;
    private Integer videoRushCompression = null;
    private Stream remoteRushBlob = null;
    private Integer videoRushXSize = null;
    private Integer videoRushVtrTCTimeBits = null;
    private Integer videoRushYSize = null;
    private Integer videoRushColourFormat = null;
    private Integer videoRushKeycodeTimeBits = null;
    private Integer videoRushVtrTCUserBits = null;
    private Integer videoRushFormatFlags = null;
    private Integer videoRushScanType = null;
    private Integer rushFileIsMultipleFrames = null;
    private Integer audioRushFrameRateDenominator = null;
    private Integer videoRushPlanes = null;
    private Integer rushIngestTC = null;
    private Integer videoRushWhiteLevel = null;
    private Integer videoRushKeycodeType = null;
    private Integer videoRushXAspect = null;

    public MaterialPackageImpl() {
    }

    public MaterialPackageImpl(PackageID packageID, @AAFString String name) throws NullPointerException {
        if (packageID == null) {
            throw new NullPointerException("Cannot create a new material package with a null package id.");
        }
        if (name == null) {
            throw new NullPointerException("Cannot create a new material package with a null name.");
        }
        this.setPackageID(packageID);
        this.setPackageName(name);
        this.setPackageLastModified(new TimeStampImpl());
        this.setCreationTime(new TimeStampImpl());
    }

    @Override
    @MediaProperty(uuid1=100729092, uuid2=20, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 12}, definedName="PackageMarker", aliases={"PackageMarkerObject"}, typeName="PackageMarkerStrongReference", optional=true, uniqueIdentifier=false, symbol="PackageMarker", pid=0, description="Package marker for this material package, which specifies an optional sub-section that may be played as an alternative to the full material package.")
    public PackageMarker getPackageMarker() throws PropertyNotPresentException {
        if (this.packageMarker == null) {
            throw new PropertyNotPresentException("The optional package marker property is not present for this material package.");
        }
        return this.packageMarker;
    }

    @Override
    @MediaPropertySetter(value="PackageMarker")
    public void setPackageMarker(PackageMarker packageMarker) {
        this.packageMarker = packageMarker;
    }

    @Override
    public void addMaterialTrack(DataDefinition dataDef, int sourceTrackID, SourcePackage sourcePackage, int masterTrackID, String trackName) throws NullPointerException, InvalidDataDefinitionException, TrackNotFoundException, TrackExistsException {
    }

    @Override
    public void appendPhysSourceRef(Rational editrate, int track, DataDefinition essenceKind, SourceReferenceValue ref, long srcRefLength) throws NullPointerException {
    }

    @Override
    public short countChannels(int trackID, CriteriaType mediaCrit, DataDefinition mediaKind) throws NullPointerException, TrackNotFoundException {
        return 0;
    }

    @Override
    public EssenceAccess createEssence(int masterTrackID, DataDefinition mediaKind, AUID codecID, Rational editRate, Rational samplerate, CompressEnable enable, Locator destination, AUID fileFormat) throws NullPointerException {
        return null;
    }

    @Override
    public EssenceAccess createEventEssence(int masterTrackID, DataDefinition mediaKind, AUID codecID, Rational editRate, Rational sampleRate, CompressEnable enable, Locator destination, AUID fileFormat) throws NullPointerException {
        return null;
    }

    @Override
    public EssenceMultiAccess createMultiEssence(AUID codecID, MultiCreateItem[] mediaArray, CompressEnable enable, Locator destination, AUID fileFormat) throws NullPointerException {
        return null;
    }

    @Override
    public EssenceAccess createStaticEssence(int masterTrackID, DataDefinition mediaKind, AUID codecID, CompressEnable enable, Locator destination, AUID fileFormat) throws NullPointerException {
        if (mediaKind == null) {
            throw new NullPointerException("Cannot create new static essence for this material package using a null media kind value.");
        }
        if (codecID == null) {
            throw new NullPointerException("Cannot create new static essence for this material package using a null codec id value.");
        }
        if (enable == null) {
            throw new NullPointerException("Cannot create new static essence for this material package using a null compress enable value.");
        }
        RationalImpl editRate = new RationalImpl(1, 1);
        RationalImpl sampleRate = new RationalImpl(1, 1);
        AUID mediaKindId = mediaKind.getAUID();
        return null;
    }

    @Override
    public EssenceAccess extendEssence(int masterTrackID, DataDefinition mediaKind, AUID codecID, Rational editRate, Rational sampleRate, CompressEnable enable, Locator destintation, AUID fileFormat) throws NullPointerException {
        return null;
    }

    @Override
    public EssenceMultiAccess extendMultiEssence(AUID codecID, MultiCreateItem[] mediaArray, CompressEnable enable, Locator destination, AUID fileFormat) throws NullPointerException {
        return null;
    }

    @Override
    public SegmentImpl getCriteriaSegment(int trackID, CriteriaType criteria) throws TrackNotFoundException, NullPointerException {
        return null;
    }

    @Override
    public int getNumberOfRepresentations(int trackID) throws TrackNotFoundException {
        return 0;
    }

    @Override
    public SegmentImpl getRepresentation(int trackID, int index) throws TrackNotFoundException, IndexOutOfBoundsException {
        return null;
    }

    @Override
    public String getTapeName(int masterTrackID) throws TrackNotFoundException, NotTapePackageException {
        return null;
    }

    @Override
    public void newPhysSourceRef(Rational editrate, int track, DataDefinition essenceKind, SourceReferenceValue ref, long srcRefLength) throws NullPointerException {
    }

    @Override
    public EssenceAccess openEssence(int trackID, CriteriaType mediaCrit, MediaOpenMode openMode, CompressEnable compEnable) throws NullPointerException, TrackNotFoundException {
        return null;
    }

    @Override
    public EssenceMultiAccess openMultiEssence(int trackID, CriteriaType mediaCrit, MediaOpenMode openMode, CompressEnable compEnable) throws NullPointerException, TrackNotFoundException {
        return null;
    }

    public EventTrackImpl appendNewEventTrack(RationalImpl editRate, Segment segment, int trackID, String trackName) throws NullPointerException {
        return null;
    }

    @Override
    public StaticTrackImpl appendNewStaticTrack(Segment segment, int trackID, String trackName) throws NullPointerException {
        return null;
    }

    @Override
    public TimelineTrackImpl appendNewTimelineTrack(Rational editRate, Segment segment, int trackID, String trackName, long origin) throws NullPointerException {
        return null;
    }

    @MediaProperty(uuid1=1174937349, uuid2=-7790, uuid3=19002, uuid4={-118, -70, -98, 7, 109, -126, 8, 24}, definedName="Rush ingest tc dropframe", symbol="Rush_ingest_tc_dropframe", aliases={"Rush_ingest_tc_dropframe"}, typeName="Int32", optional=true, uniqueIdentifier=false, pid=0, prefix="q", namespace="http://www.quantel.com/genQ/extensions")
    @Int32
    public int getRushIngestTCDropframe() {
        if (this.rushIngestTCDropframe == null) {
            throw new PropertyNotPresentException("The optional rush ingest TC dropframe property is not present for this Quantel material package.");
        }
        return this.rushIngestTCDropframe;
    }

    @MediaPropertySetter(value="Rush ingest tc dropframe")
    public void setRushIngestTCDropFrame(@Int32 Integer rushIngestTCDropframe) {
        this.rushIngestTCDropframe = rushIngestTCDropframe;
    }

    @MediaProperty(uuid1=-1910562809, uuid2=-31644, uuid3=19302, uuid4={-124, 35, 85, 78, 63, -30, 111, -87}, definedName="Video rush firstLineIsF2", symbol="Video_rush_firstLineIsF2", aliases={"Video_rush_firstLineIsF2"}, typeName="Int32", optional=true, uniqueIdentifier=false, pid=0, prefix="q", namespace="http://www.quantel.com/genQ/extensions")
    @Int32
    public int getVideoRushFirstLineIsF2() {
        if (this.videoRushFirstLineIsF2 == null) {
            throw new PropertyNotPresentException("The optional video rush first line is F2 property is not present for this Quantel material package.");
        }
        return this.videoRushFirstLineIsF2;
    }

    @MediaPropertySetter(value="Video rush firstLineIsF2")
    public void setVideoRushFirstLineIsF2(@Int32 Integer videoRushFirstLineIsF2) {
        this.videoRushFirstLineIsF2 = videoRushFirstLineIsF2;
    }

    @MediaProperty(uuid1=-2104095479, uuid2=31489, uuid3=17884, uuid4={-74, -24, -90, -10, 83, -114, 114, -23}, definedName="Video rush chroma range", symbol="Video_rush_chroma_range", aliases={"Video_rush_chroma_range"}, typeName="UInt32", optional=true, uniqueIdentifier=false, pid=0, prefix="q", namespace="http://www.quantel.com/genQ/extensions")
    @UInt32
    public int getVideoRushChromaRange() {
        if (this.videoRushChromaRange == null) {
            throw new PropertyNotPresentException("The optional video rush chroma range property is not present for this Quantel material package.");
        }
        return this.videoRushChromaRange;
    }

    @MediaPropertySetter(value="Video rush chroma range")
    public void setVideoRushChromaRange(@UInt32 Integer videoRushChromaRange) {
        if (videoRushChromaRange == null) {
            this.videoRushChromaRange = null;
            return;
        }
        if (videoRushChromaRange < 0) {
            throw new IllegalArgumentException("Cannot set property video rush chroma range to a negative value.");
        }
        this.videoRushChromaRange = videoRushChromaRange;
    }

    @MediaProperty(uuid1=-1726238960, uuid2=24987, uuid3=17302, uuid4={-77, -101, -27, 50, 19, -55, -34, 65}, definedName="Video rush production tc user bits", symbol="Video_rush_production_tc_user_bits", aliases={"Video_rush_production_tc_user_bits"}, typeName="UInt32", optional=true, uniqueIdentifier=false, pid=0, prefix="q", namespace="http://www.quantel.com/genQ/extensions")
    @UInt32
    public int getVideoRushProductionTCUserBits() {
        if (this.videoRushProductionTCUserBits == null) {
            throw new PropertyNotPresentException("The optional video rush production TC user bits property is not present for this Quantel material package.");
        }
        return this.videoRushProductionTCUserBits;
    }

    @MediaPropertySetter(value="Video rush production tc user bits")
    public void setVideoRushProductionTCUserBits(@UInt32 Integer videoRushProductionTCUserBits) {
        if (videoRushProductionTCUserBits == null) {
            this.videoRushProductionTCUserBits = null;
            return;
        }
        if (videoRushProductionTCUserBits < 0) {
            throw new IllegalArgumentException("Cannot set property video rush production TC user bits to a negative value.");
        }
        this.videoRushProductionTCUserBits = videoRushProductionTCUserBits;
    }

    @MediaProperty(uuid1=590602260, uuid2=23326, uuid3=18176, uuid4={-103, 105, -7, 76, 21, -16, 33, -103}, definedName="Audio rush channels", symbol="Audio_rush_channels", aliases={"Audio_rush_channels"}, typeName="UInt32", optional=true, uniqueIdentifier=false, pid=0, prefix="q", namespace="http://www.quantel.com/genQ/extensions")
    @UInt32
    public int getAudioRushChannels() {
        if (this.audioRushChannels == null) {
            throw new PropertyNotPresentException("The optional audio rush channels property is not present for this Quantel material package.");
        }
        return this.audioRushChannels;
    }

    @MediaPropertySetter(value="Audio rush channels")
    public void setAudioRushChannels(@UInt32 Integer audioRushChannels) {
        if (audioRushChannels == null) {
            this.audioRushChannels = null;
            return;
        }
        if (audioRushChannels < 0) {
            throw new IllegalArgumentException("Cannot set property video rush production TC user bits to a negative value.");
        }
        this.audioRushChannels = audioRushChannels;
    }

    @MediaProperty(uuid1=-1084162274, uuid2=-7852, uuid3=17685, uuid4={-126, 54, -42, 84, 13, 25, 125, 38}, definedName="Video rush production tc type", symbol="Video_rush_production_tc_type", aliases={"Video_rush_production_tc_type"}, typeName="UInt32", optional=true, uniqueIdentifier=false, pid=0, prefix="q", namespace="http://www.quantel.com/genQ/extensions")
    @UInt32
    public int getVideoRushProductionTCType() {
        if (this.videoRushProductionTCType == null) {
            throw new PropertyNotPresentException("The optional video rush production TC type property is not present for this Quantel material package.");
        }
        return this.videoRushProductionTCType;
    }

    @MediaPropertySetter(value="Video rush production tc type")
    public void setVideoRushProductionTCType(@UInt32 Integer videoRushProductionTCType) {
        if (videoRushProductionTCType == null) {
            this.videoRushProductionTCType = null;
            return;
        }
        if (videoRushProductionTCType < 0) {
            throw new IllegalArgumentException("Cannot set property video rush production TC type to a negative value.");
        }
        this.videoRushProductionTCType = videoRushProductionTCType;
    }

    @MediaProperty(uuid1=-299868385, uuid2=-13143, uuid3=18127, uuid4={-91, -101, 90, 80, -101, -121, -35, 47}, definedName="Video rush keycode user bits", symbol="Video_rush_keycode_user_bits", aliases={"Video_rush_keycode_user_bits"}, typeName="UInt32", optional=true, uniqueIdentifier=false, pid=0, prefix="q", namespace="http://www.quantel.com/genQ/extensions")
    @UInt32
    public int getVideoRushKeycodeUserBits() {
        if (this.videoRushKeycodeUserBits == null) {
            throw new PropertyNotPresentException("The optional video rush keycode user bits property is not present for this Quantel material package.");
        }
        return this.videoRushKeycodeUserBits;
    }

    @MediaPropertySetter(value="Video rush keycode user bits")
    public void setVideoRushKeycodeUserBits(@UInt32 Integer videoRushKeycodeUserBits) {
        if (videoRushKeycodeUserBits == null) {
            this.videoRushKeycodeUserBits = null;
            return;
        }
        if (videoRushKeycodeUserBits < 0) {
            throw new IllegalArgumentException("Cannot set property video rush keycode user bits to a negative value.");
        }
        this.videoRushKeycodeUserBits = videoRushKeycodeUserBits;
    }

    @MediaProperty(uuid1=-86459866, uuid2=8605, uuid3=18625, uuid4={-101, -64, -104, 73, 62, -49, 38, -68}, definedName="Video rush y aspect", symbol="Video_rush_y_aspect", aliases={"Video_rush_y_aspect"}, typeName="UInt32", optional=true, uniqueIdentifier=false, pid=0, prefix="q", namespace="http://www.quantel.com/genQ/extensions")
    @UInt32
    public int getVideoRushYAspect() {
        if (this.videoRushYAspect == null) {
            throw new PropertyNotPresentException("The optional video rush Y aspect property is not present for this Quantel material package.");
        }
        return this.videoRushYAspect;
    }

    @MediaPropertySetter(value="Video rush y aspect")
    public void setVideoRushYAspect(@UInt32 Integer videoRushYAspect) {
        if (videoRushYAspect == null) {
            this.videoRushYAspect = null;
            return;
        }
        if (videoRushYAspect < 0) {
            throw new IllegalArgumentException("Cannot set property video Rush Y aspect to a negative value.");
        }
        this.videoRushYAspect = videoRushYAspect;
    }

    @MediaProperty(uuid1=749820715, uuid2=118, uuid3=19260, uuid4={-124, -53, 68, 49, -94, -42, -30, -12}, definedName="Video rush production tc time bits", symbol="Video_rush_production_tc_time_bits", aliases={"Video_rush_production_tc_time_bits"}, typeName="UInt32", optional=true, uniqueIdentifier=false, pid=0, prefix="q", namespace="http://www.quantel.com/genQ/extensions")
    @UInt32
    public int getVideoRushProductionTCTimeBits() {
        if (this.videoRushProductionTCTimeBits == null) {
            throw new PropertyNotPresentException("The optional video rush production TC time bits property is not present for this Quantel material package.");
        }
        return this.videoRushProductionTCTimeBits;
    }

    @MediaPropertySetter(value="Video rush production tc time bits")
    public void setVideoRushProductionTCTimeBits(@UInt32 Integer videoRushProductionTCTimeBits) {
        if (videoRushProductionTCTimeBits == null) {
            this.videoRushProductionTCTimeBits = null;
            return;
        }
        if (videoRushProductionTCTimeBits < 0) {
            throw new IllegalArgumentException("Cannot set property video rush production TC time bits to a negative value.");
        }
        this.videoRushProductionTCTimeBits = videoRushProductionTCTimeBits;
    }

    @MediaProperty(uuid1=1888974382, uuid2=-1198, uuid3=18348, uuid4={-123, -58, -95, 125, -123, 23, -6, -115}, definedName="Video rush dominance", symbol="Video_rush_dominance", aliases={"Video_rush_dominance"}, typeName="Int32", optional=true, uniqueIdentifier=false, pid=0, prefix="q", namespace="http://www.quantel.com/genQ/extensions")
    @Int32
    public int getVideoRushDominance() {
        if (this.videoRushDominance == null) {
            throw new PropertyNotPresentException("The optional video rush dominance property is not present for this Quantel material package.");
        }
        return this.videoRushDominance;
    }

    @MediaPropertySetter(value="Video rush dominance")
    public void setVideoRushDominance(@Int32 Integer videoRushDominance) {
        this.videoRushDominance = videoRushDominance;
    }

    @MediaProperty(uuid1=710504258, uuid2=-28004, uuid3=17318, uuid4={-67, 74, 38, 101, -85, 32, 77, 44}, definedName="Video rush black level", symbol="Video_rush_black_level", aliases={"Video_rush_black_level"}, typeName="UInt32", optional=true, uniqueIdentifier=false, pid=0, prefix="q", namespace="http://www.quantel.com/genQ/extensions")
    @UInt32
    public int getVideoRushBlackLevel() {
        if (this.videoRushBlackLevel == null) {
            throw new PropertyNotPresentException("The optional video rush black level property is not present for this Quantel material package.");
        }
        return this.videoRushBlackLevel;
    }

    @MediaPropertySetter(value="Video rush black level")
    public void setVideoRushBlackLevel(@UInt32 Integer videoRushBlackLevel) {
        if (videoRushBlackLevel == null) {
            this.videoRushBlackLevel = null;
            return;
        }
        if (videoRushBlackLevel < 0) {
            throw new IllegalArgumentException("Cannot set property video rush black level to a negative value.");
        }
        this.videoRushBlackLevel = videoRushBlackLevel;
    }

    @MediaProperty(uuid1=2122700635, uuid2=-706, uuid3=16563, uuid4={-89, 126, -40, -32, -32, 23, 12, -95}, definedName="Audio rush sample bits", symbol="Audio_rush_sample_bits", aliases={"Audio_rush_sample_bits"}, typeName="UInt32", optional=true, uniqueIdentifier=false, pid=0, prefix="q", namespace="http://www.quantel.com/genQ/extensions")
    @UInt32
    public int getAudioRushSampleBits() {
        if (this.audioRushSampleBits == null) {
            throw new PropertyNotPresentException("The optional audio rush sample bits property is not present for this Quantel material package.");
        }
        return this.audioRushSampleBits;
    }

    @MediaPropertySetter(value="Audio rush sample bits")
    public void setAudioRushSampleBits(@UInt32 Integer audioRushSampleBits) {
        if (audioRushSampleBits == null) {
            this.audioRushSampleBits = null;
            return;
        }
        if (audioRushSampleBits < 0) {
            throw new IllegalArgumentException("Cannot set property audio rush sample bits to a negative value.");
        }
        this.audioRushSampleBits = audioRushSampleBits;
    }

    @MediaProperty(uuid1=-1958778259, uuid2=-8076, uuid3=16837, uuid4={-80, 64, -126, -31, -52, 43, -80, 49}, definedName="Rush ingest tc fps", symbol="Rush_ingest_tc_fps", aliases={"Rush_ingest_tc_fps"}, typeName="Int32", optional=true, uniqueIdentifier=false, pid=0, prefix="q", namespace="http://www.quantel.com/genQ/extensions")
    @Int32
    public int getRushIngestTCFPS() {
        if (this.rushIngestTCFPS == null) {
            throw new PropertyNotPresentException("The optional rush ingest TC FPS property is not present for this Quantel material package.");
        }
        return this.rushIngestTCFPS;
    }

    @MediaPropertySetter(value="Rush ingest tc fps")
    public void setRushIngestTCFPS(@Int32 Integer rushIngestTCFPS) {
        this.rushIngestTCFPS = rushIngestTCFPS;
    }

    @MediaProperty(uuid1=-791586959, uuid2=-18338, uuid3=20240, uuid4={-91, -65, -52, -49, -56, -98, 14, -58}, definedName="Video rush plane size", symbol="Video_rush_plane_size", aliases={"Video_rush_plane_size"}, typeName="UInt32", optional=true, uniqueIdentifier=false, pid=0, prefix="q", namespace="http://www.quantel.com/genQ/extensions")
    @UInt32
    public int getVideoRushPlaneSize() {
        if (this.videoRushPlaneSize == null) {
            throw new PropertyNotPresentException("The optional video rush plane size property is not present for this Quantel material package.");
        }
        return this.videoRushPlaneSize;
    }

    @MediaPropertySetter(value="Video rush plane size")
    public void setVideoRushPlaneSize(@UInt32 Integer videoRushPlaneSize) {
        if (videoRushPlaneSize == null) {
            this.videoRushPlaneSize = null;
            return;
        }
        if (videoRushPlaneSize < 0) {
            throw new IllegalArgumentException("Cannot set property video rush plane size to a negative value.");
        }
        this.videoRushPlaneSize = videoRushPlaneSize;
    }

    @MediaProperty(uuid1=-224349321, uuid2=29275, uuid3=20315, uuid4={-116, -4, -43, -34, -28, -37, -9, -119}, definedName="Video rush vtr tc type", symbol="Video_rush_vtr_tc_type", aliases={"Video_rush_vtr_tc_type"}, typeName="UInt32", optional=true, uniqueIdentifier=false, pid=0, prefix="q", namespace="http://www.quantel.com/genQ/extensions")
    @UInt32
    public int getVideoRushVtrTCType() {
        if (this.videoRushVtrTCType == null) {
            throw new PropertyNotPresentException("The optional video rush vtr TC type property is not present for this Quantel material package.");
        }
        return this.videoRushVtrTCType;
    }

    @MediaPropertySetter(value="Video rush vtr tc type")
    public void setVideoRushVtrTCType(@UInt32 Integer videoRushVtrTCType) {
        if (videoRushVtrTCType == null) {
            this.videoRushVtrTCType = null;
            return;
        }
        if (videoRushVtrTCType < 0) {
            throw new IllegalArgumentException("Cannot set property video rush vtr TC type to a negative value.");
        }
        this.videoRushVtrTCType = videoRushVtrTCType;
    }

    @MediaProperty(uuid1=-931689604, uuid2=16347, uuid3=19200, uuid4={-72, 127, -47, -20, -88, -17, -87, -37}, definedName="Audio rush frame rate numerator", symbol="Audio_rush_frame_rate_numerator", aliases={"Audio_rush_frame_rate_numerator"}, typeName="Int32", optional=true, uniqueIdentifier=false, pid=0, prefix="q", namespace="http://www.quantel.com/genQ/extensions")
    @Int32
    public int getAudioRushFrameRateNumerator() {
        if (this.audioRushFrameRateNumerator == null) {
            throw new PropertyNotPresentException("The optional audio rush frame rate numerator property is not present for this Quantel material package.");
        }
        return this.audioRushFrameRateNumerator;
    }

    @MediaPropertySetter(value="Audio rush frame rate numerator")
    public void setAudioRushFrameRateNumerator(@Int32 Integer audioRushFrameRateNumerator) {
        this.audioRushFrameRateNumerator = audioRushFrameRateNumerator;
    }

    @MediaProperty(uuid1=-1796324992, uuid2=-31960, uuid3=18685, uuid4={-105, -68, -107, -30, -68, -77, 12, -72}, definedName="Rush file path", symbol="Rush_file_path", aliases={"Rush_file_path"}, typeName="UTF16String", optional=true, uniqueIdentifier=false, pid=0, prefix="q", namespace="http://www.quantel.com/genQ/extensions")
    public String getRushFilePath() {
        if (this.rushFilePath == null) {
            throw new PropertyNotPresentException("The optional rush file path property is not present for this Quantel material package.");
        }
        return this.rushFilePath;
    }

    @MediaPropertySetter(value="Rush file path")
    public void setRushFilePath(String rushFilePath) {
        this.rushFilePath = rushFilePath;
    }

    @MediaProperty(uuid1=2038626688, uuid2=3325, uuid3=18965, uuid4={-99, 8, 10, 49, 30, -75, -109, 13}, definedName="Rush is file sequence", symbol="Rush_is_file_sequence", aliases={"Rush_is_file_sequence"}, typeName="Int32", optional=true, uniqueIdentifier=false, pid=0, prefix="q", namespace="http://www.quantel.com/genQ/extensions")
    @Int32
    public int getRushIsFileSequence() {
        if (this.rushIsFileSequence == null) {
            throw new PropertyNotPresentException("The optional rush is file sequence property is not present for this Quantel material package.");
        }
        return this.rushIsFileSequence;
    }

    @MediaPropertySetter(value="Rush is file sequence")
    public void setRushIsFileSequence(@Int32 int rushIsFileSequence) {
        this.rushIsFileSequence = rushIsFileSequence;
    }

    @MediaProperty(uuid1=-1964649838, uuid2=-31126, uuid3=17898, uuid4={-121, -17, -17, 7, -83, 41, 84, 43}, definedName="Video rush renderable", symbol="Video_rush_renderable", aliases={"Video_rush_renderable"}, typeName="UInt32", optional=true, uniqueIdentifier=false, pid=0, prefix="q", namespace="http://www.quantel.com/genQ/extensions")
    @UInt32
    public int getVideoRushRenderable() {
        if (this.videoRushRenderable == null) {
            throw new PropertyNotPresentException("The optional video rush renderable property is not present for this Quantel material package.");
        }
        return this.videoRushRenderable;
    }

    @MediaPropertySetter(value="Video rush renderable")
    public void setVideoRushRenderable(@UInt32 Integer videoRushRenderable) {
        if (videoRushRenderable == null) {
            this.videoRushRenderable = null;
            return;
        }
        if (videoRushRenderable < 0) {
            throw new IllegalArgumentException("Cannot set property video rush renderable to a negative value.");
        }
        this.videoRushRenderable = videoRushRenderable;
    }

    @MediaProperty(uuid1=1519537820, uuid2=-6371, uuid3=17516, uuid4={-128, -125, -2, 113, 18, -120, -79, 109}, definedName="Video rush hosepiped right", symbol="Video_rush_hosepiped_right", aliases={"Video_rush_hosepiped_right"}, typeName="UInt32", optional=true, uniqueIdentifier=false, pid=0, prefix="q", namespace="http://www.quantel.com/genQ/extensions")
    @UInt32
    public int getVideoRushHosepipedRight() {
        if (this.videoRushHosepipedRight == null) {
            throw new PropertyNotPresentException("The optional video rush hosepiped right property is not present for this Quantel material package.");
        }
        return this.videoRushHosepipedRight;
    }

    @MediaPropertySetter(value="Video rush hosepiped right")
    public void setVideoRushHosepipedRight(@UInt32 Integer videoRushHosepipedRight) {
        if (videoRushHosepipedRight == null) {
            this.videoRushHosepipedRight = null;
            return;
        }
        if (videoRushHosepipedRight < 0) {
            throw new IllegalArgumentException("Cannot set property video rush hosepiped right to a negative value.");
        }
        this.videoRushHosepipedRight = videoRushHosepipedRight;
    }

    @MediaProperty(uuid1=-517472096, uuid2=-29723, uuid3=16652, uuid4={-116, -23, -73, -2, 64, -106, 50, -12}, definedName="Video rush compression", symbol="Video_rush_compression", aliases={"Video_rush_compression"}, typeName="UInt32", optional=true, uniqueIdentifier=false, pid=0, prefix="q", namespace="http://www.quantel.com/genQ/extensions")
    @UInt32
    public int getVideoRushCompression() {
        if (this.videoRushCompression == null) {
            throw new PropertyNotPresentException("The optional video rush compression property is not present for this Quantel material package.");
        }
        return this.videoRushCompression;
    }

    @MediaPropertySetter(value="Video rush compression")
    public void setVideoRushCompression(@UInt32 Integer videoRushCompression) {
        if (videoRushCompression == null) {
            this.videoRushCompression = null;
            return;
        }
        if (videoRushCompression < 0) {
            throw new IllegalArgumentException("Cannot set property video rush compression to a negative value.");
        }
        this.videoRushCompression = videoRushCompression;
    }

    @MediaProperty(uuid1=2038895781, uuid2=31054, uuid3=17239, uuid4={-68, -2, 73, 24, 37, -7, -55, -11}, definedName="Remote rush blob", symbol="Remote_rush_blob", aliases={"Remote_rush_blob"}, typeName="Stream", optional=true, uniqueIdentifier=false, pid=0, prefix="q", namespace="http://www.quantel.com/genQ/extensions")
    public Stream getRemoteRushBlob() {
        if (this.remoteRushBlob == null) {
            throw new PropertyNotPresentException("The optional remote rush blob property is not present for this Quantel material package.");
        }
        return this.remoteRushBlob;
    }

    @MediaPropertySetter(value="Remote rush blob")
    public void setRemoteRushBlob(Stream remoteRushBlob) {
        this.remoteRushBlob = remoteRushBlob;
    }

    @MediaProperty(uuid1=-944117841, uuid2=13533, uuid3=18354, uuid4={-123, 52, 46, 12, 14, -29, -19, 92}, definedName="Video rush x size", symbol="Video_rush_x_size", aliases={"Video_rush_x_size"}, typeName="UInt32", optional=true, uniqueIdentifier=false, pid=0, prefix="q", namespace="http://www.quantel.com/genQ/extensions")
    @UInt32
    public int getVideoRushXSize() {
        if (this.videoRushXSize == null) {
            throw new PropertyNotPresentException("The optional video rush X size property is not present for this Quantel material package.");
        }
        return this.videoRushXSize;
    }

    @MediaPropertySetter(value="Video rush x size")
    public void setVideoRushXSize(@UInt32 Integer videoRushXSize) {
        if (videoRushXSize == null) {
            this.videoRushXSize = null;
            return;
        }
        if (videoRushXSize < 0) {
            throw new IllegalArgumentException("Cannot set property video rush X size to a negative value.");
        }
        this.videoRushXSize = videoRushXSize;
    }

    @MediaProperty(uuid1=-1272648017, uuid2=28805, uuid3=19539, uuid4={-71, 106, -94, -47, -128, 48, 49, -98}, definedName="Video rush vtr tc time bits", symbol="Video_rush_vtr_tc_time_bits", aliases={"Video_rush_vtr_tc_time_bits"}, typeName="UInt32", optional=true, uniqueIdentifier=false, pid=0, prefix="q", namespace="http://www.quantel.com/genQ/extensions")
    @UInt32
    public int getVideoRushVtrTCTimeBits() {
        if (this.videoRushVtrTCTimeBits == null) {
            throw new PropertyNotPresentException("The optional video rush vtr TC time bits property is not present for this Quantel material package.");
        }
        return this.videoRushVtrTCTimeBits;
    }

    @MediaPropertySetter(value="Video rush vtr tc time bits")
    public void setVideoRushVtrTCTimeBits(@UInt32 Integer videoRushVtrTCTimeBits) {
        if (videoRushVtrTCTimeBits == null) {
            this.videoRushVtrTCTimeBits = null;
            return;
        }
        if (videoRushVtrTCTimeBits < 0) {
            throw new IllegalArgumentException("Cannot set property video rush vtr TC time bits to a negative value.");
        }
        this.videoRushVtrTCTimeBits = videoRushVtrTCTimeBits;
    }

    @MediaProperty(uuid1=1693708463, uuid2=23485, uuid3=18876, uuid4={-77, -74, 71, 95, -30, -83, 116, -107}, definedName="Video rush y size", symbol="Video_rush_y_size", aliases={"Video_rush_y_size"}, typeName="UInt32", optional=true, uniqueIdentifier=false, pid=0, prefix="q", namespace="http://www.quantel.com/genQ/extensions")
    @UInt32
    public int getVideoRushYSize() {
        if (this.videoRushYSize == null) {
            throw new PropertyNotPresentException("The optional video rush Y size property is not present for this Quantel material package.");
        }
        return this.videoRushYSize;
    }

    @MediaPropertySetter(value="Video rush y size")
    public void setVideoRushYSize(@UInt32 Integer videoRushYSize) {
        if (videoRushYSize == null) {
            this.videoRushYSize = null;
            return;
        }
        if (videoRushYSize < 0) {
            throw new IllegalArgumentException("Cannot set property video rush Y size to a negative value.");
        }
        this.videoRushYSize = videoRushYSize;
    }

    @MediaProperty(uuid1=-1603343949, uuid2=-17864, uuid3=17111, uuid4={-99, -74, -98, 106, -53, -33, -12, 4}, definedName="Video rush colour format", symbol="Video_rush_colour_format", aliases={"Video_rush_colour_format"}, typeName="UInt32", optional=true, uniqueIdentifier=false, pid=0, prefix="q", namespace="http://www.quantel.com/genQ/extensions")
    @UInt32
    public int getVideoRushColourFormat() {
        if (this.videoRushColourFormat == null) {
            throw new PropertyNotPresentException("The optional video rush colour format property is not present for this Quantel material package.");
        }
        return this.videoRushColourFormat;
    }

    @MediaPropertySetter(value="Video rush colour format")
    public void setVideoRushColourFormat(@UInt32 Integer videoRushColourFormat) {
        if (videoRushColourFormat == null) {
            this.videoRushColourFormat = null;
            return;
        }
        if (videoRushColourFormat < 0) {
            throw new IllegalArgumentException("Cannot set property video rush colour format to a negative value.");
        }
        this.videoRushColourFormat = videoRushColourFormat;
    }

    @MediaProperty(uuid1=-198415947, uuid2=-14801, uuid3=18721, uuid4={-79, -39, 37, 99, 25, -102, 112, 6}, definedName="Video rush keycode time bits", symbol="Video_rush_keycode_time_bits", aliases={"Video_rush_keycode_time_bits"}, typeName="UInt32", optional=true, uniqueIdentifier=false, pid=0, prefix="q", namespace="http://www.quantel.com/genQ/extensions")
    @UInt32
    public int getVideoRushKeycodeTimeBits() {
        if (this.videoRushKeycodeTimeBits == null) {
            throw new PropertyNotPresentException("The optional video rush keycode time bits property is not present for this Quantel material package.");
        }
        return this.videoRushKeycodeTimeBits;
    }

    @MediaPropertySetter(value="Video rush keycode time bits")
    public void setVideoRushKeycodeTimeBits(@UInt32 Integer videoRushKeycodeTimeBits) {
        if (videoRushKeycodeTimeBits == null) {
            this.videoRushKeycodeTimeBits = null;
            return;
        }
        if (videoRushKeycodeTimeBits < 0) {
            throw new IllegalArgumentException("Cannot set property video rush keycode time bits to a negative value.");
        }
        this.videoRushKeycodeTimeBits = videoRushKeycodeTimeBits;
    }

    @MediaProperty(uuid1=576000694, uuid2=-31252, uuid3=18280, uuid4={-65, -40, -123, -124, 58, 124, -54, 65}, definedName="Video rush vtr tc user bits", symbol="Video_rush_vtr_tc_user_bits", aliases={"Video_rush_vtr_tc_user_bits"}, typeName="UInt32", optional=true, uniqueIdentifier=false, pid=0, prefix="q", namespace="http://www.quantel.com/genQ/extensions")
    @UInt32
    public int getVideoRushVtrTCUserBits() {
        if (this.videoRushVtrTCUserBits == null) {
            throw new PropertyNotPresentException("The optional video rush vtr TC user bits property is not present for this Quantel material package.");
        }
        return this.videoRushVtrTCUserBits;
    }

    @MediaPropertySetter(value="Video rush vtr tc user bits")
    public void setVideoRushVtrTCUserBits(@UInt32 Integer videoRushVtrTCUserBits) {
        if (videoRushVtrTCUserBits == null) {
            this.videoRushVtrTCUserBits = null;
            return;
        }
        if (videoRushVtrTCUserBits < 0) {
            throw new IllegalArgumentException("Cannot set property video rush vtr TC user bits to a negative value.");
        }
        this.videoRushVtrTCUserBits = videoRushVtrTCUserBits;
    }

    @MediaProperty(uuid1=1052410556, uuid2=-5754, uuid3=17142, uuid4={-87, -15, -110, 61, -81, -68, -44, -97}, definedName="Video rush format flags", symbol="Video_rush_format_flags", aliases={"Video_rush_format_flags"}, typeName="UInt32", optional=true, uniqueIdentifier=false, pid=0, prefix="q", namespace="http://www.quantel.com/genQ/extensions")
    @UInt32
    public int getVideoRushFormatFlags() {
        if (this.videoRushFormatFlags == null) {
            throw new PropertyNotPresentException("The optional video rush format flags property is not present for this Quantel material package.");
        }
        return this.videoRushFormatFlags;
    }

    @MediaPropertySetter(value="Video rush format flags")
    public void setVideoRushFormatFlags(@UInt32 Integer videoRushFormatFlags) {
        if (videoRushFormatFlags == null) {
            this.videoRushFormatFlags = null;
            return;
        }
        if (videoRushFormatFlags < 0) {
            throw new IllegalArgumentException("Cannot set property video rush format flags to a negative value.");
        }
        this.videoRushFormatFlags = videoRushFormatFlags;
    }

    @MediaProperty(uuid1=-872833603, uuid2=-10276, uuid3=19622, uuid4={-77, -43, 111, 76, -80, -91, -72, 2}, definedName="Video rush scan type", symbol="Video_rush_scan_type", aliases={"Video_rush_scan_type"}, typeName="Int32", optional=true, uniqueIdentifier=false, pid=0, prefix="q", namespace="http://www.quantel.com/genQ/extensions")
    @Int32
    public int getVideoRushScanType() {
        if (this.videoRushScanType == null) {
            throw new PropertyNotPresentException("The optional video rush scan type property is not present for this Quantel material package.");
        }
        return this.videoRushScanType;
    }

    @MediaPropertySetter(value="Video rush scan type")
    public void setVideoRushScanType(@Int32 Integer videoRushScanType) {
        this.videoRushScanType = videoRushScanType;
    }

    @MediaProperty(uuid1=-872863030, uuid2=-31494, uuid3=19393, uuid4={-108, -58, 41, 48, 75, 9, -91, -67}, definedName="Rush file is multiple frames", symbol="Rush_file_is_multiple_frames", aliases={"Rush_file_is_multiple_frames"}, typeName="Int32", optional=true, uniqueIdentifier=false, pid=0, prefix="q", namespace="http://www.quantel.com/genQ/extensions")
    @Int32
    public int getRushFileIsMultipleFrames() {
        if (this.rushFileIsMultipleFrames == null) {
            throw new PropertyNotPresentException("The optional rush file is multiple frames property is not present for this Quantel material package.");
        }
        return this.rushFileIsMultipleFrames;
    }

    @MediaPropertySetter(value="Rush file is multiple frames")
    public void setRushFileIsMultipleFrames(@Int32 Integer rushFileIsMultipleFrames) {
        this.rushFileIsMultipleFrames = rushFileIsMultipleFrames;
    }

    @MediaProperty(uuid1=-1276414770, uuid2=-11810, uuid3=16659, uuid4={-123, -39, -3, 25, -35, 108, 106, 59}, definedName="Audio rush frame rate denominator", symbol="Audio_rush_frame_rate_denominator", aliases={"Audio_rush_frame_rate_denominator"}, typeName="Int32", optional=true, uniqueIdentifier=false, pid=0, prefix="q", namespace="http://www.quantel.com/genQ/extensions")
    @Int32
    public int getAudioRushFrameRateDenominator() {
        if (this.audioRushFrameRateDenominator == null) {
            throw new PropertyNotPresentException("The optional audio rush frame rate denominator property is not present for this Quantel material package.");
        }
        return this.audioRushFrameRateDenominator;
    }

    @MediaPropertySetter(value="Audio rush frame rate denominator")
    public void setAudioRushFrameRateDenominator(@Int32 Integer audioRushFrameRateDenominator) {
        this.audioRushFrameRateDenominator = audioRushFrameRateDenominator;
    }

    @MediaProperty(uuid1=1297176784, uuid2=-6409, uuid3=18800, uuid4={-68, 65, 103, 125, -58, 21, 3, -105}, definedName="Video rush planes", symbol="Video_rush_planes", aliases={"Video_rush_planes"}, typeName="UInt32", optional=true, uniqueIdentifier=false, pid=0, prefix="q", namespace="http://www.quantel.com/genQ/extensions")
    @UInt32
    public int getVideoRushPlanes() {
        if (this.videoRushPlanes == null) {
            throw new PropertyNotPresentException("The optional video rush planes property is not present for this Quantel material package.");
        }
        return this.videoRushPlanes;
    }

    @MediaPropertySetter(value="Video rush planes")
    public void setVideoRushPlanes(@UInt32 Integer videoRushPlanes) {
        if (videoRushPlanes == null) {
            this.videoRushPlanes = null;
            return;
        }
        if (videoRushPlanes < 0) {
            throw new IllegalArgumentException("Cannot set property video rush planes to a negative value.");
        }
        this.videoRushPlanes = videoRushPlanes;
    }

    @MediaProperty(uuid1=-1332866092, uuid2=-18311, uuid3=19795, uuid4={-115, -37, 52, -67, 118, 77, -46, -76}, definedName="Rush ingest tc", symbol="Rush_ingest_tc", aliases={"Rush_ingest_tc"}, typeName="Int32", optional=true, uniqueIdentifier=false, pid=0, prefix="q", namespace="http://www.quantel.com/genQ/extensions")
    @Int32
    public int getRushIngestTC() {
        if (this.rushIngestTC == null) {
            throw new PropertyNotPresentException("The optional rush ingest TC property is not present for this Quantel material package.");
        }
        return this.rushIngestTC;
    }

    @MediaPropertySetter(value="Rush ingest tc")
    public void setRushIngestTC(@Int32 Integer audioRushFrameRateDenominator) {
        this.audioRushFrameRateDenominator = audioRushFrameRateDenominator;
    }

    @MediaProperty(uuid1=245453030, uuid2=17635, uuid3=19781, uuid4={-107, 77, -66, -92, -45, 120, 107, -104}, definedName="Video rush white level", symbol="Video_rush_white_level", aliases={"Video_rush_white_level"}, typeName="UInt32", optional=true, uniqueIdentifier=false, pid=0, prefix="q", namespace="http://www.quantel.com/genQ/extensions")
    @UInt32
    public int getVideoRushWhiteLevel() {
        if (this.videoRushWhiteLevel == null) {
            throw new PropertyNotPresentException("The optional video rush white level property is not present for this Quantel material package.");
        }
        return this.videoRushWhiteLevel;
    }

    @MediaPropertySetter(value="Video rush white level")
    public void setVideoRushWhiteLevel(@UInt32 Integer videoRushWhiteLevel) {
        if (videoRushWhiteLevel == null) {
            this.videoRushWhiteLevel = null;
            return;
        }
        if (videoRushWhiteLevel < 0) {
            throw new IllegalArgumentException("Cannot set property video rush white level to a negative value.");
        }
        this.videoRushWhiteLevel = videoRushWhiteLevel;
    }

    @MediaProperty(uuid1=150195953, uuid2=24490, uuid3=17813, uuid4={-108, 92, -12, -79, 38, 102, -28, 102}, definedName="Video rush keycode type", symbol="Video_rush_keycode_type", aliases={"Video_rush_keycode_type"}, typeName="UInt32", optional=true, uniqueIdentifier=false, pid=0, prefix="q", namespace="http://www.quantel.com/genQ/extensions")
    @UInt32
    public int getVideoRushKeycodeType() {
        if (this.videoRushKeycodeType == null) {
            throw new PropertyNotPresentException("The optional video rush keycode type property is not present for this Quantel material package.");
        }
        return this.videoRushKeycodeType;
    }

    @MediaPropertySetter(value="Video rush keycode type")
    public void setVideoRushKeycodeType(@UInt32 Integer videoRushKeycodeType) {
        if (videoRushKeycodeType == null) {
            this.videoRushKeycodeType = null;
            return;
        }
        if (videoRushKeycodeType < 0) {
            throw new IllegalArgumentException("Cannot set property video rush keycode type to a negative value.");
        }
        this.videoRushKeycodeType = videoRushKeycodeType;
    }

    @MediaProperty(uuid1=-820107276, uuid2=-22055, uuid3=18769, uuid4={-85, 46, -89, 50, -126, 21, -19, 96}, definedName="Video rush x aspect", symbol="Video_rush_x_aspect", aliases={"Video_rush_x_aspect"}, typeName="UInt32", optional=true, uniqueIdentifier=false, pid=0, prefix="q", namespace="http://www.quantel.com/genQ/extensions")
    @UInt32
    public int getVideoRushXAspect() {
        if (this.videoRushXAspect == null) {
            throw new PropertyNotPresentException("The optional video rush X aspect property is not present for this Quantel material package.");
        }
        return this.videoRushXAspect;
    }

    @MediaPropertySetter(value="Video rush x aspect")
    public void setVideoRushXAspect(@UInt32 Integer videoRushXAspect) {
        if (videoRushXAspect == null) {
            this.videoRushXAspect = null;
            return;
        }
        if (videoRushXAspect < 0) {
            throw new IllegalArgumentException("Cannot set property video rush X aspect to a negative value.");
        }
        this.videoRushXAspect = videoRushXAspect;
    }

    @Override
    public MaterialPackage clone() {
        return (MaterialPackage)super.clone();
    }
}

