/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.model.impl;

import java.io.Serializable;
import tv.amwa.maj.enumeration.TapeCaseType;
import tv.amwa.maj.enumeration.TapeFormatType;
import tv.amwa.maj.enumeration.VideoSignalType;
import tv.amwa.maj.exception.PropertyNotPresentException;
import tv.amwa.maj.industry.MediaClass;
import tv.amwa.maj.industry.MediaProperty;
import tv.amwa.maj.industry.MediaPropertySetter;
import tv.amwa.maj.integer.Int32;
import tv.amwa.maj.model.TapeDescriptor;
import tv.amwa.maj.model.impl.EssenceDescriptorImpl;

@MediaClass(uuid1=0xD010101, uuid2=257, uuid3=11776, uuid4={6, 14, 43, 52, 2, 6, 1, 1}, definedName="TapeDescriptor", description="The TapeDescriptor class describes audio tape or video tape media.", symbol="TapeDescriptor")
public class TapeDescriptorImpl
extends EssenceDescriptorImpl
implements TapeDescriptor,
tv.amwa.maj.extensions.avid.TapeDescriptor,
Serializable,
Cloneable {
    private static final long serialVersionUID = -5061283625147621078L;
    private TapeCaseType tapeFormFactor = null;
    private VideoSignalType videoSignal = null;
    private TapeFormatType tapeFormat = null;
    private Integer tapeCapacity = null;
    private String tapeManufacturer = null;
    private String tapeFormulation = null;
    private String tapeBatchNumber = null;
    private String tapeStock = null;
    @Int32
    private Integer colorFrame = null;

    @Override
    @MediaProperty(uuid1=0x4010401, uuid2=256, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="VideoSignal", typeName="VideoSignalType", optional=true, uniqueIdentifier=false, pid=14850, symbol="VideoSignal")
    public VideoSignalType getSignalType() throws PropertyNotPresentException {
        if (this.videoSignal == null) {
            throw new PropertyNotPresentException("The optional video signal type is not present in this tape descriptor.");
        }
        return this.videoSignal;
    }

    @Override
    @MediaPropertySetter(value="VideoSignal")
    public void setSignalType(VideoSignalType videoSignal) {
        this.videoSignal = videoSignal;
    }

    @Override
    @MediaProperty(uuid1=0x4100101, uuid2=257, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="TapeFormFactor", aliases={"FormFactor"}, typeName="TapeCaseType", optional=true, uniqueIdentifier=false, pid=14849, symbol="TapeFormFactor")
    public TapeCaseType getTapeFormFactor() throws PropertyNotPresentException {
        if (this.tapeFormFactor == null) {
            throw new PropertyNotPresentException("The optional tape form factor property is not present for this tape descriptor.");
        }
        return this.tapeFormFactor;
    }

    @Override
    @MediaPropertySetter(value="TapeFormFactor")
    public void setTapeFormFactor(TapeCaseType tapeFormFactor) {
        this.tapeFormFactor = tapeFormFactor;
    }

    @Override
    @MediaProperty(uuid1=0xD010101, uuid2=257, uuid3=256, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="TapeFormat", typeName="TapeFormatType", optional=true, uniqueIdentifier=false, pid=14851, symbol="TapeFormat")
    public TapeFormatType getTapeFormat() throws PropertyNotPresentException {
        if (this.tapeFormat == null) {
            throw new PropertyNotPresentException("The optional tape format property is not present for this tape descriptor");
        }
        return this.tapeFormat;
    }

    @Override
    @MediaPropertySetter(value="TapeFormat")
    public void setTapeFormat(TapeFormatType tapeFormat) {
        this.tapeFormat = tapeFormat;
    }

    @Override
    @MediaProperty(uuid1=0x4100101, uuid2=768, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="TapeCapacity", aliases={"Length", "TapeDescriptorLength"}, typeName="UInt32", optional=true, uniqueIdentifier=false, pid=14852, symbol="TapeCapacity")
    public int getTapeCapacity() throws PropertyNotPresentException {
        if (this.tapeCapacity == null) {
            throw new PropertyNotPresentException("The optional tape capacity property is not present in this tape descriptor.");
        }
        return this.tapeCapacity;
    }

    @Override
    @MediaPropertySetter(value="TapeCapacity")
    public void setTapeCapacity(Integer tapeCapacity) throws IllegalArgumentException {
        if (tapeCapacity == null) {
            this.tapeCapacity = null;
            return;
        }
        if (tapeCapacity < 0) {
            throw new IllegalArgumentException("Cannot set the length for this tape descriptor to a negative value.");
        }
        this.tapeCapacity = tapeCapacity;
    }

    @Override
    @MediaProperty(uuid1=0x4100101, uuid2=1025, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="TapeManufacturer", aliases={"ManufcaturerID", "TapeDescriptorManufacturerID"}, typeName="UTF16String", optional=true, uniqueIdentifier=false, pid=14853, symbol="TapeManufacturer")
    public String getTapeManufacturer() throws PropertyNotPresentException {
        if (this.tapeManufacturer == null) {
            throw new PropertyNotPresentException("The optional tape manufacturer property is not present in this tape descriptor.");
        }
        return this.tapeManufacturer;
    }

    @Override
    @MediaPropertySetter(value="TapeManufacturer")
    public void setTapeManufacturer(String tapeManufacturer) {
        this.tapeManufacturer = tapeManufacturer;
    }

    @Override
    @MediaProperty(uuid1=0x4100101, uuid2=513, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="TapeFormulation", aliases={"Model", "TapeDescriptorModel"}, typeName="UTF16String", optional=true, uniqueIdentifier=false, pid=14854, symbol="TapeFormulation")
    public String getTapeFormuulation() throws PropertyNotPresentException {
        if (this.tapeFormulation == null) {
            throw new PropertyNotPresentException("The optional tape formulation property is not present in this tape descriptor.");
        }
        return this.tapeFormulation;
    }

    @Override
    @MediaPropertySetter(value="TapeFormulation")
    public void setTapeFormulation(String tapeFormulation) {
        this.tapeFormulation = tapeFormulation;
    }

    @Override
    @MediaProperty(uuid1=0x4100101, uuid2=1537, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="TapeBatchNumber", typeName="UTF16String", optional=true, uniqueIdentifier=false, pid=14855, symbol="TapeBatchNumber")
    public String getTapeBatchNumber() throws PropertyNotPresentException {
        if (this.tapeBatchNumber == null) {
            throw new PropertyNotPresentException("The optional tape batch number property is not present in this tape descriptor.");
        }
        return this.tapeBatchNumber;
    }

    @Override
    @MediaPropertySetter(value="TapeBatchNumber")
    public void setTapeBatchNumber(String tapeBatchNumber) {
        this.tapeBatchNumber = tapeBatchNumber;
    }

    @Override
    @MediaProperty(uuid1=0x4100101, uuid2=1281, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="TapeStock", typeName="UTF16String", optional=true, uniqueIdentifier=false, pid=14856, symbol="TapeStock")
    public String getTapeStock() throws PropertyNotPresentException {
        if (this.tapeStock == null) {
            throw new PropertyNotPresentException("The optional tape stock property is not present for this tape descriptor.");
        }
        return this.tapeStock;
    }

    @Override
    @MediaPropertySetter(value="TapeStock")
    public void setTapeStock(String tapeStock) {
        this.tapeStock = tapeStock;
    }

    @Override
    public TapeDescriptor clone() {
        return (TapeDescriptor)super.clone();
    }

    @Override
    @MediaProperty(uuid1=-1790398406, uuid2=5627, uuid3=4564, uuid4={-96, -113, 0, 96, -108, -21, 117, -53}, definedName="ColorFrame", typeName="Int32", optional=true, uniqueIdentifier=false, pid=0, symbol="ColorFrame", namespace="http://www.amwa.tv/is03/extensions/avid", prefix="avid")
    @Int32
    public int getColorFrame() throws PropertyNotPresentException {
        if (this.colorFrame == null) {
            throw new NullPointerException("The optional color frame property is not present for this tape descriptor.");
        }
        return this.colorFrame;
    }

    @Override
    @MediaPropertySetter(value="ColorFrame")
    public void setColorFrame(@Int32 Integer colorFrame) {
        this.colorFrame = colorFrame;
    }
}

