/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.industry;

import java.lang.reflect.Method;
import java.text.ParseException;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Vector;
import tv.amwa.maj.enumeration.EdgeType;
import tv.amwa.maj.enumeration.FilmType;
import tv.amwa.maj.enumeration.MaterialType;
import tv.amwa.maj.enumeration.ProductReleaseType;
import tv.amwa.maj.enumeration.RGBAComponentKind;
import tv.amwa.maj.exception.GenerationMethodNotSupportedException;
import tv.amwa.maj.exception.IllegalPropertyException;
import tv.amwa.maj.industry.MediaEngine;
import tv.amwa.maj.industry.MetadataObject;
import tv.amwa.maj.industry.Warehouse;
import tv.amwa.maj.industry.WeakReference;
import tv.amwa.maj.industry.WeakReferenceTarget;
import tv.amwa.maj.integer.Int16;
import tv.amwa.maj.integer.Int32;
import tv.amwa.maj.integer.Int8;
import tv.amwa.maj.integer.UInt16;
import tv.amwa.maj.integer.UInt8;
import tv.amwa.maj.meta.ClassDefinition;
import tv.amwa.maj.meta.PropertyDefinition;
import tv.amwa.maj.misctype.FrameOffset;
import tv.amwa.maj.misctype.PackageIDType;
import tv.amwa.maj.misctype.PositionType;
import tv.amwa.maj.misctype.TrackID;
import tv.amwa.maj.model.InterchangeObject;
import tv.amwa.maj.record.AUID;
import tv.amwa.maj.record.DateStruct;
import tv.amwa.maj.record.EdgeCodeValue;
import tv.amwa.maj.record.InstanceNumberGeneration;
import tv.amwa.maj.record.MaterialNumberGeneration;
import tv.amwa.maj.record.PackageID;
import tv.amwa.maj.record.ProductVersion;
import tv.amwa.maj.record.RGBAComponent;
import tv.amwa.maj.record.Rational;
import tv.amwa.maj.record.TimeStamp;
import tv.amwa.maj.record.TimeStruct;
import tv.amwa.maj.record.TimecodeValue;
import tv.amwa.maj.record.VersionType;
import tv.amwa.maj.record.impl.AUIDImpl;
import tv.amwa.maj.record.impl.DateStructImpl;
import tv.amwa.maj.record.impl.EdgeCodeValueImpl;
import tv.amwa.maj.record.impl.PackageIDImpl;
import tv.amwa.maj.record.impl.ProductVersionImpl;
import tv.amwa.maj.record.impl.RGBAComponentImpl;
import tv.amwa.maj.record.impl.RationalImpl;
import tv.amwa.maj.record.impl.TimeStampImpl;
import tv.amwa.maj.record.impl.TimeStructImpl;
import tv.amwa.maj.record.impl.TimecodeValueImpl;
import tv.amwa.maj.record.impl.VersionTypeImpl;
import tv.amwa.maj.union.SourceReferenceValue;
import tv.amwa.maj.union.impl.SourceReferenceValueImpl;

public final class Forge {
    private Forge() {
    }

    public static final AUID parseAUID(String auidAsString) throws NullPointerException, ParseException {
        try {
            return AUIDImpl.parseFactory(auidAsString);
        }
        catch (NumberFormatException nfe) {
            throw new ParseException("Parse error when trying to read an AUID value: " + nfe.getMessage(), 0);
        }
    }

    public static final AUID timebasedAUID() {
        return AUIDImpl.timebasedAUID();
    }

    public static final void setLocalNodeID(byte[] localNodeID) throws NullPointerException {
        if (localNodeID == null) {
            throw new NullPointerException("The given local host ID value is null and so cannot be used.");
        }
        AUIDImpl.setLocalNodeID(localNodeID);
    }

    public static final AUID timebasedAUID(byte[] nodeID) throws NullPointerException, IllegalArgumentException {
        return AUIDImpl.timebasedAUID(nodeID);
    }

    public static final AUID namebasedAUID(byte[] nameData) throws NullPointerException {
        return AUIDImpl.namebasedAUID(nameData);
    }

    public static final AUID namebasedAUID(String nameData) throws NullPointerException {
        if (nameData == null) {
            throw new NullPointerException("Cannot make a name-type AUID value using null name data.");
        }
        return AUIDImpl.namebasedAUID(nameData.getBytes());
    }

    public static final AUID randomAUID() {
        return AUIDImpl.randomAUID();
    }

    public static final AUID makeAUID(byte[] bytes) throws NullPointerException {
        return new AUIDImpl(bytes);
    }

    public static final AUID makeAUID(int data1, short data2, short data3, byte[] data4) throws NullPointerException {
        return new AUIDImpl(data1, data2, data3, data4);
    }

    public static final AUID nilAUID() {
        return new AUIDImpl(new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0});
    }

    public static final DateStruct parseDate(String dateAsString) throws NullPointerException, ParseException, IllegalArgumentException {
        return DateStructImpl.parseFactory(dateAsString);
    }

    public static final DateStruct todaysDate() {
        return new DateStructImpl();
    }

    public static final DateStruct makeDate(@UInt8 byte day, @UInt8 byte month, @Int16 short year) throws IllegalArgumentException {
        return new DateStructImpl(day, month, year);
    }

    public static final DateStruct makeDate(Calendar dateAsCalendar) throws NullPointerException {
        return new DateStructImpl(dateAsCalendar);
    }

    public static final EdgeCodeValue parseEdgeCode(String edgeCodeAsString) throws NullPointerException, ParseException {
        return EdgeCodeValueImpl.parseFactory(edgeCodeAsString);
    }

    public static final EdgeCodeValue makeEdgeCode() {
        return new EdgeCodeValueImpl();
    }

    public static final EdgeCodeValue makeEdgeCode(@PositionType long startFrame, FilmType filmKind, EdgeType codeFormat) throws NullPointerException {
        return new EdgeCodeValueImpl(startFrame, filmKind, codeFormat);
    }

    public static final EdgeCodeValue makeEdgeCode(@PositionType long startFrame, FilmType filmKind, EdgeType codeFormat, byte[] header) throws NullPointerException {
        EdgeCodeValueImpl value = new EdgeCodeValueImpl(startFrame, filmKind, codeFormat);
        value.setEdgeCodeHeader(header);
        return value;
    }

    public static final EdgeCodeValue makeEdgeCode(@PositionType long startFrame, FilmType filmKind, EdgeType codeFormat, String header) throws NullPointerException {
        EdgeCodeValueImpl value = new EdgeCodeValueImpl(startFrame, filmKind, codeFormat);
        value.setEdgeCodeHeader(header);
        return value;
    }

    public static final PackageID parsePackageID(String packageIDAsString) throws NullPointerException, ParseException {
        return PackageIDImpl.parseFactory(packageIDAsString);
    }

    public static final PackageID zeroPackageID() {
        return PackageIDImpl.getZeroPackageID();
    }

    public static final PackageID makePackageID(byte[] univeralLabel, @UInt8 byte length, @UInt8 byte instanceHigh, @UInt8 byte instanceMid, @UInt8 byte instanceLow, AUID materialNumber) throws NullPointerException {
        return new PackageIDImpl(univeralLabel, length, instanceHigh, instanceMid, instanceLow, materialNumber);
    }

    public static final PackageID makePackageID(byte[] bytes) throws NullPointerException {
        return new PackageIDImpl(bytes);
    }

    public static final PackageID generatePackageID(AUID materialNumber) throws NullPointerException {
        if (materialNumber == null) {
            throw new NullPointerException("Cannot generate a package identifier from a null material number.");
        }
        return PackageIDImpl.umidFactory(MaterialType.NotIdentified, MaterialNumberGeneration.UUID_UL, InstanceNumberGeneration.NotDefined, materialNumber.getAUIDValue());
    }

    public static final PackageID generatePackageID(MaterialType materialType, InstanceNumberGeneration instanceNumberGeneration, MaterialNumberGeneration materialNumberGeneration) throws NullPointerException, GenerationMethodNotSupportedException {
        return PackageIDImpl.umidFactory(materialType, materialNumberGeneration, instanceNumberGeneration, new byte[0]);
    }

    public static final PackageID generatePackageID(MaterialType materialType, InstanceNumberGeneration instanceNumberGeneration, MaterialNumberGeneration materialNumberGeneration, byte[] extraData) throws NullPointerException, GenerationMethodNotSupportedException {
        return PackageIDImpl.umidFactory(materialType, materialNumberGeneration, instanceNumberGeneration, extraData);
    }

    public static final PackageID generatePackageID(MaterialType materialType, InstanceNumberGeneration instanceNumberGeneration, MaterialNumberGeneration materialNumberGeneration, AUID materialNumber) throws NullPointerException, GenerationMethodNotSupportedException {
        return PackageIDImpl.umidFactory(materialType, materialNumberGeneration, instanceNumberGeneration, materialNumber.getAUIDValue());
    }

    public static final PackageID dCinemaUMID() {
        return PackageIDImpl.umidFactory(MaterialType.NotIdentified, MaterialNumberGeneration.UUID_UL, InstanceNumberGeneration.NotDefined, Forge.randomAUID().getAUIDValue());
    }

    public static final PackageID randomUMID() {
        return Forge.dCinemaUMID();
    }

    public static final ProductVersion parseProductVersion(String versionAsAString) throws NullPointerException, ParseException {
        return ProductVersionImpl.parseFactory(versionAsAString);
    }

    public static final ProductVersion makeProductVersion(@UInt16 short major, @UInt16 short minor, @UInt16 short tertiary, @UInt16 short patchLevel, ProductReleaseType type) throws NullPointerException, IllegalArgumentException {
        return new ProductVersionImpl(major, minor, tertiary, patchLevel, type);
    }

    public static final ProductVersion zeroProductVersion() {
        return new ProductVersionImpl(0, 0, 0, 0, ProductReleaseType.Unknown);
    }

    public static final Rational parseRational(String rationalAsString) throws NullPointerException, ParseException {
        return RationalImpl.parseFactory(rationalAsString);
    }

    public static final Rational makeRational(@Int32 int numerator, @Int32 int denominator) {
        return new RationalImpl(numerator, denominator);
    }

    public static final Rational zeroRational() {
        return new RationalImpl();
    }

    public static final RGBAComponent parseRGBAComponent(String rgbaComponentAsString) throws NullPointerException, ParseException {
        return RGBAComponentImpl.parseFactory(rgbaComponentAsString);
    }

    public static final RGBAComponent makeRGBAComponent(RGBAComponentKind code, @UInt8 byte size) throws NullPointerException, IllegalArgumentException {
        return new RGBAComponentImpl(code, size);
    }

    public static final RGBAComponent zeroRGBAComponent() {
        return new RGBAComponentImpl();
    }

    public static final TimecodeValue parseTimecode(String timecodeAsAString) throws NullPointerException, ParseException {
        return TimecodeValueImpl.parseTimecode(timecodeAsAString);
    }

    public static final TimecodeValue parseTimecode(String timecodeAsAString, @UInt16 short explicitFramesPerSecond, boolean explicitDropFrameIndicator) throws NullPointerException, ParseException, IllegalArgumentException {
        return TimecodeValueImpl.parseTimecode(timecodeAsAString, explicitFramesPerSecond, explicitDropFrameIndicator);
    }

    public static final TimecodeValue makeTimecode(@FrameOffset long startFrame, @UInt16 short fps, boolean drop) throws IllegalArgumentException {
        return new TimecodeValueImpl(drop, startFrame, fps);
    }

    public static final TimecodeValue calculateTimecode(short hours, short minutes, short seconds, short frames, @UInt16 short fps, boolean drop) throws IllegalArgumentException {
        return new TimecodeValueImpl(fps, hours, minutes, seconds, frames, drop);
    }

    public static final TimecodeValue calculateTimecode(short hours, short minutes, short seconds, short frames, short framePair, @UInt16 short fps, boolean drop) throws IllegalArgumentException {
        return new TimecodeValueImpl(fps, hours, minutes, seconds, frames, framePair, drop);
    }

    public static final TimecodeValue zeroTimecode() {
        return new TimecodeValueImpl();
    }

    public static final TimecodeValue calculateDuration(TimecodeValue startValue, TimecodeValue endValue) throws NullPointerException, IllegalArgumentException {
        return TimecodeValueImpl.calculateDuration(startValue, endValue);
    }

    public static final TimecodeValue calculateEndTimecode(TimecodeValue startValue, TimecodeValue duration) throws NullPointerException, IllegalArgumentException {
        return TimecodeValueImpl.calculateEndTimecode(startValue, duration);
    }

    public static final TimeStamp parseTimeStamp(String timeStampAsAString) throws NullPointerException, ParseException {
        return TimeStampImpl.parseFactory(timeStampAsAString);
    }

    public static final TimeStamp makeTimeStamp(DateStruct date, TimeStruct time) throws NullPointerException, IllegalArgumentException {
        return new TimeStampImpl(date, time);
    }

    public static final TimeStamp makeTimeStamp(@Int16 short year, @UInt8 byte month, @UInt8 byte day, @UInt8 byte hour, @UInt8 byte minute, @UInt8 byte second, @UInt8 byte fraction) throws IllegalArgumentException {
        return new TimeStampImpl(Forge.makeDate(day, month, year), Forge.makeTime(hour, minute, second, fraction));
    }

    public static final TimeStamp makeTimeStamp(Calendar timeStampAsCalendar) throws NullPointerException, IllegalArgumentException {
        return new TimeStampImpl(timeStampAsCalendar);
    }

    public static final TimeStamp now() {
        return new TimeStampImpl();
    }

    public static final TimeStruct parseTime(String timeAsAString) throws NullPointerException, ParseException {
        return TimeStructImpl.parseFactory(timeAsAString);
    }

    public static final TimeStruct makeTime(byte hour, byte minute, byte second) throws IllegalArgumentException {
        return new TimeStructImpl(hour, minute, second);
    }

    public static final TimeStruct makeTime(byte hour, byte minute, byte second, byte fraction) throws IllegalArgumentException {
        return new TimeStructImpl(hour, minute, second, fraction);
    }

    public static final TimeStruct makeTime(Calendar timeAsCalendar) throws NullPointerException, IllegalArgumentException {
        return new TimeStructImpl(timeAsCalendar);
    }

    public static final TimeStruct timeNow() {
        return new TimeStructImpl();
    }

    public static final VersionType parseVersion(String versionAsAString) throws NullPointerException, ParseException {
        return VersionTypeImpl.parseFactory(versionAsAString);
    }

    public static final VersionType makeVersion(@Int8 byte major, @Int8 byte minor) {
        return new VersionTypeImpl(major, minor);
    }

    public static final VersionType zeroVersion() {
        return new VersionTypeImpl();
    }

    public static final SourceReferenceValue originalSource() {
        return SourceReferenceValueImpl.originalSource();
    }

    public static final SourceReferenceValue inContextReference(@TrackID int sourceTrackID) throws IllegalArgumentException {
        return SourceReferenceValueImpl.inContextReference(sourceTrackID);
    }

    public static final SourceReferenceValue inContextReference(@TrackID int sourceTrackID, @PositionType Long startPosition) throws IllegalArgumentException {
        return SourceReferenceValueImpl.inContextReference(sourceTrackID, startPosition);
    }

    public static final SourceReferenceValue makeReference(@PackageIDType PackageID sourcePackageID, @TrackID int sourceTrackID, @PositionType Long startPosition) throws IllegalArgumentException {
        return new SourceReferenceValueImpl(sourcePackageID, sourceTrackID, startPosition);
    }

    public static final <T extends MetadataObject> T make(Class<T> type, boolean strict, Object ... properties) throws NullPointerException, IllegalArgumentException {
        if (type == null) {
            throw new NullPointerException("Cannot make a new value for a null class specification.");
        }
        ClassDefinition typeClass = Warehouse.lookForClass(type);
        MetadataObject instance = typeClass.createInstance();
        if (instance == null) {
            throw new IllegalArgumentException("Unable to create an instance of class " + typeClass.getName() + ".");
        }
        if (properties.length % 2 != 0) {
            throw new IllegalArgumentException("The list of properties and their values must be a list of pairs.");
        }
        Vector<Exception> exceptions = new Vector<Exception>();
        HashSet<PropertyDefinition> valuesSet = new HashSet<PropertyDefinition>();
        if (instance instanceof InterchangeObject) {
            try {
                valuesSet.add(typeClass.lookupPropertyDefinition("ObjectClass"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        for (int u = 0; u < properties.length; u += 2) {
            PropertyDefinition propertyDefinition;
            Object value;
            Object property;
            block29: {
                property = properties[u];
                value = properties[u + 1];
                if (property == null) {
                    exceptions.add(new NullPointerException("Cannot set a property indentified by a null value."));
                    continue;
                }
                propertyDefinition = null;
                try {
                    if (property instanceof PropertyDefinition) {
                        propertyDefinition = (PropertyDefinition)property;
                        typeClass.lookupPropertyDefinition(propertyDefinition.getAUID());
                        break block29;
                    }
                    if (property instanceof String) {
                        try {
                            propertyDefinition = typeClass.lookupPropertyDefinition(AUIDImpl.parseFactory((String)property));
                        }
                        catch (Exception e) {
                            propertyDefinition = typeClass.lookupPropertyDefinition((String)property);
                        }
                        break block29;
                    }
                    if (!(property instanceof AUID)) break block29;
                    propertyDefinition = typeClass.lookupPropertyDefinition((AUID)property);
                }
                catch (Exception e) {
                    exceptions.add(new Exception(e.getClass().getName() + " thrown when finding property definition " + property.toString() + ".", e));
                    continue;
                }
            }
            if (propertyDefinition == null) {
                exceptions.add(new IllegalPropertyException("Class " + typeClass.getName() + " does not define property " + property.toString() + "."));
                continue;
            }
            valuesSet.add(propertyDefinition);
            try {
                propertyDefinition.setPropertyValue(instance, propertyDefinition.getTypeDefinition().createValue(value));
                continue;
            }
            catch (Exception e) {
                exceptions.add(new Exception(e.getClass().getName() + " thrown when setting property " + propertyDefinition.getName() + ".", e));
            }
        }
        block14: for (PropertyDefinition requiredTest : typeClass.getAllPropertyDefinitions()) {
            if (requiredTest.getIsOptional() || valuesSet.contains(requiredTest)) continue;
            if (!strict) {
                try {
                    Method initMethod = requiredTest.getMemberOf().getJavaImplementation().getMethod("initialize" + requiredTest.getName().replace(" ", ""), new Class[0]);
                    Object value = initMethod.invoke((Object)instance, new Object[0]);
                    requiredTest.setPropertyValue(instance, requiredTest.getTypeDefinition().createValue(value));
                }
                catch (Exception e) {
                    System.err.println("Info: Possible unsafe setting of property " + requiredTest.getMemberOf().getName() + "." + requiredTest.getName() + " due to a " + e.getClass().getName() + ": " + e.getMessage());
                }
                continue;
            }
            switch (requiredTest.getTypeDefinition().getTypeCategory()) {
                case Set: 
                case FixedArray: 
                case VariableArray: {
                    continue block14;
                }
            }
            exceptions.add(new Exception("Required property " + requiredTest.getName() + " has not been provided with a value."));
        }
        if (exceptions.size() > 0) {
            StringBuffer exceptionDescription = new StringBuffer();
            if (exceptions.size() == 1) {
                exceptionDescription.append("Error setting property values for class ");
            } else {
                exceptionDescription.append("Errors setting property values for class ");
            }
            exceptionDescription.append(typeClass.getName());
            exceptionDescription.append(':');
            for (Exception e : exceptions) {
                exceptionDescription.append('\n');
                exceptionDescription.append(" - ");
                exceptionDescription.append(e.getMessage());
                if (e.getCause() == null) continue;
                exceptionDescription.append(' ');
                exceptionDescription.append(e.getCause().getMessage());
            }
            throw new IllegalArgumentException(exceptionDescription.toString());
        }
        if (instance instanceof WeakReferenceTarget) {
            WeakReference.registerTarget((WeakReferenceTarget)((Object)instance));
        }
        return (T)instance;
    }

    public static final <T extends MetadataObject> T make(Class<T> type, Object ... properties) throws NullPointerException, IllegalArgumentException {
        return Forge.make(type, false, properties);
    }

    public static final <T extends MetadataObject> T makeByName(String namespace, String typeName, boolean strict, Object ... properties) throws NullPointerException, IllegalArgumentException {
        if (namespace == null) {
            throw new NullPointerException("Cannot make a new instance with a null namespace.");
        }
        if (typeName == null) {
            throw new NullPointerException("Cannot make a new instance from a null name.");
        }
        String fullName = "{" + namespace + "}" + typeName;
        return (T)Forge.make(Warehouse.lookForClass(fullName).getJavaImplementation(), strict, properties);
    }

    public static final <T extends MetadataObject> T makeByName(String namespace, String typeName, Object ... properties) throws NullPointerException, IllegalArgumentException {
        return Forge.makeByName(namespace, typeName, false, properties);
    }

    public static final <T extends MetadataObject> T makeAAF(String typeName, Object ... properties) throws NullPointerException, IllegalArgumentException {
        MediaEngine.initializeAAF();
        return Forge.makeByName("http://www.smpte-ra.org/schemas/2001-2/2007/aaf", typeName, false, properties);
    }
}

