/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.io.mxf.impl;

import java.nio.ByteBuffer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import tv.amwa.maj.io.mxf.EssenceElement;
import tv.amwa.maj.io.mxf.UL;
import tv.amwa.maj.io.mxf.UnitType;
import tv.amwa.maj.io.xml.XMLBuilder;
import tv.amwa.maj.io.xml.XMLSerializable;

public class EssenceElementImpl
implements EssenceElement,
XMLSerializable {
    private byte itemType;
    private byte elementCount;
    private byte elementType;
    private byte elementNumber;
    private ByteBuffer data;

    public ByteBuffer getData() {
        return this.data;
    }

    public void setData(ByteBuffer data) {
        this.data = data;
    }

    public static final boolean isEssenceElement(UL key) {
        if (key == null) {
            return false;
        }
        byte[] keyBytes = key.getUniversalLabel();
        if (keyBytes[0] != 6) {
            return false;
        }
        if (keyBytes[1] != 14) {
            return false;
        }
        if (keyBytes[2] != 43) {
            return false;
        }
        if (keyBytes[3] != 52) {
            return false;
        }
        if (keyBytes[4] != 1) {
            return false;
        }
        if (keyBytes[5] != 2) {
            return false;
        }
        if (keyBytes[6] != 1) {
            return false;
        }
        if (keyBytes[8] != 13) {
            return false;
        }
        if (keyBytes[9] != 1) {
            return false;
        }
        if (keyBytes[10] != 3) {
            return false;
        }
        if (keyBytes[11] != 1) {
            return false;
        }
        if (keyBytes[12] < 5 || keyBytes[12] > 24) {
            return false;
        }
        return keyBytes[12] <= 7 || keyBytes[12] >= 21;
    }

    public static final EssenceElement make(UL elementKey, ByteBuffer data) {
        EssenceElementImpl element = new EssenceElementImpl();
        byte[] keyBytes = elementKey.getUniversalLabel();
        element.setItemType(keyBytes[12]);
        element.setElementCount(keyBytes[13]);
        element.setElementType(keyBytes[14]);
        element.setElementNumber(keyBytes[15]);
        element.setData(data);
        return element;
    }

    public byte getItemType() {
        return this.itemType;
    }

    public void setItemType(byte itemType) {
        this.itemType = itemType;
    }

    public byte getElementCount() {
        return this.elementCount;
    }

    public void setElementCount(byte elementCount) {
        this.elementCount = elementCount;
    }

    public byte getElementType() {
        return this.elementType;
    }

    public void setElementType(byte elementType) {
        this.elementType = elementType;
    }

    public byte getElementNumber() {
        return this.elementNumber;
    }

    public void setElementNumber(byte elementNumber) {
        this.elementNumber = elementNumber;
    }

    public int getEssenceTrackIdentifier() {
        return this.byteToInt(this.itemType) << 24 | this.byteToInt(this.elementCount) << 16 | this.byteToInt(this.elementType) << 8 | this.byteToInt(this.elementNumber);
    }

    int byteToInt(byte inByte) {
        return inByte >= 0 ? inByte : 256 + inByte;
    }

    @Override
    public void appendXMLChildren(Node parent) {
        String elementName = null;
        switch (this.itemType) {
            case 5: {
                elementName = "CPPicture";
                break;
            }
            case 6: {
                elementName = "CPSound";
                break;
            }
            case 7: {
                elementName = "CPData";
                break;
            }
            case 21: {
                elementName = "GCPicture";
                break;
            }
            case 22: {
                elementName = "GCSound";
                break;
            }
            case 23: {
                elementName = "GCData";
                break;
            }
            case 24: {
                elementName = "GCCompound";
                break;
            }
            default: {
                elementName = "Unknown";
            }
        }
        Element element = XMLBuilder.createChild(parent, "http://www.smpte-ra.org/rp210", "mxf", elementName);
        XMLBuilder.setAttribute(element, "", "", "essenceTrackIdentifier", Integer.toString(this.getEssenceTrackIdentifier()));
        XMLBuilder.appendElement((Node)element, "http://www.smpte-ra.org/rp210", "mxf", "ElementCount", this.elementCount);
        XMLBuilder.appendElement((Node)element, "http://www.smpte-ra.org/rp210", "mxf", "ElementType", this.elementType);
        XMLBuilder.appendElement((Node)element, "http://www.smpte-ra.org/rp210", "mxf", "ElementNumber", this.elementNumber);
        this.data.rewind();
        byte[] firstBytes = new byte[32];
        this.data.get(firstBytes);
        this.data.rewind();
        XMLBuilder.appendElement((Node)element, "http://www.smpte-ra.org/rp210", "mxf", "InitialData", firstBytes);
        XMLBuilder.appendElement((Node)element, "http://www.smpte-ra.org/rp210", "mxf", "DataLength", this.data.limit());
    }

    @Override
    public String getComment() {
        return null;
    }

    public String toString() {
        return XMLBuilder.toXMLNonMetadata(this);
    }

    @Override
    public UnitType getUnitType() {
        switch (this.itemType) {
            case 5: {
                return UnitType.ContentPackagePicture;
            }
            case 6: {
                return UnitType.ContentPackageSound;
            }
            case 7: {
                return UnitType.ContentPackageData;
            }
            case 21: {
                return UnitType.GenericContainerPicture;
            }
            case 22: {
                return UnitType.GenericContainerSound;
            }
            case 23: {
                return UnitType.GenericContainerData;
            }
            case 24: {
                return UnitType.GenericContainerCompound;
            }
        }
        return UnitType.Unknown;
    }
}

