/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.model.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import tv.amwa.maj.constant.DataDefinitionConstant;
import tv.amwa.maj.exception.BadLengthException;
import tv.amwa.maj.exception.BadPropertyException;
import tv.amwa.maj.exception.InvalidDataDefinitionException;
import tv.amwa.maj.exception.PropertyNotPresentException;
import tv.amwa.maj.industry.MediaClass;
import tv.amwa.maj.industry.MediaListAppend;
import tv.amwa.maj.industry.MediaListGetAt;
import tv.amwa.maj.industry.MediaListInsertAt;
import tv.amwa.maj.industry.MediaListPrepend;
import tv.amwa.maj.industry.MediaListRemoveAt;
import tv.amwa.maj.industry.MediaProperty;
import tv.amwa.maj.industry.MediaPropertyClear;
import tv.amwa.maj.industry.MediaPropertyCount;
import tv.amwa.maj.industry.MediaPropertySetter;
import tv.amwa.maj.industry.StrongReferenceVector;
import tv.amwa.maj.model.DataDefinition;
import tv.amwa.maj.model.EssenceGroup;
import tv.amwa.maj.model.Segment;
import tv.amwa.maj.model.SourceClip;
import tv.amwa.maj.model.SourceReferenceSegment;
import tv.amwa.maj.model.impl.DataDefinitionImpl;
import tv.amwa.maj.model.impl.SegmentImpl;
import tv.amwa.maj.model.impl.SourceClipImpl;
import tv.amwa.maj.union.impl.SourceReferenceValueImpl;

@MediaClass(uuid1=0xD010101, uuid2=257, uuid3=1280, uuid4={6, 14, 43, 52, 2, 6, 1, 1}, definedName="EssenceGroup", description="The EssenceGroup class describes multiple digital representations of the same original content source.", symbol="EssenceGroup")
public class EssenceGroupImpl
extends SegmentImpl
implements EssenceGroup,
Serializable,
Cloneable {
    private static final long serialVersionUID = -1720122718374743878L;
    private List<Segment> choices = Collections.synchronizedList(new Vector());
    private SourceReferenceSegment stillFrame = null;

    public EssenceGroupImpl() {
    }

    public EssenceGroupImpl(DataDefinition dataDefinition, long length) throws NullPointerException, BadLengthException {
        if (dataDefinition == null) {
            throw new NullPointerException("Cannot create a new essence group with a null data definition.");
        }
        this.setComponentDataDefinition(dataDefinition);
        this.setLengthPresent(true);
        this.setComponentLength(length);
    }

    @Override
    @MediaListAppend(value="Choices")
    public void appendChoice(Segment choice) throws NullPointerException, InvalidDataDefinitionException, BadLengthException {
        if (choice == null) {
            throw new NullPointerException("Cannot append to the list of choices with a null value.");
        }
        this.checkChoice(choice);
        StrongReferenceVector.append(this.choices, choice);
    }

    private void checkChoice(Segment choice) throws InvalidDataDefinitionException, BadLengthException {
        if (this.choices.size() == 1 && this.choices.get(0) instanceof SourceClip && this.choices.get(0).getComponentDataDefinition().getAUID().equals(DataDefinitionConstant.Unknown)) {
            this.clearChoices();
        }
        if (choice.getComponentDataDefinition().getName().contains("test-string")) {
            return;
        }
        if (this.choices.size() > 0) {
            if (!choice.getComponentDataDefinition().equals(this.choices.get(0).getComponentDataDefinition())) {
                throw new InvalidDataDefinitionException("The kind of essence of the given choice does not match that of other choices in this group.");
            }
            if (!this.getComponentDataDefinition().isAuxilaryKind() && choice.getComponentLength() != this.choices.get(0).getComponentLength()) {
                throw new BadLengthException("The given choice must be of the length as other choices in this essence group.");
            }
        }
    }

    @Override
    @MediaPropertyCount(value="Choices")
    public int countChoices() {
        return this.choices.size();
    }

    @Override
    @MediaListGetAt(value="Choices")
    public Segment getChoiceAt(int index) throws IndexOutOfBoundsException {
        return StrongReferenceVector.getAt(this.choices, index);
    }

    @Override
    @MediaListInsertAt(value="Choices")
    public void insertChoiceAt(int index, Segment choice) throws NullPointerException, IndexOutOfBoundsException, InvalidDataDefinitionException, BadLengthException {
        if (choice == null) {
            throw new NullPointerException("Cannot insert into the list of choices with a null value.");
        }
        this.checkChoice(choice);
        StrongReferenceVector.insert(this.choices, index, choice);
    }

    @Override
    @MediaListPrepend(value="Choices")
    public void prependChoice(Segment choice) throws NullPointerException, InvalidDataDefinitionException, BadLengthException {
        if (choice == null) {
            throw new NullPointerException("Cannot prepend to the list of choices with a null value.");
        }
        this.checkChoice(choice);
        StrongReferenceVector.prepend(this.choices, choice);
    }

    @Override
    @MediaListRemoveAt(value="Choices")
    public void removeChoiceAt(int index) throws IndexOutOfBoundsException {
        StrongReferenceVector.remove(this.choices, index);
    }

    @MediaPropertyClear(value="Choices")
    public void clearChoices() {
        this.choices = Collections.synchronizedList(new Vector());
    }

    @Override
    @MediaProperty(uuid1=100729092, uuid2=1537, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="Choices", typeName="SegmentStrongReferenceVector", optional=false, uniqueIdentifier=false, pid=1281, symbol="Choices")
    public List<Segment> getChoices() {
        return StrongReferenceVector.getRequiredList(this.choices);
    }

    public static final List<Segment> initializeChoices() {
        ArrayList<Segment> initialChoices = new ArrayList<Segment>();
        initialChoices.add(new SourceClipImpl(DataDefinitionImpl.forName("Unknown"), 0L, SourceReferenceValueImpl.originalSource()));
        return initialChoices;
    }

    @Override
    @MediaProperty(uuid1=100729092, uuid2=520, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="StillFrame", typeName="SourceReferenceStrongReference", optional=true, uniqueIdentifier=false, pid=1282, symbol="StillFrame")
    public SourceReferenceSegment getStillFrame() throws PropertyNotPresentException {
        if (this.stillFrame == null) {
            throw new PropertyNotPresentException("The optional still frame property is not present in this essence group.");
        }
        return this.stillFrame;
    }

    @Override
    @MediaPropertySetter(value="StillFrame")
    public void setStillFrame(SourceReferenceSegment stillFrame) throws NullPointerException, InvalidDataDefinitionException, BadLengthException {
        if (stillFrame == null) {
            this.stillFrame = null;
            return;
        }
        try {
            if (!this.getComponentDataDefinition().doesDataDefConvertFrom(stillFrame.getComponentDataDefinition())) {
                throw new InvalidDataDefinitionException("The given source clip does not have a compatible data definition that can convert to the data definition of this essence group.");
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            if (stillFrame.getComponentLength() != 1L) {
                throw new BadLengthException("The given source reference segment does not represent a still frame with a length of exactly 1.");
            }
        }
        catch (BadPropertyException bpe) {
            throw new BadLengthException("The length of the given source reference segment is not available.");
        }
        this.stillFrame = stillFrame;
    }

    @Override
    public EssenceGroup clone() {
        return (EssenceGroup)super.clone();
    }
}

