/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.model.impl;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import tv.amwa.maj.exception.IllegalPropertyValueException;
import tv.amwa.maj.exception.PropertyNotPresentException;
import tv.amwa.maj.industry.MediaClass;
import tv.amwa.maj.industry.MediaProperty;
import tv.amwa.maj.industry.MediaPropertySetter;
import tv.amwa.maj.industry.PropertyValue;
import tv.amwa.maj.industry.Warehouse;
import tv.amwa.maj.industry.WeakReference;
import tv.amwa.maj.io.xml.XMLBuilder;
import tv.amwa.maj.io.xml.XMLSerializable;
import tv.amwa.maj.meta.ClassDefinition;
import tv.amwa.maj.meta.ExtensionScheme;
import tv.amwa.maj.meta.MetaDefinition;
import tv.amwa.maj.meta.PropertyDefinition;
import tv.amwa.maj.model.ApplicationObject;
import tv.amwa.maj.model.impl.InterchangeObjectImpl;
import tv.amwa.maj.record.AUID;

@MediaClass(uuid1=0xD010101, uuid2=257, uuid3=26112, uuid4={6, 14, 43, 52, 2, 6, 1, 1}, definedName="ApplicationObject", symbol="ApplicationObject", description="Common properties of application plugin objects and application referenced objects. These classes provide the mechanism to decorate interchange objects with application-specific extension metadata.")
public abstract class ApplicationObjectImpl
extends InterchangeObjectImpl
implements ApplicationObject,
Cloneable,
Serializable,
XMLSerializable {
    private static final long serialVersionUID = -6841492239125321529L;
    private WeakReference<ClassDefinition> baseClass = null;
    private Map<AUID, PropertyValue> extensionProperties = Collections.synchronizedMap(new HashMap());

    @Override
    @MediaProperty(uuid1=100729092, uuid2=267, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 12}, definedName="BaseClass", typeName="ClassDefinitionWeakReference", optional=true, uniqueIdentifier=false, pid=0, symbol="BaseClass", description="Class of the immediate superclass that this object extends.")
    public ClassDefinition getBaseClass() throws PropertyNotPresentException {
        if (this.baseClass == null) {
            throw new PropertyNotPresentException("The optional base class property is not present for this application object.");
        }
        return this.baseClass.getTarget();
    }

    @Override
    @MediaPropertySetter(value="BaseClass")
    public void setBaseClass(ClassDefinition baseClass) {
        if (baseClass == null) {
            this.baseClass = null;
            return;
        }
        this.baseClass = new WeakReference<ClassDefinition>(baseClass);
    }

    @Override
    public Set<AUID> getExtensionPropertyIDs() {
        return this.extensionProperties.keySet();
    }

    @Override
    public void clearExtensionProperties() {
        this.extensionProperties.clear();
    }

    @Override
    public int countExtensionProperties() {
        return this.extensionProperties.size();
    }

    @Override
    public PropertyValue getExtensionProperty(AUID propertyID) throws NullPointerException, PropertyNotPresentException, IllegalArgumentException {
        if (propertyID == null) {
            throw new NullPointerException("Cannot retrieve an extension property using a null id.");
        }
        if (this.extensionProperties.size() == 0) {
            throw new PropertyNotPresentException("The optional extension properties set is not present for this application object.");
        }
        if (!this.extensionProperties.containsKey(propertyID)) {
            if (this.getApplicationScheme().containsMetaDefinition(propertyID)) {
                PropertyDefinition property = Warehouse.lookForProperty(propertyID);
                if (property != null) {
                    throw new PropertyNotPresentException("The optional property " + property.getMemberOf().getName() + "." + property.getName() + " is not present for this application object.");
                }
                throw new PropertyNotPresentException("The optional property with identifier " + propertyID.toString() + " is not present for this applicaiton object.");
            }
            throw new IllegalArgumentException("The given property identifier is not part of extension scheme " + this.getApplicationScheme().getSchemeURI() + ".");
        }
        return this.extensionProperties.get(propertyID);
    }

    @Override
    public PropertyValue getExtensionProperty(String propertyName) throws NullPointerException, PropertyNotPresentException, IllegalArgumentException {
        if (propertyName == null) {
            throw new NullPointerException("Cannot retrieve an extension property value using a null value.");
        }
        AUID propertyKey = this.getApplicationScheme().lookupMetaDefinitionIdentifier(propertyName);
        if (propertyKey == null) {
            throw new IllegalArgumentException("The given property name " + propertyName + " is not known in the associated application scheme.");
        }
        return this.getExtensionProperty(propertyKey);
    }

    @Override
    public boolean isExtensionPropertyPresent(AUID propertyID) throws NullPointerException, IllegalArgumentException {
        if (propertyID == null) {
            throw new NullPointerException("Cannot check for an extension property using a null value.");
        }
        if (this.extensionProperties.containsKey(propertyID)) {
            return true;
        }
        if (this.getApplicationScheme().containsMetaDefinition(propertyID)) {
            return false;
        }
        throw new IllegalArgumentException("The given property identifier does not match one of the associated extension scheme.");
    }

    @Override
    public boolean isExtensionPropertyPresent(String propertyName) throws NullPointerException, IllegalArgumentException {
        if (propertyName == null) {
            throw new NullPointerException("Cannot check for an extension property usning a null value.");
        }
        AUID propertyKey = this.getApplicationScheme().lookupMetaDefinitionIdentifier(propertyName);
        if (propertyKey == null) {
            throw new IllegalArgumentException("The given property name does not match one of the associated extension scheme.");
        }
        return this.isExtensionPropertyPresent(propertyKey);
    }

    @Override
    public void putExtensionProperty(AUID propertyID, PropertyValue propertyValue) throws IllegalArgumentException, NullPointerException, IllegalPropertyValueException {
        if (propertyID == null) {
            throw new NullPointerException("Cannot put an extension property value using a null property identifier.");
        }
        if (propertyValue == null) {
            throw new NullPointerException("Cannot put an extension property value using a null property value.");
        }
        if (!this.getApplicationScheme().containsMetaDefinition(propertyID)) {
            throw new IllegalArgumentException("The given property identifier does not match one of the associated extension scheme.");
        }
        MetaDefinition metaDefinition = this.getApplicationScheme().lookupMetaDefinition(propertyID);
        if (!(metaDefinition instanceof PropertyDefinition)) {
            throw new IllegalArgumentException("The given property identifier is not for a property definition.");
        }
        PropertyDefinition propertyDefinition = (PropertyDefinition)metaDefinition;
        if (!propertyDefinition.getTypeDefinition().equals(propertyValue.getType())) {
            throw new IllegalPropertyValueException("The type of the property value " + propertyValue.getType().getName() + " does not match the type of the associated property " + propertyDefinition.getTypeDefinition().getName() + ".");
        }
        this.extensionProperties.put(propertyID, propertyValue);
    }

    @Override
    public void putExtensionProperty(String propertyName, PropertyValue propertyValue) throws IllegalArgumentException, NullPointerException, IllegalPropertyValueException {
        if (propertyName == null) {
            throw new NullPointerException("Cannot put an extension property value using a null property name.");
        }
        AUID propertyKey = this.getApplicationScheme().lookupMetaDefinitionIdentifier(propertyName);
        if (propertyKey == null) {
            throw new IllegalArgumentException("The given property name does not match one of the associated extension scheme.");
        }
        this.putExtensionProperty(propertyKey, propertyValue);
    }

    public abstract ExtensionScheme getApplicationScheme();

    @Override
    public SortedMap<? extends PropertyDefinition, ? extends PropertyValue> getProperties() {
        TreeMap<PropertyDefinition, PropertyValue> properties = new TreeMap<PropertyDefinition, PropertyValue>();
        ExtensionScheme applicationScheme = this.getApplicationScheme();
        for (AUID propertyKey : this.extensionProperties.keySet()) {
            MetaDefinition likelyPropertyDefinition = applicationScheme.lookupMetaDefinition(propertyKey);
            if (likelyPropertyDefinition == null || !(likelyPropertyDefinition instanceof PropertyDefinition)) continue;
            properties.put((PropertyDefinition)likelyPropertyDefinition, this.extensionProperties.get(propertyKey));
        }
        return properties;
    }

    @Override
    public void appendXMLChildren(Node parent) {
        ExtensionScheme applicationScheme = this.getApplicationScheme();
        for (AUID propertyKey : this.getExtensionPropertyIDs()) {
            PropertyValue value = this.getExtensionProperty(propertyKey);
            XMLBuilder.appendValue((Element)parent, applicationScheme.getSchemeURI(), applicationScheme.getPreferredPrefix(), applicationScheme.lookupMetaDefinition(propertyKey).getSymbol(), value);
        }
    }

    @Override
    public ApplicationObject clone() {
        return (ApplicationObject)super.clone();
    }
}

