/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.meta.impl;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import tv.amwa.maj.enumeration.TypeCategory;
import tv.amwa.maj.exception.EndOfDataException;
import tv.amwa.maj.exception.IllegalPropertyValueException;
import tv.amwa.maj.exception.InsufficientSpaceException;
import tv.amwa.maj.industry.MediaClass;
import tv.amwa.maj.industry.MetadataObject;
import tv.amwa.maj.industry.PropertyValue;
import tv.amwa.maj.io.aaf.AAFConstants;
import tv.amwa.maj.meta.PropertyDefinition;
import tv.amwa.maj.meta.TypeDefinition;
import tv.amwa.maj.meta.impl.MetaDefinitionImpl;
import tv.amwa.maj.meta.impl.MethodBag;
import tv.amwa.maj.meta.impl.PropertyDefinitionImpl;
import tv.amwa.maj.record.AUID;

@MediaClass(uuid1=0xD010101, uuid2=515, uuid3=0, uuid4={6, 14, 43, 52, 2, 6, 1, 1}, definedName="TypeDefinition", description="The TypeDefinition class defines a property type.", symbol="TypeDefinition")
public abstract class TypeDefinitionImpl
extends MetaDefinitionImpl
implements TypeDefinition,
Serializable,
Cloneable {
    private static final long serialVersionUID = 963203215988237810L;
    private static Map<String, String> typeNameMap = null;

    public static final void initalizeTypeNameMap() {
        int typeMapSize = AAFConstants.typeNameAliases.length / 2;
        typeNameMap = Collections.synchronizedMap(new HashMap(typeMapSize));
        for (int x = 0; x < typeMapSize; ++x) {
            typeNameMap.put(AAFConstants.typeNameAliases[x * 2], AAFConstants.typeNameAliases[x * 2 + 1]);
        }
    }

    @Override
    public abstract TypeCategory getTypeCategory();

    @Override
    public abstract PropertyValue createValue(Object var1) throws ClassCastException;

    @Override
    public abstract void setPropertyValue(MetadataObject var1, PropertyDefinition var2, PropertyValue var3) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException;

    @Override
    public PropertyValue getPropertyValue(MetadataObject metadataObject, PropertyDefinition property) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        MethodBag methods = ((PropertyDefinitionImpl)property).getMethodBag();
        Object baseValue = methods.get(metadataObject);
        return this.createValue(baseValue);
    }

    static MethodBag makeMethodBagForType(TypeDefinition type, Method getter, Method[] candidateMethods, String propertyName) {
        return ((TypeDefinitionImpl)type).makeMethodBag(getter, candidateMethods, propertyName);
    }

    abstract MethodBag makeMethodBag(Method var1, Method[] var2, String var3);

    @Override
    public PropertyValue createFromBytes(ByteBuffer buffer) throws NullPointerException, EndOfDataException {
        if (buffer == null) {
            throw new NullPointerException("Cannot create a value from a null byte buffer.");
        }
        return null;
    }

    @Override
    public List<PropertyValue> writeAsBytes(PropertyValue value, ByteBuffer buffer) throws NullPointerException, IllegalPropertyValueException, InsufficientSpaceException {
        if (value == null) {
            throw new NullPointerException("Cannot write a null property value to a byte stream.");
        }
        if (buffer == null) {
            throw new NullPointerException("Cannot write a value to a null byte buffer.");
        }
        if (!value.getType().equals(this)) {
            throw new IllegalPropertyValueException("The given property value to write a bytes is not the same as this type. " + value.getType().getName() + " != " + this.getName() + ".");
        }
        return null;
    }

    @Override
    public List<PropertyValue> writeAsStructuredStorageBytes(PropertyValue value, ByteBuffer buffer) throws NullPointerException, IllegalPropertyValueException, InsufficientSpaceException {
        return this.writeAsBytes(value, buffer);
    }

    @Override
    public long lengthAsBytes(PropertyValue value) throws NullPointerException, IllegalPropertyValueException {
        if (value == null) {
            throw new NullPointerException("Cannot provide the length in bytes of a null value.");
        }
        if (!value.getType().equals(this)) {
            throw new IllegalPropertyValueException("The given property value to find the serialized length of is not the same as this type. " + value.getType().getName() + " != " + this.getName() + ".");
        }
        return 0L;
    }

    @Override
    public boolean resolveReferences(PropertyValue value, Map<AUID, MetadataObject> referenceMap) throws NullPointerException, IllegalPropertyValueException {
        if (value == null) {
            throw new NullPointerException("Cannot resolve references for a null property.");
        }
        if (referenceMap == null) {
            throw new NullPointerException("Cannot resolve references using a null reference map.");
        }
        if (!value.getType().equals(this)) {
            throw new IllegalPropertyValueException("The given property value for property resolution is not the same as this type. " + value.getType().getName() + " != " + this.getName() + ".");
        }
        return true;
    }

    @Override
    public String nameToAAFName(String name) {
        if (typeNameMap != null) {
            String mappedName = typeNameMap.get(name);
            return mappedName != null ? mappedName : name;
        }
        return name;
    }

    @Override
    public String getPrefix() {
        if (this.prefix == null) {
            return "unknown";
        }
        return this.prefix;
    }

    @Override
    public String getNamespace() {
        if (this.namespace == null) {
            return "unknown";
        }
        return this.namespace;
    }

    @Override
    public TypeDefinition clone() {
        return (TypeDefinition)super.clone();
    }

    public static abstract class PropertyValueImpl
    implements PropertyValue {
        @Override
        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o == this) {
                return true;
            }
            if (!(o instanceof PropertyValue)) {
                return false;
            }
            PropertyValue testValue = (PropertyValue)o;
            if (!this.getType().equals(testValue.getType())) {
                return false;
            }
            if (this.getValue() == null && testValue.getValue() == null) {
                return true;
            }
            return this.getValue().equals(testValue.getValue());
        }

        @Override
        public int hashCode() {
            if (this.getValue() == null) {
                return this.getType().hashCode();
            }
            return this.getType().hashCode() ^ this.getValue().hashCode();
        }

        @Override
        public String toString() {
            if (this.getValue() == null) {
                return "null";
            }
            return this.getValue().toString();
        }
    }
}

