/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.model.impl;

import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import tv.amwa.maj.enumeration.TCSource;
import tv.amwa.maj.exception.BadSampleOffsetException;
import tv.amwa.maj.exception.EndOfDataException;
import tv.amwa.maj.exception.PositionOutOfRangeException;
import tv.amwa.maj.exception.TimecodeNotFoundException;
import tv.amwa.maj.industry.MediaClass;
import tv.amwa.maj.industry.MediaProperty;
import tv.amwa.maj.industry.MediaPropertySetter;
import tv.amwa.maj.industry.MemoryResidentStream;
import tv.amwa.maj.industry.Stream;
import tv.amwa.maj.model.TimecodeStream;
import tv.amwa.maj.model.impl.SegmentImpl;
import tv.amwa.maj.record.Rational;
import tv.amwa.maj.record.TimecodeValue;
import tv.amwa.maj.record.impl.RationalImpl;
import tv.amwa.maj.record.impl.TimecodeValueImpl;

@MediaClass(uuid1=0xD010101, uuid2=257, uuid3=5376, uuid4={6, 14, 43, 52, 2, 6, 1, 1}, definedName="TimecodeStream", description="The TimecodeStream class specifies a stream of timecode data.", symbol="TimecodeStream")
public abstract class TimecodeStreamImpl
extends SegmentImpl
implements TimecodeStream,
Serializable,
Cloneable {
    private static final long serialVersionUID = -3448173192584470825L;
    private Rational timecodeStreamSampleRate;
    private Stream timecodeStreamData;
    private TCSource timecodeSource;

    @Override
    @MediaProperty(uuid1=0x4040101, uuid2=513, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="TimecodeStreamSampleRate", aliases={"SampleRate"}, typeName="Rational", optional=false, uniqueIdentifier=false, pid=5633, symbol="TimecodeStreamSampleRate")
    public Rational getTimecodeStreamSampleRate() {
        return this.timecodeStreamSampleRate.clone();
    }

    @Override
    @MediaPropertySetter(value="TimecodeStreamSampleRate")
    public void setTimecodeStreamSampleRate(Rational timecodeStreamSampleRate) throws NullPointerException {
        if (timecodeStreamSampleRate == null) {
            throw new NullPointerException("Cannot set the sample rate of this timecode stream using a null value.");
        }
        this.timecodeStreamSampleRate = timecodeStreamSampleRate.clone();
    }

    public static final Rational initializeTimecodeStreamSampleRate() {
        return new RationalImpl(0, 1);
    }

    @Override
    public abstract int getSampleSize();

    @Override
    @MediaProperty(uuid1=67568384, uuid2=0, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="TimecodeStreamData", aliases={"Source"}, typeName="Stream", optional=false, uniqueIdentifier=false, pid=5634, symbol="TimecodeStreamData")
    public Stream getTimecodeStreamData() {
        return this.timecodeStreamData.clone();
    }

    @Override
    @MediaPropertySetter(value="TimecodeStreamData")
    public void setTimecodeStreamData(Stream timecodeStreamData) throws NullPointerException {
        if (timecodeStreamData == null) {
            throw new NullPointerException("Cannot set the value of the source property of this timecode stream using a null value.");
        }
        this.timecodeStreamData = timecodeStreamData.clone();
    }

    public static final Stream initializeTimecodeStreamData() {
        return new MemoryResidentStream(0);
    }

    @Override
    public long getSourceBufferLength() throws IOException {
        return this.timecodeStreamData.getLength();
    }

    @Override
    @MediaProperty(uuid1=67371521, uuid2=0, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 1}, definedName="TimecodeSource", aliases={"SourceType"}, typeName="TCSource", optional=false, uniqueIdentifier=false, pid=5635, symbol="TimecodeSource")
    public TCSource getTimecodeSource() {
        return this.timecodeSource;
    }

    @Override
    @MediaPropertySetter(value="TimecodeSource")
    public void setTimecodeSource(TCSource timecodeSource) throws NullPointerException {
        if (timecodeSource == null) {
            throw new NullPointerException("Cannot set the timecode source type of this timecode stream to a null value.");
        }
        this.timecodeSource = timecodeSource;
    }

    public static final TCSource initializeTimecodeSource() {
        return TCSource.TimecodeVITC;
    }

    @Override
    public ByteBuffer getUserDataAtPosition(long position) throws PositionOutOfRangeException, IOException {
        try {
            int sampleSize = this.getSampleSize();
            this.setPosition((long)sampleSize * position);
            ByteBuffer packedBuffer = this.read(sampleSize);
            ByteBuffer buffer = this.unpackUserBits(packedBuffer);
            return buffer;
        }
        catch (IllegalArgumentException iae) {
            throw new PositionOutOfRangeException("The given timecode position is outside the range of the timecode stream.");
        }
        catch (EndOfDataException eode) {
            throw new PositionOutOfRangeException("End of data reached when trying to read the requested sampled.");
        }
    }

    @Override
    public void setUserDataAtPosition(long position, ByteBuffer buffer) throws NullPointerException, PositionOutOfRangeException, IOException {
        try {
            int sampleSize = this.getSampleSize();
            this.setPosition(position * (long)sampleSize);
            ByteBuffer packedBuffer = this.read(sampleSize);
            this.setPosition(position * (long)sampleSize);
            packedBuffer = this.packUserBits(buffer, packedBuffer);
            this.write(packedBuffer);
        }
        catch (IllegalArgumentException iae) {
            throw new PositionOutOfRangeException("The given timecode position is outside the range of the timecode stream.");
        }
        catch (EndOfDataException eode) {
            throw new PositionOutOfRangeException("End of data reached when trying to read the requested sampled.");
        }
    }

    @Override
    public abstract int getUserDataLength();

    @Override
    public TimecodeValue getPositionTimecode(long position) throws PositionOutOfRangeException, IOException {
        Rational rate = this.getTimecodeStreamSampleRate();
        double floatRate = (double)rate.getNumerator() / (double)rate.getDenominator();
        short fps = floatRate >= 29.96 || floatRate <= 30.0 ? (short)30 : (short)((short)floatRate);
        TimecodeValue positionTimecode = new TimecodeValueImpl();
        positionTimecode.setFramesPerSecond(fps);
        try {
            int sampleSize = this.getSampleSize();
            this.setPosition(position * (long)sampleSize);
            ByteBuffer buffer = this.read(sampleSize);
            positionTimecode = this.unpackTimecode(buffer, fps);
            return positionTimecode;
        }
        catch (IllegalArgumentException iae) {
            throw new PositionOutOfRangeException("The given timecode position is outside the range of the timecode stream.");
        }
        catch (EndOfDataException eode) {
            throw new PositionOutOfRangeException("End of data reached when trying to read the requested sampled.");
        }
    }

    @Override
    public void setPositionTimecode(long position, TimecodeValue timecode) throws NullPointerException, PositionOutOfRangeException, IOException {
        if (timecode == null) {
            throw new NullPointerException("Cannot write bytes to the timecode stream using a null timecode value.");
        }
        try {
            int sampleSize = this.getSampleSize();
            this.setPosition(position * (long)sampleSize);
            ByteBuffer packedBuffer = this.read(sampleSize);
            this.setPosition(position * (long)sampleSize);
            packedBuffer = this.packTimecode(timecode, packedBuffer);
            this.write(packedBuffer);
        }
        catch (IllegalArgumentException iae) {
            throw new PositionOutOfRangeException("The given timecode position is outside the range of the timecode stream.");
        }
        catch (EndOfDataException eode) {
            throw new PositionOutOfRangeException("End of data reached when trying to read the requested sampled.");
        }
    }

    @Override
    public TimecodeValue segmentOffsetToTC(long offset) throws IllegalArgumentException {
        try {
            return this.getPositionTimecode(offset);
        }
        catch (PositionOutOfRangeException poore) {
            throw new IllegalArgumentException(poore.getMessage());
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("IO error when tryign to access the underlying stream.");
        }
    }

    @Override
    public long segmentTCToOffset(TimecodeValue timecode, Rational editRate) throws NullPointerException, TimecodeNotFoundException, BadSampleOffsetException {
        if (timecode == null) {
            throw new NullPointerException("Cannot calculate segment timecode offset for this timecode stream using a null timecode value.");
        }
        if (editRate == null) {
            throw new NullPointerException("Cannot calculate segment timecode offset for this timecode stream using a null edit rate value.");
        }
        long increment = (long)timecode.getFramesPerSecond() * 10L;
        editRate = this.getTimecodeStreamSampleRate();
        TimecodeValue baseTimecode = null;
        try {
            try {
                baseTimecode = this.getPositionTimecode(0L);
            }
            catch (PositionOutOfRangeException positionOutOfRangeException) {
                // empty catch block
            }
            long testOffset = timecode.getStartTimecode() - baseTimecode.getStartTimecode();
            long numSamples = this.timecodeStreamData.getLength() / (long)this.getSampleSize();
            TimecodeValue testTimecode = new TimecodeValueImpl();
            if (testOffset >= 0L && testOffset < numSamples) {
                try {
                    testTimecode = this.getPositionTimecode(testOffset);
                }
                catch (PositionOutOfRangeException poore) {
                    poore.printStackTrace();
                }
                if (testTimecode.equals(timecode)) {
                    return testOffset;
                }
            } else if ((testOffset += timecode.getStartTimecode() - testTimecode.getStartTimecode()) >= 0L) {
                try {
                    testTimecode = this.getPositionTimecode(testOffset);
                }
                catch (PositionOutOfRangeException poore) {
                    poore.printStackTrace();
                }
                if (testTimecode.equals(timecode)) {
                    return testOffset;
                }
            }
            long scanStart = 0L;
            if (testOffset > numSamples) {
                testOffset = 0L;
            } else {
                for (testOffset = increment; testOffset < numSamples; testOffset += increment) {
                    try {
                        testTimecode = this.getPositionTimecode(testOffset);
                    }
                    catch (PositionOutOfRangeException poore) {
                        poore.printStackTrace();
                    }
                    int error = (int)(timecode.getStartTimecode() - testTimecode.getStartTimecode());
                    if ((long)error >= -increment && (long)error <= increment) {
                        if (error < 0) {
                            testOffset -= increment;
                        }
                        scanStart = testOffset;
                        break;
                    }
                    if (testOffset < numSamples) continue;
                    scanStart = testOffset -= increment;
                }
            }
            while (testOffset < numSamples) {
                try {
                    testTimecode = this.getPositionTimecode(testOffset);
                }
                catch (PositionOutOfRangeException poore) {
                    poore.printStackTrace();
                }
                if (testTimecode.equals(timecode)) {
                    return testOffset;
                }
                ++testOffset;
            }
            for (testOffset = 0L; testOffset < scanStart; ++testOffset) {
                try {
                    testTimecode = this.getPositionTimecode(testOffset);
                }
                catch (PositionOutOfRangeException poore) {
                    poore.printStackTrace();
                }
                if (!testTimecode.equals(timecode)) continue;
                return testOffset;
            }
        }
        catch (IOException ioe) {
            throw new TimecodeNotFoundException("Could not find a matching timecode due to a IO error: " + ioe.getMessage());
        }
        throw new TimecodeNotFoundException("Could not find a matching timecode within this timecode stream.");
    }

    public abstract TimecodeValue unpackTimecode(ByteBuffer var1, short var2) throws NullPointerException, IllegalArgumentException;

    public abstract ByteBuffer packTimecode(TimecodeValue var1, ByteBuffer var2) throws NullPointerException, IllegalArgumentException;

    public abstract ByteBuffer unpackUserBits(ByteBuffer var1) throws NullPointerException, IllegalArgumentException;

    public abstract ByteBuffer packUserBits(ByteBuffer var1, ByteBuffer var2) throws NullPointerException, IllegalArgumentException;

    long getPosition() throws IOException {
        return this.timecodeStreamData.getPosition();
    }

    private void setPosition(long offset) throws IllegalArgumentException, IOException {
        this.timecodeStreamData.setPosition(offset);
    }

    private ByteBuffer read(long bytes) throws EndOfDataException, IOException {
        return this.timecodeStreamData.read((int)bytes);
    }

    private int write(ByteBuffer buffer) throws EndOfDataException, IOException {
        return this.timecodeStreamData.write(buffer);
    }

    @Override
    public TimecodeStream clone() {
        return (TimecodeStream)super.clone();
    }

    public String getTimecodeStreamSampleRateString() {
        return RationalImpl.toPersistentForm(this.timecodeStreamSampleRate);
    }

    public void setTimecodeStreamSampleRateString(String timecodeStreamSampleRate) {
        this.timecodeStreamSampleRate = RationalImpl.fromPersistentForm(timecodeStreamSampleRate);
    }
}

