/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.model.impl;

import java.io.Serializable;
import tv.amwa.maj.exception.PropertyNotPresentException;
import tv.amwa.maj.industry.MediaClass;
import tv.amwa.maj.industry.MediaProperty;
import tv.amwa.maj.industry.MediaPropertySetter;
import tv.amwa.maj.industry.WeakReference;
import tv.amwa.maj.industry.WeakReferenceTarget;
import tv.amwa.maj.meta.ExtensionScheme;
import tv.amwa.maj.model.ApplicationPluginObject;
import tv.amwa.maj.model.impl.ApplicationObjectImpl;
import tv.amwa.maj.record.AUID;

@MediaClass(uuid1=0xD010101, uuid2=257, uuid3=24832, uuid4={6, 14, 43, 52, 2, 6, 1, 1}, definedName="ApplicationPluginObject", symbol="ApplicationPluginObject", description="Enables application-specific extensions to be associated with any interchange object.")
public class ApplicationPluginObjectImpl
extends ApplicationObjectImpl
implements ApplicationPluginObject,
Cloneable,
Serializable,
WeakReferenceTarget {
    private static final long serialVersionUID = -6136644711475711832L;
    private AUID applicationPluginInstanceID;
    private String applicationEnvironmentID = null;
    private WeakReference<ExtensionScheme> applicationScheme;

    @Override
    @MediaProperty(uuid1=85985025, uuid2=3328, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 12}, definedName="ApplicationPluginInstanceID", aliases={"ApplicationPlug-InInstanceID"}, typeName="AUID", optional=false, uniqueIdentifier=true, pid=0, symbol="ApplicationPluginInstanceID", description="Immutable identifier of this application metadata plug-in instance.")
    public AUID getApplicationPluginInstanceID() {
        return this.applicationPluginInstanceID.clone();
    }

    @Override
    @MediaPropertySetter(value="ApplicationPluginInstanceID")
    public void setApplicationPluginInstanceID(AUID applicationPluginInstanceID) throws NullPointerException {
        if (applicationPluginInstanceID == null) {
            throw new NullPointerException("Cannot set the application plugin instance identifier using a null value.");
        }
        this.applicationPluginInstanceID = applicationPluginInstanceID.clone();
        WeakReference.registerTarget(this);
    }

    @Override
    public AUID getAUID() {
        return this.getApplicationPluginInstanceID();
    }

    @Override
    @MediaProperty(uuid1=85985025, uuid2=3840, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 12}, definedName="ApplicationEnvironmentID", typeName="UTF16String", optional=true, uniqueIdentifier=false, pid=0, symbol="ApplicationEnvironmentID", description="Application environment identifier, an Uniform Resource Identifier (RFC 3986) that identifies the application to which the information in this plugin object applies.")
    public String getApplicationEnvironmentID() throws PropertyNotPresentException {
        if (this.applicationEnvironmentID == null) {
            throw new PropertyNotPresentException("The optional application environment ID property is not present for this application plugin object.");
        }
        return this.applicationEnvironmentID;
    }

    @Override
    @MediaPropertySetter(value="ApplicationEnvironmentID")
    public void setApplicationEnvironmentID(String applicationEnvironmentID) {
        this.applicationEnvironmentID = applicationEnvironmentID;
    }

    @Override
    @MediaProperty(uuid1=67504131, uuid2=0, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 12}, definedName="ApplicationScheme", typeName="ExtensionSchemeWeakReference", optional=false, uniqueIdentifier=false, pid=0, symbol="ApplicationScheme", description="Application metadata scheme contained in this plugin object.")
    public ExtensionScheme getApplicationScheme() {
        return this.applicationScheme.getTarget();
    }

    @Override
    @MediaPropertySetter(value="ApplicationScheme")
    public void setApplicationScheme(ExtensionScheme applicationScheme) throws NullPointerException {
        if (applicationScheme == null) {
            throw new NullPointerException("Unable to set the application scheme of this application plugin using a null value.");
        }
        this.applicationScheme = new WeakReference<ExtensionScheme>(applicationScheme);
    }

    @Override
    public String getWeakTargetReference() {
        return this.applicationPluginInstanceID.toString();
    }

    @Override
    public ApplicationPluginObject clone() {
        return (ApplicationPluginObject)super.clone();
    }
}

