/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.model.impl;

import java.io.Serializable;
import tv.amwa.maj.exception.PropertyNotPresentException;
import tv.amwa.maj.exception.TraversalNotPossibleException;
import tv.amwa.maj.industry.MediaClass;
import tv.amwa.maj.industry.MediaProperty;
import tv.amwa.maj.industry.MediaPropertySetter;
import tv.amwa.maj.integer.UInt32;
import tv.amwa.maj.misctype.PositionType;
import tv.amwa.maj.model.Component;
import tv.amwa.maj.model.DataDefinition;
import tv.amwa.maj.model.Event;
import tv.amwa.maj.model.Filler;
import tv.amwa.maj.model.Segment;
import tv.amwa.maj.model.Sequence;
import tv.amwa.maj.model.TimelineTrack;
import tv.amwa.maj.model.impl.EventImpl;
import tv.amwa.maj.model.impl.SequenceImpl;
import tv.amwa.maj.model.impl.TrackImpl;
import tv.amwa.maj.record.Rational;
import tv.amwa.maj.record.impl.RationalImpl;

@MediaClass(uuid1=0xD010101, uuid2=257, uuid3=15104, uuid4={6, 14, 43, 52, 2, 6, 1, 1}, definedName="TimelineTrack", aliases={"TimelineMobSlot"}, description="The TimelineTrack class describes time-varying timeline essence.", symbol="TimelineTrack")
public class TimelineTrackImpl
extends TrackImpl
implements TimelineTrack,
Serializable,
Cloneable {
    private static final long serialVersionUID = 7780080264046280928L;
    private Rational editRate;
    private long origin;
    private Long markIn = null;
    private Long markOut = null;
    private Long userPosition = null;

    public TimelineTrackImpl() {
    }

    public TimelineTrackImpl(@UInt32 int trackId, Segment segment, Rational editRate, @PositionType long origin) throws NullPointerException, IllegalArgumentException {
        if (segment == null) {
            throw new NullPointerException("Cannot create a new timeline track with a null segment value.");
        }
        if (editRate == null) {
            throw new NullPointerException("Cannot create a new timeline track with a null edit rate.");
        }
        if (trackId < 0) {
            throw new IllegalArgumentException("Cannot create a new timeline track with a negative track id.");
        }
        this.setTrackID(trackId);
        this.setTrackSegment(segment);
        this.setEditRate(editRate);
        this.setOrigin(origin);
    }

    @Override
    @MediaProperty(uuid1=87032837, uuid2=0, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="EditRate", aliases={"TimelineMobSlotEditRate"}, typeName="Rational", optional=false, uniqueIdentifier=false, pid=19201, symbol="EditRate")
    public Rational getEditRate() {
        return this.editRate.clone();
    }

    @Override
    @MediaPropertySetter(value="EditRate")
    public void setEditRate(Rational editRate) throws NullPointerException {
        if (editRate == null) {
            throw new NullPointerException("Cannot set the edit rate for this timeline track using a null value.");
        }
        this.editRate = editRate.clone();
    }

    public static final Rational initializeEditRate() {
        return new RationalImpl(1, 1);
    }

    @Override
    @MediaProperty(uuid1=117571843, uuid2=268, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 7}, definedName="MarkIn", typeName="PositionType", optional=true, uniqueIdentifier=false, pid=19203, symbol="MarkIn")
    public long getMarkIn() throws PropertyNotPresentException {
        if (this.markIn == null) {
            throw new PropertyNotPresentException("The optional mark in property is not present for this timeline track.");
        }
        return this.markIn;
    }

    @Override
    @MediaPropertySetter(value="MarkIn")
    public void setMarkIn(Long value) {
        this.markIn = value;
    }

    @Override
    @MediaProperty(uuid1=117571843, uuid2=515, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 7}, definedName="MarkOut", typeName="PositionType", optional=true, uniqueIdentifier=false, pid=19204, symbol="MarkOut")
    public long getMarkOut() throws PropertyNotPresentException {
        if (this.markOut == null) {
            throw new PropertyNotPresentException("The optional mark out property is not present for this timeline track.");
        }
        return this.markOut;
    }

    @Override
    @MediaPropertySetter(value="MarkOut")
    public void setMarkOut(Long value) {
        this.markOut = value;
    }

    @Override
    @MediaProperty(uuid1=117571843, uuid2=259, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="Origin", aliases={"SlotOrigin"}, typeName="PositionType", optional=false, uniqueIdentifier=false, pid=19202, symbol="Origin")
    public long getOrigin() {
        return this.origin;
    }

    @Override
    @MediaPropertySetter(value="Origin")
    public void setOrigin(long origin) {
        this.origin = origin;
    }

    public static final long initializeOrigin() {
        return 0L;
    }

    @Override
    @MediaProperty(uuid1=117571843, uuid2=269, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 7}, definedName="UserPosition", aliases={"UserPos"}, typeName="PositionType", optional=true, uniqueIdentifier=false, pid=19205, symbol="UserPosition")
    public long getUserPosition() throws PropertyNotPresentException {
        if (this.userPosition == null) {
            throw new PropertyNotPresentException("The user position property is not present for this timeline track.");
        }
        return this.userPosition;
    }

    @Override
    @MediaPropertySetter(value="UserPosition")
    public void setUserPosition(Long userPosition) {
        this.userPosition = userPosition;
    }

    @Override
    public void setTrackSegment(Segment segment) throws NullPointerException, IllegalArgumentException {
        if (!(segment instanceof Sequence)) {
            segment.setLengthPresent(true);
            super.setTrackSegment(segment);
            return;
        }
        Sequence sequence = (Sequence)segment;
        Object firstEvent = null;
        for (Component component : sequence.getComponentObjects()) {
            if (!(component instanceof EventImpl)) continue;
            firstEvent = (EventImpl)component;
            break;
        }
        if (firstEvent == null) {
            sequence.setLengthPresent(true);
            super.setTrackSegment(sequence);
            return;
        }
        DataDefinition sequenceDataDefinition = sequence.getComponentDataDefinition();
        Class<?> clazz = firstEvent.getClass();
        for (Component component : sequence.getComponentObjects()) {
            if (!(component instanceof Event) && !(component instanceof Filler)) {
                throw new IllegalArgumentException("If a timeline track contains a sequence with an event, all elements of that sequence must be either events or fillers.");
            }
            if (!component.getComponentDataDefinition().doesDataDefConvertTo(sequenceDataDefinition)) {
                throw new IllegalArgumentException("All events and fillers in a timeline track must have the same data definition as the sequence.");
            }
            if (component == firstEvent || !(component instanceof Event) || clazz.isInstance(component)) continue;
            throw new IllegalArgumentException("All events in the sequence of a timeline track must be of the same concrete event class.");
        }
        sequence.setLengthPresent(true);
        super.setTrackSegment(sequence);
    }

    public void sourcePackageContext() {
        this.markIn = null;
        this.markOut = null;
        this.userPosition = null;
    }

    @Override
    TrackImpl.FoundSegment findSegment(long offset) throws TraversalNotPossibleException {
        Rational sourceRate = this.getEditRate();
        long origin = this.getOrigin();
        Segment segment = this.getTrackSegment();
        TrackImpl.FoundSegment foundSegment = SequenceImpl.findSubSegment(segment, offset += origin);
        foundSegment.sourceRate = sourceRate;
        if (foundSegment == null) {
            throw new TraversalNotPossibleException("Could not find a segment at the given offset for this timeline track.");
        }
        return foundSegment;
    }

    @Override
    public TimelineTrack clone() {
        return (TimelineTrack)super.clone();
    }

    public String getEditRateString() {
        return RationalImpl.toPersistentForm(this.editRate);
    }

    public void setEditRateString(String editRate) {
        this.editRate = RationalImpl.fromPersistentForm(editRate);
    }
}

