/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.meta.impl;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import tv.amwa.maj.enumeration.TypeCategory;
import tv.amwa.maj.exception.BadParameterException;
import tv.amwa.maj.exception.DuplicateException;
import tv.amwa.maj.exception.EndOfDataException;
import tv.amwa.maj.exception.IllegalPropertyValueException;
import tv.amwa.maj.exception.InsufficientSpaceException;
import tv.amwa.maj.exception.InvalidParameterException;
import tv.amwa.maj.industry.MediaClass;
import tv.amwa.maj.industry.MediaListAppend;
import tv.amwa.maj.industry.MediaProperty;
import tv.amwa.maj.industry.MediaPropertyClear;
import tv.amwa.maj.industry.PropertyValue;
import tv.amwa.maj.industry.Warehouse;
import tv.amwa.maj.io.mxf.UL;
import tv.amwa.maj.io.xml.XMLBuilder;
import tv.amwa.maj.meta.TypeDefinition;
import tv.amwa.maj.meta.TypeDefinitionExtendibleEnumeration;
import tv.amwa.maj.meta.impl.SingletonTypeDefinitionImpl;
import tv.amwa.maj.meta.impl.TypeDefinitionImpl;
import tv.amwa.maj.misctype.AAFString;
import tv.amwa.maj.record.AUID;
import tv.amwa.maj.record.impl.AUIDImpl;

@MediaClass(uuid1=0xD010101, uuid2=544, uuid3=0, uuid4={6, 14, 43, 52, 2, 6, 1, 1}, definedName="TypeDefinitionExtendibleEnumeration", description="The TypeDefinitionExtendibleEnumeration class defines a property type that can have one of an extendible set of AUID values.", symbol="TypeDefinitionExtendibleEnumeration")
public final class TypeDefinitionExtendibleEnumerationImpl
extends SingletonTypeDefinitionImpl
implements TypeDefinitionExtendibleEnumeration,
Serializable,
Cloneable {
    static final long serialVersionUID = -3191040594861355572L;

    protected TypeDefinitionExtendibleEnumerationImpl() {
    }

    public TypeDefinitionExtendibleEnumerationImpl(AUID identification, @AAFString String typeName, String symbolPrefix) throws NullPointerException, DuplicateException {
        if (identification == null) {
            throw new NullPointerException("Cannot create a new extendible enumeration type definition with a null identification.");
        }
        this.setIdentification(identification);
        this.setName(typeName);
        this.symbol = symbolPrefix;
    }

    @MediaProperty(uuid1=50397699, uuid2=1792, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="ExtendibleEnumerationElementNames", aliases={"ElementNames", "ExtEnumElementNames"}, typeName="UTF16StringArray", optional=false, uniqueIdentifier=false, pid=31, symbol="ExtendibleEnumerationElementNames")
    public String[] getElementNames() {
        SortedMap<String, AUID> enumeration = Warehouse.lookupExtendibleEnumeration(this.symbol);
        String[] names = new String[enumeration.size()];
        int index = 0;
        for (String name : enumeration.keySet()) {
            names[index++] = this.symbol + "_" + name;
        }
        return names;
    }

    public static final List<String> initializeExtendibleEnumerationElementNames() {
        return new ArrayList<String>();
    }

    @MediaPropertyClear(value="ExtendibleEnumerationElementNames")
    public void clearExtendibleEnumerationElementNames() {
    }

    @MediaListAppend(value="ExtendibleEnumerationElementNames")
    public void appendExtendibleEnumerationElementName(String elementName) {
    }

    @MediaProperty(uuid1=50397699, uuid2=2048, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="ExtendibleEnumerationElementValues", aliases={"ElementValues", "ExtEnumElementValues"}, typeName="AUIDArray", optional=false, uniqueIdentifier=false, pid=32, symbol="ExtendibleEnumerationElementValues")
    public AUID[] getElementValues() {
        SortedMap<String, AUID> enumeration = Warehouse.lookupExtendibleEnumeration(this.symbol);
        AUID[] values = new AUID[enumeration.size()];
        int index = 0;
        for (String name : enumeration.keySet()) {
            values[index++] = (AUID)enumeration.get(name);
        }
        return values;
    }

    public static final List<AUID> initializeExtendibleEnumerationElementValues() {
        return new ArrayList<AUID>();
    }

    @MediaPropertyClear(value="ExtendibleEnumerationElementValues")
    public void clearExtendibleEnumerationElementValues() {
    }

    @MediaListAppend(value="ExtendibleEnumerationElementValues")
    public void appendExtendibleEnumerationElementValue(AUID extendibleEnumerationElementValue) {
    }

    @Override
    public void appendElement(AUID value, String name) throws NullPointerException, DuplicateException {
        if (value == null) {
            throw new NullPointerException("Cannot append an enumeration element to this extendible enumeration with a null identifying AUID.");
        }
        if (name == null) {
            throw new NullPointerException("Cannot append an enumeration element to this extendible enumeration with a null name.");
        }
        SortedMap<String, AUID> enumeration = Warehouse.lookupExtendibleEnumeration(this.symbol);
        if (enumeration.containsKey(name)) {
            throw new DuplicateException("The given name is already the name of an element of the " + this.symbol + " extendible enumeration.");
        }
        if (enumeration.containsValue(value)) {
            throw new DuplicateException("The given value is already the value of an element of the " + this.symbol + " extendible enumeration.");
        }
        String testName = Warehouse.extendibleEnumerationName(value);
        if (testName != null && !testName.equals(this.symbol)) {
            throw new DuplicateException("The given value is alerady an element value of another extendible enumeration.");
        }
        Warehouse.registerExtendibleEnumerationElement(this.symbol, name, value);
    }

    @Override
    public int countElements() {
        SortedMap<String, AUID> enumeration = Warehouse.lookupExtendibleEnumeration(this.symbol);
        return enumeration.size();
    }

    @Override
    public PropertyValue createValueFromName(String name) throws NullPointerException, InvalidParameterException {
        SortedMap<String, AUID> enumeration;
        if (name == null) {
            throw new NullPointerException("Cannot create an extendible enumeration property value from a null name.");
        }
        if (name.startsWith(this.symbol)) {
            int truncateBy = this.symbol.length();
            if (name.charAt(truncateBy) == '_') {
                ++truncateBy;
            }
            if (Character.isDigit((name = name.substring(truncateBy)).charAt(0))) {
                name = "_" + name;
            }
        }
        if (!(enumeration = Warehouse.lookupExtendibleEnumeration(this.symbol)).containsKey(name)) {
            throw new InvalidParameterException("The given element name does not match the name of an element of this extendible enumeration.");
        }
        return new ExtendibleEnumerationValue(this, name, (AUID)enumeration.get(name));
    }

    @Override
    public AUID getAUIDValue(PropertyValue enumerationProperty) throws NullPointerException, IllegalPropertyValueException {
        if (enumerationProperty == null) {
            throw new NullPointerException("Cannot extract the identification from a null extendible enumeration property value.");
        }
        if (!this.equals(enumerationProperty.getType())) {
            throw new IllegalPropertyValueException("The type of the given property value does not match this extendible enumeration type definition.");
        }
        return ((ExtendibleEnumerationValue)enumerationProperty).getValue();
    }

    @Override
    public String getElementName(int index) throws IndexOutOfBoundsException {
        SortedMap<String, AUID> enumeration = Warehouse.lookupExtendibleEnumeration(this.symbol);
        if (index < 0 || index >= enumeration.size()) {
            throw new IndexOutOfBoundsException("The given index is outside the acceptable range for this extensible enumeration type definition.");
        }
        int counter = 0;
        for (String elementName : enumeration.keySet()) {
            if (counter == index) {
                return elementName;
            }
            ++counter;
        }
        throw new IndexOutOfBoundsException("Unexpectedly, the given index is outside the acceptable range for this extensible enumeration type definition.");
    }

    @Override
    public AUID getElementValue(int index) throws IndexOutOfBoundsException {
        SortedMap<String, AUID> enumeration = Warehouse.lookupExtendibleEnumeration(this.symbol);
        if (index < 0 || index >= enumeration.size()) {
            throw new IndexOutOfBoundsException("The given index is outside the acceptable range for this extensible enumeration type definition.");
        }
        int counter = 0;
        for (String elementName : enumeration.keySet()) {
            if (counter == index) {
                return (AUID)enumeration.get(elementName);
            }
            ++counter;
        }
        throw new IndexOutOfBoundsException("Unexpectedly, the given index is outside the acceptable range for this extensible enumeration type definition.");
    }

    @Override
    public AUID getAUIDFromName(String name) throws NullPointerException, BadParameterException {
        if (name == null) {
            throw new NullPointerException("Cannot retrieve the AUID corresponding to a null name.");
        }
        SortedMap<String, AUID> enumeration = Warehouse.lookupExtendibleEnumeration(this.symbol);
        if (!enumeration.containsKey(name)) {
            if (name.contains(this.symbol + "_")) {
                try {
                    name = name.substring(this.symbol.length() + 1);
                }
                catch (IndexOutOfBoundsException iobe) {
                    throw new BadParameterException("The given AUID does not correspond to a known enumeration element for this extensible enumeration definition.");
                }
                if (!enumeration.containsKey(name)) {
                    throw new BadParameterException("The given AUID does not correspond to a known enumeration element for this extensible enumeration definition.");
                }
            } else {
                throw new BadParameterException("The given AUID does not correspond to a known enumeration element for this extensible enumeration definition.");
            }
        }
        return ((AUID)enumeration.get(name)).clone();
    }

    SortedMap<String, AUID> getElements() {
        return Warehouse.lookupExtendibleEnumeration(this.symbol);
    }

    @Override
    public String getNameFromAUID(AUID value) throws NullPointerException, BadParameterException {
        if (value == null) {
            throw new NullPointerException("Cannot retrieve the name of an extendible enumeration element using a null identity.");
        }
        String enumerationName = Warehouse.extendibleEnumerationName(value);
        if (enumerationName == null || !enumerationName.equals(this.symbol)) {
            throw new BadParameterException("This extendible enumeration type definition does not contain an element with the given identity.");
        }
        return Warehouse.extendibleEnumerationElementName(value);
    }

    @Override
    public String getNameFromValue(PropertyValue enumerationProperty) throws NullPointerException, IllegalPropertyValueException {
        if (enumerationProperty == null) {
            throw new NullPointerException("Cannot extract the name from a null extendible enumeration property value.");
        }
        if (!this.equals(enumerationProperty.getType())) {
            throw new IllegalPropertyValueException("The type of the given property value does not match this extendible enumeration type definition.");
        }
        return ((ExtendibleEnumerationValue)enumerationProperty).getName();
    }

    public String getSymbolFromValue(PropertyValue enumerationProperty) throws NullPointerException, IllegalPropertyValueException {
        String name = this.getNameFromValue(enumerationProperty);
        if (name.charAt(0) == '_') {
            name = name.substring(1);
        }
        if (this.symbol.length() > 0) {
            return this.symbol + "_" + name;
        }
        return name;
    }

    @Override
    public void setAUIDValue(PropertyValue enumerationProperty, AUID value) throws NullPointerException, IllegalPropertyValueException, BadParameterException {
        if (enumerationProperty == null) {
            throw new NullPointerException("Cannot set the value of a null extendible enumeration property.");
        }
        if (value == null) {
            throw new NullPointerException("Cannot set the value of a null extendible enumeration property with a null identity value.");
        }
        if (!this.equals(enumerationProperty.getType())) {
            throw new IllegalPropertyValueException("The type of the given property value does not match this extendible enumeration type definition.");
        }
        String elementName = this.getNameFromAUID(value);
        ((ExtendibleEnumerationValue)enumerationProperty).setValue(elementName, value);
    }

    @Override
    public PropertyValue createValue(Object javaValue) throws ClassCastException {
        PropertyValue propertyValue;
        if (javaValue == null) {
            throw new ClassCastException("Cannot create a new extendible enumeration property value by casting from null.");
        }
        if (javaValue instanceof PropertyValue && (propertyValue = (PropertyValue)javaValue).getType().equals(this)) {
            ExtendibleEnumerationValue extensiblePropertyValue = (ExtendibleEnumerationValue)propertyValue;
            return new ExtendibleEnumerationValue(this, extensiblePropertyValue.getName(), extensiblePropertyValue.getValue());
        }
        try {
            if (javaValue instanceof String) {
                return this.createValueFromName((String)javaValue);
            }
        }
        catch (InvalidParameterException e) {
            throw new ClassCastException("Cannot create a new extendible enumeration property value from the given name as it does not match the name of an enumeration element.");
        }
        try {
            if (javaValue instanceof AUID) {
                String elementName = this.getNameFromAUID((AUID)javaValue);
                return new ExtendibleEnumerationValue(this, elementName, (AUID)javaValue);
            }
        }
        catch (BadParameterException bpe) {
            if (this.getName().equals("OperationCategoryType")) {
                return new ExtendibleEnumerationValue(this, "Effect", (AUID)javaValue);
            }
            throw new ClassCastException("Cannot create a new extendible enumeration property value from the given AUID identity as it does not match the identity of an enumeration element of type " + this.getName() + ".");
        }
        throw new ClassCastException("Cannot create a new extendible enumeration property value from the given value.");
    }

    @Override
    public TypeCategory getTypeCategory() {
        return TypeCategory.ExtEnum;
    }

    @Override
    public PropertyValue createFromBytes(ByteBuffer buffer) throws NullPointerException, EndOfDataException {
        super.createFromBytes(buffer);
        if (buffer.remaining() < 16) {
            throw new EndOfDataException("Not enough bytes available in the provided buffer to create a extendible enumeration value.");
        }
        AUID enumKey = AUIDImpl.createFromBuffer(buffer);
        return this.createValue(enumKey);
    }

    @Override
    public List<PropertyValue> writeAsBytes(PropertyValue value, ByteBuffer buffer) throws NullPointerException, IllegalPropertyValueException, InsufficientSpaceException {
        super.writeAsBytes(value, buffer);
        if (buffer.remaining() < 16) {
            throw new InsufficientSpaceException("Not enough space remaining in the given buffer to write an extendible emumeration value.");
        }
        AUID keyValue = ((ExtendibleEnumerationValue)value).getValue();
        if (keyValue.isUniversalLabel()) {
            buffer.put(((UL)keyValue).getUniversalLabel());
        } else {
            buffer.put(keyValue.getAUIDValue());
        }
        return null;
    }

    @Override
    public List<PropertyValue> writeAsStructuredStorageBytes(PropertyValue value, ByteBuffer buffer) throws NullPointerException, IllegalPropertyValueException, InsufficientSpaceException {
        super.writeAsBytes(value, buffer);
        if (buffer.remaining() < 16) {
            throw new InsufficientSpaceException("Not enough space remaining in the given buffer to write an extendible emumeration value.");
        }
        AUID keyValue = ((ExtendibleEnumerationValue)value).getValue();
        buffer.put(keyValue.getAUIDValue());
        return null;
    }

    @Override
    public long lengthAsBytes(PropertyValue value) throws NullPointerException, IllegalPropertyValueException {
        super.lengthAsBytes(value);
        return 16L;
    }

    @Override
    public void appendMetadictXML(Node metadict, String namespace, String prefix) {
        Element typeElement = XMLBuilder.createChild(metadict, namespace, prefix, "TypeDefinitionExtendibleEnumeration");
        super.appendMetadictXML(typeElement, namespace, prefix);
        this.appendMetadictElements(metadict, namespace, prefix);
    }

    public void appendMetadictElements(Node metadict, String namespace, String prefix) {
        SortedMap<String, AUID> enumeration = Warehouse.lookupExtendibleEnumeration(this.symbol);
        for (String elementName : enumeration.keySet()) {
            Element elementElement = XMLBuilder.createChild(metadict, namespace, prefix, "ExtendibleEnumerationElement");
            XMLBuilder.appendElement((Node)elementElement, namespace, prefix, "ElementOf", this.getIdentification().toString());
            XMLBuilder.appendElement((Node)elementElement, namespace, prefix, "Name", elementName);
            XMLBuilder.appendElement((Node)elementElement, namespace, prefix, "Value", ((AUID)enumeration.get(elementName)).toString());
        }
    }

    @Override
    public TypeDefinitionExtendibleEnumeration clone() {
        return (TypeDefinitionExtendibleEnumeration)super.clone();
    }

    public static class ExtendibleEnumerationValue
    extends TypeDefinitionImpl.PropertyValueImpl
    implements PropertyValue {
        private TypeDefinitionExtendibleEnumerationImpl type;
        private String valueName;
        private AUID valueId;

        private ExtendibleEnumerationValue(TypeDefinitionExtendibleEnumerationImpl type, String valueName, AUID valueId) {
            this.type = type;
            this.setValue(valueName, valueId);
        }

        private void setValue(String valueName, AUID valueId) {
            this.valueName = valueName;
            this.valueId = valueId.clone();
        }

        @Override
        public TypeDefinition getType() {
            return this.type;
        }

        @Override
        public AUID getValue() {
            return this.valueId;
        }

        public String getName() {
            return this.valueName;
        }

        public boolean isDefinedType() {
            return true;
        }

        @Override
        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (this == o) {
                return true;
            }
            if (o instanceof PropertyValue) {
                return this.getValue().equals(((PropertyValue)o).getValue());
            }
            return this.getValue().equals(o);
        }
    }
}

